/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.ui.controls.MultiVarListAccessor;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.KnownComponentVisitor;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class DdmInspectorDlg
extends JDialog {
    private BaseProcedureDialog parent;
    private JTextArea mTextArea;

    public DdmInspectorDlg(BaseProcedureDialog baseProcedureDialog) {
        super((Dialog)((Object)baseProcedureDialog), "DDM Inspector", true);
        this.parent = baseProcedureDialog;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DdmInspectorDlg.this.requestClose();
            }
        });
        this.setupContentPane();
        this.getComponentInfo();
        this.getDDMInfo();
        this.setVisible(true);
    }

    private void requestClose() {
        this.setVisible(false);
        this.dispose();
    }

    private void setupContentPane() {
        double[] dArray = new double[]{0.0, -1.0, 0.0};
        double[] dArray2 = new double[]{0.0, -1.0, -2.0, 0.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        tableLayout.setHGap(5);
        tableLayout.setVGap(5);
        JPanel jPanel = new JPanel((LayoutManager)tableLayout, true);
        this.setContentPane(jPanel);
        AbstractAction abstractAction = new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DdmInspectorDlg.this.requestClose();
            }
        };
        JButton jButton = new JButton(abstractAction);
        this.mTextArea = new JTextArea(50, 80);
        JScrollPane jScrollPane = new JScrollPane(this.mTextArea);
        jPanel.add((Component)jScrollPane, "1,1");
        jPanel.add((Component)jButton, "1, 2, l, c");
        this.setContentPane(jPanel);
        this.pack();
    }

    private void getComponentInfo() {
        this.mTextArea.append("***\nThese are the dialog data model names found by inspecting the components\n***\n");
        InspectorVisitor inspectorVisitor = new InspectorVisitor();
        InspectorVisitor.start((Container)((Object)this.parent), inspectorVisitor);
        this.mTextArea.append("\n\n");
    }

    private void getDDMInfo() {
        this.mTextArea.append("***\nThese are _all_ the names known to the dialog data model\n***\n");
        String string = this.parent.getDialogDataModel().dumpToString();
        this.mTextArea.append(string);
    }

    private class InspectorVisitor
    extends KnownComponentVisitor {
        private InspectorVisitor() {
        }

        @Override
        protected boolean visitSrcVariableList(SrcVariableList srcVariableList) {
            String string = srcVariableList.getIdentifier();
            DdmInspectorDlg.this.mTextArea.append("SrcVariableList = " + string + "\n");
            return true;
        }

        @Override
        protected boolean visitTargetVariableList(TargetVariableList targetVariableList) {
            String string = targetVariableList.getIdentifier();
            DdmInspectorDlg.this.mTextArea.append("TargetVariableList = " + string + "\n");
            return true;
        }

        @Override
        protected boolean visitMultiVarListAccessor(MultiVarListAccessor multiVarListAccessor) {
            DdmInspectorDlg.this.mTextArea.append("MultiVarListAccessor:\n");
            ArrayList<VarListModel> arrayList = multiVarListAccessor.getVarListModels();
            String string = multiVarListAccessor.getTargetVariableList().getIdentifier();
            for (int i = 0; i < arrayList.size(); ++i) {
                DdmInspectorDlg.this.mTextArea.append(string + i + "\n");
            }
            return true;
        }

        @Override
        protected boolean visitToggleButton(JToggleButton jToggleButton) {
            ToggleButtonAction toggleButtonAction = (ToggleButtonAction)jToggleButton.getAction();
            DdmInspectorDlg.this.mTextArea.append("JToggleButton = " + toggleButtonAction.getActionKey() + "\n");
            return true;
        }

        @Override
        protected boolean visitComboBox(JComboBox jComboBox) {
            ComboboxAction comboboxAction = (ComboboxAction)jComboBox.getAction();
            DdmInspectorDlg.this.mTextArea.append("JComboBox = " + comboboxAction.getActionKey() + "\n");
            return true;
        }

        @Override
        protected boolean visitTextField(JTextField jTextField) {
            TextFieldAction textFieldAction = (TextFieldAction)jTextField.getAction();
            DdmInspectorDlg.this.mTextArea.append("JTextField = " + textFieldAction.getActionKey() + "\n");
            return true;
        }

        @Override
        protected boolean visitSerializableList(SerializableList serializableList) {
            DdmInspectorDlg.this.mTextArea.append("SerializableList = " + serializableList.getActionKey() + "\n");
            return true;
        }
    }
}

