/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class CustomAttributeArrayDlg
extends BaseDialog
implements ActionListener,
ListSelectionListener,
FocusListener {
    static final String IDS_CUSTOM_ATTR_ADD_BUTTON = "IDS_CUSTOM_ATTR_ADD_BUTTON";
    static final String IDS_CUSTOM_ATTR_DELETE_BUTTON = "IDS_CUSTOM_ATTR_DELETE_BUTTON";
    private Vector<String> mAttributeValueOriginal;
    private JButton mOkButton;
    private Vector<AttributeTableData> mTableData;
    private JButton mCancelButton;
    private JButton mHelpButton;
    private JButton mAddButton;
    private JButton mDeleteButton;
    private JTable mAttrValueTabel;
    private JLabel mAttributeNameLabel;
    private AttributeValueTableModel mAttributeValueTableModel;
    private boolean mOkPressed;

    public CustomAttributeArrayDlg(JDialog jDialog, Vector<String> vector, String string) {
        this((SpssFrame)jDialog.getParent(), vector, string);
        this.setLocationRelativeTo(jDialog);
    }

    public CustomAttributeArrayDlg(SpssFrame spssFrame, Vector<String> vector, String string) {
        super((JFrame)spssFrame, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()).getString("IDS_CUSTOM_ATTR_TITLE"), true, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.mAttributeValueOriginal = vector != null ? vector : new Vector();
        this.loadTableFromList(this.mAttributeValueOriginal);
        this.mAttributeNameLabel.setText(string);
        this.updateButtons();
        this.setLocationRelativeTo(spssFrame);
    }

    public boolean wasOkPressed() {
        return this.mOkPressed;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.mCancelButton)) {
            this.dispose();
        } else if (actionEvent.getSource().equals(this.mOkButton)) {
            this.mOkPressed = true;
            this.mAttrValueTabel.getColumnModel().getColumn(1).getCellEditor().stopCellEditing();
            this.mAttributeValueOriginal.clear();
            int n = this.mTableData.size();
            for (int i = 0; i < n; ++i) {
                AttributeTableData attributeTableData = this.mTableData.get(i);
                this.mAttributeValueOriginal.add(attributeTableData.getAttributeValue());
            }
            this.dispose();
        } else if (actionEvent.getSource().equals(this.mHelpButton)) {
            this.doHelp();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.updateButtons();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mAttrValueTabel) && this.mAttrValueTabel.getCellEditor() != null) {
            this.mAttrValueTabel.getCellEditor().stopCellEditing();
        }
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        this.mOkButton = new JButton(this.getResString("IDS_OK"));
        this.mOkButton.addActionListener(this);
        this.mCancelButton = new JButton(this.getResString("IDS_CANCEL"));
        this.mCancelButton.addActionListener(this);
        this.mHelpButton = new JButton(this.getResString("IDS_HELP"));
        this.mHelpButton.addActionListener(this);
        Insets insets = DialogUtil.getStandardButtonInsets();
        if (DialogUtil.areCommandButtonsBelow()) {
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                jPanel.add(this.mCancelButton);
                jPanel.add(this.mHelpButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCancelButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mHelpButton);
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, insets.left, n2, 0);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CUSTOM_ATTR_ARRAY_LABEL");
        jLabel.setLabelFor(this.mAttrValueTabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(jLabel);
        jPanel2.add(this.mAttributeNameLabel);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 3, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mAttrValueTabel);
        jScrollPane.setPreferredSize(this.mAttrValueTabel.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 2, 2, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.left = n2;
        DialogUtil.addUsingGBL(jPanel, this.mAddButton, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDeleteButton, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        this.setTabTraversalOrder();
        this.pack();
    }

    protected String getDialogHelpID() {
        return "idh_idd_custom_array_dlg";
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mAttrValueTabel);
        vector.add(this.mAddButton);
        vector.add(this.mDeleteButton);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void loadTableFromList(Vector<String> vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            if (vector.get(i).length() <= 0) continue;
            AttributeTableData attributeTableData = new AttributeTableData(i + 1, vector.get(i));
            this.mTableData.add(attributeTableData);
        }
        if (this.mAttrValueTabel.getModel().getRowCount() > 0) {
            this.mAttrValueTabel.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void initVars() {
        this.mOkPressed = false;
        this.mAttributeNameLabel = new JLabel();
        this.mTableData = new Vector();
        this.mAttributeValueTableModel = new AttributeValueTableModel();
        this.mAttrValueTabel = new JTable(this.mAttributeValueTableModel);
        this.mAttrValueTabel.getSelectionModel().addListSelectionListener(this);
        this.mAttrValueTabel.setTableHeader(null);
        this.mAttrValueTabel.setAutoResizeMode(3);
        this.mAttrValueTabel.getColumnModel().getColumn(0).setMaxWidth(50);
        this.mAttrValueTabel.getColumnModel().getColumn(1).setWidth(150);
        this.mAttrValueTabel.setMinimumSize(new Dimension(200, 150));
        this.mAttrValueTabel.addFocusListener(this);
        this.mAttrValueTabel.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(new JTextField()));
        this.mAttrValueTabel.setRowHeight(this.mAttrValueTabel.getRowHeight() + 3);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, IDS_CUSTOM_ATTR_ADD_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomAttributeArrayDlg.this.mAttributeValueTableModel.addNewElement();
                final int n = CustomAttributeArrayDlg.this.mAttrValueTabel.getRowCount();
                if (n > 0) {
                    CustomAttributeArrayDlg.this.setTabTraversalOrder();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CustomAttributeArrayDlg.this.mAttrValueTabel.requestFocusInWindow();
                            CustomAttributeArrayDlg.this.mAttrValueTabel.changeSelection(n - 1, 1, false, false);
                            CustomAttributeArrayDlg.this.mAttrValueTabel.editCellAt(n - 1, 1);
                        }
                    });
                }
            }
        };
        this.mAddButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, IDS_CUSTOM_ATTR_DELETE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CustomAttributeArrayDlg.this.mAttrValueTabel.getSelectedRows();
                if (CustomAttributeArrayDlg.this.mAttrValueTabel.getCellEditor() != null) {
                    CustomAttributeArrayDlg.this.mAttrValueTabel.getCellEditor().stopCellEditing();
                }
                CustomAttributeArrayDlg.this.mAttributeValueTableModel.deleteElement(nArray);
            }
        };
        this.mDeleteButton = new JButton(toggleButtonAction);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    private void updateButtons() {
        boolean bl = true;
        String string = this.mAttributeNameLabel.getText();
        if (string != null && string.startsWith("$")) {
            bl = false;
        }
        this.mAddButton.setEnabled(bl);
        this.mDeleteButton.setEnabled(bl && this.mAttrValueTabel.getSelectionModel().getMinSelectionIndex() >= 0);
    }

    private class AttributeTableData {
        private int mSerialNumber;
        private String mAttrValue;

        public AttributeTableData(int n, String string) {
            this.mSerialNumber = n;
            this.mAttrValue = string;
        }

        public int getSerialNumber() {
            return this.mSerialNumber;
        }

        public String getAttributeValue() {
            return this.mAttrValue;
        }

        public void setAttributeValue(String string) {
            this.mAttrValue = string;
        }

        public void setSerialNumber(int n) {
            this.mSerialNumber = n;
        }
    }

    private class AttributeValueTableModel
    extends AbstractTableModel {
        private String[] mColumnNames = new String[]{"", ""};

        private AttributeValueTableModel() {
        }

        public void addNewElement() {
            AttributeTableData attributeTableData = new AttributeTableData(CustomAttributeArrayDlg.this.mTableData.size() + 1, "");
            CustomAttributeArrayDlg.this.mTableData.add(attributeTableData);
            int n = CustomAttributeArrayDlg.this.mTableData.size() - 1;
            this.fireTableRowsInserted(n, n);
        }

        public void deleteElement(int[] nArray) {
            int n;
            for (n = nArray.length - 1; n >= 0; --n) {
                CustomAttributeArrayDlg.this.mTableData.remove(nArray[n]);
            }
            n = CustomAttributeArrayDlg.this.mTableData.size();
            for (int i = 0; i < n; ++i) {
                AttributeTableData attributeTableData = (AttributeTableData)CustomAttributeArrayDlg.this.mTableData.get(i);
                attributeTableData.setSerialNumber(i + 1);
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return CustomAttributeArrayDlg.this.mTableData.size();
        }

        @Override
        public int getColumnCount() {
            return this.mColumnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.mColumnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AttributeTableData attributeTableData = (AttributeTableData)CustomAttributeArrayDlg.this.mTableData.get(n);
            if (n2 == 0) {
                return attributeTableData.getSerialNumber();
            }
            return attributeTableData.getAttributeValue();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            String string = CustomAttributeArrayDlg.this.mAttributeNameLabel.getText();
            return n2 != 0 && !string.startsWith("$");
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                AttributeTableData attributeTableData = (AttributeTableData)CustomAttributeArrayDlg.this.mTableData.get(n);
                attributeTableData.setAttributeValue(object.toString());
            }
        }
    }
}

