/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Window;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class ContentValidatorFileChooser
extends RemoteFileChooser {
    private String mPath = null;
    private String mMangledPassword;

    public ContentValidatorFileChooser(RemoteFileChooser.ChooserType chooserType, RemoteFileChooser.ChooserOption chooserOption, String string, boolean bl) {
        super(chooserType, chooserOption, string, bl);
    }

    @Override
    public void approveSelection() {
        this.mPath = this.getSelectedFilePath();
        if (this.mPath != null) {
            boolean bl;
            Object object;
            if (this.isServerFileSystem()) {
                String string;
                object = this.getSelectedFilePath();
                if (!((String)object).startsWith("\\\\") && (string = this.getSelectedFileName()).length() > 0) {
                    object = string;
                }
                this.validateServerFile((String)object);
                this.mPath = this.getSelectedFilePath();
            }
            if (!(bl = ((DocUtil.EncryptionTestResults)(object = DocUtil.testOpenEncryptedData(null, this.mPath))).isCanContinue())) {
                if (((DocUtil.EncryptionTestResults)object).isPasswordDlgOKPressed()) {
                    String string = "";
                    switch (((DocUtil.EncryptionTestResults)object).getRetVal()) {
                        case 2: 
                        case 3: {
                            string = MessageFormat.format(ResUtil.getCommonDlgString("ERR_FILE_NOT_VALID_SAV"), this.mPath);
                        }
                    }
                    if (!string.isEmpty()) {
                        if (this.mParentComponent instanceof Window) {
                            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParentComponent, string, VersionInfo.getAppVersionString());
                        } else if (this.mParentComponent instanceof JComponent) {
                            SpssAlertOptionPane.showWarningMessageDialog((JComponent)this.mParentComponent, string, VersionInfo.getAppVersionString());
                        } else {
                            JOptionPane.showMessageDialog(this, string, VersionInfo.getAppVersionString(), 0, new ImageIcon(ResUtil.getImageResource("warning_core.png")));
                        }
                    }
                }
            } else {
                this.mMangledPassword = ((DocUtil.EncryptionTestResults)object).getMangledPassword();
                super.approveSelection();
            }
        }
    }

    public String getMangledPassword() {
        return this.mMangledPassword;
    }

    public String getPath() {
        if (this.mPath == null) {
            this.mPath = "";
        }
        return this.mPath;
    }
}

