/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class BootstrapDlg
extends BaseSubDialog
implements ItemListener {
    public static String DIALOG_KEY = "BOOTSTRAPPING_DIALOG_KEY";
    private static String BS_PERFORM_BS_KEY = "IDS_COMMON_BOOTSTRAP_PERFORM_BOOTSTRAP";
    private static String BS_SET_SEED_KEY = "IDS_COMMON_BOOTSTRAP_SET_SEED_CHECK";
    private static String BS_NUM_SAMPLES_KEY = "BS_NUM_SAMPLES_KEY";
    private static String BS_SEED_FIELD_KEY = "BS_SEED_FIELD_KEY";
    private static String BS_LEVEL_KEY = "BS_LEVEL_KEY";
    private static String BS_PERCENTILE_BUTTON_KEY = "IDS_COMMON_BOOTSTRAP_PERCENTILE";
    private static String BS_BCA_BUTTON_KEY = "IDS_COMMON_BOOTSTRAP_BCA";
    private static String BS_SIMPLE_BUTTON_KEY = "IDS_COMMON_BOOTSTRAP_SIMPLE_METHOD";
    private static String BS_STRATIFIED_BUTTON_KEY = "IDS_COMMON_BOOTSTRAP_STRATIFIED_METHOD";
    private static String BS_SRC_VAR_LIST = "BS_SOURCE_VARIABLE_LIST_KEY";
    private static String BS_TARGET_FIELD_LIST_KEY = "BS_STRATA_VARIABLE_LIST_KEY";
    private JCheckBox mPerformBootStrapping;
    private JLabel mNumOfSamplesLabel;
    private IntTextField mNumOfSamplesField;
    private JCheckBox mSetSeedCheck;
    private JLabel mSeedLabel;
    private IntTextField mSeedField;
    private JLabel mLevelLabel;
    private FloatTextField mLevelField;
    private JRadioButton mPercentitleButton;
    private JRadioButton mBCaButton;
    private JRadioButton mSimpleButton;
    private JRadioButton mStraifiedButton;
    private SrcVariableList mVariableSrcList;
    private JLabel mSrcListLabel;
    private JScrollPane mSrcScrollPane;
    private TargetVariableList mTargetFieldList;
    private JLabel mTargetFieldLabel;
    private JScrollPane mTargetFieldScrollPane;
    private ArrowButton mTargetFieldArrowButton;
    private DialogDataModel mBootstrapDataModel = new DialogDataModel();

    public BootstrapDlg(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, ResUtil.getCommonDlgString("IDS_COMMON_BOOTSTRAPPING_TITLE"), true, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mPerformBootStrapping.isSelected()) {
            this.enableControls(true);
        } else {
            this.enableControls(false);
            this.enableVariableList(false);
        }
        if (this.mSetSeedCheck.isEnabled() && this.mSetSeedCheck.isSelected()) {
            this.mSeedLabel.setEnabled(true);
            this.mSeedField.setEnabled(true);
        } else {
            this.mSeedLabel.setEnabled(false);
            this.mSeedField.setEnabled(false);
        }
        if (this.mStraifiedButton.isEnabled() && this.mStraifiedButton.isSelected()) {
            this.enableVariableList(true);
        } else {
            this.enableVariableList(false);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_bootstrap";
    }

    public void reset() {
        this.mBootstrapDataModel.clear();
    }

    private void enableVariableList(boolean bl) {
        this.mVariableSrcList.setEnabled(bl);
        this.mSrcListLabel.setEnabled(bl);
        this.mSrcScrollPane.setEnabled(bl);
        this.mTargetFieldList.setEnabled(bl);
        this.mTargetFieldLabel.setEnabled(bl);
        this.mTargetFieldScrollPane.setEnabled(bl);
        this.mTargetFieldArrowButton.setEnabled(bl);
    }

    private void enableControls(boolean bl) {
        this.mNumOfSamplesLabel.setEnabled(bl);
        this.mNumOfSamplesField.setEnabled(bl);
        this.mSetSeedCheck.setEnabled(bl);
        this.mSeedLabel.setEnabled(bl);
        this.mSeedField.setEnabled(bl);
        this.mLevelLabel.setEnabled(bl);
        this.mLevelField.setEnabled(bl);
        this.mPercentitleButton.setEnabled(bl);
        this.mBCaButton.setEnabled(bl);
        this.mSimpleButton.setEnabled(bl);
        this.mStraifiedButton.setEnabled(bl);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        this.saveDialogState();
        BaseProcedureDialog.saveSourceVarList(this.mVariableSrcList, this.mBootstrapDataModel);
        BaseProcedureDialog.saveTargetVarList(BS_TARGET_FIELD_LIST_KEY, this.mTargetFieldList.getModel(), this.mBootstrapDataModel);
        dialogDataModel.putObject(DIALOG_KEY, this.mBootstrapDataModel);
        return true;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        if (dialogDataModel.getObject(DIALOG_KEY) != null) {
            this.mBootstrapDataModel = (DialogDataModel)dialogDataModel.getObject(DIALOG_KEY);
        }
        this.loadDialogState();
        BaseProcedureDialog.loadSourceList(this.mVariableSrcList, this.mBootstrapDataModel, BaseProcedureDialog.NameLabelOption.no_override);
        BaseProcedureDialog.loadTargetList(this.mTargetFieldList, this.mBootstrapDataModel, BaseProcedureDialog.NameLabelOption.no_override);
        BaseProcedureDialog.addMissingVarsToSrcList();
    }

    private void saveDialogState() {
        this.mBootstrapDataModel.putBoolean(BS_PERFORM_BS_KEY, this.mPerformBootStrapping.isSelected());
        this.mBootstrapDataModel.putString(BS_NUM_SAMPLES_KEY, this.mNumOfSamplesField.getText());
        this.mBootstrapDataModel.putBoolean(BS_SET_SEED_KEY, this.mSetSeedCheck.isSelected());
        this.mBootstrapDataModel.putString(BS_SEED_FIELD_KEY, this.mSeedField.getText());
        this.mBootstrapDataModel.putString(BS_LEVEL_KEY, this.mLevelField.getText());
        this.mBootstrapDataModel.putBoolean(BS_PERCENTILE_BUTTON_KEY, this.mPercentitleButton.isSelected());
        this.mBootstrapDataModel.putBoolean(BS_BCA_BUTTON_KEY, this.mBCaButton.isSelected());
        this.mBootstrapDataModel.putBoolean(BS_SIMPLE_BUTTON_KEY, this.mSimpleButton.isSelected());
        this.mBootstrapDataModel.putBoolean(BS_STRATIFIED_BUTTON_KEY, this.mStraifiedButton.isSelected());
    }

    private void loadDialogState() {
        String string;
        Boolean bl = this.mBootstrapDataModel.getBoolean(BS_PERFORM_BS_KEY);
        if (bl != null) {
            this.mPerformBootStrapping.setSelected(bl);
        }
        if ((string = this.mBootstrapDataModel.getString(BS_NUM_SAMPLES_KEY)) != null) {
            this.mNumOfSamplesField.setText(string);
        }
        if ((bl = this.mBootstrapDataModel.getBoolean(BS_SET_SEED_KEY)) != null) {
            this.mSetSeedCheck.setSelected(bl);
        }
        if ((string = this.mBootstrapDataModel.getString(BS_SEED_FIELD_KEY)) != null) {
            this.mSeedField.setText(string);
        }
        if ((string = this.mBootstrapDataModel.getString(BS_LEVEL_KEY)) != null) {
            this.mLevelField.setText(string);
        }
        if ((bl = this.mBootstrapDataModel.getBoolean(BS_PERCENTILE_BUTTON_KEY)) != null) {
            this.mPercentitleButton.setSelected(bl);
        }
        if ((bl = this.mBootstrapDataModel.getBoolean(BS_BCA_BUTTON_KEY)) != null) {
            this.mBCaButton.setSelected(bl);
        }
        if ((bl = this.mBootstrapDataModel.getBoolean(BS_SIMPLE_BUTTON_KEY)) != null) {
            this.mSimpleButton.setSelected(bl);
        }
        if ((bl = this.mBootstrapDataModel.getBoolean(BS_STRATIFIED_BUTTON_KEY)) != null) {
            this.mStraifiedButton.setSelected(bl);
        }
    }

    public static String getBootstrapSyntax(String string, String string2, DialogDataModel dialogDataModel) {
        return BootstrapDlg.getBootstrapSyntax(string, string2, dialogDataModel, false);
    }

    public static String getBootstrapSyntax(String string, String string2, DialogDataModel dialogDataModel, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        Boolean bl2 = dialogDataModel.getBoolean(BS_PERFORM_BS_KEY);
        if (bl2 != null && bl2.booleanValue()) {
            Object object;
            Boolean bl3 = dialogDataModel.getBoolean(BS_SET_SEED_KEY);
            boolean bl4 = false;
            if (bl3 != null && bl3.booleanValue()) {
                bl4 = true;
                stringBuffer.append(SyntaxUtil.getCommand("PRESERVE."));
                stringBuffer.append(SyntaxUtil.getCommand("SET RNG=MT MTINDEX=" + dialogDataModel.getString(BS_SEED_FIELD_KEY), false));
                stringBuffer.append(SyntaxUtil.terminateSyntax());
                stringBuffer.append(SyntaxUtil.getCommand("SHOW RNG."));
            }
            stringBuffer.append(SyntaxUtil.getCommand("BOOTSTRAP"));
            bl3 = dialogDataModel.getBoolean(BS_SIMPLE_BUTTON_KEY);
            if (bl3 != null && bl3.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getCommand("  /SAMPLING METHOD=SIMPLE", false));
            }
            if ((bl3 = dialogDataModel.getBoolean(BS_STRATIFIED_BUTTON_KEY)) != null && bl3.booleanValue()) {
                object = dialogDataModel.getVarArray(BS_TARGET_FIELD_LIST_KEY);
                String string3 = "";
                if (object != null && ((ISpssVariable[])object).length > 0) {
                    for (ISpssVariable iSpssVariable : object) {
                        if (BootstrapDlg.isSplitVar(iSpssVariable)) continue;
                        string3 = string3 + iSpssVariable.getName() + " ";
                    }
                    stringBuffer.append(SyntaxUtil.getCommand("  /SAMPLING METHOD=STRATIFIED(STRATA=" + string3 + ")  ", false));
                }
            }
            if (string2.trim().length() > 0 || string.trim().length() > 0) {
                stringBuffer.append(SyntaxUtil.getCommand("\n  /VARIABLES ", false));
                if (string.trim().length() > 0) {
                    stringBuffer.append(SyntaxUtil.getCommand("TARGET=" + string + " ", false));
                }
                if (string2.trim().length() > 0) {
                    stringBuffer.append(SyntaxUtil.getCommand("INPUT=" + string2 + " ", false));
                }
            }
            stringBuffer.append(SyntaxUtil.getCommand("\n  /CRITERIA ", false));
            object = dialogDataModel.getString(BS_LEVEL_KEY);
            if (object != null && ((String)object).length() > 0) {
                stringBuffer.append(SyntaxUtil.getCommand("CILEVEL=" + (String)object, false));
            }
            if ((bl3 = dialogDataModel.getBoolean(BS_PERCENTILE_BUTTON_KEY)) != null && bl3.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getCommand(" CITYPE=PERCENTILE ", false));
            } else {
                stringBuffer.append(SyntaxUtil.getCommand(" CITYPE=BCA ", false));
            }
            object = dialogDataModel.getString(BS_NUM_SAMPLES_KEY);
            if (object != null && ((String)object).length() > 0) {
                stringBuffer.append(SyntaxUtil.getCommand(" NSAMPLES=" + (String)object, false));
            }
            if (!bl) {
                stringBuffer.append(SyntaxUtil.getCommand("\n  /MISSING USERMISSING=EXCLUDE", false));
            } else {
                stringBuffer.append(SyntaxUtil.getCommand("\n  /MISSING USERMISSING=INCLUDE", false));
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    public static String getRestoreSyntax(DialogDataModel dialogDataModel) {
        Boolean bl;
        String string = "";
        Boolean bl2 = dialogDataModel.getBoolean(BS_PERFORM_BS_KEY);
        if (bl2 != null && bl2.booleanValue() && (bl = dialogDataModel.getBoolean(BS_SET_SEED_KEY)) != null && bl.booleanValue()) {
            string = SyntaxUtil.getCommand("RESTORE.").toString();
        }
        return string;
    }

    public static boolean isStrataVariableListEmpty(BaseProcedureDialog baseProcedureDialog) {
        Boolean bl;
        DialogDataModel dialogDataModel = BootstrapDlg.getBootstrapModel();
        if (dialogDataModel != null && (bl = dialogDataModel.getBoolean(BS_PERFORM_BS_KEY)) != null && bl.booleanValue()) {
            Boolean bl2 = dialogDataModel.getBoolean(BS_STRATIFIED_BUTTON_KEY);
            int n = 0;
            if (bl2 != null && bl2.booleanValue()) {
                ISpssVariable[] iSpssVariableArray;
                for (ISpssVariable iSpssVariable : iSpssVariableArray = dialogDataModel.getVarArray(BS_TARGET_FIELD_LIST_KEY)) {
                    if (BootstrapDlg.isSplitVar(iSpssVariable)) continue;
                    ++n;
                }
                if (iSpssVariableArray.length == 0 || n == 0) {
                    String string = ResUtil.getCommonDlgString("ERR_COMMON_BOOTSTRAP_EMPTY_STRATA_LIST") + ResUtil.getCommonDlgString("ERR_COMMON_BOOTSTRAP_EMPTY_STRATA_LIST_MESG2");
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)baseProcedureDialog), string, VersionInfo.getAppVersionString());
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        if (this.mPerformBootStrapping.isSelected()) {
            boolean bl2;
            if (this.mNumOfSamplesField.getText().length() == 0 || Integer.parseInt(this.mNumOfSamplesField.getText()) == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_COMMON_BOOTSTRAP_NUM_SAMPLES"), VersionInfo.getAppVersionString());
                this.setSelectionText((JTextField)this.mNumOfSamplesField, 0);
                return false;
            }
            boolean bl3 = true;
            if (this.mSetSeedCheck.isSelected()) {
                boolean bl4 = bl3 = this.mSeedField.getText().length() > 0;
                if (bl3) {
                    try {
                        int n = Integer.parseInt(this.mSeedField.getText());
                        if (n == 0 || n > 2000000000) {
                            bl3 = false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl3 = false;
                    }
                }
                if (!bl3) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_COMMON_BOOTSTRAP_RANDOM_SEED"), VersionInfo.getAppVersionString());
                    this.setSelectionText((JTextField)this.mSeedField, 0);
                    return false;
                }
            }
            double d = 0.0;
            boolean bl5 = bl2 = this.mLevelField.getText().length() > 0;
            if (bl2) {
                try {
                    d = Double.parseDouble(this.mLevelField.getText());
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_COMMON_BOOTSTRAP_CONF_LEVEL"), VersionInfo.getAppVersionString());
                this.setSelectionText((JTextField)this.mLevelField, 0);
                return false;
            }
            if (this.mStraifiedButton.isEnabled() && this.mStraifiedButton.isSelected() && this.mTargetFieldList.getModel().getSize() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_COMMON_BOOTSTRAP_EMPTY_STRATA_LIST"), VersionInfo.getAppVersionString());
                this.mVariableSrcList.setSelectedIndex(0);
                return false;
            }
            double d2 = 100.0 * (1.0 - 2.0 / (1.0 + (double)Integer.parseInt(this.mNumOfSamplesField.getText())));
            if (d2 < d) {
                NumberFormat numberFormat = NumberFormat.getPercentInstance(ComponentState.getSPSSLocale());
                numberFormat.setMaximumFractionDigits(2);
                String string = numberFormat.format(d / 100.0);
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), String.format(this.getResString("ERR_COMMON_BOOTSTRAP_EMPTY_STRATA_LIST_MESG3"), string), VersionInfo.getAppVersionString());
                this.setSelectionText((JTextField)this.mNumOfSamplesField, 0);
                return false;
            }
        }
        return bl;
    }

    public static DialogDataModel getBootstrapModel() {
        DialogDataModel dialogDataModel = new DialogDataModel();
        ProcedureDlgMgr.getMgr().loadPersistentState(DIALOG_KEY, dialogDataModel);
        return dialogDataModel;
    }

    public static boolean isCurrentDatasetInMIMode() {
        if (VersionInfo.allowMultipleImputation()) {
            boolean bl;
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            boolean bl2 = bl = iSpssDataSrc != null && iSpssDataSrc.isMultipleImputation();
            if (!bl && iSpssDataSrc != null && iSpssDataSrc.findVarIndex("Imputation_") >= 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, n2 - 3, 4);
        DialogUtil.addUsingGBL(jPanel, this.mPerformBootStrapping, gridBagConstraints, 0, 0, 3, 1, n, insets);
        insets.set(4, n2 * 3, n2 - 3, 4);
        DialogUtil.addUsingGBL(jPanel, this.mNumOfSamplesLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(4, 4, n2 - 3, 4);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumOfSamplesField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, new JLabel(" "), gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(4, n2 * 3, n2 - 3, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSetSeedCheck, gridBagConstraints, 0, 2, 3, 1, n, insets);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel2, this.mSeedLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, n2 - 3, n2 * 10);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mSeedField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, new JLabel(" "), gridBagConstraints, 2, 0, 1, 1, n, insets);
        insets.set(0, n2 * 7, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 3, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(n2 - 3, 2, n2 - 3, n2);
        DialogUtil.addUsingGBL(jPanel, this.setupConfidenceIntervalPanel(), gridBagConstraints, 0, 4, 3, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupSamplingPanel(), gridBagConstraints, 0, 5, 3, 1, n, insets);
        this.setFocusTraversalPolicy();
        this.setDefaults();
        this.pack();
    }

    private void initVars() {
        this.mPerformBootStrapping = DialogUtil.createCheckBox(this, BS_PERFORM_BS_KEY, null);
        this.mPerformBootStrapping.addItemListener(this);
        this.mNumOfSamplesLabel = DialogUtil.createLabel("IDS_COMMON_BOOTSTRAP_NUM_SAMPLES_LABEL");
        this.mNumOfSamplesField = new IntTextField(true);
        this.mNumOfSamplesField.setAction((Action)new TextFieldAction(this, BS_NUM_SAMPLES_KEY));
        this.mNumOfSamplesField.setColumns(6);
        this.mNumOfSamplesField.setHorizontalAlignment(4);
        this.mNumOfSamplesLabel.setLabelFor((Component)this.mNumOfSamplesField);
        this.mSetSeedCheck = DialogUtil.createCheckBox(this, BS_SET_SEED_KEY, null);
        this.mSetSeedCheck.addItemListener(this);
        this.mSeedLabel = DialogUtil.createLabel("IDS_COMMON_BOOTSTRAP_SEED_LABEL");
        this.mSeedField = new IntTextField(true);
        this.mSeedField.setAction((Action)new TextFieldAction(this, BS_SEED_FIELD_KEY));
        this.mSeedField.setColumns(10);
        this.mSeedField.setHorizontalAlignment(4);
        this.mSeedLabel.setLabelFor((Component)this.mSeedField);
        FocusListener[] focusListenerArray = this.mSeedField.getFocusListeners();
        for (FocusListener focusListener : focusListenerArray) {
            if (!(focusListener instanceof IntTextField)) continue;
            this.mSeedField.removeFocusListener(focusListener);
            break;
        }
        this.mLevelLabel = DialogUtil.createLabel("IDS_COMMON_BOOTSTRAP_CONF_LEVEL_LABEL");
        this.mLevelField = new FloatTextField(0.0, 100.0, 2, true);
        this.mLevelField.setAction((Action)new TextFieldAction(this, BS_LEVEL_KEY));
        this.mLevelField.setColumns(8);
        this.mLevelField.setHorizontalAlignment(4);
        this.mLevelField.setIncludeMaxRange(false);
        this.mLevelLabel.setLabelFor((Component)this.mLevelField);
        this.mPercentitleButton = DialogUtil.createRadioButton(this, BS_PERCENTILE_BUTTON_KEY, null);
        this.mBCaButton = DialogUtil.createRadioButton(this, BS_BCA_BUTTON_KEY, null);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mPercentitleButton);
        spssButtonGroup.add(this.mBCaButton);
        this.mSimpleButton = DialogUtil.createRadioButton(this, BS_SIMPLE_BUTTON_KEY, null);
        this.mSimpleButton.addItemListener(this);
        this.mStraifiedButton = DialogUtil.createRadioButton(this, BS_STRATIFIED_BUTTON_KEY, null);
        this.mStraifiedButton.addItemListener(this);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mSimpleButton);
        spssButtonGroup2.add(this.mStraifiedButton);
        this.mVariableSrcList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        SplitVarFilter splitVarFilter = new SplitVarFilter();
        this.mVariableSrcList.addVarFilter(splitVarFilter);
        this.mVariableSrcList.setIdentifier(BS_SRC_VAR_LIST);
        this.mVariableSrcList.setContextMenuFlags(this.mVariableSrcList.getContextMenuFlags() | 8);
        this.mSrcListLabel = DialogUtil.createLabel(this, "IDS_COMMON_BOOTSTRAP_VARIABLE_LABLE");
        this.mSrcListLabel.setLabelFor(this.mVariableSrcList);
        this.mSrcScrollPane = new JScrollPane(this.mVariableSrcList);
        this.mSrcScrollPane.setHorizontalScrollBarPolicy(30);
        this.mSrcScrollPane.setVerticalScrollBarPolicy(20);
        this.mTargetFieldList = new TargetVariableList();
        this.mTargetFieldList.addVarFilter(splitVarFilter);
        this.mTargetFieldList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetFieldList.setIdentifier(BS_TARGET_FIELD_LIST_KEY);
        this.mTargetFieldLabel = DialogUtil.createLabel(this, "IDS_COMMON_BOOTSTRAP_STRATA_VARIABLE_LABEL");
        this.mTargetFieldLabel.setLabelFor(this.mTargetFieldList);
        this.mTargetFieldList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetFieldList.getFixedCellHeight() * 6 + 2));
        this.mTargetFieldScrollPane = new JScrollPane(this.mTargetFieldList);
        this.mTargetFieldScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTargetFieldScrollPane.setVerticalScrollBarPolicy(21);
        this.mTargetFieldScrollPane.setPreferredSize(this.mTargetFieldList.getMinimumSize());
        this.mSrcScrollPane.setPreferredSize(this.mTargetFieldList.getMinimumSize());
        this.mTargetFieldArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTargetFieldArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mTargetFieldArrowButton.registerVariableList(this.mTargetFieldList, SpssArrowButton.ButtonOrientation.left);
    }

    private JPanel setupSamplingPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_COMMON_BOOTSTRAP_SAMPLING_PANEL_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2, 4, n2 - 3, 4);
        DialogUtil.addUsingGBL(jPanel, this.mSimpleButton, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mStraifiedButton, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(4, n2 * 6, n2 - 3, 4);
        DialogUtil.addUsingGBL(jPanel, this.setupListPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.set(4, 4, n2 - 3, 4);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupTargetlistPanel(), gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupConfidenceIntervalPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_COMMON_BOOTSTRAP_CONF_PANEL_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2 - 3, n2, n2 - 3, n2);
        DialogUtil.addUsingGBL(jPanel, this.mLevelLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2 - 3, n2, n2 - 3, n2 * 15);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLevelField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, new JLabel(" "), gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 - 3, n2 - 3, n2 - 3, n2);
        DialogUtil.addUsingGBL(jPanel, this.mPercentitleButton, gridBagConstraints, 0, 1, 3, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mBCaButton, gridBagConstraints, 0, 3, 3, 1, n, insets);
        return jPanel;
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSrcListLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupTargetlistPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetFieldLabel, gridBagConstraints, 1, 0, 1, 1, 23, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2 - 3, 0, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mTargetFieldArrowButton, gridBagConstraints, 0, 0, 1, 2, 10, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mTargetFieldScrollPane, gridBagConstraints, 1, 1, 1, 1, 23, insets);
        return jPanel;
    }

    private void setDefaults() {
        this.mVariableSrcList.loadFromActiveDataset();
        this.mPerformBootStrapping.setSelected(false);
        this.mNumOfSamplesField.setText("1000");
        this.mSetSeedCheck.setSelected(false);
        this.mSeedField.setText("2000000");
        this.mLevelField.setText("95");
        this.mPercentitleButton.setSelected(true);
        this.mSimpleButton.setSelected(true);
        this.mPercentitleButton.setEnabled(false);
        this.mNumOfSamplesLabel.setEnabled(false);
        this.mNumOfSamplesField.setEnabled(false);
        this.mSetSeedCheck.setEnabled(false);
        this.mSeedLabel.setEnabled(false);
        this.mSeedField.setEnabled(false);
        this.mLevelLabel.setEnabled(false);
        this.mLevelField.setEnabled(false);
        this.mBCaButton.setEnabled(false);
        this.mSimpleButton.setEnabled(false);
        this.mStraifiedButton.setEnabled(false);
        this.mVariableSrcList.setEnabled(false);
        this.mSrcListLabel.setEnabled(false);
        this.mSrcScrollPane.setEnabled(false);
        this.mTargetFieldList.setEnabled(false);
        this.mTargetFieldLabel.setEnabled(false);
        this.mTargetFieldScrollPane.setEnabled(false);
        this.mTargetFieldArrowButton.setEnabled(false);
    }

    private void setFocusTraversalPolicy() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPerformBootStrapping);
        vector.add(this.mNumOfSamplesField);
        vector.add(this.mSetSeedCheck);
        vector.add(this.mSeedField);
        vector.add(this.mLevelField);
        vector.add(this.mPercentitleButton);
        vector.add(this.mBCaButton);
        vector.add(this.mSimpleButton);
        vector.add(this.mStraifiedButton);
        vector.add(this.mVariableSrcList);
        vector.add(this.mTargetFieldArrowButton);
        vector.add(this.mTargetFieldList);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setSelectionText(final JTextField jTextField, int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jTextField.requestFocusInWindow();
            }
        });
        jTextField.setSelectionStart(n);
        jTextField.setSelectionEnd(jTextField.getText().length());
    }

    private static boolean isSplitVar(ISpssVariable iSpssVariable) {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.getNSplitVars();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(iSpssDataSrc.getSplitVarIndex(i));
            if (iSpssVariable == null || iSpssVariable2 == null || !iSpssVariable.getId().equals((Object)iSpssVariable2.getId())) continue;
            return true;
        }
        return false;
    }

    private class SplitVarFilter
    implements IVarFilter {
        private SplitVarFilter() {
        }

        @Override
        public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
            return !BootstrapDlg.isSplitVar(iSpssVariable);
        }
    }
}

