/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSpssDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IPlainListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.WizardModel;
import com.spss.java_client.ui.doc_types.doc_util.ProcedureDialogLoader;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public abstract class BaseWizardDialog
extends BaseDialog {
    private CardLayout mCardLayout;
    private WizardModel mWizardModel;
    private AbstractWizardPage mCurrentPage;
    private BackAction mBackAction;
    private NextAction mNextAction;
    private FinishAction mFinishAction;
    private JButton mBackButton;
    private JButton mNextButton;
    private JButton mFinishButton;
    private JButton mCancelButton;
    private JButton mHelpButton;
    protected IVarMoveHandler mVarMoveHandler;
    protected IPlainListVarMoveHandler mPlainListVarMoveHandler;

    public BaseWizardDialog(JFrame jFrame, String string, String string2) throws HeadlessException {
        this(jFrame, "", false, string, string2);
    }

    public BaseWizardDialog(JFrame jFrame, boolean bl, String string, String string2) throws HeadlessException {
        this(jFrame, "", bl, string, string2, true);
    }

    public BaseWizardDialog(JFrame jFrame, String string, String string2, String string3) throws HeadlessException {
        this(jFrame, string, false, string2, string3, true);
    }

    public BaseWizardDialog(JFrame jFrame, String string, boolean bl, String string2, String string3) {
        this(jFrame, string, false, string2, string3, true);
    }

    public BaseWizardDialog(JFrame jFrame, String string, boolean bl, String string2, String string3, boolean bl2) {
        super(jFrame, string, bl, ResUtil.getBundle(string2, ResUtil.getLocale()), string3);
        Point point;
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize(((Object)((Object)this)).getClass().getName());
        if (dimension != null) {
            this.setSize(dimension);
        }
        if ((point = ProcedureDlgMgr.getMgr().getDialogLocation(((Object)((Object)this)).getClass().getName())) != null) {
            this.setLocation(point);
        }
        if (bl2) {
            this.showWizardPage(null, this.mWizardModel.getCurrentPage());
        }
    }

    public void registerPage(AbstractWizardPage abstractWizardPage) throws PageAlreadyRegistered {
        if (!this.mWizardModel.registerPage(abstractWizardPage)) {
            throw new PageAlreadyRegistered();
        }
        this.mViewPanel.add((Component)abstractWizardPage.getPanel(), abstractWizardPage.getID());
    }

    public void setDefaultButton(WizardButton wizardButton) {
        if (wizardButton == null) {
            this.getRootPane().setDefaultButton(null);
        } else if (wizardButton.equals((Object)WizardButton.eBack)) {
            this.getRootPane().setDefaultButton(this.mBackButton);
        } else if (wizardButton.equals((Object)WizardButton.eNext)) {
            this.getRootPane().setDefaultButton(this.mNextButton);
        } else if (wizardButton.equals((Object)WizardButton.eFinish)) {
            this.getRootPane().setDefaultButton(this.mFinishButton);
        } else if (wizardButton.equals((Object)WizardButton.eCancel)) {
            this.getRootPane().setDefaultButton(this.mCancelButton);
        }
    }

    public void enableFinish(boolean bl) {
        this.mFinishAction.setEnabled(bl);
        this.mFinishButton.setEnabled(bl);
        if (!bl && this.mFinishButton.hasFocus()) {
            this.mCancelButton.requestFocus();
        }
    }

    public void enableNext(boolean bl) {
        this.mNextAction.setEnabled(bl);
        this.mNextButton.setEnabled(bl);
        if (!bl && this.mNextButton.hasFocus()) {
            JButton jButton = this.mFinishButton;
            if (!jButton.isEnabled()) {
                jButton = this.mCancelButton;
            }
            jButton.requestFocus();
        }
    }

    public void enableBack(boolean bl) {
        this.mBackAction.setEnabled(bl);
        this.mBackButton.setEnabled(bl);
        if (!bl && this.mBackButton.hasFocus()) {
            JButton jButton = this.mNextButton;
            if (!jButton.isEnabled()) {
                jButton = this.mFinishButton;
            }
            if (!jButton.isEnabled()) {
                jButton = this.mCancelButton;
            }
            jButton.requestFocus();
        }
    }

    public WizardModel getWizardModel() {
        return this.mWizardModel;
    }

    public void setNameLabelOverride(BaseProcedureDialog.NameLabelOption nameLabelOption, boolean bl) {
        BaseSpssDialog.updateListTextDisplaySetting(nameLabelOption, (Container)((Object)this), bl);
    }

    public void setGeneratedSyntax(String string) {
        this.mGeneratedSyntax = string;
    }

    public abstract String generateSyntax();

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.mWizardModel.getCurrentPage().getDialogHelpID());
    }

    public IVarMoveHandler getVarMoveHandler() {
        return this.mVarMoveHandler;
    }

    public abstract String getIActionKey();

    protected void init() {
        super.init();
        this.mWizardModel = new WizardModel();
    }

    public JButton getBackButton() {
        return this.mBackButton;
    }

    public JButton getNextButton() {
        return this.mNextButton;
    }

    public JButton getFinishButton() {
        return this.mFinishButton;
    }

    public JButton getCancelButton() {
        return this.mCancelButton;
    }

    public JButton getHelpButton() {
        return this.mHelpButton;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        this.mCardLayout = new CardLayout();
        this.mViewPanel.setLayout(this.mCardLayout);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        this.mBackAction = new BackAction();
        this.mBackButton = new JButton(this.mBackAction);
        this.mNextAction = new NextAction();
        this.mNextButton = new JButton(this.mNextAction);
        this.mFinishAction = new FinishAction();
        this.mFinishButton = new JButton(this.mFinishAction);
        CancelAction cancelAction = new CancelAction();
        this.mCancelButton = new JButton(cancelAction);
        HelpAction helpAction = new HelpAction();
        this.mHelpButton = new JButton(helpAction);
        DialogUtil.setupMacHelpButton(this.mHelpButton);
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            int n2 = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
            n2 = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mBackButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            DialogUtil.addUsingGBL(jPanel, this.mNextButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mFinishButton, gridBagConstraints, 4, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(this.mBackButton);
            jPanel.add(this.mNextButton);
            jPanel.add(this.mFinishButton);
            jPanel.add(this.mCancelButton);
            jPanel.add(this.mHelpButton);
        }
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected DoFinishAction doFinish() {
        return DoFinishAction.eOK;
    }

    protected boolean doCancel() {
        return true;
    }

    protected boolean validateOnFinish() {
        return this.mWizardModel.getCurrentPage().validate();
    }

    public void showWizardPage(AbstractWizardPage abstractWizardPage, final AbstractWizardPage abstractWizardPage2) {
        if (abstractWizardPage2 != null) {
            this.changeCmdButtonsState(abstractWizardPage2);
            if (!abstractWizardPage2.isInitialized()) {
                abstractWizardPage2.init();
                abstractWizardPage2.setInitialized(true);
            }
            this.setTitle(abstractWizardPage2.getTitle());
            if (abstractWizardPage != null) {
                abstractWizardPage.aboutToHidePanel();
            }
            this.mCardLayout.show(this.mViewPanel, abstractWizardPage2.getID());
            this.mCurrentPage = abstractWizardPage2;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    abstractWizardPage2.aboutToShowPanel();
                }
            });
        }
    }

    public void showPage(AbstractWizardPage abstractWizardPage) {
        if (abstractWizardPage != null) {
            this.mCardLayout.show(this.mViewPanel, abstractWizardPage.getID());
            this.mCurrentPage = abstractWizardPage;
        }
    }

    protected boolean canDispose() {
        if (this.mCurrentPage != null) {
            return this.mCurrentPage.canDispose();
        }
        return true;
    }

    protected boolean canBeRecalled() {
        return true;
    }

    protected boolean proceedWithNewDataset() {
        return true;
    }

    private void updateListTextDisplaySetting(BaseProcedureDialog.NameLabelOption nameLabelOption, Container container, boolean bl) {
        boolean bl2 = nameLabelOption.equals((Object)BaseProcedureDialog.NameLabelOption.show_names);
        boolean bl3 = nameLabelOption.equals((Object)BaseProcedureDialog.NameLabelOption.show_labels);
        for (Component component : container.getComponents()) {
            if (component instanceof VariableList) {
                VariableList variableList = (VariableList)component;
                if (bl2 || bl3) {
                    variableList.setShowVarLabels(bl3, false);
                    continue;
                }
                variableList.setShowVarLabels(bl, false);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.updateListTextDisplaySetting(nameLabelOption, (Container)component, bl);
        }
    }

    private void changeCmdButtonsState(AbstractWizardPage abstractWizardPage) {
        this.enableFinish(abstractWizardPage.isLastPage());
        this.enableBack(this.mWizardModel.hasPreviousPage());
        this.enableNext(abstractWizardPage.hasNextPage());
    }

    private void setActionInfo(AbstractAction abstractAction, String string) {
        abstractAction.putValue("Name", ResUtil.getCommonDlgString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            String string2 = string;
            Integer n = ResUtil.getCommonDlgAccessKey(string2 = string2.replaceFirst("IDS_", "IDK_"));
            if (n != null) {
                abstractAction.putValue("MnemonicKey", n);
            }
        }
    }

    protected class PageAlreadyRegistered
    extends Exception {
        private static final String sMessage = "This page is already registered!";

        protected PageAlreadyRegistered() {
        }

        @Override
        public String getMessage() {
            return sMessage;
        }

        @Override
        public String toString() {
            return sMessage;
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            BaseWizardDialog.this.setActionInfo(this, "IDS_HELP");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseWizardDialog.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            BaseWizardDialog.this.setActionInfo(this, "IDS_CANCEL");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BaseWizardDialog.this.doCancel()) {
                BaseWizardDialog.this.setVisible(false);
                BaseWizardDialog.this.dispose();
            }
        }
    }

    class FinishAction
    extends AbstractAction {
        FinishAction() {
            String string = "IDS_FINISH";
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                string = "IDS_FINISH_MAC";
            }
            BaseWizardDialog.this.setActionInfo(this, string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BaseWizardDialog.this.validateOnFinish()) {
                if (BaseWizardDialog.this.canBeRecalled()) {
                    ProcedureDlgMgr.getMgr().addRecallItem(BaseWizardDialog.this.getTitle(), BaseWizardDialog.this.getIActionKey());
                }
                if (BaseWizardDialog.this.proceedWithNewDataset()) {
                    Object object;
                    BaseWizardDialog.this.setVisible(false);
                    BaseWizardDialog.this.mGeneratedSyntax = BaseWizardDialog.this.generateSyntax();
                    if (BaseWizardDialog.this.mPasteExecuteSyntax && BaseWizardDialog.this.mGeneratedSyntax != null && BaseWizardDialog.this.mGeneratedSyntax.length() > 0) {
                        switch (BaseWizardDialog.this.doFinish().asInt()) {
                            case 0: {
                                SyntaxMgr.getSyntaxMgr().executeSyntax(BaseWizardDialog.this.mGeneratedSyntax);
                                break;
                            }
                            case 1: {
                                object = (SyntaxFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.SYNTAX_DOC);
                                if (object == null) break;
                                ((SyntaxFrame)object).pasteSyntax("\n" + BaseWizardDialog.this.mGeneratedSyntax);
                                break;
                            }
                            case 2: {
                                return;
                            }
                        }
                    } else {
                        ComponentState.trace1((String)"No syntax to execute/paset in BaseWizardDialog!", (int)15);
                    }
                    object = ((Object)((Object)BaseWizardDialog.this)).getClass().getName();
                    ProcedureDlgMgr.getMgr().saveDialogSize((String)object, BaseWizardDialog.this.getSize());
                    ProcedureDlgMgr.getMgr().saveDialogLocation((String)object, BaseWizardDialog.this.getLocation());
                    if (CommandLine.isClementineCaller()) {
                        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
                        boolean bl = true;
                        ProcedureDialogLoader.dialogExiting(BaseWizardDialog.this.getIActionKey(), locallyUniqueId, BaseWizardDialog.this.mGeneratedSyntax, bl);
                    }
                    BaseWizardDialog.this.dispose();
                }
            }
        }
    }

    class NextAction
    extends AbstractAction {
        NextAction() {
            String string = "IDS_NEXT";
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                string = "IDS_NEXT_MAC";
            }
            BaseWizardDialog.this.setActionInfo(this, string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BaseWizardDialog.this.mWizardModel.getCurrentPage().validate()) {
                BaseWizardDialog.this.showWizardPage(BaseWizardDialog.this.mWizardModel.getCurrentPage(), BaseWizardDialog.this.mWizardModel.getNextPage());
            }
        }
    }

    class BackAction
    extends AbstractAction {
        BackAction() {
            String string = "IDS_BACK";
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                string = "IDS_BACK_MAC";
            }
            BaseWizardDialog.this.setActionInfo(this, string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BaseWizardDialog.this.mWizardModel.getCurrentPage().validateOnBack()) {
                BaseWizardDialog.this.showWizardPage(BaseWizardDialog.this.mWizardModel.getCurrentPage(), BaseWizardDialog.this.mWizardModel.getPreviousPage());
            }
        }
    }

    public static enum WizardButton {
        eBack,
        eNext,
        eFinish,
        eCancel;

    }

    public static enum DoFinishAction {
        eOK(0),
        ePaste(1),
        eNone(2);

        private int mValue;

        private DoFinishAction(int n2) {
            this.mValue = n2;
        }

        public int asInt() {
            return this.mValue;
        }
    }
}

