/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseSpssTab;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.Component;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class BaseTabbedSubDialog
extends BaseSubDialog
implements ChangeListener {
    protected JTabbedPane mTabbedPane;

    public BaseTabbedSubDialog(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        FocusTraversalPolicy focusTraversalPolicy;
        BaseSpssTab baseSpssTab = (BaseSpssTab)this.mTabbedPane.getSelectedComponent();
        baseSpssTab.setEnabled(true);
        Vector<Object> vector = baseSpssTab.getComponentOrder();
        if (vector != null && !vector.isEmpty()) {
            Component[] componentArray;
            for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
                if (vector.contains(component)) continue;
                vector.add(component);
            }
            if (!vector.contains(this.mTabbedPane)) {
                vector.add(this.mTabbedPane);
            }
            focusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        } else {
            focusTraversalPolicy = new DefaultFocusTraversalPolicy();
        }
        baseSpssTab.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(focusTraversalPolicy);
    }

    public JPanel getCmdButtonPanel() {
        return this.mCmdButtonPanel;
    }

    @Override
    public String getDialogHelpID() {
        String string = "";
        BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
        if (baseProcedureTab != null) {
            string = baseProcedureTab.getDialogHelpID();
        }
        return string;
    }

    @Override
    public boolean continuePressed() {
        return this.canSwitchTab() && super.continuePressed();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        int n;
        if (dialogDataModel == null) {
            return;
        }
        super.loadState(dialogDataModel);
        Integer n2 = dialogDataModel.getInteger("LAST_SELECTED_SUBDIALOG_TAB");
        int n3 = n = n2 != null ? n2 : 0;
        if (this.mTabbedPane.getComponentCount() > n) {
            this.mTabbedPane.setSelectedIndex(n);
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(this.mParentDlg.getDialogDataModel());
        if (bl) {
            BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
            baseProcedureTab.saveTabState(this.mParentDlg.getDialogDataModel());
            dialogDataModel.putInteger("LAST_SELECTED_SUBDIALOG_TAB", this.mTabbedPane.getSelectedIndex());
        }
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.setupTabbedPane(jPanel);
    }

    private void setupTabbedPane(JPanel jPanel) {
        this.mTabbedPane = new JTabbedPane(){

            @Override
            public void setSelectedIndex(int n) {
                if (BaseTabbedSubDialog.this.canSwitchTab()) {
                    BaseProcedureTab baseProcedureTab = (BaseProcedureTab)BaseTabbedSubDialog.this.mTabbedPane.getComponentAt(n);
                    if (!baseProcedureTab.isInitialized()) {
                        baseProcedureTab.initPanel();
                        baseProcedureTab.setInitialized(true);
                        baseProcedureTab.loadTabState(BaseTabbedSubDialog.this.mParentDlg.getDialogDataModel(), BaseTabbedSubDialog.this.mParentDlg.getNameLabelOverride());
                    }
                    baseProcedureTab.aboutToShowTab();
                    super.setSelectedIndex(n);
                }
            }
        };
        this.mTabbedPane.setFocusable(true);
        this.mTabbedPane.addChangeListener(this);
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                BaseTabbedSubDialog.this.mTabbedPane.repaint();
            }
        };
        this.mTabbedPane.addFocusListener(focusAdapter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BaseTabbedSubDialog.this.mTabbedPane.requestFocusInWindow();
            }
        };
        this.mTabbedPane.addMouseListener(mouseAdapter);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, n);
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTabbedPane, gridBagConstraints, 0, 0, 1, 1, n2, insets);
    }

    protected void addTab(String string, BaseProcedureTab baseProcedureTab) {
        this.mTabbedPane.add(string, baseProcedureTab);
    }

    protected boolean canSwitchTab() {
        boolean bl = true;
        BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
        if (baseProcedureTab != null && (bl = baseProcedureTab.validateTab())) {
            baseProcedureTab.saveTabState(this.mParentDlg.getDialogDataModel());
        }
        return bl;
    }
}

