/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseSpssTab;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class BaseTabbedDialog
extends BaseProcedureDialog
implements ChangeListener {
    protected JTabbedPane mTabbedPane;
    private StatsHelp.Book mHelpMode;

    public BaseTabbedDialog(JFrame jFrame, boolean bl, String string, String string2) {
        this(jFrame, bl, string, string2, StatsHelp.Book.BASE);
    }

    public BaseTabbedDialog(JFrame jFrame, boolean bl, String string, String string2, StatsHelp.Book book) {
        super(jFrame, "", bl, string, string2);
        this.mHelpMode = book;
    }

    public JTabbedPane getTabbedPane() {
        return this.mTabbedPane;
    }

    @Override
    public String getDialogHelpID() {
        BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
        return baseProcedureTab.getDialogHelpID();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateTabOrderForSelectedTab();
    }

    public void updateTabOrderForSelectedTab() {
        FocusTraversalPolicy focusTraversalPolicy;
        BaseSpssTab baseSpssTab = (BaseSpssTab)this.mTabbedPane.getSelectedComponent();
        boolean bl = baseSpssTab.includeTableCells();
        baseSpssTab.setEnabled(true);
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = this.getAboveTabControls();
        if (vector2 != null && vector2.size() > 0) {
            vector.addAll(vector2);
            if (!vector.contains(this.mTabbedPane)) {
                vector.add(this.mTabbedPane);
            }
        }
        Vector<Object> vector3 = baseSpssTab.getComponentOrder();
        vector.addAll(vector3);
        if (vector != null && !vector.isEmpty()) {
            Component[] componentArray;
            for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
                if (vector.contains(component)) continue;
                vector.add(component);
            }
            if (!vector.contains(this.mTabbedPane) && vector2.size() == 0) {
                vector.add(this.mTabbedPane);
            }
            focusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false, bl);
        } else {
            focusTraversalPolicy = new DefaultFocusTraversalPolicy();
        }
        baseSpssTab.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(focusTraversalPolicy);
    }

    protected Vector<Object> getAboveTabControls() {
        return new Vector<Object>();
    }

    @Override
    public void reset() {
        Component[] componentArray;
        super.reset();
        for (Component component : componentArray = this.mTabbedPane.getComponents()) {
            ((BaseProcedureTab)component).reset();
        }
    }

    @Override
    public boolean okPastePressed() {
        return this.canSwitchTab() && super.okPastePressed();
    }

    @Override
    public void doHelp() {
        BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
        if (this.mHelpMode == StatsHelp.Book.BASE) {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, baseProcedureTab.getDialogHelpID());
        } else if (this.mHelpMode == StatsHelp.Book.IGRAPH) {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.IGRAPH, baseProcedureTab.getDialogHelpID());
        }
    }

    protected boolean canSwitchTab() {
        boolean bl = true;
        BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
        if (baseProcedureTab != null && (bl = baseProcedureTab.validateTab())) {
            baseProcedureTab.saveTabState(this.getDialogDataModel());
        }
        return bl;
    }

    @Override
    protected void validateComboBoxes() {
        BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
        baseProcedureTab.validateComboBoxes();
    }

    @Override
    protected void validateTableData() {
        BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
        baseProcedureTab.validateTableData();
    }

    @Override
    protected void validateSerializableLists() {
        BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
        baseProcedureTab.validateSerializableLists();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.setupTabbedPane(jPanel);
    }

    @Override
    protected void setLastTabSelected() {
        int n;
        Integer n2 = this.getDialogDataModel().getInteger("LAST_SELECTED_TAB");
        int n3 = n = n2 != null ? n2 : 0;
        if (this.mTabbedPane.getComponentCount() > n) {
            this.mTabbedPane.setSelectedIndex(n);
        }
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putInteger("LAST_SELECTED_TAB", this.mTabbedPane.getSelectedIndex());
    }

    protected void addTab(String string, BaseProcedureTab baseProcedureTab) {
        this.mTabbedPane.add(string, baseProcedureTab);
    }

    protected void setupTabbedPane(JPanel jPanel) {
        this.mTabbedPane = new JTabbedPane(){

            @Override
            public void setSelectedIndex(int n) {
                if (BaseTabbedDialog.this.canSwitchTab()) {
                    BaseProcedureTab baseProcedureTab = (BaseProcedureTab)BaseTabbedDialog.this.mTabbedPane.getComponentAt(n);
                    if (!baseProcedureTab.isInitialized()) {
                        baseProcedureTab.initPanel();
                        baseProcedureTab.setInitialized(true);
                        baseProcedureTab.loadTabState(BaseTabbedDialog.this.getDialogDataModel(), BaseTabbedDialog.this.mNameLabelOverride);
                    }
                    baseProcedureTab.aboutToShowTab();
                    super.setSelectedIndex(n);
                }
            }
        };
        this.mTabbedPane.setFocusable(true);
        this.mTabbedPane.addChangeListener(this);
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                BaseTabbedDialog.this.mTabbedPane.repaint();
            }
        };
        this.mTabbedPane.addFocusListener(focusAdapter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BaseTabbedDialog.this.mTabbedPane.requestFocusInWindow();
            }
        };
        this.mTabbedPane.addMouseListener(mouseAdapter);
        this.addMainViewComponents(jPanel);
    }

    protected void addMainViewComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTabbedPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
    }
}

