/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSpssDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IModelTermsListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.IPlainListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public abstract class BaseSubDialog
extends BaseDialog {
    protected BaseProcedureDialog.NameLabelOption mNameLabelOverride = BaseProcedureDialog.NameLabelOption.no_override;
    protected BaseProcedureDialog mParentDlg;
    protected IVarMoveHandler mVarMoveHandler;
    protected IPlainListVarMoveHandler mPlainListVarMoveHandler;
    protected IModelTermsListVarMoveHandler mModelListVarMoveHandler;
    private boolean mContinuePressed;
    private ContinueAction mContinueAction;
    protected JButton mContinueButton;
    protected JButton mCancelButton;
    protected JButton mHelpButton;

    public BaseSubDialog(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        this(baseProcedureDialog, string, bl, baseProcedureDialog.getResourceBundle(), baseProcedureDialog.getImageFilePath());
    }

    public BaseSubDialog(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, String string2, String string3) {
        this(baseProcedureDialog, string, bl, ResUtil.getBundle(string2, ResUtil.getLocale()), string3);
    }

    public BaseSubDialog(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, ResourceBundle resourceBundle, String string2) {
        super((JDialog)((Object)baseProcedureDialog), string, bl, resourceBundle, string2);
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseSubDialog.this.loadState(BaseSubDialog.this.mParentDlg.getDialogDataModel());
                DialogUtil.resetTextCompUndoManager((Container)((Object)BaseSubDialog.this));
            }
        });
    }

    public boolean wasContinuePressed() {
        return this.mContinuePressed;
    }

    public void setContinuePressed(boolean bl) {
        this.mContinuePressed = bl;
    }

    public boolean continuePressed() {
        return true;
    }

    public void enableContinue(boolean bl) {
        if (this.mContinueAction != null) {
            this.mContinueAction.setEnabled(bl);
        }
    }

    public String getDialogHelpID() {
        return "none";
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            DialogUtil.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this.mVarMoveHandler);
        }
    }

    public void setNameLabelOverride(BaseProcedureDialog.NameLabelOption nameLabelOption, boolean bl) {
        this.mNameLabelOverride = nameLabelOption;
        BaseSpssDialog.updateListTextDisplaySetting(nameLabelOption, (Container)((Object)this), bl);
    }

    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = BaseProcedureDialog.saveState(dialogDataModel, (Container)((Object)this));
        if (bl) {
            String string = this.mParentDlg.getIActionKey() + ((Object)((Object)this)).getClass().getSimpleName();
            ProcedureDlgMgr.getMgr().saveDialogSize(string, this.getSize());
            ProcedureDlgMgr.getMgr().saveDialogLocation(string, this.getLocation());
        }
        return bl;
    }

    protected void loadState(DialogDataModel dialogDataModel) {
        BaseProcedureDialog.loadState(dialogDataModel, (Container)((Object)this), this.mParentDlg.getNameLabelOverride());
        this.loadSizeAndLocationState();
    }

    protected void loadSizeAndLocationState() {
        Dimension dimension = this.getSavedSize();
        if (dimension != null) {
            this.setSize(dimension);
        }
        String string = this.mParentDlg.getIActionKey() + ((Object)((Object)this)).getClass().getSimpleName();
        Point point = ProcedureDlgMgr.getMgr().getDialogLocation(string);
        if (point != null) {
            this.setLocation(point);
        } else {
            this.setLocationRelativeTo(this.getParent());
        }
    }

    public Dimension getSavedSize() {
        String string = this.mParentDlg.getIActionKey() + ((Object)((Object)this)).getClass().getSimpleName();
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize(string);
        return dimension;
    }

    protected void prepareAutomationState() {
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mContinueAction = new ContinueAction();
        this.mContinueButton = new JButton(this.mContinueAction);
        this.mCancelButton = new JButton((Action)this.createCancelAction());
        this.mHelpButton = new JButton((Action)this.createHelpAction());
        DialogUtil.setupMacHelpButton(this.mHelpButton);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mContinueButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mContinueButton);
                jPanel.add(this.mCancelButton);
                jPanel.add(this.mHelpButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            this.mContinueButton = new JButton(new ContinueAction());
            jPanel.add(this.mContinueButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCancelButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mHelpButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mContinueButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected void setComponentEnableState(Component component, boolean bl) {
        if (component instanceof JTextField) {
            ((JTextField)component).setEditable(bl);
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < ((Container)component).getComponentCount(); ++i) {
                this.setComponentEnableState(componentArray[i], bl);
            }
            component.setEnabled(bl);
            if (component instanceof JPanel) {
                this.enableTitledBorder((JPanel)component, bl);
            }
        }
    }

    protected void enableTitledBorder(JPanel jPanel, boolean bl) {
        Border border = jPanel.getBorder();
        UIManager.getColor("Button.disabled");
        if (border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            titledBorder.setTitleColor(UIManager.getColor("TitledBorder.titleColor"));
        }
    }

    protected void init() {
        super.init();
        this.mParentDlg = (BaseProcedureDialog)((Object)this.getParent());
        this.mParentDlg.saveDialogState();
    }

    protected void renameContinueAction(String string) {
        this.mContinueAction.putValue("Name", ResUtil.getCommonDlgString(string));
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
            this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseSubDialog.this.mContinuePressed = true;
            if (BaseSubDialog.this.continuePressed() && BaseSubDialog.this.saveState(BaseSubDialog.this.mParentDlg.getDialogDataModel())) {
                BaseSubDialog.this.dispose();
            } else {
                BaseSubDialog.this.mContinuePressed = false;
            }
        }
    }
}

