/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ExtensionType;
import com.spss.java_client.core.documents.data.dictionary.IDatasetViewObserver;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssCalculatedScaleVar;
import com.spss.java_client.core.documents.data.dictionary.SpssMRVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariableSortType;
import com.spss.java_client.core.documents.data.dictionary.TimeDependentPredictors;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.server.messages.DataEditorMsg.CellValue;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.DefaultEditableListModel;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.LayeredListWidget;
import com.spss.java_client.ui.controls.MultiVarListAccessor;
import com.spss.java_client.ui.controls.SerializableEditableList;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.data.merge_files.add_cases.AddCasesDlg;
import com.spss.java_client.ui.dialogs.base.data.merge_files.add_variables.AddVariablesDlg;
import com.spss.java_client.ui.dialogs.base.graphs.interactive.SpssIGraphVariable;
import com.spss.java_client.ui.dialogs.common.BaseSpssDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.ComponentVisitor;
import com.spss.java_client.ui.dialogs.common.DdmInspectorDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IPlainListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.doc_util.ProcedureDialogLoader;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxPrefManager;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.shared.syntaxeditor.SyntaxMasterPanel;
import com.spss.shared.syntaxeditor.shared_objects.SyntaxEditorState;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public abstract class BaseProcedureDialog
extends BaseDialog {
    protected static final String NAMES_LABELS_KEY = "NamesLabelsKey";
    protected static final String SORT_ORDER_KEY = "SortOrderKey";
    protected static final String TIMESTAMP_KEY = "TimeStampKey";
    private static DialogLoadData sLoadData = null;
    private static boolean sAddMissingVars = true;
    protected static String sLastDatasetName = "";
    protected JPanel mOptionButtonPanel;
    protected OkAction mOkAction;
    protected PasteAction mPasteAction;
    protected ResetAction mResetAction;
    protected CancelAction mCancelAction;
    protected HelpAction mHelpAction;
    protected JButton mOkButton;
    protected JButton mPasteButton;
    protected JButton mResetButton;
    protected JButton mCancelButton;
    protected JButton mHelpButton;
    protected JButton mPressedButton;
    protected NameLabelOption mNameLabelOverride = NameLabelOption.no_override;
    protected IVarMoveHandler mVarMoveHandler;
    protected IPlainListVarMoveHandler mPlainListVarMoveHandler;
    private DialogDataModel mDialogDataModel = new DialogDataModel();
    private DataViewObserverAdapter mDataViewObserverAdapter;
    protected boolean mOkPastePressed;

    public BaseProcedureDialog(JFrame jFrame, String string, String string2) throws HeadlessException {
        this(jFrame, "", false, string, string2);
    }

    public BaseProcedureDialog(JFrame jFrame, boolean bl, String string, String string2) throws HeadlessException {
        this(jFrame, "", bl, string, string2);
    }

    public BaseProcedureDialog(JFrame jFrame, String string, String string2, String string3) throws HeadlessException {
        this(jFrame, string, false, string2, string3);
    }

    public BaseProcedureDialog(JFrame jFrame, String string, boolean bl, String string2, String string3) throws HeadlessException {
        super(jFrame, string, bl, ResUtil.getBundle(string2, ResUtil.getLocale()), string3);
        SpssMgr.getSpssMgr().writeToKeyboardMonitor(((Object)((Object)this)).getClass().getSimpleName());
        if (CommandLine.isExternalCaller()) {
            this.setPasteExecuteSyntax(false);
        }
        this.setDefaultCloseOperation(2);
        this.addDataSourceObserver();
        String string4 = System.getenv("DDM_DEBUG");
        if (string4 != null) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiersEx();
                    if ((n & 0x40) != 0 && (n & 0x80) != 0) {
                        new DdmInspectorDlg(BaseProcedureDialog.this);
                    }
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (BaseProcedureDialog.this.isDisplayable()) {
                    ProcedureDlgMgr.getMgr().loadPersistentState(BaseProcedureDialog.this.getIActionKey(), BaseProcedureDialog.this.getDialogDataModel());
                    BaseProcedureDialog.this.loadDialogState();
                    BaseProcedureDialog.this.setLastTabSelected();
                    DialogUtil.resetTextCompUndoManager((Container)((Object)BaseProcedureDialog.this));
                }
            }
        });
    }

    public boolean canPrependActivateSyntax() {
        return true;
    }

    public abstract String generateSyntax();

    public abstract String getIActionKey();

    public abstract String getDialogHelpID();

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    public void reset() {
        if (!CommandLine.isClementineCaller()) {
            this.mDialogDataModel.clear();
            ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.mDialogDataModel);
        } else {
            Map<String, String> map = this.mDialogDataModel.getStringsByKeyPrefix("EXPORT_XML_FILE_PATH");
            this.mDialogDataModel.clear();
            this.restoreDdmEntries(map);
            ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.mDialogDataModel);
        }
        this.setNameLabelOverride(NameLabelOption.no_override, true);
    }

    private void restoreDdmEntries(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.mDialogDataModel.putString(entry.getKey(), entry.getValue());
        }
    }

    public NameLabelOption getNameLabelOverride() {
        return this.mNameLabelOverride;
    }

    public void setNameLabelOverride(NameLabelOption nameLabelOption, boolean bl) {
        if (nameLabelOption == this.mNameLabelOverride) {
            return;
        }
        this.mNameLabelOverride = nameLabelOption;
        BaseSpssDialog.updateListTextDisplaySetting(nameLabelOption, (Container)((Object)this), bl);
    }

    public boolean runSubDialog(BaseSubDialog baseSubDialog) {
        baseSubDialog.setVisible(true);
        return baseSubDialog.wasContinuePressed();
    }

    public void pack() {
        if (this.mOptionButtonPanel != null && this.mOptionButtonPanel.getComponentCount() == 0) {
            this.getContentPane().remove(this.mOptionButtonPanel);
        }
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            DialogUtil.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this.mVarMoveHandler);
        }
    }

    public void dispose() {
        super.dispose();
        this.removeDataSourceObserver();
        ProcedureDlgMgr.getMgr().removeProcedureDialog(this.getIActionKey());
    }

    public DialogDataModel getDialogDataModel() {
        return this.mDialogDataModel;
    }

    public void setDialogDataModel(DialogDataModel dialogDataModel) {
        this.mDialogDataModel = dialogDataModel;
    }

    public boolean wasOkPastePressed() {
        return this.mOkPastePressed;
    }

    protected boolean okPastePressed() {
        return this.validateDialogDataModel(true);
    }

    protected boolean cancelPressed() {
        return true;
    }

    public static boolean saveState(DialogDataModel dialogDataModel, Container container) {
        BaseProcedureDialog baseProcedureDialog;
        if (container instanceof BaseProcedureDialog && !(baseProcedureDialog = (BaseProcedureDialog)((Object)container)).getNameLabelOverride().equals((Object)NameLabelOption.no_override)) {
            dialogDataModel.putInteger(NAMES_LABELS_KEY, baseProcedureDialog.getNameLabelOverride().ordinal());
        }
        return BaseProcedureDialog.recursiveSaveState(dialogDataModel, container);
    }

    public static void loadState(DialogDataModel dialogDataModel, Container container, NameLabelOption nameLabelOption) {
        BaseProcedureDialog.loadState(dialogDataModel, container, nameLabelOption, true);
    }

    public static void loadState(DialogDataModel dialogDataModel, Container container, NameLabelOption nameLabelOption, boolean bl) {
        if (dialogDataModel == null) {
            return;
        }
        if (container instanceof BaseProcedureDialog) {
            BaseProcedureDialog baseProcedureDialog = (BaseProcedureDialog)((Object)container);
            Integer n = dialogDataModel.getInteger(NAMES_LABELS_KEY);
            if (n != null) {
                if (n == 1) {
                    baseProcedureDialog.setNameLabelOverride(NameLabelOption.show_names, true);
                } else if (n == 2) {
                    baseProcedureDialog.setNameLabelOverride(NameLabelOption.show_labels, true);
                }
            }
        }
        sLoadData = new DialogLoadData();
        BaseProcedureDialog.recursiveLoadState(dialogDataModel, container, nameLabelOption);
        for (ISpssVariable iSpssVariable : sLoadData.getTimeStampChangedTargetVars()) {
            sLoadData.getSrcVariableList().getModel().removeElement(iSpssVariable);
        }
        if (container instanceof BaseProcedureDialog || container instanceof BaseWizardDialog) {
            BaseProcedureDialog.addMissingVarsToSrcList();
        }
        sLoadData = null;
        if (bl) {
            BaseProcedureDialog.makeProcedureDialogVisible(container);
        }
    }

    protected void loadSimpleState() {
        this.loadSizeAndLocationState();
        BaseProcedureDialog.makeProcedureDialogVisible((Container)((Object)this));
    }

    protected static void makeProcedureDialogVisible(final Container container) {
        if (container instanceof Window) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    container.setVisible(true);
                }
            });
        }
    }

    public static void setAddMissingVars(boolean bl) {
        sAddMissingVars = bl;
    }

    public static boolean addMissingVars() {
        return sAddMissingVars;
    }

    public static void addMissingVarsToSrcList() {
        if (sLoadData == null) {
            return;
        }
        if (sLoadData.getDialogVarsMap().size() > 0 && sAddMissingVars) {
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            if (iSpssDataSrc == null) {
                return;
            }
            int n = 0;
            int n2 = iSpssDataSrc.columnCount();
            VarListModel varListModel = sLoadData.getSrcVariableList().getModel();
            if (n2 != sLoadData.getDialogVarsMap().size()) {
                for (int i = 0; i < n2; ++i) {
                    ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                    if (sLoadData.getDialogVarsMap().get(iSpssVariable.getId().asInt()) != null || varListModel.findElementIndex(iSpssVariable) != -1 || !varListModel.addElement(iSpssVariable, false)) continue;
                    ++n;
                }
                if (n > 0) {
                    varListModel.sort();
                }
            }
        }
    }

    protected DataViewObserverAdapter createDataSourceObserver() {
        return new DataViewObserverAdapter();
    }

    protected void addDataSourceObserver() {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            this.mDataViewObserverAdapter = this.createDataSourceObserver();
            iSpssDataSrc.addObserver((IDatasetViewObserver)this.mDataViewObserverAdapter);
        }
    }

    protected void removeDataSourceObserver() {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null && this.mDataViewObserverAdapter != null) {
            iSpssDataSrc.removeObserver((IDatasetViewObserver)this.mDataViewObserverAdapter);
        }
    }

    protected boolean validateDialogDataModel(boolean bl) {
        return true;
    }

    protected void loadDialogState() {
        this.loadSizeAndLocationState();
        BaseProcedureDialog.loadState(this.getDialogDataModel(), (Container)((Object)this), this.mNameLabelOverride);
    }

    protected void loadSizeAndLocationState() {
        Point point;
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize(this.getIActionKey());
        if (dimension != null) {
            this.setSize(dimension);
        }
        if ((point = ProcedureDlgMgr.getMgr().getDialogLocation(this.getIActionKey())) != null) {
            this.setLocation(point);
        } else {
            this.setLocationRelativeTo(this.getParent());
        }
    }

    protected void saveDialogState() {
        if (this.getDialogDataModel() == null) {
            return;
        }
        BaseProcedureDialog.saveState(this.getDialogDataModel(), (Container)((Object)this));
        ProcedureDlgMgr.getMgr().saveDialogSize(this.getIActionKey(), this.getSize());
        ProcedureDlgMgr.getMgr().saveDialogLocation(this.getIActionKey(), this.getLocation());
    }

    protected void enableOkPaste(boolean bl) {
        if (this.mOkAction != null) {
            this.mOkAction.setEnabled(bl);
        }
        if (this.mPasteAction != null) {
            this.mPasteAction.setEnabled(bl);
        }
    }

    protected void enableOkPaste(boolean bl, boolean bl2) {
        if (this.mOkAction != null) {
            this.mOkAction.setEnabled(bl);
        }
        if (this.mPasteAction != null) {
            this.mPasteAction.setEnabled(bl2);
        }
    }

    protected void enablePaste(boolean bl) {
        if (this.mPasteAction != null) {
            this.mPasteAction.setEnabled(bl);
        }
    }

    protected void enableReset(boolean bl) {
        if (this.mResetAction != null) {
            this.mResetAction.setEnabled(bl);
        }
    }

    protected void init() {
        super.init();
        this.mOptionButtonPanel = this.setupOptionsButtonPanel();
        if (this.mOptionButtonPanel != null) {
            DialogUtil.normalizeButtonWidths((JPanel)this.mOptionButtonPanel);
        }
        boolean bl = DialogUtil.areCommandButtonsBelow();
        JPanel jPanel = (JPanel)this.mViewPanel.getParent();
        jPanel.add((Component)this.mViewPanel, "Center");
        if (this.mOptionButtonPanel != null) {
            jPanel.add((Component)this.mOptionButtonPanel, bl ? "East" : "South");
        }
        if (this.mOptionButtonPanel != null) {
            DialogUtil.createCmdButtonGroup(this.mOptionButtonPanel);
        }
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        this.mOkAction = new OkAction();
        this.mPasteAction = new PasteAction();
        this.mResetAction = new ResetAction();
        this.mCancelAction = new CancelAction();
        this.mHelpAction = new HelpAction();
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.mOkButton = new JButton(this.mOkAction);
        this.mPasteButton = new JButton(this.mPasteAction);
        this.mResetButton = new JButton(this.mResetAction);
        this.mCancelButton = new JButton(this.mCancelAction);
        this.mHelpButton = new JButton(this.mHelpAction);
        DialogUtil.setupMacHelpButton(this.mHelpButton);
        if (UIToolDialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                int n3 = 0;
                DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, n3, 0, 1, 1, n2, null);
                DialogUtil.addUsingGBL(jPanel, this.mResetButton, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
                if (VersionInfo.allowSyntax()) {
                    DialogUtil.addUsingGBL(jPanel, this.mPasteButton, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
                }
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                if (VersionInfo.allowSyntax() && !CommandLine.isExternalCaller()) {
                    jPanel.add(this.mPasteButton);
                }
                jPanel.add(this.mResetButton);
                jPanel.add(this.mCancelButton);
                jPanel.add(this.mHelpButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createVerticalStrut(n));
            if (VersionInfo.allowSyntax() && !CommandLine.isExternalCaller()) {
                jPanel.add(this.mPasteButton);
                jPanel.add(Box.createVerticalStrut(n));
            }
            jPanel.add(this.mResetButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCancelButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mHelpButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.enableOkPaste(false);
        this.getRootPane().setDefaultButton(this.mOkButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    protected JButton getHelpButton() {
        return this.mHelpButton;
    }

    protected JButton getOkButton() {
        return this.mOkButton;
    }

    protected JButton getPasteButton() {
        return this.mPasteButton;
    }

    protected JButton getResetButton() {
        return this.mResetButton;
    }

    protected void renameOKAction(String string) {
        this.mOkButton.getAction().putValue("Name", ResUtil.getCommonDlgString(string));
    }

    protected JPanel setupOptionsButtonPanel() {
        boolean bl = DialogUtil.areCommandButtonsBelow();
        JPanel jPanel = new JPanel(true);
        if (bl) {
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
        } else {
            Insets insets = DialogUtil.getStandardButtonInsets();
            int n = insets.left + insets.right;
            int n2 = insets.top + insets.bottom;
            FlowLayout flowLayout = new FlowLayout(1, n, n2);
            jPanel.setLayout(flowLayout);
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        }
        return jPanel;
    }

    protected void addOptionsPanelButton(JPanel jPanel, JButton jButton) {
        if (!DialogUtil.areCommandButtonsBelow()) {
            jPanel.add(jButton);
        } else {
            Insets insets = DialogUtil.getStandardButtonInsets();
            int n = insets.top + insets.bottom;
            if (jPanel.getComponentCount() == 0) {
                Component component = Box.createVerticalStrut(n * 2);
                jPanel.add(component);
            }
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
    }

    protected boolean canBeRecalled() {
        return true;
    }

    protected static boolean recursiveSaveState(DialogDataModel dialogDataModel, Container container) {
        boolean bl = true;
        for (Component component : container.getComponents()) {
            Object[] objectArray;
            Serializable serializable;
            Object object;
            if (component instanceof SrcVariableList) {
                BaseProcedureDialog.saveSourceVarList((SrcVariableList)component, dialogDataModel);
                continue;
            }
            if (component instanceof TargetVariableList) {
                object = (TargetVariableList)component;
                BaseProcedureDialog.saveTargetVarList(((VariableList)object).getIdentifier(), ((VariableList)object).getModel(), dialogDataModel);
                continue;
            }
            if (component instanceof MultiVarListAccessor) {
                object = (MultiVarListAccessor)((Object)component);
                serializable = object.getVarListModels();
                objectArray = object.getTargetVariableList().getIdentifier();
                for (int i = 0; i < serializable.size(); ++i) {
                    VarListModel varListModel = serializable.get(i);
                    BaseProcedureDialog.saveTargetVarList((String)objectArray + i, varListModel, dialogDataModel);
                }
                continue;
            }
            if (component instanceof JToggleButton && ((JToggleButton)component).getAction() instanceof ToggleButtonAction) {
                object = (ToggleButtonAction)((JToggleButton)component).getAction();
                dialogDataModel.putBoolean(((ControlAction)object).getActionKey(), ((JToggleButton)component).isSelected());
                continue;
            }
            if (component instanceof JComboBox && ((JComboBox)component).getAction() instanceof ComboboxAction) {
                object = (ComboboxAction)((JComboBox)component).getAction();
                serializable = ((JComboBox)component).getSelectedIndex();
                boolean bl2 = serializable != null && (Integer)serializable > -1;
                dialogDataModel.putInteger(((ControlAction)object).getActionKey(), (Integer)((Object)(bl2 ? serializable : null)));
                dialogDataModel.putString(((ControlAction)object).getActionKey(), bl2 ? ((JComboBox)component).getSelectedItem().toString() : null);
                continue;
            }
            if (component instanceof JTextField && ((JTextField)component).getAction() instanceof TextFieldAction) {
                object = (TextFieldAction)((JTextField)component).getAction();
                dialogDataModel.putString(((ControlAction)object).getActionKey(), ((JTextField)component).getText());
                continue;
            }
            if (component instanceof SerializableList) {
                object = (SerializableList)component;
                if (!((SerializableList)object).isSerializable()) continue;
                objectArray = new Object[((JList)object).getModel().getSize()];
                LinkedList<SerializableObject> linkedList = new LinkedList<SerializableObject>();
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = serializable = ((JList)object).getModel().getElementAt(i);
                    if (!(serializable instanceof SerializableObject)) continue;
                    linkedList.add((SerializableObject)serializable);
                }
                if (linkedList.size() == ((JList)object).getModel().getSize()) {
                    dialogDataModel.putSerializableArray(((SerializableList)object).getActionKey(), linkedList.toArray(new SerializableObject[linkedList.size()]));
                    if (((JList)object).getModel().getSize() == 0) {
                        dialogDataModel.putArray(((SerializableList)object).getActionKey(), objectArray);
                        continue;
                    }
                    dialogDataModel.putArray(((SerializableList)object).getActionKey(), null);
                    continue;
                }
                dialogDataModel.putArray(((SerializableList)object).getActionKey(), objectArray);
                if (((JList)object).getModel().getSize() == 0) {
                    dialogDataModel.putSerializableArray(((SerializableList)object).getActionKey(), new SerializableObject[0]);
                    continue;
                }
                dialogDataModel.putSerializableArray(((SerializableList)object).getActionKey(), null);
                continue;
            }
            if (component instanceof SerializableEditableList) {
                object = (SerializableEditableList)component;
                if (!((SerializableEditableList)object).isSerializable()) continue;
                serializable = (DefaultEditableListModel)((JList)object).getModel();
                objectArray = new Object[((DefaultListModel)serializable).getSize()];
                ((DefaultListModel)serializable).copyInto(objectArray);
                dialogDataModel.putArray(((SerializableEditableList)object).getActionKey(), objectArray);
                continue;
            }
            if (component instanceof Container && !(bl = BaseProcedureDialog.recursiveSaveState(dialogDataModel, (Container)component))) break;
        }
        return bl;
    }

    protected static void recursiveLoadState(DialogDataModel dialogDataModel, Container container, NameLabelOption nameLabelOption) {
        for (Component component : container.getComponents()) {
            Object object;
            Serializable serializable;
            if (component instanceof SrcVariableList) {
                BaseProcedureDialog.loadSourceList((SrcVariableList)component, dialogDataModel, nameLabelOption);
                continue;
            }
            if (component instanceof TargetVariableList) {
                BaseProcedureDialog.loadTargetList((TargetVariableList)component, dialogDataModel, nameLabelOption);
                continue;
            }
            if (component instanceof MultiVarListAccessor) {
                BaseProcedureDialog.updateDialogVarMapWithUsedVars((MultiVarListAccessor)((Object)component), dialogDataModel);
                continue;
            }
            if (component instanceof JToggleButton && ((JToggleButton)component).getAction() instanceof ToggleButtonAction) {
                serializable = (ToggleButtonAction)((JToggleButton)component).getAction();
                object = dialogDataModel.getBoolean(((ControlAction)serializable).getActionKey());
                if (object == null) continue;
                ((JToggleButton)component).setSelected(object.booleanValue());
                continue;
            }
            if (component instanceof JComboBox && ((JComboBox)component).getAction() instanceof ComboboxAction) {
                serializable = (ComboboxAction)((JComboBox)component).getAction();
                object = dialogDataModel.getInteger(((ControlAction)serializable).getActionKey());
                if (object == null) continue;
                int n = ((JComboBox)component).getModel().getSize();
                if (object.intValue() >= 0 && object.intValue() < n) {
                    ((JComboBox)component).setSelectedIndex(object.intValue());
                    continue;
                }
                ((JComboBox)component).setSelectedItem(null);
                continue;
            }
            if (component instanceof JTextField && ((JTextField)component).getAction() instanceof TextFieldAction) {
                serializable = (TextFieldAction)((JTextField)component).getAction();
                object = dialogDataModel.getString(((ControlAction)serializable).getActionKey());
                if (object == null) continue;
                ((JTextField)component).setText((String)object);
                continue;
            }
            if (component instanceof SerializableList) {
                serializable = (SerializableList)component;
                if (!((SerializableList)serializable).isSerializable() || !(((JList)serializable).getModel() instanceof DefaultListModel)) continue;
                object = dialogDataModel.getSerializableArray(((SerializableList)serializable).getActionKey());
                if (object != null) {
                    DefaultListModel defaultListModel = (DefaultListModel)((JList)serializable).getModel();
                    defaultListModel.removeAllElements();
                    for (SerializableObject serializableObject : object) {
                        defaultListModel.addElement(serializableObject);
                    }
                    continue;
                }
                Object[] objectArray = dialogDataModel.getArray(((SerializableList)serializable).getActionKey());
                Object[] objectArray2 = objectArray = objectArray == null ? dialogDataModel.getSerializableArray(((SerializableList)serializable).getActionKey()) : objectArray;
                if (objectArray == null) continue;
                DefaultListModel defaultListModel = (DefaultListModel)((JList)serializable).getModel();
                defaultListModel.removeAllElements();
                Object[] objectArray3 = objectArray;
                int n = objectArray3.length;
                for (int i = 0; i < n; ++i) {
                    Object object2 = objectArray3[i];
                    defaultListModel.addElement(object2);
                }
                continue;
            }
            if (component instanceof SerializableEditableList) {
                serializable = (SerializableEditableList)component;
                if (!((SerializableEditableList)serializable).isSerializable() || !(((JList)serializable).getModel() instanceof DefaultEditableListModel) || (object = dialogDataModel.getArray(((SerializableEditableList)serializable).getActionKey())) == null) continue;
                DefaultEditableListModel defaultEditableListModel = (DefaultEditableListModel)((JList)serializable).getModel();
                defaultEditableListModel.clear();
                for (SerializableObject serializableObject : object) {
                    defaultEditableListModel.addElement(serializableObject);
                }
                continue;
            }
            if (!(component instanceof Container)) continue;
            BaseProcedureDialog.recursiveLoadState(dialogDataModel, (Container)component, nameLabelOption);
        }
    }

    private static void updateDialogVarMapWithUsedVars(MultiVarListAccessor multiVarListAccessor, DialogDataModel dialogDataModel) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null) {
            ISpssVariable[] iSpssVariableArray;
            String string = multiVarListAccessor.getTargetVariableList().getIdentifier();
            for (int i = 0; i < multiVarListAccessor.getMaxNoOfLayers() && (iSpssVariableArray = dialogDataModel.getVarArray(string + i)) != null && iSpssVariableArray.length > 0; ++i) {
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    sLoadData.getDialogVarsMap().put(iSpssVariable.getId().asInt(), true);
                }
            }
        }
    }

    protected void validateSerializableLists() {
    }

    protected void validateComboBoxes() {
    }

    protected void validateTableData() {
    }

    protected void setLastTabSelected() {
    }

    public static void saveSourceVarList(SrcVariableList srcVariableList, DialogDataModel dialogDataModel) {
        if (srcVariableList.getDragType() == VariableList.VarMoveType.eMoveOriginal) {
            dialogDataModel.putLong(TIMESTAMP_KEY, Calendar.getInstance().getTimeInMillis());
            int n = srcVariableList.getModel().getSize();
            ISpssVariable[] iSpssVariableArray = new ISpssVariable[n];
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable;
                iSpssVariableArray[i] = iSpssVariable = srcVariableList.getModel().getElementAt(i);
            }
            dialogDataModel.putVarArray(srcVariableList.getIdentifier(), iSpssVariableArray);
        }
        if (!srcVariableList.getLockItemDisplay()) {
            dialogDataModel.putInteger(SORT_ORDER_KEY, srcVariableList.getModel().getSortType().ordinal());
        }
    }

    public static void saveTargetVarList(String string, VarListModel varListModel, DialogDataModel dialogDataModel) {
        int n = varListModel.getSize();
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[n];
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable;
            iSpssVariableArray[i] = iSpssVariable = varListModel.getElementAt(i);
        }
        dialogDataModel.putVarArray(string, iSpssVariableArray);
    }

    public static void loadSourceList(SrcVariableList srcVariableList, DialogDataModel dialogDataModel, NameLabelOption nameLabelOption) {
        Object object;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc == null || !srcVariableList.isLoadFromPersistent()) {
            return;
        }
        if (sLoadData == null) {
            sLoadData = new DialogLoadData();
        }
        sLoadData.setSrcVariableList(srcVariableList);
        if (srcVariableList.getDragType() == VariableList.VarMoveType.eMoveOriginal && (object = dialogDataModel.getVarArray(srcVariableList.getIdentifier())) != null && dialogDataModel.hasVarArray(srcVariableList.getIdentifier())) {
            boolean bl = false;
            Vector<Object> vector = new Vector<Object>();
            srcVariableList.getModel().removeAll();
            for (Object object2 : object) {
                if (object2 == null) continue;
                srcVariableList.getModel().addElement((ISpssVariable)object2, false);
                sLoadData.getDialogVarsMap().put(object2.getId().asInt(), true);
                vector.add(object2);
            }
            VarListModel varListModel = srcVariableList.getModel();
            long l = dialogDataModel.getLong(TIMESTAMP_KEY);
            for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                boolean bl2 = CommandLine.isExternalCaller();
                if (bl2 || iSpssVariable.getTimeStamp() <= l || varListModel.findElementIndex(iSpssVariable) != -1) continue;
                srcVariableList.getModel().addElement(iSpssVariable, false);
                sLoadData.addTimeStampChangedVariable(iSpssVariable);
                vector.add(iSpssVariable);
                bl = true;
            }
            if (bl) {
                ISpssVariable[] iSpssVariableArray = new ISpssVariable[vector.size()];
                dialogDataModel.putArray(srcVariableList.getIdentifier(), vector.toArray(iSpssVariableArray));
            }
        }
        if (!srcVariableList.getLockItemDisplay()) {
            object = dialogDataModel.getInteger(SORT_ORDER_KEY);
            if (object != null) {
                if (((Integer)object).intValue() == SpssVariableSortType.alpha.ordinal()) {
                    srcVariableList.getModel().setSortType(SpssVariableSortType.alpha);
                } else if (((Integer)object).intValue() == SpssVariableSortType.file.ordinal()) {
                    srcVariableList.getModel().setSortType(SpssVariableSortType.file);
                } else if (((Integer)object).intValue() == SpssVariableSortType.measurement.ordinal()) {
                    srcVariableList.getModel().setSortType(SpssVariableSortType.measurement);
                }
            }
            if (nameLabelOption.equals((Object)NameLabelOption.show_names)) {
                srcVariableList.setShowVarLabels(false, false);
            } else if (nameLabelOption.equals((Object)NameLabelOption.show_labels)) {
                srcVariableList.setShowVarLabels(true, false);
            }
        }
    }

    public static void loadTargetList(TargetVariableList targetVariableList, DialogDataModel dialogDataModel, NameLabelOption nameLabelOption) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc == null || !targetVariableList.isLoadFromPersistent()) {
            return;
        }
        if (sLoadData == null) {
            sLoadData = new DialogLoadData();
        }
        boolean bl = CommandLine.isClementineCaller();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(targetVariableList.getIdentifier());
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            ISpssVariable[] iSpssVariableArray2;
            Vector<ISpssVariable[]> vector = new Vector<ISpssVariable[]>();
            targetVariableList.getModel().removeAll();
            for (int i = 0; i < iSpssVariableArray.length; ++i) {
                SrcVariableList srcVariableList;
                iSpssVariableArray2 = iSpssVariableArray[i];
                if (iSpssVariableArray2 == null) continue;
                if (!targetVariableList.getModel().addElement((ISpssVariable)iSpssVariableArray2, false) && (srcVariableList = BaseProcedureDialog.getCurrentSrcList(targetVariableList)) != null) {
                    srcVariableList.getModel().addElement((ISpssVariable)iSpssVariableArray2);
                }
                if (!(bl || iSpssVariableArray2 instanceof SpssIGraphVariable || iSpssVariableArray2 instanceof SpssCalculatedScaleVar || iSpssVariableArray2 instanceof TimeDependentPredictors || iSpssVariableArray2 instanceof SpssMRVariable || iSpssDataSrc.isVariableInCurrentSet((ISpssVariable)iSpssVariableArray2))) {
                    targetVariableList.getModel().removeElement((ISpssVariable)iSpssVariableArray2);
                }
                if (sLoadData.varTimeStampChanged((ISpssVariable)iSpssVariableArray2) && !sLoadData.targetVarTimeStampChanged((ISpssVariable)iSpssVariableArray2)) {
                    sLoadData.addTargetTimeStampChangedVariable((ISpssVariable)iSpssVariableArray2);
                }
                sLoadData.getDialogVarsMap().put(iSpssVariableArray2.getId().asInt(), true);
                vector.add(iSpssVariableArray2);
            }
            if (vector.size() != iSpssVariableArray.length) {
                iSpssVariableArray2 = new ISpssVariable[vector.size()];
                dialogDataModel.putVarArray(targetVariableList.getIdentifier(), vector.toArray(iSpssVariableArray2));
            }
        }
        if (!targetVariableList.getLockItemDisplay()) {
            if (nameLabelOption.equals((Object)NameLabelOption.show_names)) {
                targetVariableList.setShowVarLabels(false, false);
            } else if (nameLabelOption.equals((Object)NameLabelOption.show_labels)) {
                targetVariableList.setShowVarLabels(true, false);
            }
        }
    }

    private static SrcVariableList getCurrentSrcList(TargetVariableList targetVariableList) {
        if (sLoadData.getSrcVariableList() != null) {
            return sLoadData.getSrcVariableList();
        }
        Container container = targetVariableList.getParent();
        while (!(container instanceof BaseDialog) && (container = container.getParent()) != null) {
        }
        if (container != null) {
            sLoadData.setSrcVariableList(BaseProcedureDialog.findSrcVariableList(container));
        }
        return sLoadData.getSrcVariableList();
    }

    private static SrcVariableList findSrcVariableList(Container container) {
        SrcVariableList srcVariableList = null;
        for (Component component : container.getComponents()) {
            if (component instanceof SrcVariableList) {
                return (SrcVariableList)component;
            }
            if (component instanceof Container && (srcVariableList = BaseProcedureDialog.findSrcVariableList((Container)component)) != null) break;
        }
        return srcVariableList;
    }

    protected void singlePointOfExit() {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        boolean bl = true;
        if (CommandLine.isClementineCaller()) {
            bl = this.checkForValidTargetVariables();
        }
        if (locallyUniqueId != null) {
            ProcedureDialogLoader.dialogExiting(this.getIActionKey(), locallyUniqueId, this.mGeneratedSyntax, bl);
        }
    }

    protected JButton getPressedButton() {
        return this.mPressedButton;
    }

    private boolean checkForValidTargetVariables() {
        VariableChecker variableChecker = new VariableChecker();
        ComponentVisitor.start((Container)((Object)this), variableChecker);
        return variableChecker.isValidTargetVariables();
    }

    private void addRecallItem() {
        String string = this.getIActionKey();
        String string2 = this.getTitle();
        String string3 = this.modifyActionKeyForGatingDialogs(string);
        String string4 = this.modifyRecallListTextForGatingDialogs(string, string2);
        if (string != null) {
            ProcedureDlgMgr.getMgr().addRecallItem(string4, string3);
        }
    }

    private String modifyActionKeyForGatingDialogs(String string) {
        String string2 = string;
        if (string.equals("data_merge_files_continue_add_cases")) {
            string2 = this instanceof AddCasesDlg ? ((AddCasesDlg)this).getIActionGatingKey() : null;
        } else if (string.equals("data_merge_files_continue_add_vars")) {
            string2 = this instanceof AddVariablesDlg ? ((AddVariablesDlg)this).getIActionGatingKey() : null;
        }
        return string2;
    }

    private String modifyRecallListTextForGatingDialogs(String string, String string2) {
        String string3 = string2;
        if (string.equals("data_merge_files_continue_add_cases")) {
            string3 = this instanceof AddCasesDlg ? ((AddCasesDlg)this).getRecallListText() : null;
        } else if (string.equals("data_merge_files_continue_add_vars")) {
            string3 = this instanceof AddVariablesDlg ? ((AddVariablesDlg)this).getRecallListText() : null;
        }
        return string3;
    }

    private class VariableChecker
    extends ComponentVisitor {
        private boolean validTargetVariables = true;
        private Component invalidComponent;

        private VariableChecker() {
        }

        @Override
        public boolean visit(Component component) {
            if (component instanceof TargetVariableList) {
                TargetVariableList targetVariableList = (TargetVariableList)component;
                VarListModel varListModel = targetVariableList.getModel();
                for (int i = 0; i < varListModel.getSize(); ++i) {
                    ISpssVariable iSpssVariable = varListModel.getElementAt(i);
                    if (!iSpssVariable.getId().isNull()) continue;
                    this.validTargetVariables = false;
                    this.invalidComponent = component;
                    return false;
                }
            }
            return true;
        }

        public boolean isValidTargetVariables() {
            return this.validTargetVariables;
        }

        public Component getInvalidComponent() {
            return this.invalidComponent;
        }
    }

    static class DialogLoadData {
        private SrcVariableList mSrcVarList = null;
        private Vector<ISpssVariable> mTimeStampChangedVars = new Vector();
        private Vector<ISpssVariable> mTimeStampChangedTargetVars = new Vector();
        private HashMap<Integer, Boolean> mDialogVarsMap = new HashMap();

        public SrcVariableList getSrcVariableList() {
            return this.mSrcVarList;
        }

        public void setSrcVariableList(SrcVariableList srcVariableList) {
            this.mSrcVarList = srcVariableList;
        }

        public HashMap<Integer, Boolean> getDialogVarsMap() {
            return this.mDialogVarsMap;
        }

        public void addTimeStampChangedVariable(ISpssVariable iSpssVariable) {
            this.mTimeStampChangedVars.add(iSpssVariable);
        }

        public boolean varTimeStampChanged(ISpssVariable iSpssVariable) {
            return this.mTimeStampChangedVars.contains(iSpssVariable);
        }

        public void addTargetTimeStampChangedVariable(ISpssVariable iSpssVariable) {
            this.mTimeStampChangedTargetVars.add(iSpssVariable);
        }

        public boolean targetVarTimeStampChanged(ISpssVariable iSpssVariable) {
            return this.mTimeStampChangedTargetVars.contains(iSpssVariable);
        }

        public Vector<ISpssVariable> getTimeStampChangedTargetVars() {
            return this.mTimeStampChangedTargetVars;
        }
    }

    protected class DataViewObserverAdapter
    implements IDatasetViewObserver {
        Vector<ISpssVariable> mVarsToBeRemovedFromSrcList;
        Vector<ISpssVariable> mTargetListVarsMovedToSrc;
        SrcVariableList mSrcVarList;

        protected DataViewObserverAdapter() {
        }

        public void notifyCloseDataSet(LocallyUniqueId locallyUniqueId) {
        }

        public void notifyStartOfDictionaryMods() {
        }

        public void notifyEndOfDictionaryMods() {
        }

        public synchronized void notifyVariableInserted(int n, ORIGINATOR_ID oRIGINATOR_ID) {
            if (ProcedureDlgMgr.getMgr().anyProcedureDialogsRunning(true)) {
                this.mVarsToBeRemovedFromSrcList = new Vector();
                this.recursiveCheckListVars((Container)((Object)BaseProcedureDialog.this));
                this.updateSrcList();
            }
        }

        public synchronized void notifyVariablesInserted(Vector<Integer> vector, ORIGINATOR_ID oRIGINATOR_ID) {
            if (ProcedureDlgMgr.getMgr().anyProcedureDialogsRunning(true)) {
                this.mVarsToBeRemovedFromSrcList = new Vector();
                this.recursiveCheckListVars((Container)((Object)BaseProcedureDialog.this));
                this.updateSrcList();
            }
        }

        public synchronized void notifyVariablesDeleted(int n, int n2, int n3, ORIGINATOR_ID oRIGINATOR_ID) {
            if (ProcedureDlgMgr.getMgr().anyProcedureDialogsRunning(true)) {
                this.mVarsToBeRemovedFromSrcList = new Vector();
                this.recursiveCheckListVars((Container)((Object)BaseProcedureDialog.this));
                this.updateSrcList();
            }
        }

        public synchronized void notifyVariableModified(ORIGINATOR_ID oRIGINATOR_ID, int n) {
            if (ProcedureDlgMgr.getMgr().anyProcedureDialogsRunning(true)) {
                this.mTargetListVarsMovedToSrc = new Vector();
                this.mVarsToBeRemovedFromSrcList = new Vector();
                this.recursiveCheckAddModifyListVars((Container)((Object)BaseProcedureDialog.this));
                for (int i = this.mVarsToBeRemovedFromSrcList.size() - 1; i >= 0; --i) {
                    int n2;
                    ISpssVariable iSpssVariable = this.mVarsToBeRemovedFromSrcList.get(i);
                    if (this.mSrcVarList == null || (n2 = this.mSrcVarList.getModel().findElementIndex(iSpssVariable)) == -1) continue;
                    this.mSrcVarList.getModel().removeElementAt(n2);
                }
                this.moveToSrcList();
            }
        }

        public void notifyVariablesMoved(int n, int n2, int n3) {
        }

        public void notifyDataModified(ORIGINATOR_ID oRIGINATOR_ID) {
        }

        public void notifyNewRows(long l, long l2) {
        }

        public void notifyRowCountEstablished(ORIGINATOR_ID oRIGINATOR_ID) {
        }

        public void notifyResetUndo() {
        }

        public void notifyFileName(String string, boolean bl) {
        }

        public void setDirtyFlag(boolean bl) {
        }

        public void notifyCellValueFound(int n, long l, String string) {
        }

        public void notifyStopFind(boolean bl) {
        }

        public void notifyReplaceResult(Vector<CellValue> vector) {
        }

        public void notifyWeightVar(int n) {
        }

        public void notifyFilterVar(int n) {
        }

        public void notifyTrendsInfo() {
        }

        public void notifySplitFile(boolean bl) {
        }

        public void notifyPendingTransformation(LocallyUniqueId locallyUniqueId, boolean bl) {
        }

        public synchronized void notifyVariableSetsChange(Vector<String> vector) {
            this.mVarsToBeRemovedFromSrcList = new Vector();
            this.recursiveCheckListVars((Container)((Object)BaseProcedureDialog.this));
            this.updateSrcList();
        }

        public void notifyImputationInfo() {
        }

        public void notifyImputationDisplayChange() {
        }

        public void notifyDatasetAttributesModified(ExtensionType extensionType) {
        }

        private void recursiveCheckListVars(Container container) {
            for (Component component : container.getComponents()) {
                if (component instanceof VariableList) {
                    this.checkVarsInTargetLists((VariableList)component);
                    continue;
                }
                if (component instanceof SerializableList) {
                    BaseProcedureDialog.this.validateSerializableLists();
                    continue;
                }
                if (component instanceof JComboBox && ((JComboBox)component).getAction() instanceof ComboboxAction) {
                    BaseProcedureDialog.this.validateComboBoxes();
                    continue;
                }
                if (component instanceof LayeredListWidget) {
                    ((LayeredListWidget)component).validateLayeredLists(this.mVarsToBeRemovedFromSrcList);
                    continue;
                }
                if (component instanceof JTable) {
                    BaseProcedureDialog.this.validateTableData();
                    continue;
                }
                if (!(component instanceof Container)) continue;
                this.recursiveCheckListVars((Container)component);
            }
        }

        private void checkVarsInTargetLists(VariableList variableList) {
            if (variableList instanceof SrcVariableList) {
                this.loadSrcListFromDataSet((SrcVariableList)variableList);
            } else if (variableList instanceof TargetVariableList && !((TargetVariableList)variableList).isDataSource()) {
                this.validateTargetListVars((TargetVariableList)variableList);
            }
        }

        private void validateTargetListVars(TargetVariableList targetVariableList) {
            for (int i = targetVariableList.getModel().getSize() - 1; i >= 0; --i) {
                LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
                ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
                ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
                if (iSpssVariable instanceof SpssIGraphVariable || iSpssVariable instanceof SpssCalculatedScaleVar || iSpssVariable instanceof TimeDependentPredictors) continue;
                if (iSpssDataSrc.isVariableInCurrentSet(iSpssVariable)) {
                    if (targetVariableList.getDragType() != VariableList.VarMoveType.eMoveOriginal || this.mVarsToBeRemovedFromSrcList.contains(iSpssVariable)) continue;
                    this.mVarsToBeRemovedFromSrcList.add(iSpssVariable);
                    continue;
                }
                targetVariableList.getModel().removeElement(iSpssVariable);
            }
        }

        private void updateSrcList() {
            for (int i = this.mVarsToBeRemovedFromSrcList.size() - 1; i >= 0; --i) {
                ISpssVariable iSpssVariable = this.mVarsToBeRemovedFromSrcList.get(i);
                if (this.mSrcVarList == null) continue;
                for (int j = this.mSrcVarList.getModel().getSize() - 1; j >= 0; --j) {
                    if (iSpssVariable.getId().asInt() != this.mSrcVarList.getModel().getElementAt(j).getId().asInt()) continue;
                    this.mSrcVarList.getModel().removeElementAt(j);
                }
            }
        }

        private void loadSrcListFromDataSet(SrcVariableList srcVariableList) {
            int n;
            this.mSrcVarList = srcVariableList;
            Integer n2 = this.mSrcVarList.getModel().getSortType().ordinal();
            Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
            for (n = 0; n < this.mSrcVarList.getModel().getSize(); n += 1) {
                ISpssVariable iSpssVariable = this.mSrcVarList.getModel().getElementAt(n);
                if (!(iSpssVariable instanceof SpssIGraphVariable) && !(iSpssVariable instanceof SpssCalculatedScaleVar)) continue;
                vector.add(iSpssVariable);
            }
            n = this.mSrcVarList.getShowVarLabels() ? 1 : 0;
            this.mSrcVarList.loadFromActiveDataset();
            for (ISpssVariable iSpssVariable : vector) {
                this.mSrcVarList.getModel().addElement(iSpssVariable);
            }
            if (n2 != null) {
                if (n2.intValue() == SpssVariableSortType.alpha.ordinal()) {
                    this.mSrcVarList.getModel().setSortType(SpssVariableSortType.alpha);
                } else if (n2.intValue() == SpssVariableSortType.file.ordinal()) {
                    this.mSrcVarList.getModel().setSortType(SpssVariableSortType.file);
                } else if (n2.intValue() == SpssVariableSortType.measurement.ordinal()) {
                    this.mSrcVarList.getModel().setSortType(SpssVariableSortType.measurement);
                }
            }
            this.mSrcVarList.setShowVarLabels(n != 0, false);
        }

        private void recursiveCheckAddModifyListVars(Container container) {
            for (Component component : container.getComponents()) {
                if (component instanceof VariableList) {
                    this.checkVarsInLists((VariableList)component);
                    continue;
                }
                if (component instanceof SerializableList) {
                    BaseProcedureDialog.this.validateSerializableLists();
                    continue;
                }
                if (component instanceof JComboBox && ((JComboBox)component).getAction() instanceof ComboboxAction) {
                    BaseProcedureDialog.this.validateComboBoxes();
                    continue;
                }
                if (component instanceof LayeredListWidget) {
                    ((LayeredListWidget)component).validateLayeredLists(this.mVarsToBeRemovedFromSrcList);
                    continue;
                }
                if (component instanceof JTable) {
                    BaseProcedureDialog.this.validateTableData();
                    continue;
                }
                if (!(component instanceof Container)) continue;
                this.recursiveCheckAddModifyListVars((Container)component);
            }
        }

        private void checkVarsInLists(VariableList variableList) {
            if (variableList instanceof SrcVariableList) {
                this.loadSrcListFromDataSet((SrcVariableList)variableList);
            } else if (variableList instanceof TargetVariableList && !((TargetVariableList)variableList).isDataSource()) {
                LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
                ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
                for (int i = variableList.getModel().getSize() - 1; i >= 0; --i) {
                    ISpssVariable iSpssVariable = variableList.getModel().getElementAt(i);
                    if (iSpssVariable instanceof SpssIGraphVariable || iSpssVariable instanceof SpssCalculatedScaleVar) continue;
                    if (iSpssDataSrc.isVariableInCurrentSet(iSpssVariable)) {
                        if (variableList.getDragType() == VariableList.VarMoveType.eMoveOriginal && !this.mVarsToBeRemovedFromSrcList.contains(iSpssVariable)) {
                            this.mVarsToBeRemovedFromSrcList.add(iSpssVariable);
                        }
                        int n = iSpssDataSrc.findVarIndex(variableList.getModel().getElementAt(i).getId());
                        if (((TargetVariableList)variableList).getTargetType() != TargetVariableList.TargetListType.single_item) {
                            if (variableList.canIncludeVariable(iSpssDataSrc.getVariable(n))) continue;
                            variableList.getModel().removeElement(iSpssDataSrc.getVariable(n));
                            if (variableList.getDragType() != VariableList.VarMoveType.eMoveOriginal) continue;
                            this.mTargetListVarsMovedToSrc.add(iSpssDataSrc.getVariable(n));
                            continue;
                        }
                        for (IVarFilter iVarFilter : variableList.mVarFilters) {
                            if (iVarFilter == null || iVarFilter.canIncludeVariable(iSpssDataSrc.getVariable(n))) continue;
                            variableList.getModel().removeElement(iSpssDataSrc.getVariable(n));
                            if (variableList.getDragType() != VariableList.VarMoveType.eMoveOriginal) continue;
                            this.mTargetListVarsMovedToSrc.add(iSpssDataSrc.getVariable(n));
                        }
                        continue;
                    }
                    variableList.getModel().removeElement(iSpssVariable);
                }
            }
        }

        private void moveToSrcList() {
            for (ISpssVariable iSpssVariable : this.mTargetListVarsMovedToSrc) {
                if (!this.mSrcVarList.canIncludeVariable(iSpssVariable)) continue;
                this.mSrcVarList.getModel().addElement(iSpssVariable);
            }
        }
    }

    protected class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
            this.putValue("AcceleratorKey", 112);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseProcedureDialog.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseProcedureDialog.this.mPressedButton = BaseProcedureDialog.this.mCancelButton;
            if (BaseProcedureDialog.this.cancelPressed()) {
                BaseProcedureDialog.this.singlePointOfExit();
                BaseProcedureDialog.this.dispose();
            }
        }
    }

    class ResetAction
    extends AbstractAction {
        ResetAction() {
            String string = "IDS_RESET";
            this.putValue("Name", ResUtil.getCommonDlgString(string));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                string = string.replaceFirst("IDS_", "IDK_");
                this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey(string));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseProcedureDialog.this.reset();
        }
    }

    protected class PasteAction
    extends AbstractAction {
        protected PasteAction() {
            String string = "IDS_PASTE";
            this.putValue("Name", ResUtil.getCommonDlgString(string));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                string = string.replaceFirst("IDS_", "IDK_");
                this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey(string));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseProcedureDialog.this.mOkPastePressed = true;
            BaseProcedureDialog.this.mPressedButton = BaseProcedureDialog.this.mPasteButton;
            if (BaseProcedureDialog.this.okPastePressed()) {
                BaseProcedureDialog.this.saveDialogState();
                ProcedureDlgMgr.getMgr().savePersistentState(BaseProcedureDialog.this.getIActionKey(), BaseProcedureDialog.this.mDialogDataModel);
                if (BaseProcedureDialog.this.canBeRecalled()) {
                    BaseProcedureDialog.this.addRecallItem();
                }
                BaseProcedureDialog.this.mGeneratedSyntax = BaseProcedureDialog.this.canPrependActivateSyntax() ? this.getActivateSyntax() : "";
                String string = BaseProcedureDialog.this.generateSyntax();
                BaseProcedureDialog.this.mGeneratedSyntax = BaseProcedureDialog.this.mGeneratedSyntax + string;
                if (!"failed".equals(string) && BaseProcedureDialog.this.mGeneratedSyntax != null && BaseProcedureDialog.this.mGeneratedSyntax.length() > 0) {
                    SyntaxFrame syntaxFrame;
                    if (BaseProcedureDialog.this.mPasteExecuteSyntax && (syntaxFrame = (SyntaxFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.SYNTAX_DOC)) != null) {
                        SyntaxEditorState syntaxEditorState = SyntaxPrefManager.getSyntaxEditorPreferences();
                        boolean bl = syntaxEditorState.isPasteAtCursor();
                        BaseProcedureDialog.this.setVisible(false);
                        String string2 = SyntaxMgr.getSyntaxMgr().wrapSyntaxForPaste(BaseProcedureDialog.this.mGeneratedSyntax);
                        if (!bl) {
                            string2 = "\n" + string2;
                        }
                        syntaxFrame.getSyntaxView().pasteSyntax(string2, bl, false);
                        this.getSyntaxMasterPanel(syntaxFrame).getSyntaxTextPane().requestFocusInWindow();
                        int n = this.getSyntaxMasterPanel(syntaxFrame).getSyntaxHighlightDocument().getLength() - 1;
                        if (!bl) {
                            this.getSyntaxMasterPanel(syntaxFrame).getSyntaxTextPane().setCaretPosition(n);
                        }
                    }
                } else {
                    ComponentState.trace1((String)"No syntax to execute in BaseProcedureDialog!", (int)15);
                }
                BaseProcedureDialog.this.singlePointOfExit();
                BaseProcedureDialog.this.dispose();
            } else {
                BaseProcedureDialog.this.mOkPastePressed = false;
            }
        }

        private SyntaxMasterPanel getSyntaxMasterPanel(SyntaxFrame syntaxFrame) {
            return syntaxFrame.getSyntaxView().getSyntaxMasterPanel();
        }

        private String getActivateSyntax() {
            String string;
            String string2 = "";
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = locallyUniqueId != null && !locallyUniqueId.isNull() ? DataMgr.getDataMgr().getDataSource(locallyUniqueId) : null;
            String string3 = string = iSpssDataSrc != null ? iSpssDataSrc.getDatasetName() : null;
            if (string != null && string.length() > 0 && !string.equals(sLastDatasetName) && !ProcedureDlgMgr.isExceptionDialog(BaseProcedureDialog.this.getIActionKey())) {
                sLastDatasetName = string;
                string2 = "DATASET ACTIVATE " + string + ".\n";
            }
            return string2;
        }
    }

    protected class OkAction
    extends AbstractAction {
        protected OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseProcedureDialog.this.mOkPastePressed = true;
            BaseProcedureDialog.this.mPressedButton = BaseProcedureDialog.this.mOkButton;
            if (BaseProcedureDialog.this.okPastePressed()) {
                BaseProcedureDialog.this.saveDialogState();
                ProcedureDlgMgr.getMgr().savePersistentState(BaseProcedureDialog.this.getIActionKey(), BaseProcedureDialog.this.mDialogDataModel);
                if (BaseProcedureDialog.this.canBeRecalled()) {
                    BaseProcedureDialog.this.addRecallItem();
                }
                BaseProcedureDialog.this.mGeneratedSyntax = BaseProcedureDialog.this.generateSyntax();
                if (!"failed".equals(BaseProcedureDialog.this.mGeneratedSyntax) && BaseProcedureDialog.this.mGeneratedSyntax != null && BaseProcedureDialog.this.mGeneratedSyntax.length() > 0) {
                    BaseProcedureDialog.this.setVisible(false);
                    if (BaseProcedureDialog.this.mPasteExecuteSyntax) {
                        ViewerFrame viewerFrame;
                        SyntaxMgr.getSyntaxMgr().executeSyntax(SyntaxMgr.getSyntaxMgr().wrapSyntaxForPaste(BaseProcedureDialog.this.mGeneratedSyntax));
                        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("general");
                        if (preferences.getBoolean("raise_viewer_window", true) && SpssFrameMgr.getSpssFrameMgr().openDocumentCount(DocType.OUTPUT_DOC) > 0 && (viewerFrame = (ViewerFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.OUTPUT_DOC)) != null) {
                            if (viewerFrame.getExtendedState() != 6) {
                                viewerFrame.setExtendedState(0);
                            }
                            viewerFrame.toFront();
                        }
                    }
                } else {
                    ComponentState.trace1((String)"No syntax to execute in BaseProcedureDialog!", (int)15);
                }
                BaseProcedureDialog.this.singlePointOfExit();
                BaseProcedureDialog.this.dispose();
            } else {
                BaseProcedureDialog.this.mOkPastePressed = false;
            }
        }
    }

    public static enum NameLabelOption {
        no_override,
        show_names,
        show_labels;

    }
}

