/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.cf_integration.action.CFCommandAction;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.dialogs.TCM.TCMModelGatingDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.actions.ProcedureAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.doc_util.ProcedureDialogLoader;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.DialogInvocationUtil;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public abstract class BaseGatingDialog
extends BaseDialog {
    protected DialogDataModel mDialogDataModel = new DialogDataModel();
    protected ContinueAction mContinueAction;
    protected CancelAction mCancelAction;
    protected HelpAction mHelpAction;
    private boolean mContinuePressed;
    protected JButton mDefineButton;
    protected JButton mCancelButton;
    protected JButton mHelpButton;
    protected String mPassword = null;

    public BaseGatingDialog(JFrame jFrame, String string, String string2) throws HeadlessException {
        this(jFrame, "", string, string2);
    }

    public BaseGatingDialog(JFrame jFrame, String string, String string2, String string3) throws HeadlessException {
        super(jFrame, string, true, ResUtil.getBundle(string2, ResUtil.getLocale()), string3);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (BaseGatingDialog.this.isDisplayable()) {
                    ProcedureDlgMgr.getMgr().loadPersistentState(BaseGatingDialog.this.getIActionKey(), BaseGatingDialog.this.getDialogDataModel());
                    BaseGatingDialog.this.loadDialogState();
                }
            }
        });
    }

    public BaseGatingDialog(BaseDialog baseDialog, String string, boolean bl) {
        super(baseDialog, string, bl, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (BaseGatingDialog.this.isDisplayable()) {
                    ProcedureDlgMgr.getMgr().loadPersistentState(BaseGatingDialog.this.getIActionKey(), BaseGatingDialog.this.getDialogDataModel());
                    BaseGatingDialog.this.loadDialogState();
                }
            }
        });
    }

    protected void loadDialogState() {
        BaseProcedureDialog.loadState(this.getDialogDataModel(), (Container)((Object)this), BaseProcedureDialog.NameLabelOption.no_override);
    }

    protected void saveDialogState() {
        ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.getDialogDataModel());
    }

    protected void renameContinueAction(String string) {
        this.mContinueAction.putValue("Name", ResUtil.getCommonDlgString(string));
        super.init();
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = insets.top + insets.bottom;
        int n2 = insets.left + insets.right;
        this.mDefineButton = new JButton(this.mContinueAction);
        this.mCancelButton = new JButton(this.mCancelAction);
        this.mHelpButton = new JButton(this.mHelpAction);
        DialogUtil.setupMacHelpButton(this.mHelpButton);
        if (UIToolDialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                int n3 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n3, null);
                n3 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                Insets insets2 = new Insets(0, n2, 0, 0);
                DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n3, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mDefineButton, gridBagConstraints, 2, 0, 1, 1, n3, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n2, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mDefineButton);
                jPanel.add(this.mCancelButton);
                jPanel.add(this.mHelpButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mDefineButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCancelButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mHelpButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mDefineButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    public abstract String getIActionKey();

    public abstract String getNextProcDlgActionKey();

    public String getDialogHelpID() {
        return "none";
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    public abstract boolean continuePressed();

    public boolean wasContinuePressed() {
        return this.mContinuePressed;
    }

    public void enableContinue(boolean bl) {
        if (this.mContinueAction != null) {
            this.mContinueAction.setEnabled(bl);
        }
    }

    public DialogDataModel getDialogDataModel() {
        return this.mDialogDataModel;
    }

    protected void init() {
        this.mContinueAction = new ContinueAction();
        this.mCancelAction = new CancelAction();
        this.mHelpAction = new HelpAction();
        super.init();
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(2);
    }

    protected void processCancelAction() {
        this.dispose();
    }

    protected void processContinueAction(ActionEvent actionEvent) {
        this.resetAutomationListener();
        this.mContinuePressed = true;
        if (this.continuePressed() && BaseProcedureDialog.saveState(this.getDialogDataModel(), (Container)((Object)this))) {
            this.saveDialogState();
            this.dispose();
            String string = this.getNextProcDlgActionKey();
            if (string != null && !string.equals("")) {
                Object object;
                SpssAction spssAction = ActionCatalog.getActionCatalog().getSpssAction(string);
                if (spssAction instanceof ProcedureAction) {
                    JFrame jFrame = this.getParentFrame();
                    ProcedureDialogLoader.showDialog((ProcedureAction)spssAction, jFrame);
                } else if (spssAction instanceof CFCommandAction && (object = actionEvent.getSource()) instanceof Container) {
                    CFCommandAction cFCommandAction = (CFCommandAction)spssAction;
                    if (this instanceof TCMModelGatingDlg) {
                        cFCommandAction.setDimensionFields(((TCMModelGatingDlg)this).getSelectedDims(), !((TCMModelGatingDlg)this).isEnableDimValueChecked());
                        cFCommandAction.setTCMDataFilterSyntax(((TCMModelGatingDlg)this).getDataFilterSyntax());
                        cFCommandAction.setmDateTimeVar(((TCMModelGatingDlg)this).getSelectedDateTimeVarName(), ((TCMModelGatingDlg)this).getTimeInterval());
                        cFCommandAction.setTrendInfo(((TCMModelGatingDlg)this).getDateSpec());
                    }
                    cFCommandAction.actionPerformed(new ActionEvent((Object)this, 1, "launch"));
                }
            }
        } else {
            this.mContinuePressed = false;
        }
        DialogInvocationUtil.unregisterWaitingThread((Thread)Thread.currentThread());
    }

    protected JFrame getParentFrame() {
        Container container = this.getParent();
        JFrame jFrame = container instanceof JFrame ? (JFrame)container : SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
        return jFrame;
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseGatingDialog.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseGatingDialog.this.processCancelAction();
        }
    }

    public class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
            this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseGatingDialog.this.processContinueAction(actionEvent);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
        }
    }
}

