/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class AssignMeasureLevelDlg
extends BaseProcedureDialog
implements ListDataListener {
    private static final int NOMINAL = 0;
    private static final int ORDINAL = 1;
    private static final int CONTINUOUS = 2;
    private static String NOMINAL_LIST = "NOMINAL_LIST";
    private static String ORDINAL_LIST = "ORDINAL_LIST";
    private static String CONTINUOUS_LIST = "CONT_LIST";
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private TargetVariableList[] mTargetVarLists;
    private JScrollPane[] mTargetScrollPanes;
    private ArrowButton[] mArrowButtons;

    public AssignMeasureLevelDlg(JFrame jFrame) {
        super(jFrame, true, CommonDlgResBundle.getDefaultResourceBundleName(), CommonDlgResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_ASSIGN_MEASURELEVEL_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public String getIActionKey() {
        return "data_assign_measurelevel";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_assign_measurement_level";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(true);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(!this.isAllTargetsEmpty());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(!this.isAllTargetsEmpty());
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public boolean okPastePressed() {
        ProcedureDlgMgr.getMgr().addRecallItem(this.getTitle(), "data_assign_measurelevel");
        return super.okPastePressed();
    }

    @Override
    protected void saveDialogState() {
    }

    @Override
    protected void loadDialogState() {
        if (this.mSrcVarList.getModel().getSize() > 0) {
            this.mSrcVarList.setSelectedIndex(0);
        }
    }

    @Override
    public String generateSyntax() {
        String string;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* ").append(this.getResString("IDS_ASSIGN_MEASURELEVEL_TITLE")).append(".\n");
        stringBuffer.append(SyntaxUtil.getMainCommand("VARIABLE LEVEL"));
        String string2 = this.mTargetVarLists[0].getVariablesStringList();
        if (string2.length() > 0) {
            stringBuffer.append("\n");
            string = "/" + string2 + "(NOMINAL)";
            stringBuffer.append(SyntaxUtil.getSubCommand(string));
        }
        if ((string2 = this.mTargetVarLists[1].getVariablesStringList()).length() > 0) {
            stringBuffer.append("\n");
            string = "/" + string2 + "(ORDINAL)";
            stringBuffer.append(SyntaxUtil.getSubCommand(string));
        }
        if ((string2 = this.mTargetVarLists[2].getVariablesStringList()).length() > 0) {
            stringBuffer.append("\n");
            string = "/" + string2 + "(SCALE)";
            stringBuffer.append(SyntaxUtil.getSubCommand(string));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        UnknownMLVarFilter unknownMLVarFilter = new UnknownMLVarFilter();
        this.mSrcVarList.addVarFilter(unknownMLVarFilter);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setShowIcon(false);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        Dimension dimension = this.mSrcVarList.getMinimumSize();
        this.mSrcScrollPane.setPreferredSize(dimension);
        this.mTargetVarLists = new TargetVariableList[3];
        this.mTargetScrollPanes = new JScrollPane[3];
        this.mArrowButtons = new ArrowButton[3];
        for (int i = 0; i <= 2; ++i) {
            this.mTargetVarLists[i] = new TargetVariableList(TargetVariableList.TargetListType.normal);
            String string = i == 0 ? NOMINAL_LIST : (i == 1 ? ORDINAL_LIST : CONTINUOUS_LIST);
            this.mTargetVarLists[i].setIdentifier(string);
            this.mTargetVarLists[i].setShowIcon(false);
            this.mTargetVarLists[i].setDragType(VariableList.VarMoveType.eMoveOriginal);
            this.mTargetVarLists[i].getModel().addListDataListener(this);
            this.mTargetVarLists[i].setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarLists[i].getFixedCellHeight() * 2 + 2));
            this.mTargetScrollPanes[i] = new JScrollPane(this.mTargetVarLists[i]);
            Dimension dimension2 = this.mTargetVarLists[i].getMinimumSize();
            dimension2.height += 40;
            this.mTargetScrollPanes[i].setPreferredSize(dimension2);
            this.mArrowButtons[i] = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
            this.mArrowButtons[i].registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
            this.mArrowButtons[i].registerVariableList(this.mTargetVarLists[i], SpssArrowButton.ButtonOrientation.left);
        }
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        for (TargetVariableList targetVariableList : this.mTargetVarLists) {
            targetVariableList.removeAll();
        }
        this.enableOkPaste(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.addAll(Arrays.asList(this.mArrowButtons));
        vector.addAll(Arrays.asList(this.mTargetVarLists));
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private void setupViewPanel(JPanel jPanel) {
        Serializable serializable;
        int n;
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        Icon icon = UIManager.getIcon("OptionPane.informationIcon");
        JLabel jLabel = new JLabel(icon);
        JTextArea jTextArea = this.createInfoArea("IDS_OVERALL_INFO", 86, 2);
        jTextArea.setMinimumSize(new Dimension(690, 32));
        jTextArea.setPreferredSize(new Dimension(690, 32));
        int n2 = 23;
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n3, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, jTextArea, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_SOURCE_LABEL");
        jLabel2.setLabelFor(this.mSrcVarList);
        JLabel[] jLabelArray = new JLabel[3];
        JLabel[] jLabelArray2 = new JLabel[3];
        JTextArea[] jTextAreaArray = new JTextArea[3];
        for (n = 0; n <= 2; ++n) {
            jLabelArray[n] = DialogUtil.createLabel(this, "IDS_TARGET_LABEL" + n);
            jLabelArray[n].setLabelFor(this.mTargetVarLists[n]);
            jLabelArray2[n] = new JLabel("");
            jTextAreaArray[n] = this.createInfoArea("IDS_TARGET_EXPLAIN" + n, 26, n == 2 ? 4 : 3);
            jTextAreaArray[n].setColumns(26);
            serializable = null;
            if (n == 0) {
                serializable = this.getResImageURL("IDS_NOMINAL_VAR_IMAGE");
            } else if (n == 1) {
                serializable = this.getResImageURL("IDS_ORDINAL_VAR_IMAGE");
            } else if (n == 2) {
                serializable = this.getResImageURL("IDS_SCALE_VAR_IMAGE");
            }
            jLabelArray2[n].setIcon(new ImageIcon((URL)serializable));
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        n = DialogUtil.getComponentGroupGap();
        insets.set(0, 0, n, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 5, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 5, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 2, 1, 6, n2, null);
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPanes[0], gridBagConstraints, 2, 3, 1, 1, n2, null);
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPanes[1], gridBagConstraints, 2, 5, 1, 1, n2, null);
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPanes[2], gridBagConstraints, 2, 7, 1, 1, n2, null);
        n2 = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        serializable = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, ((Insets)serializable).left, 0, ((Insets)serializable).right);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtons[0], gridBagConstraints, 1, 3, 1, 1, n2, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtons[1], gridBagConstraints, 1, 5, 1, 1, n2, (Insets)serializable);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtons[2], gridBagConstraints, 1, 7, 1, 1, n2, (Insets)serializable);
        gridBagConstraints.weightx = 1.0;
        n2 = 23;
        gridBagConstraints.fill = 2;
        Insets insets3 = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabelArray[0], gridBagConstraints, 2, 2, 1, 1, n2, insets3);
        DialogUtil.addUsingGBL(jPanel, jLabelArray[1], gridBagConstraints, 2, 4, 1, 1, n2, insets3);
        DialogUtil.addUsingGBL(jPanel, jLabelArray[2], gridBagConstraints, 2, 6, 1, 1, n2, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 18;
        insets3 = new Insets(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabelArray2[0], gridBagConstraints, 3, 3, 1, 1, n2, insets3);
        DialogUtil.addUsingGBL(jPanel, jLabelArray2[1], gridBagConstraints, 3, 5, 1, 1, n2, insets3);
        DialogUtil.addUsingGBL(jPanel, jLabelArray2[2], gridBagConstraints, 3, 7, 1, 1, n2, insets3);
        insets3.left = n / 2;
        DialogUtil.addUsingGBL(jPanel, jTextAreaArray[0], gridBagConstraints, 4, 3, 1, 1, n2, insets3);
        DialogUtil.addUsingGBL(jPanel, jTextAreaArray[1], gridBagConstraints, 4, 5, 1, 1, n2, insets3);
        DialogUtil.addUsingGBL(jPanel, jTextAreaArray[2], gridBagConstraints, 4, 7, 1, 1, n2, insets3);
    }

    private JTextArea createInfoArea(String string, int n, int n2) {
        JTextArea jTextArea = new JTextArea(ResUtil.getCommonDlgString(string));
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setRows(n2);
        jTextArea.setFocusable(false);
        return jTextArea;
    }

    private boolean isAllTargetsEmpty() {
        boolean bl = true;
        for (TargetVariableList targetVariableList : this.mTargetVarLists) {
            if (targetVariableList.getModel().getSize() <= 0) continue;
            bl = false;
            break;
        }
        return bl;
    }

    class UnknownMLVarFilter
    implements IVarFilter {
        UnknownMLVarFilter() {
        }

        @Override
        public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
            return iSpssVariable.getMeasurementLevel() == MeasurementLevel.unknown;
        }
    }
}

