/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.common;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public class ActivateDocumentDialog
extends BaseDialog {
    private JList mListCtrl = null;

    public ActivateDocumentDialog(SpssFrame spssFrame) {
        super((JFrame)spssFrame, ResUtil.getCommonDlgString("IDS_MORE_WINDOWS_TITLE"), true, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.addControls();
        this.mListCtrl.setSelectedIndex(0);
        this.setLocationRelativeTo(null);
    }

    private void addControls() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = DialogUtil.getStandardDialogInsets();
        LinkedList<JFrame> linkedList = new LinkedList<JFrame>();
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        linkedList.addAll(Arrays.asList(spssFrameArray));
        linkedList.addAll(SpssFrameMgr.getSpssFrameMgr().getNonDocumentFrames());
        this.mListCtrl = new JList<Object>(linkedList.toArray());
        this.mListCtrl.setCellRenderer(new DoclistCellRenderer());
        this.mListCtrl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    ActivateDocumentDialog.this.doSelectDocument();
                }
            }
        });
        jPanel.add((Component)new JScrollPane(this.mListCtrl), gridBagConstraints);
        this.mListCtrl.setPrototypeCellValue("123-45-6789");
        int n = this.mListCtrl.getFixedCellHeight();
        n = n < 18 ? 18 : n;
        this.mListCtrl.setFixedCellHeight(n);
        this.mListCtrl.setFixedCellWidth(-1);
        this.pack();
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        OKAction oKAction = new OKAction();
        JButton jButton = new JButton(oKAction);
        JButton jButton2 = new JButton(new CancelAction());
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            FlowLayout flowLayout = new FlowLayout(2, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(jButton2);
            jPanel.add(jButton);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void doSelectDocument() {
        int n = this.mListCtrl.getLeadSelectionIndex();
        if (n > -1) {
            Object e = this.mListCtrl.getModel().getElementAt(n);
            if (e instanceof SpssFrame) {
                SpssFrame spssFrame = (SpssFrame)e;
                this.setVisible(false);
                if (spssFrame.getState() == 1) {
                    spssFrame.setState(0);
                }
                spssFrame.toFront();
                this.dispose();
            } else if (e instanceof BuilderFrame) {
                BuilderFrame builderFrame = (BuilderFrame)e;
                this.setVisible(false);
                if (builderFrame.getState() == 1) {
                    builderFrame.setState(0);
                }
                builderFrame.toFront();
                this.dispose();
            }
        }
    }

    public void doHelp() {
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActivateDocumentDialog.this.dispose();
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActivateDocumentDialog.this.doSelectDocument();
        }
    }

    class DoclistCellRenderer
    extends JLabel
    implements ListCellRenderer {
        DoclistCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            boolean bl3 = object instanceof SpssFrame;
            boolean bl4 = object instanceof BuilderFrame;
            if (bl3) {
                SpssFrame spssFrame = (SpssFrame)object;
                this.setText(spssFrame.getTitle());
                this.setIcon(new ImageIcon(spssFrame.getIconImage()));
            } else if (bl4) {
                BuilderFrame builderFrame = (BuilderFrame)object;
                this.setText(builderFrame.getTitle());
                this.setIcon(new ImageIcon(builderFrame.getIconImage()));
            } else {
                this.setText(object.toString());
            }
            if (bl) {
                if (this.hasFocus()) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(Color.lightGray);
                    this.setForeground(Color.black);
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }
}

