/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.view.toolbars;

import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.controlbar.ToolbarObject;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ToolbarsTableModel
extends AbstractTableModel {
    private List<ToolbarObject> mToolbars = new ArrayList<ToolbarObject>();
    private List<ToolbarObject> mVisibleToolbars = new ArrayList<ToolbarObject>();
    private DocType currentDocType;
    private JTable mToolbarsTable;
    private List<String> mColumnNames;

    public ToolbarsTableModel(JTable jTable) {
        this.mToolbarsTable = jTable;
    }

    public void setColumnNames(List<String> list) {
        this.mColumnNames = list;
    }

    public void setCurrentDocType(DocType docType) {
        this.currentDocType = docType;
        this.refresh();
    }

    public void refresh() {
        this.mVisibleToolbars.clear();
        if (this.currentDocType == null) {
            this.mVisibleToolbars.addAll(this.mToolbars);
        } else {
            for (ToolbarObject toolbarObject : this.mToolbars) {
                if (!toolbarObject.getDocTypes().contains(this.currentDocType)) continue;
                this.mVisibleToolbars.add(toolbarObject);
            }
        }
        this.fireTableDataChanged();
        if (this.mVisibleToolbars.size() > 0) {
            this.mToolbarsTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public List<ToolbarObject> getToolbarObjects() {
        return this.mToolbars;
    }

    @Override
    public int getRowCount() {
        return this.mVisibleToolbars != null ? this.mVisibleToolbars.size() : 0;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        if (this.mColumnNames != null && n < this.mColumnNames.size()) {
            return this.mColumnNames.get(n);
        }
        return "";
    }

    public ToolbarObject getToolbarObjectAt(int n) {
        return this.mVisibleToolbars.get(n);
    }

    public void add(ToolbarObject toolbarObject) {
        this.mToolbars.add(toolbarObject);
        if (this.currentDocType != null) {
            if (toolbarObject.getDocTypes().contains(this.currentDocType)) {
                this.mVisibleToolbars.add(toolbarObject);
                int n = this.mVisibleToolbars.size() - 1;
                this.fireTableRowsInserted(n, n);
            }
        } else {
            this.mVisibleToolbars.add(toolbarObject);
            int n = this.mVisibleToolbars.size() - 1;
            this.fireTableRowsInserted(n, n);
        }
    }

    public void deleteToolbarObject(ToolbarObject toolbarObject) {
        this.mToolbars.remove(toolbarObject);
        int n = -1;
        if (this.mVisibleToolbars.contains(toolbarObject)) {
            n = this.mVisibleToolbars.indexOf(toolbarObject);
            this.mVisibleToolbars.remove(toolbarObject);
        }
        this.fireTableRowsDeleted(n, n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0 && object instanceof Boolean) {
            this.mVisibleToolbars.get(n).setVisible((Boolean)object);
            this.fireTableCellUpdated(n, n2);
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        ToolbarObject toolbarObject = this.mVisibleToolbars.get(n);
        switch (n2) {
            case 0: {
                object = toolbarObject.isVisible();
                break;
            }
            case 1: {
                object = toolbarObject.getName();
            }
        }
        return object;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Class<Object> clazz = Object.class;
        switch (n) {
            case 0: {
                clazz = Boolean.class;
                break;
            }
            case 1: {
                clazz = String.class;
            }
        }
        return clazz;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }
}

