/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.view.toolbars;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.base.view.toolbars.EditToolBarDlg;
import com.spss.java_client.ui.dialogs.base.view.toolbars.ToolbarPreviewPanel;
import com.spss.uitools.controls.drag_drop.ComponentDragAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class ToolbarPreviewPanelDragAdapter
extends ComponentDragAdapter {
    private final EditToolBarDlg mEditToolBarDlg;
    private ToolbarPreviewPanel mTbPreviewPanel;
    private int mSelectedItemIndex;

    public ToolbarPreviewPanelDragAdapter(ToolbarPreviewPanel toolbarPreviewPanel, DragPane dragPane, String string, EditToolBarDlg editToolBarDlg) {
        super(dragPane, string);
        this.mTbPreviewPanel = toolbarPreviewPanel;
        this.mEditToolBarDlg = editToolBarDlg;
    }

    public Object getTransferData() {
        if (this.mTransferData == null) {
            this.acquireTransferData();
        }
        return this.mTransferData;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mDndArmedEvent = null;
        if (mouseEvent.isConsumed() || mouseEvent.getButton() != 1 && mouseEvent.getButton() != 2) {
            return;
        }
        Component component = mouseEvent.getComponent();
        if (component instanceof JButton) {
            Component component2;
            Component[] componentArray;
            boolean bl = false;
            Component[] componentArray2 = componentArray = this.mTbPreviewPanel.getComponents();
            int n = componentArray2.length;
            for (int i = 0; i < n && !(bl = (component2 = componentArray2[i]) == component); ++i) {
            }
            if (!bl) {
                return;
            }
        } else {
            return;
        }
        if (!this.mTbPreviewPanel.isEnabled()) {
            return;
        }
        this.mSelectedItemIndex = this.mTbPreviewPanel.getComponentIndex(component);
        this.mDndArmedEvent = mouseEvent;
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mTransferData == null) {
            this.mDndArmedEvent = null;
            return;
        }
        Point point = (Point)mouseEvent.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, this.mTbPreviewPanel);
        super.mouseReleased(mouseEvent);
        this.mTbPreviewPanel.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolbarPreviewPanelDragAdapter.this.mTbPreviewPanel.setEnabled(true);
            }
        });
    }

    protected void acquireTransferData() {
        if (this.mTbPreviewPanel != null) {
            this.mTransferData = this.mEditToolBarDlg.getToolbarPreviewPanel().getToolbarItems().get(this.mSelectedItemIndex);
        }
    }

    protected BufferedImage getDragImage(Component component) {
        if (!(component instanceof JButton)) {
            assert (false);
            return null;
        }
        Dimension dimension = component.getSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(0, 0, dimension.width, dimension.height);
        JLabel jLabel = new JLabel(((JButton)component).getIcon());
        jLabel.setLocation(new Point(0, 0));
        jLabel.setSize(dimension);
        graphics2D.setComposite(AlphaComposite.getInstance(2, 0.5f));
        jLabel.setOpaque(false);
        jLabel.paint(graphics2D);
        graphics2D.translate(0, dimension.height);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected void startDrag(MouseEvent mouseEvent) {
        Object object;
        Object object2;
        if (mouseEvent == null) {
            return;
        }
        Component component = mouseEvent.getComponent();
        if (component instanceof JButton) {
            Component component2;
            boolean bl = false;
            object2 = this.mTbPreviewPanel.getComponents();
            object = object2;
            int n = ((Component[])object).length;
            for (int i = 0; i < n && !(bl = (component2 = object[i]) == component); ++i) {
            }
            if (!bl) {
                return;
            }
        } else {
            return;
        }
        this.acquireTransferData();
        BufferedImage bufferedImage = this.getDragImage(this.mTbPreviewPanel.getSelectedComponent());
        if (bufferedImage == null) {
            return;
        }
        object2 = mouseEvent.getPoint();
        object = (Point)((Point2D)object2).clone();
        SwingUtilities.convertPointToScreen((Point)object, this.mTbPreviewPanel);
        SwingUtilities.convertPointFromScreen((Point)object, (Component)this.mDragPane);
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(ComponentState.getSPSSLocale());
        Point point = componentOrientation == ComponentOrientation.RIGHT_TO_LEFT ? new Point(this.mTbPreviewPanel.getWidth(), 0) : new Point(bufferedImage.getWidth() / 2, bufferedImage.getHeight() / 2);
        this.mDragPane.setDragImage(bufferedImage, true);
        this.mDragPane.setDragPoint((Point)object);
        this.mDragPane.setImageHotSpot(point);
        this.mDragPane.setVisible(true);
        this.mDragPane.repaint();
    }
}

