/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.view.toolbars;

import com.spss.java_client.ui.dialogs.base.view.toolbars.ToolbarPreviewPanel;
import com.spss.java_client.ui.dialogs.base.view.toolbars.ToolbarPreviewPanelButton;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;

public class ToolbarPreviewPanelButtonGroup
extends ButtonGroup
implements FocusListener {
    private boolean mPanelComponentHasFocus = false;
    private ButtonGroupKeylistener mArrowKeyListener = new ButtonGroupKeylistener();
    private ButtonGroupMouselistener mMouseListener = new ButtonGroupMouselistener();
    private ToolbarPreviewPanelButton mSelectedButton;
    private final ToolbarPreviewPanel mToolbarPanel;

    public ToolbarPreviewPanelButtonGroup(ToolbarPreviewPanel toolbarPreviewPanel) {
        this.mToolbarPanel = toolbarPreviewPanel;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.setSelectedButton((ToolbarPreviewPanelButton)focusEvent.getSource());
        this.mPanelComponentHasFocus = true;
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mPanelComponentHasFocus = !(focusEvent.getOppositeComponent() instanceof ToolbarPreviewPanelButton);
    }

    @Override
    public void add(AbstractButton abstractButton) {
        if (abstractButton == null) {
            return;
        }
        if (abstractButton instanceof ToolbarPreviewPanelButton) {
            super.add(abstractButton);
            abstractButton.addKeyListener(this.mArrowKeyListener);
            abstractButton.addMouseListener(this.mMouseListener);
            abstractButton.addFocusListener(this);
        }
    }

    @Override
    public void remove(AbstractButton abstractButton) {
        if (abstractButton == null) {
            return;
        }
        if (abstractButton instanceof ToolbarPreviewPanelButton) {
            super.remove(abstractButton);
        }
        this.buttons.remove(abstractButton);
        if (abstractButton == this.mSelectedButton) {
            this.mSelectedButton = null;
        }
        KeyListener[] keyListenerArray = abstractButton.getKeyListeners();
        EventListener[] eventListenerArray = keyListenerArray;
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            KeyListener keyListener = eventListenerArray[i];
            abstractButton.removeKeyListener(keyListener);
        }
        for (EventListener eventListener : eventListenerArray = abstractButton.getMouseListeners()) {
            abstractButton.removeMouseListener((MouseListener)eventListener);
        }
        abstractButton.removeFocusListener(this);
    }

    public ToolbarPreviewPanelButton getSelectedButton() {
        return this.mSelectedButton;
    }

    public int getSelectedButtonIndex() {
        return this.buttons.indexOf(this.mSelectedButton);
    }

    public ToolbarPreviewPanelButton getButtonAtIndex(int n) {
        return (ToolbarPreviewPanelButton)this.buttons.get(n);
    }

    @Override
    public int getButtonCount() {
        return this.buttons.size();
    }

    public void removeAll() {
        Iterator iterator = this.buttons.iterator();
        while (iterator.hasNext()) {
            int n;
            AbstractButton abstractButton = (AbstractButton)iterator.next();
            if (!(abstractButton instanceof ToolbarPreviewPanelButton)) continue;
            iterator.remove();
            KeyListener[] keyListenerArray = abstractButton.getKeyListeners();
            EventListener[] eventListenerArray = keyListenerArray;
            int n2 = eventListenerArray.length;
            for (n = 0; n < n2; ++n) {
                KeyListener keyListener = eventListenerArray[n];
                abstractButton.removeKeyListener(keyListener);
            }
            EventListener[] eventListenerArray2 = eventListenerArray = abstractButton.getMouseListeners();
            n = eventListenerArray2.length;
            for (int i = 0; i < n; ++i) {
                EventListener eventListener = eventListenerArray2[i];
                abstractButton.removeMouseListener((MouseListener)eventListener);
            }
        }
    }

    public int getComponentIndex(Component component) {
        if (component instanceof ToolbarPreviewPanelButton) {
            return this.buttons.indexOf(component);
        }
        return -1;
    }

    public void setSelectedButtonIndex(int n) {
        if (n >= 0 && n < this.buttons.size()) {
            ToolbarPreviewPanelButton toolbarPreviewPanelButton = (ToolbarPreviewPanelButton)this.buttons.get(n);
            this.setSelectedButton(toolbarPreviewPanelButton);
        } else {
            this.setSelectedButton(null);
        }
    }

    private void setSelectedButton(ToolbarPreviewPanelButton toolbarPreviewPanelButton) {
        if (this.mSelectedButton != null) {
            this.mSelectedButton.setSelected(false);
            this.mSelectedButton.repaint();
        }
        this.mSelectedButton = toolbarPreviewPanelButton;
        if (this.mSelectedButton != null) {
            toolbarPreviewPanelButton.setSelected(true);
            this.mSelectedButton.repaint();
            if (this.mPanelComponentHasFocus) {
                this.mSelectedButton.requestFocus();
            }
        }
        this.mToolbarPanel.buttonSelectionChanged();
    }

    private class ButtonGroupMouselistener
    extends MouseAdapter {
        private ButtonGroupMouselistener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof ToolbarPreviewPanelButton && mouseEvent.getButton() == 1) {
                ToolbarPreviewPanelButton toolbarPreviewPanelButton = (ToolbarPreviewPanelButton)mouseEvent.getSource();
                ToolbarPreviewPanelButtonGroup.this.setSelectedButton(toolbarPreviewPanelButton);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof ToolbarPreviewPanelButton && mouseEvent.getButton() == 1) {
                ToolbarPreviewPanelButton toolbarPreviewPanelButton = (ToolbarPreviewPanelButton)mouseEvent.getSource();
                ToolbarPreviewPanelButtonGroup.this.setSelectedButton(toolbarPreviewPanelButton);
            }
        }

        private void focusButton(AbstractButton abstractButton) {
            abstractButton.requestFocusInWindow();
            if (abstractButton instanceof ToolbarPreviewPanelButton) {
                abstractButton.setSelected(true);
            }
        }
    }

    private class ButtonGroupKeylistener
    extends KeyAdapter {
        private ButtonGroupKeylistener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            AbstractButton abstractButton = (AbstractButton)keyEvent.getComponent();
            if (keyEvent.getKeyCode() == 39) {
                AbstractButton abstractButton2;
                int n = ToolbarPreviewPanelButtonGroup.this.buttons.indexOf(abstractButton) + 1;
                do {
                    if (n != ToolbarPreviewPanelButtonGroup.this.buttons.size()) continue;
                    n = 0;
                } while (!(abstractButton2 = (AbstractButton)ToolbarPreviewPanelButtonGroup.this.buttons.elementAt(n++)).isEnabled());
                this.focusButton(abstractButton2);
            } else if (keyEvent.getKeyCode() == 37) {
                AbstractButton abstractButton3;
                int n = ToolbarPreviewPanelButtonGroup.this.buttons.indexOf(abstractButton) - 1;
                do {
                    if (n != -1) continue;
                    n += ToolbarPreviewPanelButtonGroup.this.buttons.size();
                } while (!(abstractButton3 = (AbstractButton)ToolbarPreviewPanelButtonGroup.this.buttons.elementAt(n--)).isEnabled());
                this.focusButton(abstractButton3);
            }
        }

        private void focusButton(AbstractButton abstractButton) {
            abstractButton.requestFocusInWindow();
            if (abstractButton instanceof ToolbarPreviewPanelButton) {
                ToolbarPreviewPanelButtonGroup.this.setSelectedButton((ToolbarPreviewPanelButton)abstractButton);
            }
        }
    }
}

