/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.view.toolbars;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controlbar.IToolbarConstants;
import com.spss.java_client.ui.controlbar.ToolbarItem;
import com.spss.java_client.ui.controlbar.ToolbarsUtil;
import com.spss.java_client.ui.dialogs.base.view.toolbars.EditToolBarDlg;
import com.spss.java_client.ui.dialogs.base.view.toolbars.MenuItemListDragAdapter;
import com.spss.java_client.ui.dialogs.base.view.toolbars.ToolbarItemTransferable;
import com.spss.java_client.ui.dialogs.base.view.toolbars.ToolbarPreviewPanelButton;
import com.spss.java_client.ui.dialogs.base.view.toolbars.ToolbarPreviewPanelButtonGroup;
import com.spss.java_client.ui.dialogs.base.view.toolbars.ToolbarPreviewPanelDragAdapter;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ToolbarPreviewPanel
extends JPanel
implements IDropListener,
Scrollable,
MouseListener,
KeyListener,
ActionListener,
FocusListener {
    private static final int AUTOSCROLL_INSET = 5;
    private static final int PREVIEW_BUTTON_HEIGHT = 20;
    private static final int PREVIEW_BUTTON_WIDTH = 20;
    private Timer mTimer = null;
    private Point mLastPosition = null;
    private Rectangle mOuterRect = new Rectangle();
    private Rectangle mInnerRect = new Rectangle();
    private int mHysteresis = 10;
    private EditToolBarDlg mEditToolBarDlg;
    private List<ToolbarItem> mTbItems = new ArrayList<ToolbarItem>();
    private ToolbarPreviewPanelButtonGroup mGroup;

    public ToolbarPreviewPanel(EditToolBarDlg editToolBarDlg) {
        this.mEditToolBarDlg = editToolBarDlg;
        this.mGroup = new ToolbarPreviewPanelButtonGroup(this);
        this.addMouseListener((MouseListener)((Object)this.mEditToolBarDlg.getPanelAdapter()));
        this.addMouseMotionListener((MouseMotionListener)((Object)this.mEditToolBarDlg.getPanelAdapter()));
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.setFocusTraversalPolicy(new ToolbarPreviewPanelFocusTraversalPolicy());
        this.bindKeys();
        this.setPreferredSize(this.getPreferredScrollableViewportSize());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.initPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.initPopup(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (keyEvent.getKeyCode() == 525 || keyEvent.isShiftDown() && keyEvent.getKeyCode() == 121) {
            int n = 10;
            int n2 = 10;
            this.doContextMenu(n, n2, this.hasFocus());
            keyEvent.consume();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Dimension dimension = this.getPreferredSize();
        if (dimension.width < this.getPreferredScrollableViewportSize().width) {
            this.setPreferredSize(this.getPreferredScrollableViewportSize());
            this.setSize(this.getPreferredScrollableViewportSize());
        } else {
            this.setSize(dimension);
        }
        if (this.mGroup.getButtonCount() > 0) {
            if (this.mGroup.getSelectedButton() == null) {
                this.mGroup.setSelectedButtonIndex(0);
            }
            this.mGroup.getSelectedButton().requestFocus();
        } else {
            this.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.mGroup.getButtonCount() < 1) {
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(600, 20);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 60;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.updateAutoscrollRegion(this);
        Rectangle rectangle = (Rectangle)this.mInnerRect.clone();
        rectangle.grow(-this.mHysteresis, -this.mHysteresis);
        if (this.mLastPosition != null && this.pointWithin(this.mLastPosition, this.mOuterRect) && !this.pointWithin(this.mLastPosition, rectangle)) {
            this.autoscroll(this, this.mLastPosition);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.mGroup.getButtonCount() < 1) {
            if (this.hasFocus()) {
                graphics.setColor(Color.blue);
            } else {
                graphics.setColor(Color.gray);
            }
            graphics.drawRect(2, 2, 14, 14);
        }
    }

    public int getSelectedComponentIndex() {
        return this.mGroup.getSelectedButtonIndex();
    }

    public Component getSelectedComponent() {
        return this.mGroup.getSelectedButton();
    }

    public boolean containsInVisibleArea(Point point) {
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this);
        return this.getVisibleRect().contains(point2);
    }

    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        boolean bl = false;
        if (!this.isEnabled() || !this.isShowing()) {
            return bl;
        }
        return dragDropAdapter.getTransferData() instanceof ToolbarItem;
    }

    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        Cursor cursor;
        boolean bl = false;
        if (dragDropAdapter instanceof ToolbarPreviewPanelDragAdapter) {
            if (this.containsInVisibleArea(point)) {
                bl = true;
            }
            cursor = Cursor.getPredefinedCursor(12);
        } else if (this.containsInVisibleArea(point) && dragDropAdapter instanceof MenuItemListDragAdapter) {
            if (this.canDrop(dragDropAdapter)) {
                bl = true;
                cursor = Cursor.getPredefinedCursor(12);
            } else {
                cursor = DragPane.getNoDropCursor();
            }
        } else {
            cursor = DragPane.getNoDropCursor();
        }
        if (bl) {
            Point point2 = (Point)point.clone();
            SwingUtilities.convertPointFromScreen(point2, this);
            this.checkAutoScroll(point2);
        }
        return cursor;
    }

    /*
     * WARNING - void declaration
     */
    public void itemDropped(DropEvent dropEvent) {
        int n;
        Object object = dropEvent.getTransferData();
        Component[] componentArray = this.getComponents();
        Point point = null;
        Point point2 = (Point)dropEvent.getDropLocation().clone();
        for (Component component : componentArray) {
            point = component.getLocation();
        }
        int n2 = point == null ? 0 : point.x;
        if (this.mLastPosition != null) {
            this.mLastPosition = null;
            if (this.mTimer != null) {
                this.mTimer.stop();
            }
        }
        if (dropEvent.getSource() instanceof JList && this.containsInVisibleArea((Point)dropEvent.getDropLocation().clone())) {
            void var7_8;
            SwingUtilities.convertPointFromScreen(point2, this);
            int n3 = point2.x / 20;
            n = point2.x % 20;
            if (n > 10) {
                ++var7_8;
            }
            ToolbarItem toolbarItem = (ToolbarItem)dropEvent.getTransferData();
            List<ToolbarItem> list = this.mEditToolBarDlg.getToolbarPreviewPanel().getToolbarItems();
            if (toolbarItem.getActionId().equals("separator") || !list.contains(toolbarItem)) {
                if (n2 < point2.x) {
                    this.addToolbarItem(toolbarItem);
                } else {
                    this.addToolbarItem(toolbarItem, (int)var7_8);
                }
            } else {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.mEditToolBarDlg.getResString("ERR_TB_ITEM_ALREADY_EXISTS"), VersionInfo.getAppVersionString());
            }
        } else if (dropEvent.getSource() instanceof JButton) {
            if (this.containsInVisibleArea(point2)) {
                Point point3 = (Point)dropEvent.getDropLocation().clone();
                SwingUtilities.convertPointFromScreen(point3, this);
                n = point3.x / 20;
                int n3 = point3.x % 20;
                if (n3 > 10) {
                    ++n;
                }
                int n4 = this.getSelectedComponentIndex();
                this.removeToolbarItemAtIndex(n4);
                if (n2 < point3.x) {
                    this.addToolbarItem((ToolbarItem)object);
                } else {
                    if (n4 < n) {
                        --n;
                    }
                    this.addToolbarItem((ToolbarItem)object, n);
                }
            } else {
                this.removeToolbarItemAtIndex(this.getSelectedComponentIndex());
            }
        }
    }

    public int getComponentIndex(Component component) {
        return this.mGroup.getComponentIndex(component);
    }

    public ToolbarPreviewPanelButton getButtonAtIndex(int n) {
        return this.mGroup.getButtonAtIndex(n);
    }

    public void setSelectedComponentIndex(int n) {
        this.mGroup.setSelectedButtonIndex(n);
    }

    public void addToolbarItem(ToolbarItem toolbarItem) {
        int n = this.mGroup.getButtonCount();
        if (n < 0) {
            n = 0;
        }
        this.addToolbarItem(toolbarItem, n);
    }

    public void addToolbarItem(ToolbarItem toolbarItem, int n) {
        this.mTbItems.add(n, toolbarItem);
        this.refresh();
        this.revalidate();
        this.repaint();
        this.setNewSize();
        this.mGroup.setSelectedButtonIndex(n);
        this.mEditToolBarDlg.updateContinueButton();
    }

    public void removeToolbarItem(ToolbarItem toolbarItem) {
        this.removeToolbarItemAtIndex(this.mTbItems.indexOf(toolbarItem));
    }

    public void removeToolbarItemAtIndex(int n) {
        if (n >= 0) {
            ToolbarItem toolbarItem = this.mTbItems.get(n);
            if (toolbarItem.isUserDefinedImage()) {
                this.mEditToolBarDlg.getDeletedUserImagesSet().add(toolbarItem.getImageKey());
            }
            this.mTbItems.remove(n);
            ToolbarPreviewPanelButton toolbarPreviewPanelButton = this.mGroup.getButtonAtIndex(n);
            this.mGroup.remove(toolbarPreviewPanelButton);
            this.remove(toolbarPreviewPanelButton);
            this.revalidate();
            this.setNewSize();
            this.repaint();
            int n2 = this.mGroup.getButtonCount();
            if (n2 >= 1 && n == n2) {
                --n;
            }
            if (this.mGroup.getButtonCount() > 0) {
                this.mGroup.setSelectedButtonIndex(n);
            } else {
                this.buttonSelectionChanged();
                this.requestFocus();
            }
            this.mEditToolBarDlg.updateContinueButton();
        }
    }

    public void buttonSelectionChanged() {
        this.mEditToolBarDlg.updateChangeImageButton();
        final ToolbarPreviewPanelButton toolbarPreviewPanelButton = this.mGroup.getSelectedButton();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (toolbarPreviewPanelButton != null) {
                    Point point = toolbarPreviewPanelButton.getLocation();
                    int n = ((FlowLayout)ToolbarPreviewPanel.this.getLayout()).getHgap();
                    Rectangle rectangle = new Rectangle(point.x - n, point.y, toolbarPreviewPanelButton.getWidth() + 2 * n, toolbarPreviewPanelButton.getHeight());
                    ToolbarPreviewPanel.this.scrollRectToVisible(rectangle);
                }
            }
        });
    }

    public List<ToolbarItem> getToolbarItems() {
        return this.mTbItems;
    }

    public void setTbItems(List<ToolbarItem> list) {
        this.mTbItems = list;
    }

    public void freshLayout() {
        this.refresh();
        this.revalidate();
        this.repaint();
        this.setNewSize();
    }

    private void refresh() {
        this.removeAll();
        this.mGroup.removeAll();
        this.setPreferredSize(null);
        if (this.mTbItems != null) {
            for (ToolbarItem toolbarItem : this.mTbItems) {
                ToolbarPreviewPanelButton toolbarPreviewPanelButton = new ToolbarPreviewPanelButton();
                toolbarPreviewPanelButton.addMouseListener((MouseListener)((Object)this.mEditToolBarDlg.getPanelAdapter()));
                toolbarPreviewPanelButton.addMouseMotionListener((MouseMotionListener)((Object)this.mEditToolBarDlg.getPanelAdapter()));
                toolbarPreviewPanelButton.addMouseListener(this);
                toolbarPreviewPanelButton.addKeyListener(this);
                this.mGroup.add(toolbarPreviewPanelButton);
                ImageIcon imageIcon = null;
                if (toolbarItem.isUserDefinedImage()) {
                    imageIcon = ToolbarsUtil.getUserImageIcon(toolbarItem.getImageKey(), IToolbarConstants.SMALL_IMAGE_SIZE);
                } else {
                    URL uRL = ResUtil.getImageURL(toolbarItem.getImageKey());
                    if (uRL == null) {
                        toolbarItem.setImageKey("generic_menu_icon");
                        uRL = ResUtil.getImageURL(toolbarItem.getImageKey());
                    }
                    if (uRL != null) {
                        imageIcon = new ImageIcon(uRL);
                    }
                }
                toolbarPreviewPanelButton.setIcon(imageIcon);
                toolbarPreviewPanelButton.setPreferredSize(new Dimension(20, 20));
                this.add(toolbarPreviewPanelButton);
            }
        } else {
            this.removeAll();
        }
    }

    private void setNewSize() {
        Dimension dimension = this.getPreferredSize();
        if (dimension.width < this.getPreferredScrollableViewportSize().width) {
            this.setPreferredSize(this.getPreferredScrollableViewportSize());
        }
    }

    private void bindKeys() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(86, 128);
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(keyStroke, "pasteAction");
        actionMap.put("pasteAction", new PasteAction());
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(88, 128);
        inputMap = this.getInputMap(1);
        actionMap = this.getActionMap();
        inputMap.put(keyStroke2, "cutAction");
        actionMap.put("cutAction", new CutAction());
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(127, 0);
        inputMap = this.getInputMap(1);
        actionMap = this.getActionMap();
        inputMap.put(keyStroke3, "deleteAction");
        actionMap.put("deleteAction", new DeleteAction());
    }

    private void doContextMenu(int n, int n2, boolean bl) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(new CutAction());
        jMenuItem.setEnabled(!bl);
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(new PasteAction());
        Transferable transferable = this.mEditToolBarDlg.getClipboard().getContents(this);
        jMenuItem2.setEnabled(transferable != null && transferable.isDataFlavorSupported(ToolbarItemTransferable.TOOLBAR_ITEM_FLAVOR));
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(new DeleteAction());
        jMenuItem3.setEnabled(!bl);
        jPopupMenu.add(jMenuItem3);
        if (bl) {
            jPopupMenu.show(this, n, n2);
        } else {
            jPopupMenu.show(this.getSelectedComponent(), n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAutoScroll(Point point) {
        if (this.mLastPosition == null) {
            if (this.contains(point)) {
                this.mLastPosition = point.getLocation();
                this.updateAutoscrollRegion(this);
                this.initPropertiesIfNecessary();
            }
        } else {
            ToolbarPreviewPanel toolbarPreviewPanel = this;
            synchronized (toolbarPreviewPanel) {
                if (Math.abs(point.x - this.mLastPosition.x) > this.mHysteresis || Math.abs(point.y - this.mLastPosition.y) > this.mHysteresis) {
                    if (this.mTimer.isRunning()) {
                        this.mTimer.stop();
                    }
                    this.mLastPosition = null;
                } else {
                    if (!this.mTimer.isRunning()) {
                        this.mTimer.start();
                    }
                    this.mLastPosition = point;
                }
            }
        }
    }

    private void updateAutoscrollRegion(JComponent jComponent) {
        int n;
        Rectangle rectangle = jComponent.getVisibleRect();
        this.mInnerRect.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Insets insets = new Insets(0, 0, 0, 0);
        if (jComponent instanceof Scrollable) {
            n = 10;
            if (rectangle.width >= n) {
                insets.right = 5;
                insets.left = 5;
            }
            if (rectangle.height >= n) {
                insets.bottom = 5;
                insets.top = 5;
            }
        }
        n = rectangle.x;
        int n2 = rectangle.y;
        this.mOuterRect.setBounds(rectangle.x - insets.left, rectangle.y - insets.top, n + rectangle.width + insets.right, n2 + rectangle.height + insets.bottom);
    }

    private void autoscroll(JComponent jComponent, Point point) {
        if (jComponent instanceof Scrollable) {
            int n;
            Rectangle rectangle;
            Scrollable scrollable = (Scrollable)((Object)jComponent);
            if (point.y < this.mInnerRect.y + this.mHysteresis) {
                rectangle = this.getVisibleRect();
                n = scrollable.getScrollableUnitIncrement(rectangle, 1, -1);
                Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y - n, rectangle.width, n);
                jComponent.scrollRectToVisible(rectangle2);
                this.mLastPosition.y -= n;
            } else if (point.y > this.mInnerRect.y + this.mInnerRect.height - this.mHysteresis) {
                rectangle = this.getVisibleRect();
                n = scrollable.getScrollableUnitIncrement(rectangle, 1, 1);
                Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, n);
                jComponent.scrollRectToVisible(rectangle3);
                this.mLastPosition.y += n;
            }
            if (point.x < this.mInnerRect.x + this.mHysteresis) {
                int n2 = scrollable.getScrollableUnitIncrement(this.mInnerRect, 0, -1);
                Rectangle rectangle4 = new Rectangle(this.mInnerRect.x - n2, this.mInnerRect.y, n2, this.mInnerRect.height);
                jComponent.scrollRectToVisible(rectangle4);
                this.mLastPosition.x -= n2;
            } else if (point.x > this.mInnerRect.x + this.mInnerRect.width - this.mHysteresis) {
                int n3 = scrollable.getScrollableUnitIncrement(this.mInnerRect, 0, 1);
                Rectangle rectangle5 = new Rectangle(this.mInnerRect.x + this.mInnerRect.width, this.mInnerRect.y, n3, this.mInnerRect.height);
                jComponent.scrollRectToVisible(rectangle5);
                this.mLastPosition.x += n3;
            }
        }
    }

    private void initPropertiesIfNecessary() {
        if (this.mTimer == null) {
            int n = 100;
            int n2 = 100;
            this.mTimer = new Timer(n2, this);
            this.mTimer.setCoalesce(true);
            this.mTimer.setInitialDelay(n);
        }
    }

    private boolean pointWithin(Point point, Rectangle rectangle) {
        return point.x > rectangle.x && point.y > rectangle.y && point.x < rectangle.width && point.y < rectangle.height;
    }

    private void initPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (mouseEvent.isPopupTrigger() && (mouseEvent.getSource() instanceof ToolbarPreviewPanelButton || mouseEvent.getSource() == this)) {
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
            SwingUtilities.convertPointFromScreen(point, this);
            this.setSelectedComponentIndex(point.x / 20);
            this.doContextMenu(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getSource() == this);
            mouseEvent.consume();
        }
    }

    private class ToolbarPreviewPanelFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private ToolbarPreviewPanelFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            int n;
            if (component != null && component instanceof ToolbarPreviewPanelButton && (n = ToolbarPreviewPanel.this.mGroup.getButtonCount()) > 0) {
                int n2 = ToolbarPreviewPanel.this.mGroup.getComponentIndex(component);
                n2 = n2 == n - 1 ? 0 : ++n2;
                return ToolbarPreviewPanel.this.mGroup.getButtonAtIndex(n2);
            }
            return null;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            if (component != null && component instanceof ToolbarPreviewPanelButton) {
                int n = ToolbarPreviewPanel.this.mGroup.getComponentIndex(component);
                n = n != ToolbarPreviewPanel.this.mGroup.getButtonCount() - 1 ? 0 : ++n;
                ToolbarPreviewPanel.this.mGroup.getButtonAtIndex(n);
            }
            return null;
        }

        @Override
        public Component getFirstComponent(Container container) {
            return container.getComponents()[0];
        }

        @Override
        public Component getLastComponent(Container container) {
            Component[] componentArray = container.getComponents();
            return componentArray[componentArray.length - 1];
        }

        @Override
        public Component getDefaultComponent(Container container) {
            if (ToolbarPreviewPanel.this.mGroup.getSelectedButton() != null) {
                return ToolbarPreviewPanel.this.mGroup.getSelectedButton();
            }
            if (ToolbarPreviewPanel.this.mTbItems.size() > 0) {
                return ToolbarPreviewPanel.this.mGroup.getButtonAtIndex(0);
            }
            return null;
        }
    }

    private class PasteAction
    extends AbstractAction {
        public PasteAction() {
            this.putValue("Name", ToolbarPreviewPanel.this.mEditToolBarDlg.getResString("IDS_TB_PASTE_TOOL"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", ToolbarPreviewPanel.this.mEditToolBarDlg.getDlgAccessKey("IDK_TB_PASTE_TOOL_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Transferable transferable = ToolbarPreviewPanel.this.mEditToolBarDlg.getClipboard().getContents(ToolbarPreviewPanel.this);
            if (transferable != null && transferable.isDataFlavorSupported(ToolbarItemTransferable.TOOLBAR_ITEM_FLAVOR)) {
                try {
                    ToolbarItem toolbarItem = (ToolbarItem)transferable.getTransferData(ToolbarItemTransferable.TOOLBAR_ITEM_FLAVOR);
                    if (toolbarItem.getActionId().equals("separator") || !ToolbarPreviewPanel.this.getToolbarItems().contains(toolbarItem)) {
                        int n = ToolbarPreviewPanel.this.getSelectedComponentIndex();
                        if (n >= 0) {
                            ToolbarPreviewPanel.this.addToolbarItem(toolbarItem, n + 1);
                        } else {
                            ToolbarPreviewPanel.this.addToolbarItem(toolbarItem);
                        }
                    } else {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)ToolbarPreviewPanel.this.mEditToolBarDlg), ToolbarPreviewPanel.this.mEditToolBarDlg.getResString("ERR_TB_ITEM_ALREADY_EXISTS"), VersionInfo.getAppVersionString());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            this.putValue("Name", ToolbarPreviewPanel.this.mEditToolBarDlg.getResString("IDS_TB_DELETE_TOOL"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", ToolbarPreviewPanel.this.mEditToolBarDlg.getDlgAccessKey("IDK_TB_DELETE_TOOL_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToolbarPreviewPanel.this.removeToolbarItemAtIndex(ToolbarPreviewPanel.this.getSelectedComponentIndex());
        }
    }

    private class CutAction
    extends AbstractAction {
        public CutAction() {
            this.putValue("Name", ToolbarPreviewPanel.this.mEditToolBarDlg.getResString("IDS_TB_CUT_TOOL"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", ToolbarPreviewPanel.this.mEditToolBarDlg.getDlgAccessKey("IDK_TB_CUT_TOOL_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ToolbarPreviewPanel.this.getSelectedComponentIndex();
            if (n >= 0) {
                ToolbarItem toolbarItem = ToolbarPreviewPanel.this.getToolbarItems().get(n);
                ToolbarItemTransferable toolbarItemTransferable = new ToolbarItemTransferable(toolbarItem);
                ToolbarPreviewPanel.this.mEditToolBarDlg.getClipboard().setContents(toolbarItemTransferable, ToolbarPreviewPanel.this.mEditToolBarDlg);
                ToolbarPreviewPanel.this.removeToolbarItemAtIndex(n);
            }
        }
    }
}

