/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.view.toolbars;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controlbar.ToolbarDefaults;
import com.spss.java_client.ui.controlbar.ToolbarItem;
import com.spss.java_client.ui.controlbar.ToolbarObject;
import com.spss.java_client.ui.controlbar.ToolbarsUtil;
import com.spss.java_client.ui.controlbar.UserTool;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.view.res.ViewResBundle;
import com.spss.java_client.ui.dialogs.base.view.toolbars.EditToolBarDlg;
import com.spss.java_client.ui.dialogs.base.view.toolbars.NewToolbarPropertiesDlg;
import com.spss.java_client.ui.dialogs.base.view.toolbars.ToolbarsTableModel;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSpssDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SpssFocusCellRenderer;
import com.spss.java_client.ui.dialogs.common.SpssFocusGenericRenderer;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.util.TableUtilities;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;

public class ShowToolBarsDlg
extends BaseSpssDialog
implements ListSelectionListener,
ItemListener,
TableModelListener {
    private JTable mToolbarsTable;
    private ToolbarsTableModel mToolbarTableModel;
    private JCheckBox mShowToolTipsCheck;
    private JCheckBox mLargeButtonsCheck;
    private JComboBox mWindowCombo;
    private JButton mNewButton;
    private JButton mEditButton;
    private JButton mDeleteButton;
    private LinkedHashMap<String, UserTool> mUserTbItemsList;
    private long mUserNodeSuffix;
    private Set<String> mDeleteTools = new HashSet<String>();
    private DialogDataModel mDialogDataModel = new DialogDataModel();
    private Set<String> mNewUserImages = new HashSet<String>();
    private Set<String> mDeletedUserImages = new HashSet<String>();

    public ShowToolBarsDlg(SpssFrame spssFrame) {
        super((JFrame)spssFrame, true, ResUtil.getBundle(ViewResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), ViewResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_TB_SHOW_TOOLBARS_TITLE"));
        this.restoreDialogSizeLocationFromPrefs(this.getIActionKey());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ShowToolBarsDlg.this.isDisplayable()) {
                    ProcedureDlgMgr.getMgr().loadPersistentState(ShowToolBarsDlg.this.getIActionKey(), ShowToolBarsDlg.this.getDialogDataModel());
                    BaseProcedureDialog.loadState(ShowToolBarsDlg.this.getDialogDataModel(), (Container)((Object)ShowToolBarsDlg.this), BaseProcedureDialog.NameLabelOption.no_override);
                }
            }
        });
    }

    public long getUserNodeSuffix() {
        return this.mUserNodeSuffix;
    }

    public void setUserNodeSuffix(long l) {
        this.mUserNodeSuffix = l;
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_idd_spss_view_toolbars");
    }

    public void doDeleteToolbar() {
        int n = this.mToolbarsTable.getSelectedRow();
        if (n > -1) {
            ToolbarObject toolbarObject = this.mToolbarTableModel.getToolbarObjectAt(n);
            if (toolbarObject.isUserDefinedToolbar()) {
                SpssFrame[] spssFrameArray;
                String string = this.getResString("ERR_TB_WARNING_DELETE");
                String string2 = string.replace("%s", toolbarObject.getName());
                if (1 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) {
                    spssFrameArray = toolbarObject.getToolbarItems();
                    for (ToolbarItem toolbarItem : spssFrameArray) {
                        if (!toolbarItem.isUserDefinedImage()) continue;
                        this.mDeletedUserImages.add(toolbarItem.getImageKey());
                    }
                    this.mToolbarTableModel.deleteToolbarObject(toolbarObject);
                }
                spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
                for (SpssFrame spssFrame : spssFrameArray) {
                    spssFrame.refreshToolbar();
                }
            } else {
                ToolbarObject toolbarObject2 = new ToolbarDefaults().getDefaultToolbar(toolbarObject.getPreferencesNode());
                toolbarObject.setName(toolbarObject2.getName());
                toolbarObject.setDocTypes(toolbarObject2.getDocTypes());
                toolbarObject.setToolbarItems(toolbarObject2.getToolbarItems());
                toolbarObject.setVisible(toolbarObject2.isVisible());
                this.mToolbarTableModel.fireTableRowsUpdated(n, n);
            }
        }
    }

    public ToolbarsTableModel getToolbarTableModel() {
        return this.mToolbarTableModel;
    }

    public Map<String, UserTool> getUserTbItemList() {
        return this.mUserTbItemsList;
    }

    public void setUserTbItemsList(LinkedHashMap<String, UserTool> linkedHashMap) {
        this.mUserTbItemsList = linkedHashMap;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.mToolbarsTable.getSelectionModel()) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = this.mToolbarsTable.getSelectedRow();
            if (n > -1) {
                ToolbarObject toolbarObject = this.mToolbarTableModel.getToolbarObjectAt(n);
                this.mDeleteButton.setEnabled(toolbarObject.isUserDefinedToolbar());
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mWindowCombo) {
            switch (this.mWindowCombo.getSelectedIndex()) {
                case 0: {
                    this.mToolbarTableModel.setCurrentDocType(null);
                    break;
                }
                case 1: {
                    this.mToolbarTableModel.setCurrentDocType(DocType.DE_DOC);
                    break;
                }
                case 2: {
                    this.mToolbarTableModel.setCurrentDocType(DocType.SYNTAX_DOC);
                    break;
                }
                case 3: {
                    this.mToolbarTableModel.setCurrentDocType(DocType.OUTPUT_DOC);
                }
            }
            if (this.mToolbarTableModel.getRowCount() > 0) {
                this.mToolbarsTable.getSelectionModel().setSelectionInterval(0, 0);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getSource() == this.mToolbarTableModel) {
            this.mEditButton.setEnabled(this.mToolbarTableModel.getRowCount() > 0);
        }
    }

    public void addToolsToDelete(Set<String> set) {
        this.mDeleteTools.addAll(set);
        List<ToolbarObject> list = this.mToolbarTableModel.getToolbarObjects();
        for (ToolbarObject toolbarObject : list) {
            Iterator<ToolbarItem> iterator = toolbarObject.getToolbarItems().iterator();
            while (iterator.hasNext()) {
                if (!set.contains(iterator.next().getActionId())) continue;
                iterator.remove();
            }
        }
    }

    public void addNewUserImages(Set<String> set) {
        this.mNewUserImages.addAll(set);
    }

    public void addDeletedUserImages(Set<String> set) {
        this.mDeletedUserImages.addAll(set);
    }

    public DialogDataModel getDialogDataModel() {
        return this.mDialogDataModel;
    }

    protected void saveDialogState() {
        ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.getDialogDataModel());
        this.saveDialogSizeLocationToPrefs(this.getIActionKey());
    }

    protected void init() {
        super.init();
        this.initVars();
        this.setupViewPanel(this.getViewPanel());
        this.setDefaults();
        this.mToolbarsTable.getSelectionModel().addListSelectionListener(this);
        this.mWindowCombo.addItemListener(this);
        this.mToolbarTableModel.addTableModelListener(this);
        this.setDocTypeComboSelection();
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        JButton jButton = new JButton(new OkAction());
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        if (DialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setUpButtonPanel() {
        JPanel jPanel = new JPanel();
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = insets.top + insets.bottom;
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        this.mNewButton = new JButton(new NewToolbarAction());
        jPanel.add(this.mNewButton);
        jPanel.add(Box.createVerticalStrut(n));
        this.mEditButton = new JButton(new EditAction());
        jPanel.add(this.mEditButton);
        jPanel.add(Box.createVerticalStrut(n));
        this.mDeleteButton = new JButton(new DeleteAction());
        jPanel.add(this.mDeleteButton);
        jPanel.add(Box.createVerticalStrut(n));
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private void setDefaults() {
        this.mDeleteButton.setEnabled(false);
        this.mToolbarsTable.getSelectionModel().setSelectionInterval(0, 0);
    }

    private void initVars() {
        this.mWindowCombo = new JComboBox<String>(this.getResStringArray("IDS_TB_WINDOW_OPTIONS"));
        this.setToolbarsTable();
        this.mShowToolTipsCheck = DialogUtil.createCheckBox(this, "IDS_TB_SHOW_TOOLTIPS", null);
        this.mLargeButtonsCheck = DialogUtil.createCheckBox(this, "IDS_TB_LARGE_BUTTONS", null);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mShowToolTipsCheck);
        spssButtonGroup.add(this.mLargeButtonsCheck);
        this.mShowToolTipsCheck.setSelected(ToolbarsUtil.getShowToolTips());
        this.mLargeButtonsCheck.setSelected(ToolbarsUtil.getShowLargeButtons());
        this.mUserTbItemsList = ToolbarsUtil.loadUserDefinedToolsMapFromPrefs();
        this.mUserNodeSuffix = ToolbarsUtil.getUserToolNodeSuffx();
    }

    private void setupTableForFocusRepainting(final JTable jTable) {
        SpssFocusCellRenderer spssFocusCellRenderer = new SpssFocusCellRenderer();
        jTable.setDefaultRenderer(Object.class, spssFocusCellRenderer);
        jTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                jTable.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                jTable.repaint();
            }
        });
    }

    private void setToolbarsTable() {
        this.mToolbarsTable = new JTable();
        this.mToolbarTableModel = new ToolbarsTableModel(this.mToolbarsTable);
        List<ToolbarObject> list = ToolbarsUtil.loadToolBarsFromPrefs();
        for (ToolbarObject object2 : list) {
            this.mToolbarTableModel.add(object2);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.getResString("IDS_TB_TOOLBARS_SHOW_HEADER"));
        arrayList.add(this.getResString("IDS_TB_TOOLBARS_NAME_HEADER"));
        this.mToolbarTableModel.setColumnNames(arrayList);
        this.mToolbarsTable.setModel(this.mToolbarTableModel);
        this.mToolbarsTable.setAutoResizeMode(0);
        this.mToolbarsTable.setShowHorizontalLines(false);
        this.mToolbarsTable.setShowVerticalLines(false);
        this.mToolbarsTable.setIntercellSpacing(new Dimension(0, 0));
        this.mToolbarsTable.setColumnSelectionAllowed(false);
        this.mToolbarsTable.setPreferredScrollableViewportSize(new Dimension(205, 136));
        this.mToolbarsTable.setAutoResizeMode(3);
        this.mToolbarsTable.setFocusTraversalKeys(0, null);
        this.mToolbarsTable.setFocusTraversalKeys(1, null);
        this.mToolbarsTable.getSelectionModel().setSelectionMode(0);
        this.setupTableForFocusRepainting(this.mToolbarsTable);
        this.mToolbarsTable.getColumnModel().getColumn(0).setCellRenderer(new SpssFocusGenericRenderer(this.mToolbarsTable.getDefaultRenderer(Boolean.class)));
        this.initColumnSizes();
        JTableHeader jTableHeader = this.mToolbarsTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(false);
    }

    private void initColumnSizes() {
        int n = TableUtilities.calculateColumnHeaderTextWidth((JTable)this.mToolbarsTable, (int)0);
        this.mToolbarsTable.getColumnModel().getColumn(0).setPreferredWidth(n);
        this.mToolbarsTable.getColumnModel().getColumn(1).setPreferredWidth(205 - n);
    }

    private void setDocTypeComboSelection() {
        DocType docType = SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame().docType();
        int n = 0;
        if (docType.equals((Object)DocType.DE_DOC)) {
            n = 1;
        } else if (docType.equals((Object)DocType.SYNTAX_DOC)) {
            n = 2;
        } else if (docType.equals((Object)DocType.OUTPUT_DOC)) {
            n = 3;
        }
        this.mWindowCombo.setSelectedIndex(n);
    }

    private void setupViewPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TB_WINDOW");
        jLabel.setLabelFor(this.mWindowCombo);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_TB_TOOLBARS");
        jLabel2.setLabelFor(this.mToolbarsTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mWindowCombo, gridBagConstraints, 0, 1, 2, 1, n, insets);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(insets.top, insets.left, insets.bottom, n2 * 2);
        JScrollPane jScrollPane = new JScrollPane(this.mToolbarsTable);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.setUpButtonPanel(), gridBagConstraints, 1, 3, 1, 4, n, null);
        gridBagConstraints.weightx = 1.0;
        insets2.set(n2, insets.left, n2, insets.right);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, new JSeparator(), gridBagConstraints, 0, 4, 3, 1, 10, insets2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.setupCheckBoxPanel(), gridBagConstraints, 0, 5, 1, 1, n, insets);
    }

    private JPanel setupCheckBoxPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mShowToolTipsCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap() * 3, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mLargeButtonsCheck, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private String getIActionKey() {
        return "view_customize_toolbar";
    }

    private void deleteUserImages(Set<String> set) {
        if (set.size() > 0) {
            String string = System.getProperty("user.home.spss");
            for (String string2 : set) {
                File file = new File(string + File.separatorChar + "toolbar_images" + File.separatorChar + string2);
                if (!file.exists() || file.delete()) continue;
                ComponentState.trace1((String)("failed to delete file: " + file.getPath()), (int)15);
            }
        }
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mWindowCombo);
        vector.add(this.mToolbarsTable);
        vector.add(this.mNewButton);
        vector.add(this.mEditButton);
        vector.add(this.mDeleteButton);
        vector.add(this.mShowToolTipsCheck);
        vector.add(this.mLargeButtonsCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private class EditAction
    extends AbstractAction {
        EditAction() {
            this.putValue("Name", ShowToolBarsDlg.this.getResString("IDS_TB_EDIT"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", ShowToolBarsDlg.this.getDlgAccessKey("IDK_TB_EDIT_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new EditToolBarDlg(ShowToolBarsDlg.this, ShowToolBarsDlg.this.mToolbarTableModel.getToolbarObjectAt(ShowToolBarsDlg.this.mToolbarsTable.getSelectedRow()), false);
        }
    }

    private class NewToolbarAction
    extends AbstractAction {
        NewToolbarAction() {
            this.putValue("Name", ShowToolBarsDlg.this.getResString("IDS_TB_NEW"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", ShowToolBarsDlg.this.getDlgAccessKey("IDK_TB_NEW_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new NewToolbarPropertiesDlg(ShowToolBarsDlg.this).setVisible(true);
        }
    }

    private class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            this.putValue("Name", ShowToolBarsDlg.this.getResString("IDS_TB_DELETE"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", ShowToolBarsDlg.this.getDlgAccessKey("IDS_TB_DELETE_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ShowToolBarsDlg.this.doDeleteToolbar();
        }
    }

    private class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
            this.putValue("AcceleratorKey", 112);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ShowToolBarsDlg.this.doHelp();
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ShowToolBarsDlg.this.deleteUserImages(ShowToolBarsDlg.this.mNewUserImages);
            ShowToolBarsDlg.this.dispose();
        }
    }

    private class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpssFrame[] spssFrameArray;
            List<ToolbarObject> list = ShowToolBarsDlg.this.mToolbarTableModel.getToolbarObjects();
            ToolbarsUtil.deleteUserTools(ShowToolBarsDlg.this.mDeleteTools);
            ToolbarsUtil.saveUserDefinedToolsMapToPrefs(ShowToolBarsDlg.this.mUserTbItemsList, ShowToolBarsDlg.this.mUserNodeSuffix);
            ToolbarsUtil.saveToolbarToPrefs(list, ShowToolBarsDlg.this.mLargeButtonsCheck.isSelected(), ShowToolBarsDlg.this.mShowToolTipsCheck.isSelected());
            for (SpssFrame spssFrame : spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments()) {
                spssFrame.setToolbarPrefCache(list);
                spssFrame.setShowLargeButtonsToolbar(ShowToolBarsDlg.this.mLargeButtonsCheck.isSelected());
                spssFrame.setShowTooltipsToolbar(ShowToolBarsDlg.this.mShowToolTipsCheck.isSelected());
                spssFrame.refreshToolbar();
            }
            ShowToolBarsDlg.this.deleteUserImages(ShowToolBarsDlg.this.mDeletedUserImages);
            BaseProcedureDialog.saveState(ShowToolBarsDlg.this.getDialogDataModel(), (Container)((Object)ShowToolBarsDlg.this));
            ShowToolBarsDlg.this.saveDialogState();
            ShowToolBarsDlg.this.dispose();
        }
    }
}

