/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.view.toolbars;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.controlbar.ToolbarObject;
import com.spss.java_client.ui.controlbar.ToolbarsUtil;
import com.spss.java_client.ui.dialogs.base.view.toolbars.BaseToolBarPropertiesDlg;
import com.spss.java_client.ui.dialogs.base.view.toolbars.EditToolBarDlg;
import com.spss.java_client.ui.dialogs.base.view.toolbars.ShowToolBarsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;

public class NewToolbarPropertiesDlg
extends BaseToolBarPropertiesDlg {
    private JButton mEditButton;

    public NewToolbarPropertiesDlg(final ShowToolBarsDlg showToolBarsDlg) {
        super(showToolBarsDlg);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseProcedureDialog.loadState(showToolBarsDlg.getDialogDataModel(), (Container)((Object)NewToolbarPropertiesDlg.this), BaseProcedureDialog.NameLabelOption.no_override);
            }
        });
    }

    @Override
    protected void doTextEvent(DocumentEvent documentEvent) {
        this.mEditButton.setEnabled(this.checkDialogOkCondition());
    }

    @Override
    protected void doItemStateEvent(ItemEvent itemEvent) {
        this.mEditButton.setEnabled(this.checkDialogOkCondition());
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.mEditButton.setEnabled(false);
        this.mDataEditorCheck.setSelected(true);
        this.mViewerCheck.setSelected(true);
        this.mSyntaxCheck.setSelected(true);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        this.mEditButton = new JButton(new EditAction());
        Insets insets = DialogUtil.getStandardButtonInsets();
        JButton jButton = new JButton(new BaseToolBarPropertiesDlg.CancelAction());
        JButton jButton2 = new JButton(new BaseToolBarPropertiesDlg.HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        if (DialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mEditButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mEditButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mEditButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mEditButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private class EditAction
    extends AbstractAction {
        EditAction() {
            this.putValue("Name", NewToolbarPropertiesDlg.this.getResString("IDS_TB_EDIT"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", NewToolbarPropertiesDlg.this.getDlgAccessKey("IDK_TB_EDIT_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final ShowToolBarsDlg showToolBarsDlg = (ShowToolBarsDlg)((Object)NewToolbarPropertiesDlg.this.getParent());
            String string = NewToolbarPropertiesDlg.this.mToolBarNameText.getText();
            if (ToolbarsUtil.isUniqueToolbarName(string, showToolBarsDlg.getToolbarTableModel().getToolbarObjects())) {
                final ToolbarObject toolbarObject = new ToolbarObject();
                toolbarObject.setName(string);
                toolbarObject.setUserDefinedToolbar(true);
                toolbarObject.setVisible(true);
                HashSet<DocType> hashSet = new HashSet<DocType>();
                if (NewToolbarPropertiesDlg.this.mDataEditorCheck.isSelected()) {
                    hashSet.add(DocType.DE_DOC);
                }
                if (NewToolbarPropertiesDlg.this.mSyntaxCheck.isSelected()) {
                    hashSet.add(DocType.SYNTAX_DOC);
                }
                if (NewToolbarPropertiesDlg.this.mSyntaxCheck.isSelected()) {
                    hashSet.add(DocType.OUTPUT_DOC);
                }
                toolbarObject.setDocTypes(hashSet);
                BaseProcedureDialog.saveState(((ShowToolBarsDlg)((Object)NewToolbarPropertiesDlg.this.getParent())).getDialogDataModel(), (Container)((Object)NewToolbarPropertiesDlg.this));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new EditToolBarDlg(showToolBarsDlg, toolbarObject, true);
                    }
                });
                NewToolbarPropertiesDlg.this.dispose();
            } else {
                String string2 = NewToolbarPropertiesDlg.this.getResString("ERR_TB_DUPLICATE_TB_NAME").replace("%s", string);
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)NewToolbarPropertiesDlg.this), string2, VersionInfo.getAppVersionString());
            }
        }
    }
}

