/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.view.toolbars;

import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.controlbar.ToolbarObject;
import com.spss.java_client.ui.dialogs.base.view.toolbars.BaseToolBarPropertiesDlg;
import com.spss.java_client.ui.dialogs.base.view.toolbars.EditToolBarDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;

public class EditToolbarPropertiesDlg
extends BaseToolBarPropertiesDlg {
    private JButton mContuniueButton;
    private final ToolbarObject mToolbarObject;

    public EditToolbarPropertiesDlg(final EditToolBarDlg editToolBarDlg, ToolbarObject toolbarObject) {
        super(editToolBarDlg);
        this.mToolbarObject = toolbarObject;
        this.mToolBarNameText.setText(this.mToolbarObject.getName());
        Set<DocType> set = this.mToolbarObject.getDocTypes();
        this.mDataEditorCheck.setSelected(set.contains(DocType.DE_DOC));
        this.mViewerCheck.setSelected(set.contains(DocType.OUTPUT_DOC));
        this.mSyntaxCheck.setSelected(set.contains(DocType.SYNTAX_DOC));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseProcedureDialog.loadState(editToolBarDlg.getDialogDataModel(), (Container)((Object)EditToolbarPropertiesDlg.this), BaseProcedureDialog.NameLabelOption.no_override);
            }
        });
    }

    @Override
    protected void doTextEvent(DocumentEvent documentEvent) {
        this.mContuniueButton.setEnabled(this.checkDialogOkCondition());
    }

    @Override
    protected void doItemStateEvent(ItemEvent itemEvent) {
        this.mContuniueButton.setEnabled(this.checkDialogOkCondition());
    }

    @Override
    protected void init() {
        super.init();
        this.mContuniueButton.setEnabled(false);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.mContuniueButton = new JButton(new ContinueAction());
        JButton jButton = new JButton(new BaseToolBarPropertiesDlg.CancelAction());
        JButton jButton2 = new JButton(new BaseToolBarPropertiesDlg.HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        if (DialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mContuniueButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mContuniueButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mContuniueButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mContuniueButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditToolbarPropertiesDlg.this.mToolbarObject.setName(EditToolbarPropertiesDlg.this.mToolBarNameText.getText());
            HashSet<DocType> hashSet = new HashSet<DocType>();
            if (EditToolbarPropertiesDlg.this.mDataEditorCheck.isSelected()) {
                hashSet.add(DocType.DE_DOC);
            }
            if (EditToolbarPropertiesDlg.this.mViewerCheck.isSelected()) {
                hashSet.add(DocType.OUTPUT_DOC);
            }
            if (EditToolbarPropertiesDlg.this.mSyntaxCheck.isSelected()) {
                hashSet.add(DocType.SYNTAX_DOC);
            }
            EditToolbarPropertiesDlg.this.mToolbarObject.setDocTypes(hashSet);
            BaseProcedureDialog.saveState(((EditToolBarDlg)((Object)EditToolbarPropertiesDlg.this.getParent())).getDialogDataModel(), (Container)((Object)EditToolbarPropertiesDlg.this));
            EditToolbarPropertiesDlg.this.dispose();
        }
    }
}

