/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.view.toolbars;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controlbar.ToolbarDefaults;
import com.spss.java_client.ui.controlbar.ToolbarItem;
import com.spss.java_client.ui.controlbar.ToolbarObject;
import com.spss.java_client.ui.controlbar.UserTool;
import com.spss.java_client.ui.dialogs.base.view.res.ViewResBundle;
import com.spss.java_client.ui.dialogs.base.view.toolbars.CreateNewToolDialog;
import com.spss.java_client.ui.dialogs.base.view.toolbars.EditToolbarPropertiesDlg;
import com.spss.java_client.ui.dialogs.base.view.toolbars.MenuItem;
import com.spss.java_client.ui.dialogs.base.view.toolbars.MenuItemList;
import com.spss.java_client.ui.dialogs.base.view.toolbars.MenuItemListDragAdapter;
import com.spss.java_client.ui.dialogs.base.view.toolbars.MenuUtil;
import com.spss.java_client.ui.dialogs.base.view.toolbars.ShowToolBarsDlg;
import com.spss.java_client.ui.dialogs.base.view.toolbars.ToolbarItemTransferable;
import com.spss.java_client.ui.dialogs.base.view.toolbars.ToolbarPreviewPanel;
import com.spss.java_client.ui.dialogs.base.view.toolbars.ToolbarPreviewPanelDragAdapter;
import com.spss.java_client.ui.dialogs.base.view.toolbars.ToolbarsTableModel;
import com.spss.java_client.ui.dialogs.base.view.toolbars.ToolsListCellRenderer;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class EditToolBarDlg
extends BaseDialog
implements ListSelectionListener,
MouseListener,
ActionListener,
ClipboardOwner,
FocusListener,
KeyListener {
    private static final String OPEN_IMAGE_KEY = "LAST_OPEN_IMGAE_DIR_KEY";
    private LinkedHashMap<String, List<MenuItem>> mActionCatToMenuItemMap;
    private JList mCategoriesList;
    private JButton mChangeImageButton;
    private LinkedHashMap<String, UserTool> mCurrentUserDefinedToolsMap;
    private boolean mDefiningNewToolbar;
    private ToolbarObject mEditableToolbarObject;
    private JButton mNewToolButton;
    private JButton mPropertiesButton;
    private JButton mRemoveToolButton;
    private JButton mResetClearToolbarButton;
    private JButton mContinueButton;
    private MenuItemList mToolsList;
    private JLabel mToolbarNameLabel;
    private ToolbarObject mToolbarObject;
    private ToolbarPreviewPanel mToolbarPanel;
    private long mUserNodeSuffix;
    private ToolbarPreviewPanelDragAdapter mTbPreviewPanelAdapter;
    private Set<String> mDeleteTools = new HashSet<String>();
    private String mUserDefinedToolCat;
    private WeakReference<DialogDataModel> mDialogDataModel;
    private DialogDataModel mOriginalDataModel;
    private Clipboard mClipboard;
    private JPanel mCmdPanel;
    private Set<String> mNewUserImages = new HashSet<String>();
    private Set<String> mDeletedUserImages = new HashSet<String>();

    public EditToolBarDlg(final ShowToolBarsDlg showToolBarsDlg, ToolbarObject toolbarObject, boolean bl) {
        super((BaseDialog)showToolBarsDlg, "", true, ResUtil.getBundle(ViewResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), ViewResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_EDIT_TOOLBAR_TITLE"));
        this.mDefiningNewToolbar = bl;
        ShowToolBarsDlg showToolBarsDlg2 = (ShowToolBarsDlg)((Object)this.getParent());
        this.mUserNodeSuffix = showToolBarsDlg2.getUserNodeSuffix();
        this.mCurrentUserDefinedToolsMap.putAll(showToolBarsDlg2.getUserTbItemList());
        this.prepareEditableObject(toolbarObject);
        this.setLocationRelativeTo(this.getParent());
        this.mDialogDataModel = new WeakReference<DialogDataModel>(showToolBarsDlg.getDialogDataModel());
        this.mOriginalDataModel = new DialogDataModel();
        this.mOriginalDataModel.copyFrom((DialogDataModel)this.mDialogDataModel.get());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseProcedureDialog.loadState(showToolBarsDlg.getDialogDataModel(), (Container)((Object)EditToolBarDlg.this), BaseProcedureDialog.NameLabelOption.no_override);
                EditToolBarDlg.this.updateContinueButton();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mPropertiesButton) {
            EditToolbarPropertiesDlg editToolbarPropertiesDlg = new EditToolbarPropertiesDlg(this, this.mEditableToolbarObject);
            editToolbarPropertiesDlg.setVisible(true);
            this.mToolbarNameLabel.setText(this.mEditableToolbarObject.getName());
        } else if (actionEvent.getSource() == this.mResetClearToolbarButton) {
            List<ToolbarItem> list = this.mToolbarPanel.getToolbarItems();
            for (ToolbarItem toolbarItem : list) {
                if (!toolbarItem.isUserDefinedImage()) continue;
                this.mDeletedUserImages.add(toolbarItem.getImageKey());
            }
            list.clear();
            if (!this.mEditableToolbarObject.isUserDefinedToolbar()) {
                list.addAll(new ToolbarDefaults().getDefaultToolbar(this.mEditableToolbarObject.getPreferencesNode()).getToolbarItems());
            }
            this.mToolbarPanel.freshLayout();
            this.mToolbarPanel.setSelectedComponentIndex(0);
            this.updateContinueButton();
        } else if (actionEvent.getSource() == this.mChangeImageButton) {
            this.showChangeImageDialog();
        }
    }

    public void addUserDefinedTool(UserTool userTool) {
        this.mCurrentUserDefinedToolsMap.put(userTool.getActionId(), userTool);
        List<MenuItem> list = this.mActionCatToMenuItemMap.get(this.mUserDefinedToolCat);
        list.add(new MenuItem(userTool.getActionId(), userTool.getName(), userTool.getImageKey(), true));
        if (!this.mCategoriesList.getSelectedValue().equals(this.mUserDefinedToolCat)) {
            this.mCategoriesList.setSelectedValue(this.mUserDefinedToolCat, true);
        } else {
            DefaultListModel defaultListModel = (DefaultListModel)this.mToolsList.getModel();
            defaultListModel.addElement(new MenuItem(userTool.getActionId(), userTool.getName(), userTool.getImageKey(), true));
        }
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_idd_customize_toolbar");
    }

    public Clipboard getClipboard() {
        return this.mClipboard;
    }

    public ToolbarPreviewPanelDragAdapter getPanelAdapter() {
        return this.mTbPreviewPanelAdapter;
    }

    public long getUserNodeSuffix() {
        return this.mUserNodeSuffix++;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (keyEvent.getKeyCode() == 525 || keyEvent.isShiftDown() && keyEvent.getKeyCode() == 121) {
            int n = this.mToolsList.getSelectedIndex();
            Rectangle rectangle = this.mToolsList.getCellBounds(n, n);
            int n2 = rectangle.x + 18;
            int n3 = rectangle.y;
            this.doToolsListContextMenu(n2, n3);
            keyEvent.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object e;
        if (mouseEvent.getSource() == this.mToolsList && mouseEvent.getClickCount() == 2 && (e = this.mToolsList.getSelectedValue()) instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)e;
            ToolbarItem toolbarItem = new ToolbarItem(menuItem.getActionId(), menuItem.isUserDefined(), menuItem.getImageKey(), false);
            if (menuItem.getActionId().equals("separator") || !this.mToolbarPanel.getToolbarItems().contains(toolbarItem)) {
                this.mToolbarPanel.addToolbarItem(toolbarItem);
            } else {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_TB_ITEM_ALREADY_EXISTS"), VersionInfo.getAppVersionString());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    public void updateChangeImageButton() {
        int n = this.mToolbarPanel.getSelectedComponentIndex();
        if (n > -1) {
            ToolbarItem toolbarItem = this.getToolbarPreviewPanel().getToolbarItems().get(n);
            this.mChangeImageButton.setEnabled(!toolbarItem.getActionId().equals("separator"));
        } else {
            this.mChangeImageButton.setEnabled(false);
        }
    }

    public void updateContinueButton() {
        this.mContinueButton.setEnabled(this.mToolbarPanel.getToolbarItems().size() > 0);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mToolsList && this.mToolsList.getSelectedIndex() < 0) {
            this.mToolsList.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.mCategoriesList.getSelectionModel()) {
            Object e = this.mCategoriesList.getSelectedValue();
            List<MenuItem> list = this.mActionCatToMenuItemMap.get(e.toString());
            DefaultListModel defaultListModel = (DefaultListModel)this.mToolsList.getModel();
            defaultListModel.removeAllElements();
            for (MenuItem menuItem : list) {
                defaultListModel.addElement(menuItem);
            }
            this.mToolsList.setSelectedIndex(0);
        } else if (listSelectionEvent.getSource() == this.mToolsList.getSelectionModel()) {
            this.mRemoveToolButton.setEnabled(this.mCategoriesList.getSelectedValue().equals(this.mUserDefinedToolCat) && this.mToolsList.getSelectedIndex() > 0);
        }
    }

    public DialogDataModel getDialogDataModel() {
        if (this.mDialogDataModel == null) {
            this.mDialogDataModel = new WeakReference<DialogDataModel>(new DialogDataModel());
        }
        return (DialogDataModel)this.mDialogDataModel.get();
    }

    public ToolbarPreviewPanel getToolbarPreviewPanel() {
        return this.mToolbarPanel;
    }

    public Set<String> getDeletedUserImagesSet() {
        return this.mDeletedUserImages;
    }

    protected void init() {
        this.initVars();
        super.init();
        this.setDefaults();
        this.setupViewPanel(this.getViewPanel());
        DragPane dragPane = new DragPane();
        MenuItemListDragAdapter menuItemListDragAdapter = new MenuItemListDragAdapter(this.mToolsList, dragPane, "List Adapter");
        this.mTbPreviewPanelAdapter = new ToolbarPreviewPanelDragAdapter(this.mToolbarPanel, dragPane, "panelAdapter", this);
        DialogUtil.modifyMouseInputListeners(this.mToolsList, menuItemListDragAdapter);
        dragPane.addDropListener((IDropListener)this.mToolbarPanel);
        this.setGlassPane((Component)dragPane);
        this.bindKeys();
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mCategoriesList);
        vector.add(this.mToolsList);
        vector.add(this.mNewToolButton);
        vector.add(this.mRemoveToolButton);
        vector.add(this.mToolbarPanel);
        vector.add(this.mChangeImageButton);
        vector.add(this.mResetClearToolbarButton);
        vector.add(this.mPropertiesButton);
        for (Component component : this.mCmdPanel.getComponents()) {
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
        this.pack();
    }

    protected JPanel setupCmdButtonPanel() {
        this.mCmdPanel = new JPanel(true);
        ContinueAction continueAction = new ContinueAction();
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.mContinueButton = new JButton(continueAction);
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        if (DialogUtil.areCommandButtonsBelow()) {
            this.mCmdPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                this.mCmdPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(this.mCmdPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(this.mCmdPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(this.mCmdPanel, this.mContinueButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                this.mCmdPanel.setLayout(flowLayout);
                this.mCmdPanel.add(this.mContinueButton);
                this.mCmdPanel.add(jButton);
                this.mCmdPanel.add(jButton2);
            }
        } else {
            this.mCmdPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(this.mCmdPanel, 1);
            this.mCmdPanel.setLayout(boxLayout);
            this.mCmdPanel.add(Box.createVerticalStrut(n * 2));
            this.mCmdPanel.add(this.mContinueButton);
            this.mCmdPanel.add(Box.createVerticalStrut(n));
            this.mCmdPanel.add(jButton);
            this.mCmdPanel.add(Box.createVerticalStrut(n));
            this.mCmdPanel.add(jButton2);
            this.mCmdPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mContinueButton);
        DialogUtil.createCmdButtonGroup(this.mCmdPanel);
        return this.mCmdPanel;
    }

    private void doToolsListContextMenu(int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem(new ToolsListCopyAction()));
        jPopupMenu.add(new JMenuItem(new ToolsListAddToToolbarAction()));
        jPopupMenu.show(this.mToolsList, n, n2);
    }

    private void doRemoveTool() {
        Object e = this.mToolsList.getSelectedValue();
        if (e != null) {
            MenuItem menuItem = (MenuItem)e;
            this.mActionCatToMenuItemMap.get(this.mUserDefinedToolCat).remove(menuItem);
            this.mCurrentUserDefinedToolsMap.remove(menuItem.getActionId());
            ((DefaultListModel)this.mToolsList.getModel()).removeElement(menuItem);
            this.mDeleteTools.add(menuItem.getActionId());
        }
    }

    private JPanel setupToolButtonPanel() {
        JPanel jPanel = new JPanel();
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = insets.top + insets.bottom;
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.mNewToolButton);
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(this.mRemoveToolButton);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private void initVars() {
        this.mClipboard = new Clipboard(this.getClass().getName());
        this.mUserDefinedToolCat = this.getResString("IDS_TB_USER_DEFINED_TOOL_CAT");
        this.mActionCatToMenuItemMap = MenuUtil.loadActionCategoryToMenuItemListMap(this);
        this.mActionCatToMenuItemMap.put(this.mUserDefinedToolCat, new ArrayList());
        Vector<String> vector = new Vector<String>();
        Set<String> set = this.mActionCatToMenuItemMap.keySet();
        for (String string : set) {
            vector.add(string);
        }
        this.mCurrentUserDefinedToolsMap = new LinkedHashMap();
        this.mCategoriesList = new JList(vector);
        this.mCategoriesList.setSelectionMode(0);
        this.mCategoriesList.getSelectionModel().addListSelectionListener(this);
        this.mToolsList = new MenuItemList(new DefaultListModel());
        this.mToolsList.setSelectionMode(0);
        this.mToolsList.setCellRenderer(new ToolsListCellRenderer());
        this.mToolsList.getSelectionModel().addListSelectionListener(this);
        this.mToolsList.addFocusListener(this);
        this.mToolsList.addMouseListener(this);
        this.mToolsList.addKeyListener(this);
        this.mNewToolButton = new JButton(new NewToolButtonAction());
        this.mRemoveToolButton = new JButton(new RemoveToolAction());
        this.mToolbarNameLabel = new JLabel("", 10);
        this.mToolbarPanel = new ToolbarPreviewPanel(this);
        this.mToolbarPanel.setLayout(new FlowLayout(0, 0, 0));
        this.mPropertiesButton = DialogUtil.createButton(this, "IDS_TB_PROPERTIES_BUTTON", this);
        this.mResetClearToolbarButton = DialogUtil.createButton(this, "IDS_TB_RESET_TOOLBAR_BUTTON", this);
        this.mChangeImageButton = DialogUtil.createButton(this, "IDS_TB_CHANGE_IMAGE_BUTTON", this);
    }

    private void prepareEditableObject(ToolbarObject toolbarObject) {
        this.mToolbarObject = toolbarObject;
        List<MenuItem> list = this.mActionCatToMenuItemMap.get(this.mUserDefinedToolCat);
        Collection<UserTool> collection = this.mCurrentUserDefinedToolsMap.values();
        for (UserTool userTool : collection) {
            if (!userTool.isToolbarOnly()) continue;
            list.add(new MenuItem(userTool.getActionId(), userTool.getName(), userTool.getImageKey(), true));
        }
        Collections.sort(list, new UserTbItemComparator());
        list.add(0, new MenuItem("separator", ResUtil.getString("separator"), false));
        this.mEditableToolbarObject = new ToolbarObject();
        this.mEditableToolbarObject.getDocTypes().addAll(toolbarObject.getDocTypes());
        this.mEditableToolbarObject.setName(toolbarObject.getName());
        this.mEditableToolbarObject.setPreferencesNode(toolbarObject.getPreferencesNode());
        this.mToolbarPanel.getToolbarItems().addAll(toolbarObject.getToolbarItems());
        this.mEditableToolbarObject.setUserDefinedToolbar(toolbarObject.isUserDefinedToolbar());
        this.mEditableToolbarObject.setVisible(toolbarObject.isVisible());
        this.mToolbarNameLabel.setText(this.mEditableToolbarObject.getName());
        this.mToolbarPanel.freshLayout();
        if (toolbarObject.isUserDefinedToolbar()) {
            this.mResetClearToolbarButton.setAction(new ToggleButtonAction(this, "IDS_TB_CLEAR_TOOLBAR_BUTTON"));
        }
    }

    private void setDefaults() {
        this.mCategoriesList.setSelectedIndex(0);
        this.mChangeImageButton.setEnabled(false);
        this.mRemoveToolButton.setEnabled(false);
    }

    private JPanel setupCustomizingToolbarPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TB_CUSTOMIZE_TOOLBAR");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mToolbarNameLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupPropertiesClearToolbarPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 24;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mChangeImageButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mResetClearToolbarButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mPropertiesButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void setupViewPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TB_CATEGORIES_LABEL");
        jLabel.setLabelFor(this.mCategoriesList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_TB_TOOLS_LABEL");
        jLabel2.setLabelFor(this.mToolsList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        JScrollPane jScrollPane = new JScrollPane(this.mCategoriesList);
        jScrollPane.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight()));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        jScrollPane = new JScrollPane(this.mToolsList);
        jScrollPane.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight()));
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.setupToolButtonPanel(), gridBagConstraints, 2, 1, 1, 1, n, insets);
        Insets insets2 = new Insets(DialogUtil.getComponentGroupGap(), insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.setupCustomizingToolbarPanel(), gridBagConstraints, 0, 2, 2, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JScrollPane jScrollPane2 = new JScrollPane(this.mToolbarPanel);
        jScrollPane2.setHorizontalScrollBarPolicy(32);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setAutoscrolls(true);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 0, 3, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupPropertiesClearToolbarPanel(), gridBagConstraints, 0, 4, 2, 1, n, insets2);
    }

    private void showChangeImageDialog() {
        File file;
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, System.getProperty("application.home"), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(this.getResString("IDS_TB_OPEN_IMAGE_FILE"));
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_TB_BMP_FILE"), this.getResString("IDS_TB_BMP_FILE_EXTENSION"));
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.addChoosableFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_TB_PNG_FILE"), this.getResString("IDS_TB_PNG_FILE_EXTENSION")));
        remoteFileChooser.addChoosableFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_TB_GIF_FILE"), this.getResString("IDS_TB_GIF_FILE_EXTENSION")));
        remoteFileChooser.addChoosableFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_TB_JPEG_FILE"), this.getResString("IDS_TB_JPEG_FILE_EXTENSION"), ","));
        remoteFileChooser.setAcceptAllFileFilterUsed(true);
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        String string = this.getDialogDataModel().getString(OPEN_IMAGE_KEY);
        if (string != null && string.length() > 0 && (file = new File(string)).exists() && file.isDirectory()) {
            remoteFileChooser.setCurrentDirectory(file);
        }
        if (remoteFileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            file = remoteFileChooser.getSelectedFile();
            if (file.exists()) {
                this.getDialogDataModel().putString(OPEN_IMAGE_KEY, file.getParent());
                String string2 = System.getProperty("user.home.spss");
                File file2 = new File(string2 + File.separatorChar + "toolbar_images");
                if (!file2.exists() && !file2.mkdir()) {
                    ComponentState.trace1((String)("failed to create folder: " + file2.getPath()), (int)15);
                }
                String string3 = file.getName();
                int n = string3.lastIndexOf(".");
                String string4 = "";
                if (n > 0) {
                    string4 = string3.substring(n);
                    string3 = string3.substring(0, n);
                }
                File file3 = new File(file2.getAbsolutePath() + File.separatorChar + string3 + string4);
                int n2 = 1;
                while (file3.exists()) {
                    file3 = new File(file2.getAbsolutePath() + File.separatorChar + string3 + n2++ + string4);
                }
                try {
                    int n3;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    byte[] byArray = new byte[1024];
                    while ((n3 = ((InputStream)fileInputStream).read(byArray)) > 0) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n3);
                    }
                    ((InputStream)fileInputStream).close();
                    ((OutputStream)fileOutputStream).close();
                    ToolbarItem toolbarItem = this.mToolbarPanel.getToolbarItems().get(this.mToolbarPanel.getSelectedComponentIndex());
                    toolbarItem.setUserDefinedImage(true);
                    toolbarItem.setImageKey(file3.getName());
                    this.mNewUserImages.add(file3.getName());
                    int n4 = this.mToolbarPanel.getSelectedComponentIndex();
                    this.mToolbarPanel.freshLayout();
                    this.mToolbarPanel.setSelectedComponentIndex(n4);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ComponentState.trace1((String)fileNotFoundException.getMessage(), (int)15);
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_TB_FILE_DOES_NOT_EXIST_WARNING"), VersionInfo.getAppVersionString());
                }
                catch (IOException iOException) {
                    ComponentState.trace1((String)iOException.getMessage(), (int)15);
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_TB_FILE_ERROR_READING_FILE"), VersionInfo.getAppVersionString());
                }
            } else {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_TB_FILE_DOES_NOT_EXIST_WARNING"), VersionInfo.getAppVersionString());
            }
        }
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (mouseEvent.getSource() == this.mToolsList && mouseEvent.isPopupTrigger()) {
            int n = this.mToolsList.locationToIndex(mouseEvent.getPoint());
            if (n > -1) {
                this.mToolsList.setSelectedIndex(n);
            }
            this.doToolsListContextMenu(mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
        }
    }

    private void bindKeys() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(67, 128);
        InputMap inputMap = this.mToolsList.getInputMap(0);
        ActionMap actionMap = this.mToolsList.getActionMap();
        inputMap.put(keyStroke, "copyAction");
        actionMap.put("copyAction", new ToolsListCopyAction());
        this.mToolbarPanel.setFocusCycleRoot(true);
        this.mToolbarPanel.setFocusTraversalPolicyProvider(true);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.upFocusCycle(EditToolBarDlg.this.mToolbarPanel);
                EditToolBarDlg.this.mToolbarPanel.setFocusCycleRoot(false);
                if (EditToolBarDlg.this.mChangeImageButton.isEnabled()) {
                    EditToolBarDlg.this.mChangeImageButton.requestFocus();
                } else {
                    EditToolBarDlg.this.mResetClearToolbarButton.requestFocus();
                }
                EditToolBarDlg.this.mToolbarPanel.setFocusCycleRoot(true);
            }
        };
        this.mToolbarPanel.setFocusTraversalKeys(2, Collections.EMPTY_SET);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(9, 0);
        InputMap inputMap2 = this.mToolbarPanel.getInputMap(1);
        ActionMap actionMap2 = this.mToolbarPanel.getActionMap();
        inputMap2.put(keyStroke2, "myTabAction");
        actionMap2.put("myTabAction", abstractAction);
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.upFocusCycle(EditToolBarDlg.this.mToolbarPanel);
                EditToolBarDlg.this.mToolbarPanel.setFocusCycleRoot(false);
                if (EditToolBarDlg.this.mRemoveToolButton.isEnabled()) {
                    EditToolBarDlg.this.mRemoveToolButton.requestFocus();
                } else {
                    EditToolBarDlg.this.mNewToolButton.requestFocus();
                }
                EditToolBarDlg.this.mToolbarPanel.setFocusCycleRoot(true);
            }
        };
        this.mToolbarPanel.setFocusTraversalKeys(3, Collections.EMPTY_SET);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(9, 1);
        inputMap2 = this.mToolbarPanel.getInputMap(1);
        actionMap2 = this.mToolbarPanel.getActionMap();
        inputMap2.put(keyStroke3, "shiftTabAction");
        actionMap2.put("shiftTabAction", abstractAction);
        this.mToolbarPanel.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.mToolbarPanel.setFocusTraversalKeys(1, Collections.EMPTY_SET);
    }

    private class ToolsListAddToToolbarAction
    extends AbstractAction {
        public ToolsListAddToToolbarAction() {
            this.putValue("Name", EditToolBarDlg.this.getResString("IDS_TB_ADD_TO_TOOLBAR"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", EditToolBarDlg.this.getDlgAccessKey("IDK_TB_ADD_TO_TOOLBAR_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object e = EditToolBarDlg.this.mToolsList.getSelectedValue();
            if (e instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)e;
                ToolbarItem toolbarItem = new ToolbarItem(menuItem.getActionId(), menuItem.isUserDefined(), menuItem.getImageKey(), false);
                if (menuItem.getActionId().equals("separator") || !EditToolBarDlg.this.mToolbarPanel.getToolbarItems().contains(toolbarItem)) {
                    EditToolBarDlg.this.mToolbarPanel.addToolbarItem(toolbarItem);
                } else {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)EditToolBarDlg.this), EditToolBarDlg.this.getResString("ERR_TB_ITEM_ALREADY_EXISTS"), VersionInfo.getAppVersionString());
                }
            }
        }
    }

    private class ToolsListCopyAction
    extends AbstractAction {
        public ToolsListCopyAction() {
            this.putValue("Name", EditToolBarDlg.this.getResString("IDS_TB_COPY_TOOL"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", EditToolBarDlg.this.getDlgAccessKey("IDK_TB_COPY_TOOL_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object e = EditToolBarDlg.this.mToolsList.getSelectedValue();
            if (e != null && e instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)e;
                ToolbarItem toolbarItem = new ToolbarItem(menuItem.getActionId(), menuItem.isUserDefined(), menuItem.getImageKey(), false);
                ToolbarItemTransferable toolbarItemTransferable = new ToolbarItemTransferable(toolbarItem);
                EditToolBarDlg.this.mClipboard.setContents(toolbarItemTransferable, EditToolBarDlg.this);
            }
        }
    }

    private class RemoveToolAction
    extends AbstractAction {
        RemoveToolAction() {
            this.putValue("Name", EditToolBarDlg.this.getResString("IDS_TB_REMOVE_TOOL_BUTTON"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", EditToolBarDlg.this.getDlgAccessKey("IDK_TB_REMOVE_TOOL_BUTTON_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditToolBarDlg.this.doRemoveTool();
        }
    }

    private class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditToolBarDlg.this.mToolbarObject.setName(EditToolBarDlg.this.mEditableToolbarObject.getName());
            EditToolBarDlg.this.mToolbarObject.setToolbarItems(EditToolBarDlg.this.mToolbarPanel.getToolbarItems());
            EditToolBarDlg.this.mToolbarObject.setDocTypes(EditToolBarDlg.this.mEditableToolbarObject.getDocTypes());
            ShowToolBarsDlg showToolBarsDlg = (ShowToolBarsDlg)((Object)EditToolBarDlg.this.getParent());
            showToolBarsDlg.setUserNodeSuffix(EditToolBarDlg.this.mUserNodeSuffix);
            showToolBarsDlg.setUserTbItemsList(EditToolBarDlg.this.mCurrentUserDefinedToolsMap);
            showToolBarsDlg.addToolsToDelete(EditToolBarDlg.this.mDeleteTools);
            showToolBarsDlg.addNewUserImages(EditToolBarDlg.this.mNewUserImages);
            showToolBarsDlg.addDeletedUserImages(EditToolBarDlg.this.mDeletedUserImages);
            ToolbarsTableModel toolbarsTableModel = showToolBarsDlg.getToolbarTableModel();
            if (EditToolBarDlg.this.mDefiningNewToolbar) {
                toolbarsTableModel.add(EditToolBarDlg.this.mToolbarObject);
            }
            toolbarsTableModel.refresh();
            BaseProcedureDialog.saveState(EditToolBarDlg.this.getDialogDataModel(), (Container)((Object)EditToolBarDlg.this));
            EditToolBarDlg.this.dispose();
        }
    }

    private class NewToolButtonAction
    extends AbstractAction {
        NewToolButtonAction() {
            this.putValue("Name", EditToolBarDlg.this.getResString("IDS_TB_NEW_TOOL"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", EditToolBarDlg.this.getDlgAccessKey("IDK_TB_NEW_TOOL_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CreateNewToolDialog createNewToolDialog = new CreateNewToolDialog(EditToolBarDlg.this);
            createNewToolDialog.setVisible(true);
        }
    }

    private class UserTbItemComparator
    implements Comparator {
        private UserTbItemComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object != null && object2 != null && object instanceof MenuItem && object2 instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)object;
                MenuItem menuItem2 = (MenuItem)object2;
                int n = menuItem.getDisplayName().compareTo(menuItem2.getDisplayName());
                if (n != 0) {
                    return n;
                }
                return menuItem.getActionId().compareTo(menuItem2.getActionId());
            }
            return 0;
        }
    }

    private class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
            this.putValue("AcceleratorKey", 112);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditToolBarDlg.this.doHelp();
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EditToolBarDlg.this.mNewUserImages.size() > 0) {
                String string = System.getProperty("user.home.spss");
                for (String string2 : EditToolBarDlg.this.mNewUserImages) {
                    File file = new File(string + File.separatorChar + "toolbar_images" + File.separatorChar + string2);
                    if (!file.exists() || file.delete()) continue;
                    ComponentState.trace1((String)("failed to delete file: " + file.getPath()), (int)15);
                }
            }
            EditToolBarDlg.this.getDialogDataModel().copyFrom(EditToolBarDlg.this.mOriginalDataModel);
            EditToolBarDlg.this.dispose();
        }
    }
}

