/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.view.toolbars;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.script.engine.IScriptLanguage;
import com.spss.java_client.core.script.engine.IScriptLanguageMgr;
import com.spss.java_client.core.script.engine.ScriptLanguageMgr;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controlbar.UserTool;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.view.res.ViewResBundle;
import com.spss.java_client.ui.dialogs.base.view.toolbars.EditToolBarDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class CreateNewToolDialog
extends BaseDialog
implements ActionListener,
DocumentListener,
ItemListener {
    private JButton mContinueButton;
    private JRadioButton mApplicationRadio;
    private JRadioButton mSyntaxRadio;
    private JRadioButton mScriptRadio;
    private FileTextField mFilenameText;
    private JButton mBrowseButton;
    private ContextEnabledTextField mToolLabelText;
    private JComboBox mDataTypeCombo;
    private JLabel mSendDataLabel;
    private SpssButtonGroup mButtonGroup;
    private JComboBox mScriptLanguageCombo;
    private JLabel mScriptLanguageLabel;

    public CreateNewToolDialog(final EditToolBarDlg editToolBarDlg) {
        super((BaseDialog)editToolBarDlg, "", true, ResUtil.getBundle(ViewResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), ViewResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_TB_NEW_TOOL_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseProcedureDialog.loadState(editToolBarDlg.getDialogDataModel(), (Container)((Object)CreateNewToolDialog.this), BaseProcedureDialog.NameLabelOption.no_override);
            }
        });
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_idd_spss_newtool");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mBrowseButton) {
            this.showBrowseDialog();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mApplicationRadio) {
            this.mDataTypeCombo.setEnabled(this.mApplicationRadio.isSelected());
            this.mSendDataLabel.setEnabled(this.mApplicationRadio.isSelected());
        } else if (itemEvent.getSource() == this.mScriptRadio) {
            this.mScriptLanguageCombo.setEnabled(this.mScriptRadio.isSelected());
            this.mScriptLanguageLabel.setEnabled(this.mScriptRadio.isSelected());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.doTextEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.doTextEvent();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.doTextEvent();
    }

    protected void init() {
        this.initVars();
        super.init();
        this.setupViewPanel(this.getViewPanel());
        this.setDefaults();
        this.setTabTraversalOrder();
        this.pack();
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        this.mContinueButton = new JButton(new ContinueAction());
        jPanel.add(this.mContinueButton);
        Insets insets = DialogUtil.getStandardButtonInsets();
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        if (DialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mContinueButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mContinueButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mContinueButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mContinueButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void setDefaults() {
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        this.mScriptRadio.setEnabled(!vector.isEmpty());
        this.mContinueButton.setEnabled(false);
    }

    private void initVars() {
        this.mToolLabelText = new ContextEnabledTextField(15);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_TB_NEW_TOOL_APPPLICATION_RADIO");
        this.mApplicationRadio = new JRadioButton(toggleButtonAction);
        this.mDataTypeCombo = new JComboBox<String>(this.getResStringArray("IDS_TB_NEW_TOOL_DATA_TYPE_COMBO_ITEMS"));
        this.mSendDataLabel = DialogUtil.createLabel(this, "IDS_TB_NEW_TOOL_SEND_DATA_LABEL");
        this.mSendDataLabel.setLabelFor(this.mDataTypeCombo);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_TB_NEW_TOOL_SYNTAX_RADIO");
        this.mSyntaxRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_TB_NEW_TOOL_SCRIPT_RADIO");
        this.mScriptRadio = new JRadioButton(toggleButtonAction);
        this.mScriptRadio.addItemListener(this);
        this.mScriptLanguageCombo = new JComboBox();
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (!vector.isEmpty()) {
            for (IScriptLanguage iScriptLanguage : vector) {
                this.mScriptLanguageCombo.addItem(iScriptLanguage.getLanguageName());
            }
            this.mScriptLanguageCombo.setSelectedItem(iScriptLanguageMgr.getDefaultLanguage().getLanguageName());
        }
        this.mScriptLanguageLabel = DialogUtil.createLabel(this, "IDS_TB_NEW_TOOL_LANGUAGE_LABEL");
        this.mScriptLanguageLabel.setLabelFor(this.mScriptLanguageCombo);
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mApplicationRadio);
        this.mButtonGroup.add(this.mSyntaxRadio);
        this.mButtonGroup.add(this.mScriptRadio);
        this.mApplicationRadio.setSelected(true);
        this.mFilenameText = new FileTextField();
        this.mFilenameText.setColumns(15);
        this.mBrowseButton = DialogUtil.createButton(this, "IDS_TB_NEW_TOOL_BROWSE_BUTTON", this);
        this.mToolLabelText.getDocument().addDocumentListener(this);
        this.mFilenameText.getDocument().addDocumentListener(this);
        this.mApplicationRadio.addItemListener(this);
    }

    private void doTextEvent() {
        String string = this.mToolLabelText.getText();
        String string2 = this.mFilenameText.getText();
        this.mContinueButton.setEnabled(string != null && string.length() > 0 && string2 != null && string2.length() > 0);
    }

    private void showBrowseDialog() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, System.getProperty("application.home"), DataServerProxy.getDataProxy().isRemoteConnection());
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_TB_NEW_TOOL_APPLICATION_FILE"), this.getResString("IDS_TB_NEW_TOOL_APPLICATION_FILE_EXTENSION"));
        RefFileFilter refFileFilter2 = new RefFileFilter(this.getResString("IDS_TB_NEW_TOOL_SYNTAX_FILE"), this.getResString("IDS_TB_NEW_TOOL_SYNTAX_FILE_EXTENSION"));
        RefFileFilter refFileFilter3 = this.getScriptFilter();
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter2);
        if (refFileFilter3 != null) {
            remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter3);
        }
        remoteFileChooser.setAcceptAllFileFilterUsed(true);
        if (this.mApplicationRadio.isSelected()) {
            remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        } else if (this.mSyntaxRadio.isSelected()) {
            remoteFileChooser.setFileFilter((FileFilter)refFileFilter2);
        } else if (refFileFilter3 != null && this.mScriptRadio.isSelected()) {
            remoteFileChooser.setFileFilter((FileFilter)refFileFilter3);
        }
        if (remoteFileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            File file = remoteFileChooser.getSelectedFile();
            this.mFilenameText.setText("\"" + file.getAbsolutePath() + "\"");
            if (remoteFileChooser.getFileFilter() == refFileFilter2) {
                this.mSyntaxRadio.setSelected(true);
            } else if (remoteFileChooser.getFileFilter() == refFileFilter) {
                this.mApplicationRadio.setSelected(true);
            } else if (remoteFileChooser.getFileFilter() == refFileFilter3) {
                this.mScriptRadio.setSelected(true);
            }
        }
    }

    private RefFileFilter getScriptFilter() {
        RefFileFilter refFileFilter = null;
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (!vector.isEmpty()) {
            IScriptLanguage iScriptLanguage = iScriptLanguageMgr.getLanguageByName((String)this.mScriptLanguageCombo.getSelectedItem());
            Vector vector2 = iScriptLanguage.getFileExtensions();
            StringBuffer stringBuffer = new StringBuffer();
            if (vector2.size() != 0) {
                Iterator iterator = iScriptLanguage.getFileExtensions().iterator();
                stringBuffer.append((String)iterator.next());
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    assert (string != null && !string.equals(""));
                    stringBuffer.append(";");
                    stringBuffer.append(string);
                }
            }
            if (stringBuffer.length() > 0) {
                refFileFilter = new RefFileFilter(iScriptLanguage.getLanguageName() + " (" + stringBuffer.toString() + ")", stringBuffer.toString(), ";");
            }
        }
        return refFileFilter;
    }

    private JPanel setupActionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TB_NEW_TOOL_ACTION_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mApplicationRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(insets.top, n2 * 3, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.setupDataTypePanel(), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mSyntaxRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mScriptRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupScriptLanguagePanel(), gridBagConstraints, 0, 4, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupScriptLanguagePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mScriptLanguageLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mScriptLanguageCombo, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupDataTypePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mSendDataLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDataTypeCombo, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupDescriptionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TB_NEW_TOOL_DESCRIPTION_TITLE")));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TB_NEW_TOOL_LABEL_LABEL");
        jLabel.setLabelFor((Component)this.mToolLabelText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mToolLabelText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupFileNamePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TB_NEW_TOOL_FILENAME_LABEL");
        jLabel.setLabelFor((Component)((Object)this.mFilenameText));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 21;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFilenameText), gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setupViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.setupDescriptionPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupActionPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupFileNamePanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mToolLabelText);
        vector.add(this.mButtonGroup);
        vector.add(this.mDataTypeCombo);
        vector.add(this.mScriptLanguageCombo);
        vector.add(this.mFilenameText);
        vector.add(this.mBrowseButton);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditToolBarDlg editToolBarDlg = (EditToolBarDlg)((Object)CreateNewToolDialog.this.getParent());
            String string = this.removeDoubleQuotes(CreateNewToolDialog.this.mFilenameText.getText());
            if ((CreateNewToolDialog.this.mScriptRadio.isSelected() || CreateNewToolDialog.this.mSyntaxRadio.isSelected()) && !new File(string).exists()) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)CreateNewToolDialog.this), CreateNewToolDialog.this.getResString("ERR_TB_FILE_DOES_NOT_EXIST_WARNING"), VersionInfo.getAppVersionString());
                return;
            }
            UserTool userTool = new UserTool();
            userTool.setName(CreateNewToolDialog.this.mToolLabelText.getText());
            userTool.setActionId(userTool.getName() + "-" + editToolBarDlg.getUserNodeSuffix());
            if (CreateNewToolDialog.this.mApplicationRadio.isSelected()) {
                userTool.setLaunchType("application");
                switch (CreateNewToolDialog.this.mDataTypeCombo.getSelectedIndex()) {
                    case 0: {
                        userTool.setDataExportFormat("none");
                        break;
                    }
                    case 1: {
                        userTool.setDataExportFormat("spss_data_file");
                        break;
                    }
                    case 2: {
                        userTool.setDataExportFormat("xls_excel");
                        break;
                    }
                    case 3: {
                        userTool.setDataExportFormat("sylk");
                        break;
                    }
                    case 4: {
                        userTool.setDataExportFormat("lotus_123_release_3");
                        break;
                    }
                    case 5: {
                        userTool.setDataExportFormat("tab_delimited");
                        break;
                    }
                    case 6: {
                        userTool.setDataExportFormat("dbase_iv");
                    }
                }
                userTool.setImageKey("application");
            } else if (CreateNewToolDialog.this.mSyntaxRadio.isSelected()) {
                userTool.setLaunchType("syntax");
                userTool.setImageKey("syntax");
            } else if (CreateNewToolDialog.this.mScriptRadio.isSelected()) {
                userTool.setLaunchType("script");
                userTool.setImageKey("script");
            }
            userTool.setFileName(string);
            userTool.setToolbarOnly(true);
            editToolBarDlg.addUserDefinedTool(userTool);
            BaseProcedureDialog.saveState(((EditToolBarDlg)((Object)CreateNewToolDialog.this.getParent())).getDialogDataModel(), (Container)((Object)CreateNewToolDialog.this));
            CreateNewToolDialog.this.dispose();
        }

        private String removeDoubleQuotes(String string) {
            while (string.indexOf("\"") == 0) {
                string = string.replaceAll("\"", "");
            }
            while (string.indexOf("\"") == string.length() - 1) {
                string = string.replaceAll("\"", "");
            }
            return string;
        }
    }

    private class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
            this.putValue("AcceleratorKey", 112);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CreateNewToolDialog.this.doHelp();
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CreateNewToolDialog.this.dispose();
        }
    }
}

