/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.view.toolbars;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.view.res.ViewResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class BaseToolBarPropertiesDlg
extends BaseDialog
implements DocumentListener,
ItemListener {
    private static final Dimension WINDOW_PANEL_DIMENSION = new Dimension(263, 135);
    protected JButton mCancelButton;
    protected ContextEnabledTextField mToolBarNameText;
    protected JCheckBox mDataEditorCheck;
    protected JCheckBox mViewerCheck;
    protected JCheckBox mSyntaxCheck;
    protected DialogDataModel mDialogDataModel = new DialogDataModel();

    public BaseToolBarPropertiesDlg(BaseDialog baseDialog) {
        super(baseDialog, "", true, ResUtil.getBundle(ViewResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), ViewResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_TOOLBAR_PROPERTIES_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_idd_spss_tb_properties");
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.doTextEvent(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.doTextEvent(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.doTextEvent(documentEvent);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.doItemStateEvent(itemEvent);
    }

    DialogDataModel getDialogDataModel() {
        return this.mDialogDataModel;
    }

    protected void loadState(DialogDataModel dialogDataModel) {
        BaseProcedureDialog.loadState(this.getDialogDataModel(), (Container)((Object)this), BaseProcedureDialog.NameLabelOption.no_override);
    }

    protected boolean saveState(DialogDataModel dialogDataModel) {
        return BaseProcedureDialog.saveState(dialogDataModel, (Container)((Object)this));
    }

    protected boolean checkDialogOkCondition() {
        String string = this.mToolBarNameText.getText();
        return string != null && string.length() > 0 && (this.mDataEditorCheck.isSelected() || this.mViewerCheck.isSelected() || this.mSyntaxCheck.isSelected());
    }

    protected abstract void doItemStateEvent(ItemEvent var1);

    protected abstract void doTextEvent(DocumentEvent var1);

    protected void init() {
        this.initVars();
        super.init();
        this.setupViewPanel(this.getViewPanel());
        this.setDefaults();
        this.pack();
    }

    protected void initVars() {
        this.mToolBarNameText = new ContextEnabledTextField();
        this.mToolBarNameText.getDocument().addDocumentListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_TB_SHOW_TOOLTIPS");
        toggleButtonAction = new ToggleButtonAction(this, "IDS_TOOLBAR_DATA_EDITOR_CHECK");
        this.mDataEditorCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_TOOLBAR_VIEWER_CHECK");
        this.mViewerCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_TOOLBAR_SYNTAX_CHECK");
        this.mSyntaxCheck = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mDataEditorCheck);
        spssButtonGroup.add(this.mViewerCheck);
        spssButtonGroup.add(this.mSyntaxCheck);
        this.mDataEditorCheck.addItemListener(this);
        this.mViewerCheck.addItemListener(this);
        this.mSyntaxCheck.addItemListener(this);
    }

    protected void setDefaults() {
        this.mToolBarNameText.setText("");
    }

    private void setupViewPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TOOLBAR_NAME_LABEL");
        jLabel.setLabelFor((Component)this.mToolBarNameText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.setLayout(new GridBagLayout());
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mToolBarNameText, gridBagConstraints, 0, 1, 1, 1, n, insets);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n2, n2 * 2, insets.bottom, insets.right);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(this.getResString("IDS_TOOLBAR_WINDOW_PANEL")));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mDataEditorCheck, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel2, this.mViewerCheck, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel2, this.mSyntaxCheck, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        jPanel2.setPreferredSize(WINDOW_PANEL_DIMENSION);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseToolBarPropertiesDlg.this.dispose();
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
            this.putValue("AcceleratorKey", 112);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseToolBarPropertiesDlg.this.doHelp();
        }
    }
}

