/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.view.menu_editor;

import com.spss.java_client.ui.controlbar.UserTool;
import com.spss.shared.core_tools.system.OSInfo;
import javax.swing.tree.DefaultMutableTreeNode;

public class MenuTreeNode
extends DefaultMutableTreeNode {
    private String mName = "";
    private String mFileName = "";
    private String mMenuType = "System";
    private String mActionId = "";
    private int mMnemonic = 0;
    private String mDispName = "";
    private String mFileType = "";
    private String mDataType = "";
    private UserTool mUserTool;
    private String mScriptingLang = "";

    public MenuTreeNode(String string, String string2, boolean bl, String string3) {
        this.mName = string != null ? string : "";
        this.mFileName = string2;
        this.mMenuType = bl ? "User" : "System";
        this.mActionId = !string3.equals("") ? string3 : this.mName.replace(" ", "_");
    }

    public MenuTreeNode(String string, String string2) {
        this.mName = string != null ? string : "";
        this.mFileName = "";
        this.mMenuType = "System";
        this.mActionId = string2;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public void setFileName(String string) {
        this.mFileName = string;
    }

    public String getMenuName() {
        return this.mName;
    }

    public void setMenuName(String string) {
        this.mName = string != null ? string : "";
    }

    public String getMenuType() {
        return this.mMenuType;
    }

    public String getMenuItem() {
        if (this.mUserTool != null) {
            return this.mUserTool.getActionId() + ";";
        }
        if (this.mMenuType.equals("User")) {
            if (this.mActionId.equals("separator;")) {
                return this.mActionId;
            }
            return this.mName + ";" + this.mMnemonic + ";" + this.mFileName + ";" + this.mFileType;
        }
        return this.mActionId;
    }

    @Deprecated
    public void setMenuType(String string) {
        this.mMenuType = string;
    }

    public void setMnemonic(int n) {
        this.mMnemonic = n;
    }

    public int getMnemonic() {
        return this.mMnemonic;
    }

    public String getDisplayName() {
        String string = Character.toString((char)this.mMnemonic);
        int n = this.mName.indexOf(string);
        this.mDispName = n != -1 ? this.mName.substring(0, n) + "&" + this.mName.substring(n) : ((n = this.mName.indexOf(string = string.toLowerCase())) != -1 ? this.mName.substring(0, n) + "&" + this.mName.substring(n) : this.mName);
        return this.mDispName;
    }

    public void setDisplayName(String string) {
        this.mDispName = string != null ? string : "";
        if (this.mDispName.indexOf(38) != -1) {
            char c = this.mDispName.charAt(this.mDispName.indexOf(38) + 1);
            this.mMnemonic = Character.isDigit(c) ? c : Character.toUpperCase(c);
            this.mName = this.mDispName.replace("&", "");
        } else {
            this.mName = this.mDispName;
            this.mMnemonic = 0;
        }
        if (this.mUserTool != null) {
            this.mUserTool.setName(this.mName);
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.mUserTool.setMnemonicKey(this.mMnemonic);
            }
        }
    }

    public String getFileType() {
        return this.mFileType;
    }

    public void setFileType(String string) {
        this.mFileType = string;
    }

    public boolean isSyntaxType() {
        return this.mFileType != null && this.mFileType.equals("syntax");
    }

    public boolean isScriptType() {
        return this.mFileType != null && this.mFileType.equals("script");
    }

    @Deprecated
    public boolean isApplicationType() {
        return this.mFileType != null && this.mFileType.equals("application");
    }

    public void setDataType(String string) {
        this.mDataType = string;
    }

    public String getDataType() {
        return this.mDataType;
    }

    public UserTool getUserTool() {
        return this.mUserTool;
    }

    public void setUserTool(UserTool userTool) {
        this.mUserTool = userTool;
    }

    public void setScriptLangType(String string) {
        this.mScriptingLang = string;
    }

    public String getScriptLangType() {
        return this.mScriptingLang;
    }

    public boolean isSeparator() {
        return this.getMenuName().equals("separator");
    }

    public boolean isUserNode() {
        return this.getMenuType().equals("User");
    }
}

