/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.view.menu_editor;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.script.engine.IScriptLanguage;
import com.spss.java_client.core.script.engine.IScriptLanguageMgr;
import com.spss.java_client.core.script.engine.ScriptLanguageMgr;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controlbar.ToolbarObject;
import com.spss.java_client.ui.controlbar.ToolbarsUtil;
import com.spss.java_client.ui.controlbar.UserTool;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.view.menu_editor.MenuEditorUtil;
import com.spss.java_client.ui.dialogs.base.view.menu_editor.MenuTreeNode;
import com.spss.java_client.ui.dialogs.base.view.res.ViewResBundle;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.doc_util.FrameMenuBuildUtil;
import com.spss.java_client.ui.doc_types.doc_util.MenuCache;
import com.spss.java_client.ui.doc_types.doc_util.MenuItemCache;
import com.spss.java_client.ui.doc_types.doc_util.MenuItemPosComparator;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.CellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class MenuEditor
extends BaseDialog
implements MouseListener,
TreeSelectionListener,
ActionListener,
DocumentListener,
ItemListener {
    private static final String APPLICATION_RADIO = "IDS_APPLICATION";
    private static final String SYNTAX_RADIO = "IDS_SYNTAX";
    private static final String BROWSE_BUTTON = "IDS_BROWSE_BUTTON";
    private static final String NEW_MENU = "IDS_MENU_EDITOR_NEW_MENU";
    private static final String END_OF_MENU = "EndOfMenu";
    private JRadioButton mApplicationRadio;
    private JRadioButton mSyntaxRadio;
    private JRadioButton mScriptRadio;
    private JLabel mSendDataTypeLabel;
    private JComboBox mDataTypeCombo;
    private JLabel mFileNameLabel;
    private FileTextField mFileNameTextField;
    private JButton mBrowseButton;
    private JTree mMenuTree;
    private JButton mOkButton;
    private JButton mInsertItemButton;
    private JButton mInsertMenuButton;
    private JButton mInsertSeparatorButton;
    private JButton mDeleteButton;
    protected MenuCache mMenuTreeCache = new MenuCache(null);
    private MenuTreeModel mDataFrameModel;
    private MenuTreeModel mSyntaxFrameModel;
    private MenuTreeModel mViewerFrameModel;
    private JPopupMenu mPopupMenu;
    private JComboBox mApplyToCombo;
    private JMenuItem mCutItem;
    private JMenuItem mCopyItem;
    private JMenuItem mPasteItem;
    private JMenuItem mDeleteItem;
    private JMenuItem mRenameItem;
    private JMenuItem mUndoItem;
    private JMenuItem mSelectAllItem;
    private MenuTreeEditorUndoManager mUndoManager;
    private TextEditor mEditor;
    private Set<UserTool> mUpdatedNewUserTools;
    private List<UserTool> mDeletedUserTools;
    private SpssButtonGroup mRadioGroup;
    private Vector<SpssFrame> mFrames;
    private JComboBox mScriptLanguageCombo;
    private JLabel mScriptLanguageLabel;
    private int mLastMenu;

    public MenuEditor(SpssFrame spssFrame) {
        super((JFrame)spssFrame, true, ResUtil.getBundle(ViewResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), ViewResBundle.getImageFolder());
        Point point;
        this.setTitle(this.getResString("IDS_MENU_EDITOR_TITLE"));
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize("view_menu_editor");
        if (dimension != null) {
            this.setSize(dimension);
        }
        if ((point = ProcedureDlgMgr.getMgr().getDialogLocation("view_menu_editor")) != null) {
            this.setLocation(point);
        } else {
            this.setLocationRelativeTo(this.getParent());
        }
    }

    protected boolean canDispose() {
        return !this.mMenuTree.isEditing();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        UserTool userTool;
        MenuTreeNode menuTreeNode;
        if (itemEvent.getSource() == this.mApplicationRadio) {
            menuTreeNode = (MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent();
            if (menuTreeNode != null) {
                menuTreeNode.setFileType("application");
                userTool = menuTreeNode.getUserTool();
                if (userTool != null) {
                    userTool.setLaunchType("application");
                    this.mUpdatedNewUserTools.add(userTool);
                }
            }
            this.mSendDataTypeLabel.setEnabled(this.mApplicationRadio.isSelected());
            this.mDataTypeCombo.setEnabled(this.mApplicationRadio.isSelected());
        }
        if (itemEvent.getSource() == this.mSyntaxRadio) {
            menuTreeNode = (MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent();
            if (menuTreeNode != null) {
                menuTreeNode.setFileType("syntax");
                userTool = menuTreeNode.getUserTool();
                if (userTool != null) {
                    userTool.setLaunchType("syntax");
                    this.mUpdatedNewUserTools.add(userTool);
                }
            }
        } else if (this.mScriptRadio.isSelected()) {
            menuTreeNode = (MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent();
            if (menuTreeNode != null) {
                menuTreeNode.setFileType("script");
                userTool = menuTreeNode.getUserTool();
                if (userTool != null) {
                    userTool.setLaunchType("script");
                    this.mUpdatedNewUserTools.add(userTool);
                }
            }
            this.mScriptLanguageCombo.setEnabled(this.mScriptRadio.isSelected());
            this.mScriptLanguageLabel.setEnabled(this.mScriptRadio.isSelected());
        }
        if (itemEvent.getSource() == this.mDataTypeCombo && (menuTreeNode = (MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent()) != null) {
            if (this.mApplicationRadio.isSelected()) {
                menuTreeNode.setFileType("application");
                switch (this.mDataTypeCombo.getSelectedIndex()) {
                    case 0: {
                        menuTreeNode.setFileType("none");
                        break;
                    }
                    case 1: {
                        menuTreeNode.setFileType("spss_data_file");
                        break;
                    }
                    case 2: {
                        menuTreeNode.setFileType("xls_excel");
                        break;
                    }
                    case 3: {
                        menuTreeNode.setFileType("sylk");
                        break;
                    }
                    case 4: {
                        menuTreeNode.setFileType("lotus_123_release_3");
                        break;
                    }
                    case 5: {
                        menuTreeNode.setFileType("tab_delimited");
                        break;
                    }
                    case 6: {
                        menuTreeNode.setFileType("dbase_iv");
                    }
                }
            }
            if ((userTool = menuTreeNode.getUserTool()) != null) {
                userTool.setDataExportFormat(menuTreeNode.getFileType());
                this.mUpdatedNewUserTools.add(userTool);
            }
        }
        if (itemEvent.getSource() == this.mScriptLanguageCombo && (menuTreeNode = (MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent()) != null) {
            if (this.mScriptRadio.isSelected()) {
                menuTreeNode.setScriptLangType(this.mScriptLanguageCombo.getSelectedItem().toString());
            }
            if ((userTool = menuTreeNode.getUserTool()) != null) {
                userTool.setScriptLangType(menuTreeNode.getScriptLangType());
                this.mUpdatedNewUserTools.add(userTool);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.initPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.initPopup(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getSource() == null) {
            return;
        }
        MenuTreeNode menuTreeNode = (MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent();
        if (menuTreeNode == null) {
            return;
        }
        boolean bl = menuTreeNode.isUserNode();
        boolean bl2 = menuTreeNode.isSeparator();
        boolean bl3 = menuTreeNode.getChildCount() > 0;
        String string = menuTreeNode.getFileType();
        this.mInsertItemButton.setEnabled(menuTreeNode.getLevel() > 1);
        this.mInsertMenuButton.setEnabled(true);
        this.mInsertSeparatorButton.setEnabled(menuTreeNode.getLevel() > 1);
        this.mDeleteButton.setEnabled(bl);
        this.mFileNameTextField.setEnabled(bl && !bl2);
        if (this.mFileNameTextField.isEnabled()) {
            this.mFileNameTextField.setText(menuTreeNode.getFileName());
        }
        this.mFileNameLabel.setEnabled(bl && !bl2);
        this.mBrowseButton.setEnabled(bl && !bl2);
        this.mApplicationRadio.setEnabled(bl && !bl3);
        this.mSyntaxRadio.setEnabled(bl && !bl3);
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        this.mScriptRadio.setEnabled(bl && !bl3 && !vector.isEmpty());
        if (string != null && string.equals("syntax")) {
            this.mSyntaxRadio.setSelected(true);
        } else if (string != null && string.equals("script")) {
            this.mScriptRadio.setSelected(true);
            String string2 = menuTreeNode.getScriptLangType();
            if (string2 != null && !string2.equals("")) {
                this.mScriptLanguageCombo.setSelectedItem(string2);
            }
        } else {
            this.mApplicationRadio.setSelected(true);
            String string3 = menuTreeNode.getDataType();
            int n = 0;
            if (string3 != null && !string3.equals("")) {
                if (string3.equals("none")) {
                    n = 0;
                } else if (string3.equals("spss_data_file")) {
                    n = 1;
                } else if (string3.equals("xls_excel")) {
                    n = 2;
                } else if (string3.equals("sylk")) {
                    n = 3;
                } else if (string3.equals("lotus_123_release_3")) {
                    n = 4;
                } else if (string3.equals("tab_delimited")) {
                    n = 5;
                } else if (string3.equals("dbase_iv")) {
                    n = 6;
                }
            }
            this.mDataTypeCombo.setSelectedIndex(n);
        }
        this.mScriptLanguageCombo.setEnabled(this.mScriptRadio.isEnabled() && this.mScriptRadio.isSelected());
        this.mScriptLanguageLabel.setEnabled(this.mScriptRadio.isEnabled() && this.mScriptRadio.isSelected());
        this.mSendDataTypeLabel.setEnabled(this.mApplicationRadio.isEnabled() && this.mApplicationRadio.isSelected());
        this.mDataTypeCombo.setEnabled(this.mApplicationRadio.isEnabled() && this.mApplicationRadio.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        if (actionEvent.getSource() == this.mOkButton && this.isTreeValid()) {
            this.saveMenuToPreferences();
            ProcedureDlgMgr.getMgr().saveDialogSize("view_menu_editor", this.getSize());
            ProcedureDlgMgr.getMgr().saveDialogLocation("view_menu_editor", this.getLocation());
            this.dispose();
        }
        if (actionEvent.getSource() == this.mApplyToCombo) {
            serializable = null;
            if (!this.isTreeValid()) {
                this.mApplyToCombo.setSelectedIndex(this.mLastMenu);
            } else {
                this.mLastMenu = this.mApplyToCombo.getSelectedIndex();
                this.mMenuTree.clearSelection();
                this.mInsertMenuButton.setEnabled(false);
                this.mInsertItemButton.setEnabled(false);
                SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
                switch (this.mApplyToCombo.getSelectedIndex()) {
                    case 0: {
                        if (this.mDataFrameModel == null) {
                            for (SpssFrame spssFrame : spssFrameArray) {
                                if (spssFrame.docType() != DocType.DE_DOC) continue;
                                serializable = spssFrame;
                            }
                            if (serializable == null) {
                                serializable = SpssFrameMgr.getSpssFrameMgr().createFrame(DocType.DE_DOC, false);
                                if (this.mFrames == null) {
                                    this.mFrames = new Vector();
                                }
                                this.mFrames.addElement((SpssFrame)serializable);
                            }
                            try {
                                this.mMenuTreeCache = new MenuCache(null);
                                this.loadMenuCacheFromPreferences(this.mMenuTreeCache, ((SpssFrame)serializable).getFrameId());
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            this.mDataFrameModel = this.buildMenuTree();
                        }
                        this.mMenuTree.setModel(this.mDataFrameModel);
                        break;
                    }
                    case 1: {
                        if (this.mViewerFrameModel == null) {
                            for (SpssFrame spssFrame : spssFrameArray) {
                                if (spssFrame.docType() != DocType.OUTPUT_DOC) continue;
                                serializable = spssFrame;
                            }
                            if (serializable == null) {
                                serializable = SpssFrameMgr.getSpssFrameMgr().createFrame(DocType.OUTPUT_DOC, false);
                                if (this.mFrames == null) {
                                    this.mFrames = new Vector();
                                }
                                this.mFrames.addElement((SpssFrame)serializable);
                            }
                            try {
                                this.mMenuTreeCache = new MenuCache(null);
                                this.loadMenuCacheFromPreferences(this.mMenuTreeCache, ((SpssFrame)serializable).getFrameId());
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            this.mViewerFrameModel = this.buildMenuTree();
                        }
                        this.mMenuTree.setModel(this.mViewerFrameModel);
                        break;
                    }
                    case 2: {
                        if (this.mSyntaxFrameModel == null) {
                            for (SpssFrame spssFrame : spssFrameArray) {
                                if (spssFrame.docType() != DocType.SYNTAX_DOC) continue;
                                serializable = spssFrame;
                            }
                            if (serializable == null) {
                                serializable = SpssFrameMgr.getSpssFrameMgr().createFrame(DocType.SYNTAX_DOC, false);
                                if (this.mFrames == null) {
                                    this.mFrames = new Vector();
                                }
                                this.mFrames.addElement((SpssFrame)serializable);
                            }
                            try {
                                this.mMenuTreeCache = new MenuCache(null);
                                this.loadMenuCacheFromPreferences(this.mMenuTreeCache, ((SpssFrame)serializable).getFrameId());
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            this.mSyntaxFrameModel = this.buildMenuTree();
                        }
                        this.mMenuTree.setModel(this.mSyntaxFrameModel);
                    }
                }
            }
        }
        if (actionEvent.getSource() == this.mDataTypeCombo) {
            serializable = (MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent();
            switch (this.mDataTypeCombo.getSelectedIndex()) {
                case 0: {
                    ((MenuTreeNode)serializable).setDataType("none");
                    break;
                }
                case 1: {
                    ((MenuTreeNode)serializable).setDataType("spss_data_file");
                    break;
                }
                case 2: {
                    ((MenuTreeNode)serializable).setDataType("xls_excel");
                    break;
                }
                case 3: {
                    ((MenuTreeNode)serializable).setDataType("sylk");
                    break;
                }
                case 4: {
                    ((MenuTreeNode)serializable).setDataType("lotus_123_release_3");
                    break;
                }
                case 5: {
                    ((MenuTreeNode)serializable).setDataType("tab_delimited");
                    break;
                }
                case 6: {
                    ((MenuTreeNode)serializable).setDataType("dbase_iv");
                }
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mFileNameTextField.getText().length() >= 0) {
            String string = this.mFileNameTextField.getText();
            ((MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent()).setFileName(string);
            UserTool userTool = ((MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent()).getUserTool();
            if (userTool != null) {
                userTool.setFileName(string);
                this.mUpdatedNewUserTools.add(userTool);
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mFileNameTextField.getText().length() >= 0) {
            String string = this.mFileNameTextField.getText();
            ((MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent()).setFileName(string.replace("\"", ""));
            UserTool userTool = ((MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent()).getUserTool();
            if (userTool != null) {
                userTool.setFileName(string.replace("\"", ""));
                this.mUpdatedNewUserTools.add(userTool);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mFileNameTextField.getText().length() >= 0) {
            String string = this.mFileNameTextField.getText();
            ((MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent()).setFileName(string.replace("\"", ""));
            UserTool userTool = ((MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent()).getUserTool();
            if (userTool != null) {
                userTool.setFileName(string.replace("\"", ""));
                this.mUpdatedNewUserTools.add(userTool);
            }
        }
    }

    public static MenuTreeNode getClipboard() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (transferable != null && transferable.isDataFlavorSupported(TreeNodeTransfer.treeNodeFlavor)) {
                return (MenuTreeNode)transferable.getTransferData(TreeNodeTransfer.treeNodeFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void setClipboard(MenuTreeNode menuTreeNode) {
        TreeNodeTransfer treeNodeTransfer = new TreeNodeTransfer(menuTreeNode);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(treeNodeTransfer, null);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_idd_menu_editor");
    }

    protected void init() {
        super.init();
        UIToolDialogUtil.setLowerCommandButtons((boolean)false);
        JPanel jPanel = this.setupOptionsButtonPanel();
        JPanel jPanel2 = (JPanel)this.mViewPanel.getParent();
        if (jPanel != null) {
            jPanel2.add((Component)jPanel, "East");
        }
        UIToolDialogUtil.setLowerCommandButtons((boolean)true);
        this.initVars();
        JPanel jPanel3 = this.getViewPanel();
        JPanel jPanel4 = this.setupMenuPanel();
        JPanel jPanel5 = this.setupApplyToPanel();
        JPanel jPanel6 = this.setupFileTypePanel();
        JPanel jPanel7 = this.setupFileNamePanel();
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel7);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel3, jPanel4, gridBagConstraints, 0, 0, 1, 2, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel3, jPanel5, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets = new Insets(n2, 0, 0, 0);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel3, jPanel6, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel3, jPanel7, gridBagConstraints, 0, 2, 2, 1, n, insets);
        this.mUpdatedNewUserTools = new HashSet<UserTool>();
        this.mDeletedUserTools = new ArrayList<UserTool>();
        this.pack();
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.buildDefaultTreeModel();
        this.mMenuTree.setCellRenderer(new MenuTreeCellRenderer());
        this.mDataTypeCombo.addItemListener(this);
    }

    protected void initVars() {
        this.mPopupMenu = new JPopupMenu();
        this.mCutItem = new JMenuItem(this.getResString("IDS_POPUP_CUT_MENU"));
        this.mCopyItem = new JMenuItem(this.getResString("IDS_POPUP_COPY_MENU"));
        this.mPasteItem = new JMenuItem(this.getResString("IDS_POPUP_PASTE_MENU"));
        this.mDeleteItem = new JMenuItem(this.getResString("IDS_POPUP_DELETE_MENU"));
        this.mRenameItem = new JMenuItem(this.getResString("IDS_POPUP_RENAME_MENU"));
        this.mUndoItem = new JMenuItem(this.getResString("IDS_POPUP_UNDO_MENU"));
        this.mSelectAllItem = new JMenuItem(this.getResString("IDS_POPUP_SELECT_ALL_MENU"));
        this.mCutItem.addActionListener(new PopupMenuListener());
        this.mCopyItem.addActionListener(new PopupMenuListener());
        this.mPasteItem.addActionListener(new PopupMenuListener());
        this.mDeleteItem.addActionListener(new PopupMenuListener());
        this.mRenameItem.addActionListener(new PopupMenuListener());
        this.mUndoItem.addActionListener(new PopupMenuListener());
        this.mSelectAllItem.addActionListener(new PopupMenuListener());
        this.mPopupMenu.add(this.mUndoItem);
        this.mPopupMenu.addSeparator();
        this.mPopupMenu.add(this.mCutItem);
        this.mPopupMenu.add(this.mCopyItem);
        this.mPopupMenu.add(this.mPasteItem);
        this.mPopupMenu.add(this.mDeleteItem);
        this.mPopupMenu.add(this.mRenameItem);
        this.mPopupMenu.addSeparator();
        this.mPopupMenu.add(this.mSelectAllItem);
        this.mPopupMenu.getComponent(0).setVisible(false);
        this.mPopupMenu.getComponent(1).setVisible(false);
        this.mPopupMenu.getComponent(7).setVisible(false);
        this.mPopupMenu.getComponent(8).setVisible(false);
        this.mUndoManager = new MenuTreeEditorUndoManager();
        this.mEditor = new TextEditor(12);
        this.mEditor.addMouseListener(this);
        this.mEditor.getDocument().addUndoableEditListener(this.mUndoManager);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, APPLICATION_RADIO);
        this.mApplicationRadio = new JRadioButton(toggleButtonAction);
        this.mApplicationRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, SYNTAX_RADIO);
        this.mSyntaxRadio = new JRadioButton(toggleButtonAction);
        this.mSyntaxRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_SCRIPT");
        this.mScriptRadio = new JRadioButton(toggleButtonAction);
        this.mScriptRadio.addItemListener(this);
        this.mScriptLanguageCombo = new JComboBox();
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (!vector.isEmpty()) {
            for (IScriptLanguage iScriptLanguage : vector) {
                this.mScriptLanguageCombo.addItem(iScriptLanguage.getLanguageName());
            }
            this.mScriptLanguageCombo.setSelectedItem(iScriptLanguageMgr.getDefaultLanguage().getLanguageName());
        }
        this.mScriptLanguageCombo.addItemListener(this);
        this.mScriptLanguageLabel = DialogUtil.createLabel(this, "IDS_TB_NEW_TOOL_LANGUAGE_LABEL");
        this.mScriptLanguageLabel.setLabelFor(this.mScriptLanguageCombo);
        this.mSendDataTypeLabel = DialogUtil.createLabel(this, "IDS_SEND_DATA_TYPE_LABEL");
        this.mDataTypeCombo = new JComboBox<String>(this.getResStringArray("IDS_DATA_TYPE_COMBO_ITEMS"));
        this.mSendDataTypeLabel.setLabelFor(this.mDataTypeCombo);
        this.mRadioGroup = new SpssButtonGroup();
        this.mRadioGroup.add(this.mApplicationRadio);
        this.mRadioGroup.add(this.mSyntaxRadio);
        this.mRadioGroup.add(this.mScriptRadio);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.mOkButton = new JButton(this.getResString("IDS_OK"));
        this.mOkButton.addActionListener(this);
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            int n2 = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
            n2 = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(this.mOkButton);
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected JPanel setupOptionsButtonPanel() {
        Insets insets = DialogUtil.getStandardButtonInsets();
        JPanel jPanel = new JPanel(true);
        jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
        int n = insets.top + insets.bottom;
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        jPanel.add(Box.createVerticalStrut(n * 2));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_INSERT_ITEM"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuEditor.this.insertItem();
            }
        };
        this.mInsertItemButton = new JButton(toggleButtonAction);
        jPanel.add(this.mInsertItemButton);
        jPanel.add(Box.createVerticalStrut(n));
        toggleButtonAction = new ToggleButtonAction(this, "IDS_INSERT_MENU"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuEditor.this.insertMenu();
            }
        };
        this.mInsertMenuButton = new JButton(toggleButtonAction);
        jPanel.add(this.mInsertMenuButton);
        jPanel.add(Box.createVerticalStrut(n));
        toggleButtonAction = new ToggleButtonAction(this, "IDS_INSERT_SEPARATOR"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuEditor.this.insertSeparator();
            }
        };
        this.mInsertSeparatorButton = new JButton(toggleButtonAction);
        jPanel.add(this.mInsertSeparatorButton);
        jPanel.add(Box.createVerticalStrut(n));
        toggleButtonAction = new ToggleButtonAction(this, "IDS_DELETE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuEditor.this.deleteTreeNode();
            }
        };
        this.mDeleteButton = new JButton(toggleButtonAction);
        jPanel.add(this.mDeleteButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMenuTree);
        vector.add(this.mApplyToCombo);
        vector.add(this.mRadioGroup);
        vector.add(this.mDataTypeCombo);
        vector.add(this.mFileNameTextField);
        vector.add(this.mBrowseButton);
        vector.add(this.mInsertItemButton);
        vector.add(this.mInsertMenuButton);
        vector.add(this.mInsertSeparatorButton);
        vector.add(this.mDeleteButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.mCmdButtonPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupFileTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_FILE_TYPE_PANEL_BORDER")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, this.mApplicationRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top, n2 * 4, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSendDataTypeLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDataTypeCombo, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSyntaxRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mScriptRadio, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupScriptLanguagePanel(), gridBagConstraints, 0, 5, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupScriptLanguagePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mScriptLanguageLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mScriptLanguageCombo, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupFileNamePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.mFileNameLabel = DialogUtil.createLabel(this, "IDS_FILE_NAME_LABEL");
        this.mFileNameTextField = new FileTextField();
        this.mFileNameTextField.getDocument().addDocumentListener(this);
        this.mFileNameLabel.setLabelFor((Component)((Object)this.mFileNameTextField));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, BROWSE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuEditor.this.showOpenDialog();
            }
        };
        this.mBrowseButton = new JButton(toggleButtonAction);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mFileNameLabel, gridBagConstraints, 0, 0, 2, 1, n, null);
        Insets insets = new Insets(2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileNameTextField), gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        n = 24;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void initPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            boolean bl = this.mMenuTree.isEditing();
            if (bl) {
                int n = this.mEditor.getCaretPosition();
                try {
                    this.mPopupMenu.getComponent(0).setVisible(true);
                    this.mPopupMenu.getComponent(1).setVisible(true);
                    this.mPopupMenu.getComponent(6).setVisible(false);
                    this.mPopupMenu.getComponent(7).setVisible(true);
                    this.mPopupMenu.getComponent(8).setVisible(true);
                    this.mPasteItem.setEnabled(MenuEditor.isTextAvailable());
                    this.mPopupMenu.getComponent(0).setEnabled(this.mUndoManager.canUndo());
                    String string = this.mEditor.getSelectedText();
                    this.mCutItem.setEnabled(string != null);
                    this.mCopyItem.setEnabled(string != null);
                    this.mDeleteItem.setEnabled(string != null);
                    this.mSelectAllItem.setEnabled(string == null);
                    Rectangle rectangle = this.mEditor.modelToView(n);
                    this.mPopupMenu.show(this.mEditor, rectangle.x, rectangle.y);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            } else {
                int n = this.mMenuTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    this.mMenuTree.setSelectionRow(n);
                    MenuTreeNode menuTreeNode = (MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent();
                    boolean bl2 = menuTreeNode.getMenuType().equals("User");
                    boolean bl3 = menuTreeNode.isSeparator() && menuTreeNode.getUserTool() == null;
                    this.mCutItem.setEnabled(bl2);
                    this.mCopyItem.setEnabled(bl2);
                    this.mPasteItem.setEnabled(MenuEditor.isPasteAvailable());
                    this.mDeleteItem.setEnabled(bl2);
                    this.mRenameItem.setEnabled(bl2 && !bl3);
                    this.mPopupMenu.getComponent(0).setVisible(false);
                    this.mPopupMenu.getComponent(1).setVisible(false);
                    this.mPopupMenu.getComponent(6).setVisible(true);
                    this.mPopupMenu.getComponent(7).setVisible(false);
                    this.mPopupMenu.getComponent(8).setVisible(false);
                    this.mPopupMenu.show(this.mMenuTree, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    private static boolean isPasteAvailable() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        return transferable.isDataFlavorSupported(TreeNodeTransfer.treeNodeFlavor);
    }

    private static boolean isTextAvailable() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        return DataFlavor.selectBestTextFlavor(dataFlavorArray) != null;
    }

    private void insertItem() {
        MenuTreeNode menuTreeNode = (MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent();
        if (menuTreeNode == null) {
            return;
        }
        MenuTreeNode menuTreeNode2 = (MenuTreeNode)menuTreeNode.getParent();
        String string = this.getUniqueName(this.getResString("IDS_MENU_EDITOR_NEW_MENU_ITEM"), menuTreeNode2);
        MenuTreeNode menuTreeNode3 = new MenuTreeNode(string, "", true, "");
        int n = menuTreeNode.getParent().getIndex(menuTreeNode);
        ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(menuTreeNode3, (MutableTreeNode)menuTreeNode.getParent(), n);
        this.mMenuTree.requestFocus();
        Object[] objectArray = ((MenuTreeModel)this.mMenuTree.getModel()).getPathToRoot(menuTreeNode3);
        TreePath treePath = new TreePath(objectArray);
        this.mMenuTree.setSelectionPath(treePath);
        UserTool userTool = new UserTool();
        userTool.setName(menuTreeNode3.getMenuName());
        this.mUpdatedNewUserTools.add(userTool);
        menuTreeNode3.setUserTool(userTool);
        this.mMenuTree.startEditingAtPath(treePath);
        this.mEditor.setMenuTreeNode(menuTreeNode3);
        this.mEditor.setText(menuTreeNode3.getDisplayName());
        this.mEditor.requestFocus();
        this.mEditor.selectAll();
    }

    private void insertMenu() {
        MenuTreeNode menuTreeNode = (MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent();
        MenuTreeNode menuTreeNode2 = this.getNodeForMenu(menuTreeNode);
        int n = menuTreeNode.getParent().getIndex(menuTreeNode);
        ((MenuTreeModel)this.mMenuTree.getModel()).insertNodeInto(menuTreeNode2, (MutableTreeNode)menuTreeNode.getParent(), n);
        this.mMenuTree.requestFocus();
        TreePath treePath = new TreePath(menuTreeNode2.getPath());
        this.mMenuTree.setSelectionPath(treePath);
        this.mMenuTree.startEditingAtPath(treePath);
        this.mEditor.setMenuTreeNode(menuTreeNode2);
        this.mEditor.setText(menuTreeNode2.getDisplayName());
        this.mEditor.requestFocus();
        this.mEditor.selectAll();
    }

    private boolean validateMenuPath(String string) {
        boolean bl = true;
        if (string.indexOf(">") > 0) {
            bl = false;
        }
        return bl;
    }

    private String getUniqueName(String string, MenuTreeNode menuTreeNode) {
        String string2;
        if (this.findDuplicateNode(string, menuTreeNode) == null) {
            return string;
        }
        int n = 1;
        do {
            string2 = string + "_" + n;
            ++n;
        } while (this.findDuplicateNode(string2, menuTreeNode) != null);
        return string2;
    }

    private MenuTreeNode findDuplicateNode(String string, MenuTreeNode menuTreeNode) {
        for (int i = 0; i < menuTreeNode.getChildCount(); ++i) {
            MenuTreeNode menuTreeNode2 = (MenuTreeNode)menuTreeNode.getChildAt(i);
            if (!string.equals(menuTreeNode2.getMenuName())) continue;
            return menuTreeNode2;
        }
        return null;
    }

    private void insertSeparator() {
        MenuTreeNode menuTreeNode = (MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent();
        MenuTreeNode menuTreeNode2 = new MenuTreeNode("separator", "", true, "separator;");
        int n = menuTreeNode.getParent().getIndex(menuTreeNode);
        ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(menuTreeNode2, (MutableTreeNode)menuTreeNode.getParent(), n);
        this.mMenuTree.setSelectionPath(new TreePath(menuTreeNode2.getPath()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteTreeNode() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.mMenuTree.getModel();
        MenuTreeNode menuTreeNode = (MenuTreeNode)this.mMenuTree.getLastSelectedPathComponent();
        if (!menuTreeNode.getMenuType().equals("User")) {
            return;
        }
        MenuTreeNode menuTreeNode2 = (MenuTreeNode)menuTreeNode.getNextSibling();
        if (!menuTreeNode.getMenuName().equals("separator")) {
            boolean bl = this.showDeletePopUp(menuTreeNode);
            if (!bl) return;
            defaultTreeModel.removeNodeFromParent(menuTreeNode);
            this.deleteUserTool(menuTreeNode);
        } else {
            defaultTreeModel.removeNodeFromParent(menuTreeNode);
        }
        this.mMenuTree.setSelectionPath(new TreePath(menuTreeNode2.getPath()));
    }

    private void deleteUserTool(MenuTreeNode menuTreeNode) {
        UserTool userTool = menuTreeNode.getUserTool();
        if (userTool != null && userTool.getActionId() != null && userTool.getActionId().length() > 0) {
            this.mDeletedUserTools.add(userTool);
        }
        if (menuTreeNode.getChildCount() > 0) {
            for (int i = 0; i < menuTreeNode.getChildCount(); ++i) {
                this.deleteUserTool((MenuTreeNode)menuTreeNode.getChildAt(i));
            }
        }
    }

    private JPanel setupMenuPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MENU_LABEL");
        this.mMenuTree = new JTree(){

            @Override
            public boolean isPathEditable(TreePath treePath) {
                MenuTreeNode menuTreeNode = (MenuTreeNode)treePath.getLastPathComponent();
                boolean bl = menuTreeNode.getMenuType().equals("User");
                boolean bl2 = menuTreeNode.isSeparator() && menuTreeNode.getUserTool() == null;
                return bl && !bl2;
            }
        };
        this.mMenuTree.setRootVisible(false);
        this.mMenuTree.setShowsRootHandles(true);
        this.mMenuTree.setInvokesStopCellEditing(true);
        JScrollPane jScrollPane = new JScrollPane(this.mMenuTree);
        jScrollPane.setPreferredSize(new Dimension(230, 200));
        MenuTreeCellEditor menuTreeCellEditor = new MenuTreeCellEditor(this.mEditor);
        DefaultTreeCellEditor defaultTreeCellEditor = new DefaultTreeCellEditor(this.mMenuTree, null, menuTreeCellEditor);
        this.mMenuTree.setCellEditor(defaultTreeCellEditor);
        this.mMenuTree.expandRow(0);
        this.mMenuTree.addMouseListener(this);
        this.mMenuTree.addTreeSelectionListener(this);
        this.mMenuTree.setEditable(true);
        this.mMenuTree.getSelectionModel().setSelectionMode(1);
        this.mMenuTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                super.keyPressed(keyEvent);
                if (keyEvent.getKeyCode() == 127) {
                    MenuEditor.this.deleteTreeNode();
                }
            }
        });
        jLabel.setLabelFor(this.mMenuTree);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupApplyToPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_APPLY_TO_LABEL");
        this.mApplyToCombo = new JComboBox<String>(this.getResStringArray("IDS_APPLY_TO_COMBO_ITEMS"));
        this.mApplyToCombo.addActionListener(this);
        jLabel.setLabelFor(this.mApplyToCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mApplyToCombo, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private void setDefaults() {
        this.mApplicationRadio.setEnabled(false);
        this.mApplicationRadio.setSelected(true);
        this.mSyntaxRadio.setEnabled(false);
        this.mScriptRadio.setEnabled(false);
        this.mScriptLanguageCombo.setEnabled(false);
        this.mScriptLanguageLabel.setEnabled(false);
        this.mDataTypeCombo.setEnabled(false);
        this.mSendDataTypeLabel.setEnabled(false);
        this.mFileNameLabel.setEnabled(false);
        this.mFileNameTextField.setEnabled(false);
        this.mBrowseButton.setEnabled(false);
        this.mInsertMenuButton.setEnabled(true);
        this.mInsertItemButton.setEnabled(false);
        this.mInsertSeparatorButton.setEnabled(false);
        this.mDeleteButton.setEnabled(false);
    }

    private void buildDefaultTreeModel() {
        try {
            this.mMenuTreeCache = new MenuCache(null);
            this.loadMenuCacheFromPreferences(this.mMenuTreeCache, ((SpssFrame)this.getParent()).getFrameId());
            switch (((SpssFrame)this.getParent()).docType()) {
                case DE_DOC: {
                    this.mApplyToCombo.setSelectedIndex(0);
                    this.mLastMenu = 0;
                    break;
                }
                case OUTPUT_DOC: {
                    this.mApplyToCombo.setSelectedIndex(1);
                    this.mLastMenu = 1;
                    break;
                }
                case SYNTAX_DOC: {
                    this.mApplyToCombo.setSelectedIndex(2);
                    this.mLastMenu = 2;
                }
            }
            this.mMenuTree.expandRow(0);
            this.mMenuTree.setSelectionRow(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void showOpenDialog() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_APPLICATION_FILE"), this.getResString("IDS_APPLICATION_FILE_EXTENSION"));
        RefFileFilter refFileFilter2 = new RefFileFilter(this.getResString("IDS_SYNTAX_FILE"), this.getResString("IDS_SYNTAX_FILE_EXTENSION"));
        RefFileFilter refFileFilter3 = this.getScriptFilter();
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter2);
        remoteFileChooser.setAcceptAllFileFilterUsed(true);
        if (this.mApplicationRadio.isSelected()) {
            remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        } else if (this.mSyntaxRadio.isSelected()) {
            remoteFileChooser.setFileFilter((FileFilter)refFileFilter2);
        } else if (refFileFilter3 != null && this.mScriptRadio.isSelected()) {
            remoteFileChooser.setFileFilter((FileFilter)refFileFilter3);
        }
        int n = remoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string = remoteFileChooser.getSelectedFilePath();
            this.mFileNameTextField.setText("\"" + string + "\"");
            if (remoteFileChooser.getFileFilter() == refFileFilter2) {
                this.mSyntaxRadio.setSelected(true);
            } else if (remoteFileChooser.getFileFilter() == refFileFilter) {
                this.mApplicationRadio.setSelected(true);
            } else if (remoteFileChooser.getFileFilter() == refFileFilter3) {
                this.mScriptRadio.setSelected(true);
            }
        }
    }

    private RefFileFilter getScriptFilter() {
        RefFileFilter refFileFilter = null;
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (!vector.isEmpty()) {
            IScriptLanguage iScriptLanguage = iScriptLanguageMgr.getLanguageByName((String)this.mScriptLanguageCombo.getSelectedItem());
            Vector vector2 = iScriptLanguage.getFileExtensions();
            StringBuilder stringBuilder = new StringBuilder();
            if (vector2.size() != 0) {
                Iterator iterator = iScriptLanguage.getFileExtensions().iterator();
                stringBuilder.append((String)iterator.next());
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    assert (string != null && !string.equals(""));
                    stringBuilder.append(";");
                    stringBuilder.append(string);
                }
            }
            if (stringBuilder.length() > 0) {
                refFileFilter = new RefFileFilter(iScriptLanguage.getLanguageName() + " (" + stringBuilder.toString() + ")", stringBuilder.toString(), ";");
            }
        }
        return refFileFilter;
    }

    private MenuTreeModel buildMenuTree() {
        MenuTreeNode menuTreeNode;
        MenuTreeNode menuTreeNode2 = new MenuTreeNode("Root", null);
        MenuTreeModel menuTreeModel = new MenuTreeModel(menuTreeNode2);
        for (int i = 0; i < this.mMenuTreeCache.getItemCount(); ++i) {
            MenuItemCache menuItemCache = this.mMenuTreeCache.getItem(i);
            if (!menuItemCache.getItemId().equals("Window")) {
                String string = menuItemCache.getItemId();
                MenuEditorUtil menuEditorUtil = new MenuEditorUtil();
                menuEditorUtil.setMenuId(string);
                if (string.contains(";")) {
                    menuTreeNode = new MenuTreeNode(menuEditorUtil.getName(), menuEditorUtil.getFileName(), true, string);
                    if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                        menuTreeNode.setMnemonic(menuEditorUtil.getMnemonic());
                    }
                    menuTreeNode.setFileType(menuEditorUtil.getFileType());
                    menuTreeNode.setDataType(menuEditorUtil.getDataType());
                } else {
                    Integer n;
                    menuTreeNode = new MenuTreeNode(ResUtil.getString(menuEditorUtil.getName()), string);
                    if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n = ResUtil.getAccessKey(menuEditorUtil.getName())) != null) {
                        menuTreeNode.setMnemonic(n);
                    }
                }
                menuTreeNode2.add(menuTreeNode);
                this.buildSubMenuTree(menuItemCache, menuTreeNode);
                continue;
            }
            menuTreeModel.setWindowMenu(menuItemCache);
        }
        menuTreeNode = new MenuTreeNode(String.format(ComponentState.getSPSSLocale(), this.getResString("IDS_MENU_EDITOR_END_OF_MENU"), ""), END_OF_MENU);
        menuTreeNode2.add(menuTreeNode);
        return menuTreeModel;
    }

    private int buildSubMenuTree(MenuItemCache menuItemCache, MenuTreeNode menuTreeNode) {
        int n = 0;
        if (menuItemCache instanceof MenuCache) {
            MenuTreeNode menuTreeNode2;
            for (int i = 0; i < menuItemCache.getItemCount(); ++i) {
                SpssAction spssAction;
                boolean bl;
                MenuItemCache menuItemCache2 = menuItemCache.getItem(i);
                String string = menuItemCache2.getItemId();
                MenuEditorUtil menuEditorUtil = new MenuEditorUtil();
                menuEditorUtil.setMenuId(string);
                if (string.contains(";")) {
                    int n2;
                    if (menuItemCache2.getItemId().equals("separator;")) {
                        menuTreeNode2 = new MenuTreeNode("separator", "", true, "separator;");
                        menuTreeNode.add(menuTreeNode2);
                        continue;
                    }
                    bl = false;
                    if (menuItemCache2 instanceof MenuCache) {
                        bl = true;
                    } else {
                        UserTool userTool = ToolbarsUtil.getUserDefinedTool(string.substring(0, string.lastIndexOf(";")));
                        if (userTool != null) {
                            menuTreeNode2 = new MenuTreeNode(userTool.getName(), userTool.getFileName(), true, string);
                            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                                menuTreeNode2.setMnemonic(userTool.getMnemonicKey());
                            }
                            menuTreeNode2.setFileType(userTool.getLaunchType());
                            menuTreeNode2.setDataType(userTool.getDataExportFormat());
                            menuTreeNode2.setScriptLangType(userTool.getScriptLangType());
                            menuTreeNode2.setUserTool(userTool);
                        } else {
                            menuTreeNode2 = new MenuTreeNode(menuEditorUtil.getName(), menuEditorUtil.getFileName(), true, string);
                            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                                menuTreeNode2.setMnemonic(menuEditorUtil.getMnemonic());
                            }
                            menuTreeNode2.setFileType(menuEditorUtil.getFileType());
                            menuTreeNode2.setDataType(menuEditorUtil.getDataType());
                        }
                        menuTreeNode.add(menuTreeNode2);
                        ++n;
                    }
                    if (!bl) continue;
                    menuTreeNode2 = new MenuTreeNode(menuEditorUtil.getName(), string);
                    if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                        menuTreeNode2.setMnemonic(ResUtil.getAccessKey(string) == null ? 0 : ResUtil.getAccessKey(string));
                    }
                    if ((n2 = this.buildSubMenuTree(menuItemCache2, menuTreeNode2)) <= 0 && (n2 != 0 || !string.equals("file_MRUD") && !string.equals("file_MRUF"))) continue;
                    menuTreeNode.add(menuTreeNode2);
                    ++n;
                    continue;
                }
                if (menuItemCache2.getItemId().equals("separator")) {
                    if (menuTreeNode.getChildCount() <= 0 || ((MenuTreeNode)menuTreeNode.getChildAt(menuTreeNode.getChildCount() - 1)).isSeparator()) continue;
                    menuTreeNode2 = new MenuTreeNode(string, string);
                    menuTreeNode.add(menuTreeNode2);
                    continue;
                }
                bl = false;
                boolean bl2 = false;
                if (menuItemCache2 instanceof MenuCache) {
                    bl = true;
                    bl2 = true;
                } else if (FrameMenuBuildUtil.isValidLicense(string) && (spssAction = ActionCatalog.getActionCatalog().getSpssAction(string)) != null && spssAction.showMenu()) {
                    bl = true;
                }
                if (!bl) continue;
                menuTreeNode2 = new MenuTreeNode(ResUtil.getString(string), string);
                if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                    menuTreeNode2.setMnemonic(ResUtil.getAccessKey(string) == null ? 0 : ResUtil.getAccessKey(string));
                }
                int n3 = this.buildSubMenuTree(menuItemCache2, menuTreeNode2);
                if (bl2 && n3 <= 0 && (n3 != 0 || !string.equals("file_MRUD") && !string.equals("file_MRUF"))) continue;
                menuTreeNode.add(menuTreeNode2);
                ++n;
            }
            String string = String.format(ComponentState.getSPSSLocale(), this.getResString("IDS_MENU_EDITOR_END_OF_MENU"), menuTreeNode.getDisplayName());
            menuTreeNode2 = new MenuTreeNode(string, END_OF_MENU);
            menuTreeNode.add(menuTreeNode2);
        }
        return n;
    }

    private boolean isTreeValid() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mMenuTree.getModel().getRoot();
        if (!(defaultMutableTreeNode instanceof MenuTreeNode)) {
            return true;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            MenuTreeNode menuTreeNode = (MenuTreeNode)enumeration.nextElement();
            if (menuTreeNode.isUserNode() && !menuTreeNode.isSeparator() && menuTreeNode.isLeaf()) {
                if (menuTreeNode.getFileName() == null || menuTreeNode.getFileName().equals("")) {
                    serializable = new TreePath(menuTreeNode.getPath());
                    this.mMenuTree.setSelectionPath((TreePath)serializable);
                    this.mMenuTree.scrollPathToVisible((TreePath)serializable);
                    this.mFileNameTextField.requestFocus();
                    this.showMessage(this.formatInValidFileMessage(menuTreeNode.getMenuName()));
                    return false;
                }
                if ((menuTreeNode.isSyntaxType() || menuTreeNode.isScriptType()) && !((File)(serializable = new File(this.mFileNameTextField.getText().replaceAll("\"", "")))).exists()) {
                    this.mMenuTree.setSelectionPath(new TreePath(menuTreeNode.getPath()));
                    this.mFileNameTextField.requestFocus();
                    this.showMessage(this.getResString("ERR_FILE_NAME_DOESNOT_EXIST_MESSAGE"));
                    return false;
                }
            }
            if (this.validateMenuPath(menuTreeNode.getDisplayName())) continue;
            this.showMessage(this.getResString("ERR_BAD_MENU_TITLE"));
            this.mMenuTree.requestFocus();
            serializable = new TreePath(menuTreeNode.getPath());
            this.mMenuTree.scrollPathToVisible((TreePath)serializable);
            this.mMenuTree.setSelectionPath((TreePath)serializable);
            return false;
        }
        return true;
    }

    private boolean isAcceleratorDuplicate(MenuTreeNode menuTreeNode) {
        if (!menuTreeNode.getMenuType().equals("User") || menuTreeNode.getMnemonic() == 0) {
            return false;
        }
        MenuTreeNode menuTreeNode2 = (MenuTreeNode)menuTreeNode.getParent();
        for (int i = 0; i < menuTreeNode2.getChildCount(); ++i) {
            MenuTreeNode menuTreeNode3 = (MenuTreeNode)menuTreeNode2.getChildAt(i);
            if (menuTreeNode.equals(menuTreeNode3) || menuTreeNode.getMnemonic() != menuTreeNode3.getMnemonic()) continue;
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MENU_EDITOR_ACCELERATOR_DUPLICATE_MESSAGE"), this.getResString("IDS_MENU_EDITOR_ACCELERATOR_DUPLICATE_DIALOG_TITLE"));
            return true;
        }
        return false;
    }

    private void saveMenuToPreferences() {
        try {
            MenuCache menuCache;
            this.saveUserTools();
            Object object = null;
            SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
            if (this.mDataFrameModel != null) {
                menuCache = this.createMenuCache(this.mDataFrameModel);
                for (SpssFrame object2 : spssFrameArray) {
                    if (object2.docType() != DocType.DE_DOC) continue;
                    object = object2;
                }
                if (object == null && this.mFrames != null) {
                    for (SpssFrame spssFrame : this.mFrames) {
                        if (spssFrame.docType() != DocType.DE_DOC) continue;
                        object = spssFrame;
                    }
                }
                ((SpssFrame)object).setMenuTreeCache(menuCache);
            }
            if (this.mSyntaxFrameModel != null) {
                menuCache = this.createMenuCache(this.mSyntaxFrameModel);
                for (SpssFrame spssFrame : spssFrameArray) {
                    if (spssFrame.docType() != DocType.SYNTAX_DOC) continue;
                    object = spssFrame;
                }
                if (object == null && this.mFrames != null) {
                    for (SpssFrame spssFrame : this.mFrames) {
                        if (spssFrame.docType() != DocType.SYNTAX_DOC) continue;
                        object = spssFrame;
                    }
                }
                ((SpssFrame)object).setMenuTreeCache(menuCache);
            }
            if (this.mViewerFrameModel != null) {
                menuCache = this.createMenuCache(this.mViewerFrameModel);
                for (SpssFrame spssFrame : spssFrameArray) {
                    if (spssFrame.docType() != DocType.OUTPUT_DOC) continue;
                    object = spssFrame;
                }
                if (object == null && this.mFrames != null) {
                    for (SpssFrame spssFrame : this.mFrames) {
                        if (spssFrame.docType() != DocType.OUTPUT_DOC) continue;
                        object = spssFrame;
                    }
                }
                ((SpssFrame)object).setMenuTreeCache(menuCache);
            }
            if (this.mDeletedUserTools.size() > 0 || this.mUpdatedNewUserTools.size() > 0) {
                this.refreshToolbarPanel();
            }
            if (this.mFrames != null) {
                for (SpssFrame spssFrame : this.mFrames) {
                    SpssFrameMgr.getSpssFrameMgr().removeDocument(spssFrame);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void refreshToolbarPanel() {
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        List<ToolbarObject> list = ToolbarsUtil.loadToolBarsFromPrefs();
        for (SpssFrame spssFrame : spssFrameArray) {
            spssFrame.setToolbarPrefCache(list);
            spssFrame.refreshToolbar();
        }
    }

    private void saveUserTools() {
        this.mUpdatedNewUserTools.removeAll(this.mDeletedUserTools);
        ToolbarsUtil.deleteUserTools(this.mDeletedUserTools);
        long l = ToolbarsUtil.getUserToolNodeSuffx();
        for (UserTool userTool : this.mUpdatedNewUserTools) {
            String string = userTool.getActionId();
            if (string != null && string.length() != 0) continue;
            userTool.setActionId(userTool.getName() + "-" + l++);
        }
        ToolbarsUtil.saveUserDefinedToolsMapMenuEditorToPrefs(this.mUpdatedNewUserTools, l);
    }

    private MenuCache createMenuCache(MenuTreeModel menuTreeModel) {
        MenuCache menuCache = new MenuCache(null);
        MenuTreeNode menuTreeNode = (MenuTreeNode)menuTreeModel.getRoot();
        for (int i = 0; i < menuTreeNode.getChildCount(); ++i) {
            this.loadMenuPreferencesToCache(menuCache, (MenuTreeNode)menuTreeNode.getChildAt(i));
            if (i != menuTreeNode.getChildCount() - 2) continue;
            menuCache.insertAfter(menuTreeModel.getWindowMenu(), menuCache.getItem(i - 1).getItemId());
        }
        return menuCache;
    }

    private void loadMenuPreferencesToCache(MenuItemCache menuItemCache, MenuTreeNode menuTreeNode) {
        String string = menuTreeNode.getMenuItem();
        if (!menuTreeNode.isLeaf() || string.equals("file_MRUD") || string.equals("file_MRUF")) {
            MenuItemCache menuItemCache2 = FrameMenuBuildUtil.loadAPrefToCache(menuItemCache, string, FrameMenuBuildUtil.ItemType.MENU);
            if (menuItemCache2 == null) {
                return;
            }
            ArrayList<MenuTreeNode> arrayList = new ArrayList<MenuTreeNode>();
            Enumeration<TreeNode> enumeration = menuTreeNode.children();
            while (enumeration.hasMoreElements()) {
                arrayList.add((MenuTreeNode)enumeration.nextElement());
            }
            for (MenuTreeNode menuTreeNode2 : arrayList) {
                this.loadMenuPreferencesToCache(menuItemCache2, menuTreeNode2);
            }
        } else if (menuTreeNode.isSeparator()) {
            if (menuTreeNode.getPreviousSibling() == null || !((MenuTreeNode)menuTreeNode.getPreviousSibling()).isSeparator()) {
                FrameMenuBuildUtil.loadAPrefToCache(menuItemCache, menuTreeNode.getMenuItem(), FrameMenuBuildUtil.ItemType.SEPARATOR);
            }
        } else if (!menuTreeNode.getMenuItem().equalsIgnoreCase(END_OF_MENU)) {
            FrameMenuBuildUtil.loadAPrefToCache(menuItemCache, menuTreeNode.getMenuItem(), FrameMenuBuildUtil.ItemType.MENUITEM);
        }
    }

    private String formatDeleteDialogMessage(String string, boolean bl) {
        if (bl) {
            return String.format(ComponentState.getSPSSLocale(), this.getResString("ERR_DELETE_MENU_MESSAGE_FORMAT"), string);
        }
        return String.format(ComponentState.getSPSSLocale(), this.getResString("ERR_DELETE_MENUITEM_MESSAGE_FORMAT"), string);
    }

    private String formatInValidFileMessage(String string) {
        return String.format(ComponentState.getSPSSLocale(), this.getResString("ERR_NO_FILENAME_SPECIFIED_MESSAGE"), string);
    }

    private boolean showDeletePopUp(MenuTreeNode menuTreeNode) {
        String string = menuTreeNode.getChildCount() >= 1 ? this.formatDeleteDialogMessage(menuTreeNode.getMenuName(), true) : this.formatDeleteDialogMessage(menuTreeNode.getMenuName(), false);
        int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
        return n == 1;
    }

    private void showMessage(String string) {
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
    }

    private MenuTreeNode getNodeForMenu(MenuTreeNode menuTreeNode) {
        MenuTreeNode menuTreeNode2 = (MenuTreeNode)menuTreeNode.getParent();
        String string = this.getUniqueName(this.getResString(NEW_MENU), menuTreeNode2);
        MenuTreeNode menuTreeNode3 = new MenuTreeNode(string, "", true, "");
        MenuTreeNode menuTreeNode4 = new MenuTreeNode(String.format(ComponentState.getSPSSLocale(), this.getResString("IDS_MENU_EDITOR_END_OF_MENU"), menuTreeNode3.getDisplayName()), END_OF_MENU);
        menuTreeNode3.add(menuTreeNode4);
        return menuTreeNode3;
    }

    private void loadMenuCacheFromPreferences(MenuItemCache menuItemCache, String string) throws BackingStoreException {
        String string2 = "doc_types/" + string;
        String string3 = string2 + "/" + "menus";
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node(string3);
        String[] stringArray = preferences2.childrenNames();
        Arrays.sort(stringArray, 0, stringArray.length, MenuItemPosComparator.ASCENDING);
        if (menuItemCache.getItemCount() == 0) {
            for (String string4 : stringArray) {
                FrameMenuBuildUtil.loadMenuPreferencesToCache(menuItemCache, preferences2, string4);
            }
        }
    }

    class MenuTreeCellEditor
    implements TreeCellEditor {
        TextEditor leafEditor;
        CellEditor currentEditor;

        public MenuTreeCellEditor(TextEditor textEditor) {
            this.leafEditor = textEditor;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            this.currentEditor = this.leafEditor;
            this.leafEditor.setText(this.leafEditor.getText());
            this.leafEditor.selectAll();
            return (Component)((Object)this.currentEditor);
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentEditor.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return this.currentEditor.shouldSelectCell(eventObject);
        }

        @Override
        public boolean stopCellEditing() {
            return this.currentEditor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.currentEditor.cancelCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.leafEditor.addCellEditorListener(cellEditorListener);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.leafEditor.removeCellEditorListener(cellEditorListener);
        }
    }

    class TextEditor
    extends JTextField
    implements CellEditor {
        MenuTreeNode node;
        Vector<CellEditorListener> listeners;

        public void setMenuTreeNode(MenuTreeNode menuTreeNode) {
            this.node = menuTreeNode;
        }

        public TextEditor(int n) {
            this("", n);
        }

        public TextEditor(String string, int n) {
            super(string, n);
            this.listeners = new Vector();
            if (ComponentState.isBtdRtlOrLtr() && this.getDocument() != null) {
                if (ComponentState.getBTD() == 1) {
                    this.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                } else {
                    this.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                }
            }
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (TextEditor.this.stopCellEditing()) {
                        TextEditor.this.fireEditingStopped();
                    }
                }
            });
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (TextEditor.this.stopCellEditing()) {
                        TextEditor.this.fireEditingStopped();
                    }
                }
            });
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public String getText() {
            String string = super.getText();
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                return ComponentState.removeBidiDirectionMarks((String)string);
            }
            return string;
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }

        @Override
        public boolean stopCellEditing() {
            String string = this.getCellEditorValue().toString();
            MenuTreeNode menuTreeNode = MenuEditor.this.findDuplicateNode(string, (MenuTreeNode)this.node.getParent());
            if (menuTreeNode != null && menuTreeNode != this.node) {
                MenuEditor.this.showMessage(MenuEditor.this.getResString("ERR_NAME_CONFLICT_MESSAGE"));
                return false;
            }
            this.node.setDisplayName(this.getCellEditorValue().toString());
            if (MenuEditor.this.isAcceleratorDuplicate(this.node)) {
                this.node.setMnemonic(0);
                return true;
            }
            MenuTreeNode menuTreeNode2 = (MenuTreeNode)MenuEditor.this.mMenuTree.getLastSelectedPathComponent();
            MenuEditor.this.mInsertItemButton.setEnabled(menuTreeNode2.getLevel() > 1);
            if (this.node.getChildCount() > 0) {
                MenuTreeNode menuTreeNode3 = (MenuTreeNode)this.node.getLastChild();
                menuTreeNode3.setDisplayName(String.format(ComponentState.getSPSSLocale(), MenuEditor.this.getResString("IDS_MENU_EDITOR_END_OF_MENU"), this.node.getDisplayName()));
            }
            return true;
        }

        @Override
        public void cancelCellEditing() {
            String string = this.node.getMenuName();
            this.setText(string);
        }

        @Override
        public Object getCellEditorValue() {
            return this.getText();
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.addElement(cellEditorListener);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.removeElement(cellEditorListener);
        }

        protected void fireEditingStopped() {
            if (this.listeners.size() > 0) {
                ChangeEvent changeEvent = new ChangeEvent(this);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    this.listeners.elementAt(i).editingStopped(changeEvent);
                }
            }
        }
    }

    class ExpandableEdit
    extends CompoundEdit {
        private boolean done = false;

        ExpandableEdit() {
        }

        public void setFull(boolean bl) {
            this.done = bl;
        }

        public boolean isFull() {
            return this.done;
        }

        @Override
        public boolean isInProgress() {
            return false;
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            return !this.isFull() && super.addEdit(undoableEdit);
        }

        @Override
        public UndoableEdit lastEdit() {
            return super.lastEdit();
        }
    }

    class MenuTreeEditorUndoManager
    extends UndoManager {
        private static final int OTHER = 0;
        private static final int SINGLEADD = 1;
        private static final int SINGLEDELETE = 2;
        private Document lastDocument = null;
        private int lastTextOffset = 0;
        private int lastEditType = 0;

        MenuTreeEditorUndoManager() {
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            CompoundEdit compoundEdit;
            ExpandableEdit expandableEdit = (ExpandableEdit)this.lastEdit();
            if (undoableEdit instanceof AbstractDocument.DefaultDocumentEvent) {
                compoundEdit = (AbstractDocument.DefaultDocumentEvent)undoableEdit;
                boolean bl = this.lastDocument != ((AbstractDocument.DefaultDocumentEvent)compoundEdit).getDocument();
                this.lastDocument = ((AbstractDocument.DefaultDocumentEvent)compoundEdit).getDocument();
                int n = ((AbstractDocument.DefaultDocumentEvent)compoundEdit).getOffset();
                int n2 = n - this.lastTextOffset;
                int n3 = ((AbstractDocument.DefaultDocumentEvent)compoundEdit).getLength();
                int n4 = 0;
                if (n3 == 1) {
                    if (((AbstractDocument.DefaultDocumentEvent)compoundEdit).getType() == DocumentEvent.EventType.INSERT) {
                        n4 = 1;
                    }
                    if (((AbstractDocument.DefaultDocumentEvent)compoundEdit).getType() == DocumentEvent.EventType.REMOVE) {
                        n4 = 2;
                    }
                }
                boolean bl2 = false;
                if (!bl && this.lastEditType != 0 && this.lastEditType == n4) {
                    if (n4 == 1 && n2 == 1) {
                        bl2 = true;
                    }
                    if (n4 == 2 && (n2 == -1 || n2 == 0)) {
                        bl2 = true;
                    }
                }
                this.lastTextOffset = n;
                this.lastEditType = n4;
                if (bl2) {
                    expandableEdit.addEdit(undoableEdit);
                    return true;
                }
            } else {
                this.lastDocument = null;
            }
            if (expandableEdit != null) {
                expandableEdit.setFull(true);
            }
            compoundEdit = new ExpandableEdit();
            ((ExpandableEdit)compoundEdit).addEdit(undoableEdit);
            return super.addEdit(compoundEdit);
        }
    }

    class MenuTreeCellRenderer
    extends DefaultTreeCellRenderer {
        JLabel mLabel;
        String mValue = "";

        MenuTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.mLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            MenuTreeNode menuTreeNode = (MenuTreeNode)object;
            this.mValue = menuTreeNode.getDisplayName();
            if (ComponentState.isBtdRtlOrLtr() && this.mValue != null && this.mValue.length() > 0) {
                this.mValue = ComponentState.removeBidiDirectionMarks((String)this.mValue);
            }
            if (this.mValue != null && this.mValue.equals("separator") && menuTreeNode.getUserTool() == null) {
                this.mLabel.setText("---");
            } else if (ComponentState.isBtdRtlOrLtr() && this.mValue != null && this.mValue.length() > 0) {
                this.mLabel.setText(ComponentState.prepareStringForBidiRendering((String)this.mValue));
            } else {
                this.mLabel.setText(this.mValue);
            }
            if (menuTreeNode.getMenuType().equals("User")) {
                this.mLabel.setFont(this.mLabel.getFont().deriveFont(1));
            } else {
                this.mLabel.setFont(this.mLabel.getFont().deriveFont(0));
            }
            this.mLabel.setIcon(this.getDisabledIcon());
            return this.mLabel;
        }
    }

    static class TreeNodeTransfer
    implements Transferable {
        protected static DataFlavor treeNodeFlavor = new DataFlavor(MenuTreeNode.class, "Java Tree Node Flavor");
        MenuTreeNode node;

        public TreeNodeTransfer(MenuTreeNode menuTreeNode) {
            this.node = menuTreeNode;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{treeNodeFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return treeNodeFlavor.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!treeNodeFlavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.node;
        }
    }

    class MenuTreeModel
    extends DefaultTreeModel {
        MenuItemCache mWindowMenu;

        public MenuTreeModel(MenuTreeNode menuTreeNode) {
            super(menuTreeNode);
        }

        public void setWindowMenu(MenuItemCache menuItemCache) {
            this.mWindowMenu = menuItemCache;
        }

        public MenuItemCache getWindowMenu() {
            return this.mWindowMenu;
        }
    }

    class PopupMenuListener
    implements ActionListener {
        PopupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuTreeNode menuTreeNode;
            Object object;
            if (actionEvent.getSource() == MenuEditor.this.mCutItem) {
                if (MenuEditor.this.mMenuTree.isEditing()) {
                    MenuEditor.this.mEditor.cut();
                } else {
                    object = (MenuTreeNode)MenuEditor.this.mMenuTree.getLastSelectedPathComponent();
                    MenuEditor.setClipboard((MenuTreeNode)object);
                    MenuEditor.this.deleteTreeNode();
                }
            }
            if (actionEvent.getSource() == MenuEditor.this.mCopyItem) {
                if (MenuEditor.this.mMenuTree.isEditing()) {
                    MenuEditor.this.mEditor.copy();
                } else {
                    MenuEditor.setClipboard((MenuTreeNode)MenuEditor.this.mMenuTree.getLastSelectedPathComponent());
                }
            }
            if (actionEvent.getSource() == MenuEditor.this.mRenameItem) {
                object = MenuEditor.this.mEditor.getSelectedText();
                MenuEditor.this.mCutItem.setEnabled(object != null);
                MenuEditor.this.mCopyItem.setEnabled(object != null);
                MenuEditor.this.mDeleteItem.setEnabled(object != null);
                MenuEditor.this.mSelectAllItem.setEnabled(object == null);
                MenuEditor.this.mMenuTree.requestFocus();
                TreePath treePath = MenuEditor.this.mMenuTree.getSelectionPath();
                menuTreeNode = (MenuTreeNode)MenuEditor.this.mMenuTree.getLastSelectedPathComponent();
                MenuEditor.this.mMenuTree.setSelectionPath(treePath);
                MenuEditor.this.mMenuTree.startEditingAtPath(treePath);
                MenuEditor.this.mEditor.setMenuTreeNode(menuTreeNode);
                MenuEditor.this.mEditor.setText(menuTreeNode.getDisplayName());
                MenuEditor.this.mEditor.requestFocus();
                MenuEditor.this.mEditor.selectAll();
            }
            if (actionEvent.getSource() == MenuEditor.this.mDeleteItem) {
                if (MenuEditor.this.mMenuTree.isEditing()) {
                    MenuEditor.this.mEditor.setText("");
                } else {
                    MenuEditor.this.deleteTreeNode();
                }
            }
            if (actionEvent.getSource() == MenuEditor.this.mPasteItem) {
                if (MenuEditor.this.mMenuTree.isEditing()) {
                    MenuEditor.this.mEditor.paste();
                } else {
                    String string;
                    object = (MenuTreeNode)MenuEditor.this.mMenuTree.getLastSelectedPathComponent();
                    int n = ((DefaultMutableTreeNode)object).getParent().getIndex((TreeNode)object);
                    menuTreeNode = MenuEditor.getClipboard();
                    if (!menuTreeNode.isSeparator() && !(string = MenuEditor.this.getUniqueName(menuTreeNode.getMenuName(), (MenuTreeNode)((DefaultMutableTreeNode)object).getParent())).equals(menuTreeNode.getMenuName())) {
                        menuTreeNode.setMenuName(string);
                    }
                    ((DefaultTreeModel)MenuEditor.this.mMenuTree.getModel()).insertNodeInto(menuTreeNode, (MutableTreeNode)((DefaultMutableTreeNode)object).getParent(), n);
                    MenuEditor.this.mMenuTree.setSelectionPath(new TreePath(menuTreeNode.getPath()));
                }
            }
            if (actionEvent.getSource() == MenuEditor.this.mSelectAllItem) {
                MenuEditor.this.mEditor.selectAll();
            }
            if (actionEvent.getSource() == MenuEditor.this.mUndoItem) {
                MenuEditor.this.mUndoManager.undo();
            }
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
            this.putValue("AcceleratorKey", 112);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuEditor.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuEditor.this.dispose();
        }
    }
}

