/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.spell_check;

import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.data.dictionary.IDatasetViewObserver;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.dialogs.base.analyze.DataViewObserverAdapter;
import com.spss.java_client.ui.dialogs.base.utilities.spell_check.SpellCheckTableCellCycler;
import com.spss.java_client.ui.dialogs.base.utilities.spell_check.SpellingDlg;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.doc_types.data.undo.VarViewValueLabelsEdit;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.util.TableUtilities;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;

public class VarViewSpellCheckDlg
extends SpellingDlg {
    private DataFrame mFrame;
    SpellCheckTableCellCycler tableCellCycler;
    int[] mOriginalSelectedRows = null;
    int[] mOriginalSelectedCols = null;
    int valueLabelIndex = 0;
    MyDataSourceObserver myDataSourceObserver = new MyDataSourceObserver();

    public VarViewSpellCheckDlg(DataFrame dataFrame) {
        super(dataFrame);
        this.mFrame = dataFrame;
    }

    @Override
    protected void startSpellCheckSession(boolean bl) {
        super.startSpellCheckSession(bl);
        ISpssDataSrc iSpssDataSrc = this.mFrame.getDataSource();
        iSpssDataSrc.addObserver((IDatasetViewObserver)this.myDataSourceObserver);
    }

    @Override
    protected void endSpellCheckSession() {
        if (this.mFrame != null) {
            super.endSpellCheckSession();
            ISpssDataSrc iSpssDataSrc = this.mFrame.getDataSource();
            iSpssDataSrc.removeObserver((IDatasetViewObserver)this.myDataSourceObserver);
            VarViewTable varViewTable = this.getVarViewTable();
            if (varViewTable != null) {
                varViewTable.stopCellEditing();
                if (this.mOriginalSelectedRows != null && this.mOriginalSelectedCols != null) {
                    TableUtilities.restoreSelections((JTable)varViewTable, (int[])this.mOriginalSelectedRows, (int[])this.mOriginalSelectedCols);
                }
                this.getVarViewTableModel().setButtonCellOverrideText(null, null);
            }
        }
    }

    @Override
    public void doSpellCheck() {
        this.startSpellCheckSession(true);
        VarViewTable varViewTable = this.getVarViewTable();
        varViewTable.stopCellEditing();
        this.mOriginalSelectedRows = varViewTable.getSelectedRows();
        this.mOriginalSelectedCols = varViewTable.getSelectedColumns();
        this.tableCellCycler = new SpellCheckTableCellCycler(varViewTable);
        this.doNextRow();
    }

    @Override
    protected void doNextRow() {
        int n = this.getVarViewTableModel().getLabelColumn();
        boolean bl = this.tableCellCycler.cycleNext();
        if (bl) {
            int n2 = this.tableCellCycler.getActiveRow();
            int n3 = this.tableCellCycler.getActiveColumn();
            int n4 = this.tableCellCycler.getActiveValueLabelIndex();
            if (n3 == n) {
                this.spellCheckLabel(n2);
            } else {
                this.spellCheckValue(n2, n4);
            }
        } else {
            this.endSpellCheckSession();
        }
    }

    private VarViewTable getVarViewTable() {
        return (VarViewTable)this.mFrame.getDataView().getDataTable(1);
    }

    private VarViewTableModel getVarViewTableModel() {
        return (VarViewTableModel)this.getVarViewTable().getModel();
    }

    private void spellCheckLabel(final int n) {
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        final int n2 = varViewTableModel.getLabelColumn();
        String string = this.getVarViewTableModel().getValueAt(n, n2).toString();
        string = string == null ? "" : string;
        TableUtilities.restoreSelections((JTable)this.getVarViewTable(), (int[])new int[]{n}, (int[])new int[]{n2});
        this.checkText(string, new SpellingDlg.CheckTextCallback(){

            @Override
            public void spellingChangeByUser(String string) {
                VarViewSpellCheckDlg.this.getVarViewTableModel().setValueAt(string, n, n2);
            }
        });
    }

    private void spellCheckValue(final int n, int n2) {
        VarViewTable varViewTable = this.getVarViewTable();
        final VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        ISpssVariable iSpssVariable = varViewTableModel.getDataSource().getVariable(n);
        if (iSpssVariable != null) {
            IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
            Object[] objectArray = iValueLabelMap.getValueLabelEntries().toArray();
            SPSS_Format sPSS_Format = iSpssVariable.getFormat();
            int n3 = varViewTableModel.getValuesColumn();
            final HashMap<OBS, String> hashMap = varViewTable.createDuplicateOBStoLabelMap(iValueLabelMap);
            if (objectArray != null && objectArray.length > 0) {
                final Map.Entry entry = (Map.Entry)objectArray[n2];
                String string = CellValueFormatter.obsToString((OBS)((OBS)entry.getKey()), (SPSS_Format)sPSS_Format);
                String string2 = (String)entry.getValue();
                if (string2 != null && string2.length() > 0) {
                    TableUtilities.restoreSelections((JTable)varViewTable, (int[])new int[]{n}, (int[])new int[]{n3});
                    String string3 = "{" + string + ", " + string2 + "}...";
                    varViewTableModel.setButtonCellOverrideText(new Point(n3, n), string3);
                    TableUtilities.restoreSelections((JTable)varViewTable, (int[])new int[]{n}, (int[])new int[]{n3});
                    this.checkText(string2, new SpellingDlg.CheckTextCallback(){

                        @Override
                        public void spellingChangeByUser(String string) {
                            hashMap.put(entry.getKey(), string);
                            new VarViewValueLabelsEdit(varViewTableModel, hashMap, n, varViewTableModel.columnIdToColumnIndex("values"));
                        }
                    });
                }
            } else {
                this.doNextRow();
            }
        } else {
            this.doNextRow();
        }
    }

    protected class MyDataSourceObserver
    extends DataViewObserverAdapter {
        protected MyDataSourceObserver() {
            VarViewSpellCheckDlg.this.endSpellCheckSession();
        }

        @Override
        public void notifyVariableInserted(int n, ORIGINATOR_ID oRIGINATOR_ID) {
            VarViewSpellCheckDlg.this.endSpellCheckSession();
        }

        @Override
        public void notifyVariablesInserted(Vector<Integer> vector, ORIGINATOR_ID oRIGINATOR_ID) {
            VarViewSpellCheckDlg.this.endSpellCheckSession();
        }

        @Override
        public void notifyVariablesDeleted(int n, int n2, int n3, ORIGINATOR_ID oRIGINATOR_ID) {
            VarViewSpellCheckDlg.this.endSpellCheckSession();
        }

        public void notifyVariablesMoved(int n, int n2, int n3, ORIGINATOR_ID oRIGINATOR_ID) {
            VarViewSpellCheckDlg.this.endSpellCheckSession();
        }

        @Override
        public void notifyNewRows(long l, long l2) {
        }
    }
}

