/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.spell_check;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.base.utilities.spell_check.SpellCheckHelper;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SpellingOptionsDlg
extends BaseDialog {
    private boolean okAction = false;
    private JComboBox mDictionaryCombo;

    public SpellingOptionsDlg(BaseDialog baseDialog) throws HeadlessException {
        super(baseDialog, "", true, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.myInit();
        this.setLocationRelativeTo((Component)baseDialog);
    }

    public DataFrame getDataFrame() {
        return (DataFrame)this.getOwner();
    }

    private void myInit() {
        this.setTitle(this.getResString("IDS_SPELLING_OPTIONS_TITLE"));
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setLocationRelativeTo(this.getParent());
        this.pack();
    }

    private void setupViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.updateDictionaryInfosDisplayText();
        this.mDictionaryCombo = new DictionaryComboBox();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_DICTIONARY");
        jLabel.setLabelFor(this.mDictionaryCombo);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.bottom = 14;
        DialogUtil.addUsingGBL(jPanel, this.mDictionaryCombo, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        JButton jButton = new JButton(new OkAction());
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = insets.left + insets.right;
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            int n2 = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
            n2 = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add(jButton3);
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void updateDictionaryInfosDisplayText() {
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_options_data_change_dictionary");
    }

    public boolean wasOKAction() {
        return this.okAction;
    }

    private class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpellingOptionsDlg.this.doHelp();
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpellingOptionsDlg.this.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpellingOptionsDlg.this.okAction = true;
            SpellCheckHelper.DictionaryInfo dictionaryInfo = (SpellCheckHelper.DictionaryInfo)SpellingOptionsDlg.this.mDictionaryCombo.getSelectedItem();
            if (dictionaryInfo != null) {
                Preferences preferences = SpellCheckHelper.getSpellPrefs();
                preferences.put("main_dictionary_id", dictionaryInfo.getId());
            }
            SpellingOptionsDlg.this.setVisible(false);
        }
    }

    class DictionaryComboBox
    extends JComboBox {
        public DictionaryComboBox() {
            super(SpellCheckHelper.getDictionaryInfos());
            this.selectBasedOnPrefs();
            this.setRenderer(new MyDefaultListCellRenderer());
        }

        private void selectBasedOnPrefs() {
            String string = SpellCheckHelper.getSpellingMainDictionaryPref();
            SpellCheckHelper.DictionaryInfo dictionaryInfo = SpellCheckHelper.findDictionaryInfo(string);
            if (dictionaryInfo != null) {
                this.setSelectedItem(dictionaryInfo);
            } else {
                this.setSelectedIndex(0);
            }
        }

        private class MyDefaultListCellRenderer
        extends DefaultListCellRenderer {
            private MyDefaultListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null) {
                    SpellCheckHelper.DictionaryInfo dictionaryInfo = (SpellCheckHelper.DictionaryInfo)object;
                    String string = SpellingOptionsDlg.this.getResString("IDS_" + dictionaryInfo.getId());
                    this.setText(string);
                }
                return this;
            }

            @Override
            public void setText(String string) {
                if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                    super.setText(ComponentState.prepareStringForBidiRendering((String)string));
                } else {
                    super.setText(string);
                }
            }

            @Override
            public void setToolTipText(String string) {
                if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                    super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
                } else {
                    super.setToolTipText(string);
                }
            }
        }
    }
}

