/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.spell_check;

import com.keyoti.rapidSpell.BadWord;
import com.keyoti.rapidSpell.NoCurrentBadWordException;
import com.keyoti.rapidSpell.RapidSpellChecker;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.base.utilities.spell_check.SpellCheck;
import com.spss.java_client.ui.dialogs.base.utilities.spell_check.SpellCheckHelper;
import com.spss.java_client.ui.dialogs.base.utilities.spell_check.SpellingOptionsDlg;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class SpellingDlg
extends BaseDialog
implements SpellCheck {
    protected ResourceBundle mResBundle = null;
    protected String mImageFilePath = null;
    DataFrame mDataFrameParent = null;
    private JTextField mNotInDictionary;
    private JButton mAddToDictionaryButton;
    private JButton mOptionsButton;
    private JButton mChangeButton;
    private JButton mIgnoreButton;
    private JButton mIgnoreAllButton;
    private JButton mCancelButton;
    private JTextField mChangeToTextField;
    protected JList mSuggestionsList;
    private RapidSpellChecker mRapidSpellChecker;
    protected boolean mCancelAction = false;
    private CheckTextCallback mCheckTextCallback;
    protected int mBadWordCount = 0;
    public static final String SPELL_CHECK_PREFS = "dialog_settings/spell_checker";

    public SpellingDlg(BaseDialog baseDialog) throws HeadlessException {
        super(baseDialog, "", false, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.myInit();
        this.setupEditListener();
        this.setLocationRelativeTo((Component)baseDialog);
    }

    public SpellingDlg(SpssFrame spssFrame) throws HeadlessException {
        super((JFrame)spssFrame, "", false, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.myInit();
        this.setLocationRelativeTo(spssFrame);
    }

    @Override
    public abstract void doSpellCheck();

    protected void startSpellCheckSession(boolean bl) {
        if (bl) {
            this.mRapidSpellChecker.ignoreList = new Vector();
        }
        this.mBadWordCount = 0;
        this.mCheckTextCallback = null;
    }

    protected void endSpellCheckSession() {
        this.setVisible(false);
        if (!this.mCancelAction) {
            String string = this.mBadWordCount == 0 ? "IDS_SPELLCHECK_NOERRORS" : "IDS_SPELLCHECK_COMPLETE";
            JOptionPane.showMessageDialog((Component)((Object)this), ResUtil.getString(string));
        }
        this.mCancelAction = false;
    }

    public DataFrame getDataFrame() {
        return (DataFrame)this.getOwner();
    }

    private void myInit() {
        this.mRapidSpellChecker = new RapidSpellChecker();
        this.initDictFilePath();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SpellingDlg.this.endSpellCheckSession();
            }
        });
        this.setTitle(this.getResString("IDS_SPELLING_TITLE"));
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.pack();
        this.makeSameSize(this.mOptionsButton, this.mAddToDictionaryButton);
        this.pack();
        Dimension dimension = this.getSizeConstraints();
        this.setSizeConstraints(new Dimension((int)dimension.getWidth(), (int)dimension.getHeight() - 100));
    }

    private void setupViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel(this.getResString("IDS_NOT_IN_DICTIONARY"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mNotInDictionary = new JTextField("");
        this.mNotInDictionary.setEditable(false);
        this.mNotInDictionary.setPreferredSize(new Dimension(100, 25));
        jLabel.setLabelFor(this.mNotInDictionary);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mNotInDictionary, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.mAddToDictionaryButton = new JButton(new AddToDictionaryAction());
        DialogUtil.addUsingGBL(jPanel, this.mAddToDictionaryButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(20, 2, 1, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        jLabel = new JLabel(this.getResString("IDS_CHANGE_TO"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mChangeToTextField = new JTextField("");
        this.mChangeToTextField.setPreferredSize(new Dimension(100, 25));
        jLabel.setLabelFor(this.mChangeToTextField);
        this.mChangeToTextField.getDocument().addDocumentListener(new ChangeToListener());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mChangeToTextField, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        jLabel = new JLabel(this.getResString("IDS_SUGGESTIONS"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mSuggestionsList = new JList();
        this.mSuggestionsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    SpellingDlg.this.changeText();
                }
            }
        });
        this.mSuggestionsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SpellingDlg.this.processListSelectionChange();
            }
        });
        jLabel.setLabelFor(this.mSuggestionsList);
        DialogUtil.addUsingGBL(jPanel, new JScrollPane(this.mSuggestionsList), gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.mOptionsButton = new JButton(new OptionsAction());
        DialogUtil.addUsingGBL(jPanel, this.mOptionsButton, gridBagConstraints, 2, 3, 1, 1, n, insets);
    }

    private void onChangeToTextChange() {
        boolean bl = this.mChangeToTextField.getText().length() != 0;
        this.mChangeButton.setEnabled(bl);
    }

    private void setupEditListener() {
        this.mChangeToTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SpellingDlg.this.onChangeToTextChange();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SpellingDlg.this.onChangeToTextChange();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SpellingDlg.this.onChangeToTextChange();
            }
        });
    }

    private void makeSameSize(JButton jButton, JButton jButton2) {
        int n = (int)jButton.getSize().getWidth();
        int n2 = (int)jButton2.getSize().getWidth();
        int n3 = Math.max(n, n2);
        jButton.setPreferredSize(new Dimension(n3, (int)jButton.getSize().getHeight()));
        jButton2.setPreferredSize(new Dimension(n3, (int)jButton2.getSize().getHeight()));
        jButton.setMinimumSize(new Dimension(n3, (int)jButton.getSize().getHeight()));
        jButton2.setMinimumSize(new Dimension(n3, (int)jButton2.getSize().getHeight()));
        jButton.setSize(new Dimension(n3, (int)jButton.getSize().getHeight()));
        jButton2.setSize(new Dimension(n3, (int)jButton2.getSize().getHeight()));
    }

    private void processListSelectionChange() {
        if (this.mSuggestionsList != null && this.mSuggestionsList.getModel().getSize() > 0) {
            int n = this.mSuggestionsList.getSelectedIndex();
            if (n != -1) {
                String string = (String)this.mSuggestionsList.getModel().getElementAt(n);
                this.mChangeToTextField.setText(string);
            }
        } else {
            this.mChangeToTextField.setText("");
        }
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        this.mChangeButton = new JButton(new ChangeAction());
        this.mIgnoreButton = new JButton(new IgnoreAction());
        this.mIgnoreAllButton = new JButton(new IgnoreAllAction());
        this.mCancelButton = new JButton(new CancelAction());
        JButton jButton = new JButton(new HelpAction());
        jButton.putClientProperty("JButton.buttonType", "help");
        if (OSCheck.getOSType() == OSInfo.OSType.MAC && OSCheck.isMacOSXLeopardOrLater()) {
            jButton.setText("");
        }
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = insets.left + insets.right;
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            int n2 = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
            n2 = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mIgnoreButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mIgnoreAllButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            gridBagConstraints.weightx = 1.0;
            DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mChangeButton, gridBagConstraints, 4, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(this.mChangeButton);
            jPanel.add(this.mIgnoreButton);
            jPanel.add(this.mIgnoreAllButton);
            jPanel.add(this.mCancelButton);
            jPanel.add(jButton);
        }
        this.getRootPane().setDefaultButton(this.mChangeButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_spelling");
    }

    public String getCorrectedText() {
        return this.mRapidSpellChecker.getAmendedText();
    }

    public void checkText(String string, CheckTextCallback checkTextCallback) {
        this.enableControls(true);
        this.mCheckTextCallback = checkTextCallback;
        this.mRapidSpellChecker.check(string);
        this.processNextBadWord();
    }

    private void enableControls(boolean bl) {
        this.mNotInDictionary.setEnabled(bl);
        this.mAddToDictionaryButton.setEnabled(bl);
        this.mOptionsButton.setEnabled(bl);
        if (!bl) {
            this.mChangeButton.setEnabled(false);
        } else {
            this.onChangeToTextChange();
        }
        this.mIgnoreButton.setEnabled(bl);
        this.mIgnoreAllButton.setEnabled(bl);
        this.mCancelButton.setEnabled(bl);
        this.mChangeToTextField.setEnabled(bl);
        this.mSuggestionsList.setEnabled(bl);
    }

    private void addWordToDictionary(String string) {
        if (string != null && string.length() > 0) {
            this.mRapidSpellChecker.addWord(string);
        }
    }

    private void changeText() {
        String string = this.mChangeToTextField.getText();
        if ((string = string.trim()) != null) {
            try {
                boolean bl = true;
                if (!this.mRapidSpellChecker.lookUp(string)) {
                    String string2 = MessageFormat.format(this.getResString("ERR_WORD_NOT_IN_DICTIONARY"), string);
                    int n = JOptionPane.showConfirmDialog((Component)((Object)this), string2);
                    if (n == 0) {
                        this.addWordToDictionary(string);
                    }
                    if (n == 2) {
                        bl = false;
                    }
                }
                if (bl) {
                    this.mRapidSpellChecker.changeBadWord(string);
                    if (this.mCheckTextCallback != null) {
                        this.mCheckTextCallback.spellingChangeByUser(this.mRapidSpellChecker.getAmendedText());
                    }
                    this.processNextBadWord();
                }
            }
            catch (NoCurrentBadWordException noCurrentBadWordException) {
                noCurrentBadWordException.printStackTrace();
            }
        }
    }

    private void processNextBadWord() {
        BadWord badWord = this.mRapidSpellChecker.nextBadWord();
        if (badWord != null) {
            ++this.mBadWordCount;
            this.setVisible(true);
            this.mNotInDictionary.setText(badWord.getWord());
            try {
                Vector vector = this.mRapidSpellChecker.findSuggestions();
                if (vector != null) {
                    this.mSuggestionsList.setListData(vector);
                    this.mSuggestionsList.setSelectedIndex(0);
                    this.processListSelectionChange();
                }
            }
            catch (NoCurrentBadWordException noCurrentBadWordException) {
                noCurrentBadWordException.printStackTrace();
            }
        } else {
            this.enableControls(false);
            this.doNextRow();
        }
    }

    private void initDictFilePath() {
        String string = SpellCheckHelper.getSpellingMainDictionaryPref();
        String string2 = SpellCheckHelper.getDictionaryPath(string);
        if (string2 == null) {
            string2 = SpellCheckHelper.getDefaultDictionaryPath();
        }
        if (string2 != null) {
            this.mRapidSpellChecker.setDictFilePath(string2);
        }
        String string3 = SpellCheckHelper.getUserDictionaryPath(string);
        File file = new File(string3);
        this.createFile(file);
        this.mRapidSpellChecker.setUserDictionary(file);
    }

    private void createFile(File file) {
        File file2 = new File(SpellCheckHelper.USER_DIR__PATH);
        file2.mkdir();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected void doNextRow() {
    }

    public boolean isCancelAction() {
        return this.mCancelAction;
    }

    private class ChangeToListener
    implements DocumentListener {
        private ChangeToListener() {
        }

        private void updateChangeButton() {
            SpellingDlg.this.mChangeButton.setEnabled(SpellingDlg.this.mChangeToTextField.getText().length() > 0);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateChangeButton();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateChangeButton();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateChangeButton();
        }
    }

    public static interface CheckTextCallback {
        public void spellingChangeByUser(String var1);
    }

    private class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpellingDlg.this.doHelp();
        }
    }

    private class IgnoreAllAction
    extends AbstractAction {
        IgnoreAllAction() {
            Integer n;
            this.putValue("Name", SpellingDlg.this.getResString("IDS_IGNOREALL"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC && (n = SpellingDlg.this.getDlgAccessKey("IDK_IGNOREALL_KEY")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpellingDlg.this.mRapidSpellChecker.ignoreAll(SpellingDlg.this.mNotInDictionary.getText());
            SpellingDlg.this.processNextBadWord();
        }
    }

    private class IgnoreAction
    extends AbstractAction {
        IgnoreAction() {
            Integer n;
            this.putValue("Name", SpellingDlg.this.getResString("IDS_IGNORE"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC && (n = SpellingDlg.this.getDlgAccessKey("IDK_IGNORE_KEY")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpellingDlg.this.processNextBadWord();
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpellingDlg.this.mCancelAction = true;
            SpellingDlg.this.endSpellCheckSession();
        }
    }

    private class ChangeAction
    extends AbstractAction {
        ChangeAction() {
            Integer n;
            this.putValue("Name", SpellingDlg.this.getResString("IDS_CHANGE"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC && (n = SpellingDlg.this.getDlgAccessKey("IDK_CHANGE_KEY")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpellingDlg.this.changeText();
        }
    }

    private class AddToDictionaryAction
    extends AbstractAction {
        AddToDictionaryAction() {
            Integer n;
            this.putValue("Name", SpellingDlg.this.getResString("IDS_ADD_TO_DICTIONARY"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC && (n = SpellingDlg.this.getDlgAccessKey("IDK_ADD_TO_DICTIONARY_KEY")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = SpellingDlg.this.mNotInDictionary.getText();
            string = string.trim();
            SpellingDlg.this.addWordToDictionary(string);
            SpellingDlg.this.processNextBadWord();
        }
    }

    private class OptionsAction
    extends AbstractAction {
        OptionsAction() {
            Integer n;
            this.putValue("Name", SpellingDlg.this.getResString("IDS_SPELLING_OPTIONS"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC && (n = SpellingDlg.this.getDlgAccessKey("IDK_SPELLING_OPTIONS_KEY")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpellingOptionsDlg spellingOptionsDlg = new SpellingOptionsDlg(SpellingDlg.this);
            spellingOptionsDlg.setVisible(true);
            if (spellingOptionsDlg.wasOKAction()) {
                SpellingDlg.this.initDictFilePath();
            }
        }
    }
}

