/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.spell_check;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.uitools.util.TableUtilities;
import javax.swing.JTable;

public class SpellCheckTableCellCycler {
    private VarViewTable mVarViewTable;
    private int[] mSpellCheckRows;
    private int[] mSpellCheckCols;
    private int mStartRow;
    private int mStartCol;
    private int mRowArrayIndex;
    private int mColArrayIndex;
    private int mActiveCellItemIndex = 0;
    private boolean isFirstSearch = true;

    public SpellCheckTableCellCycler(VarViewTable varViewTable) {
        this.init(varViewTable);
    }

    private void init(VarViewTable varViewTable) {
        this.mVarViewTable = varViewTable;
        VarViewTableModel varViewTableModel = (VarViewTableModel)this.mVarViewTable.getModel();
        int n = varViewTableModel.getLabelColumn();
        int n2 = varViewTableModel.getValuesColumn();
        int[] nArray = varViewTable.getSelectedRows();
        int[] nArray2 = varViewTable.getSelectedColumns();
        this.mSpellCheckRows = nArray;
        this.mSpellCheckCols = nArray2;
        this.mStartRow = nArray[0];
        this.mStartCol = nArray2[0];
        this.mRowArrayIndex = 0;
        this.mColArrayIndex = 0;
        if (nArray.length == 1 && nArray2.length == 1) {
            this.mSpellCheckRows = TableUtilities.getRowArray((JTable)varViewTable);
            this.initColumnArray(n, n2);
            if (nArray2[0] != n && nArray2[0] != n2) {
                this.mStartRow = 0;
                this.mStartCol = this.mSpellCheckCols[0];
            }
        }
        this.mRowArrayIndex = this.findIndex(this.mSpellCheckRows, this.mStartRow);
        this.mColArrayIndex = this.findIndex(this.mSpellCheckCols, this.mStartCol);
        this.mActiveCellItemIndex = 0;
    }

    private int findIndex(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private void initColumnArray(int n, int n2) {
        int n3 = 0;
        n3 = n != -1 ? n3 + 1 : n3;
        n3 = n2 != -1 ? n3 + 1 : n3;
        this.mSpellCheckCols = new int[n3];
        if (n != -1 && n2 != -1) {
            this.mSpellCheckCols[0] = Math.min(n, n2);
        } else {
            int n4 = this.mSpellCheckCols[0] = n != -1 ? n : n2;
        }
        if (n != -1 && n2 != -1) {
            this.mSpellCheckCols[1] = Math.max(n, n2);
        }
    }

    public boolean cycleNext() {
        VarViewTableModel varViewTableModel = (VarViewTableModel)this.mVarViewTable.getModel();
        int n = varViewTableModel.getValuesColumn();
        boolean bl = false;
        if (!this.isFirstSearch) {
            if (this.getActiveColumn() == n) {
                ++this.mActiveCellItemIndex;
                ISpssVariable iSpssVariable = varViewTableModel.getDataSource().getVariable(this.getActiveRow());
                boolean bl2 = false;
                if (iSpssVariable != null) {
                    IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
                    if (iValueLabelMap == null || this.mActiveCellItemIndex >= iValueLabelMap.size()) {
                        bl2 = true;
                    }
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    this.mActiveCellItemIndex = 0;
                    ++this.mRowArrayIndex;
                }
            } else {
                ++this.mRowArrayIndex;
            }
            if (this.mRowArrayIndex >= this.mSpellCheckRows.length) {
                this.mRowArrayIndex = 0;
                ++this.mColArrayIndex;
                if (this.mColArrayIndex >= this.mSpellCheckCols.length) {
                    this.mColArrayIndex = 0;
                }
            }
            if (this.getActiveRow() == this.mStartRow && this.getActiveColumn() == this.mStartCol && this.mActiveCellItemIndex == 0) {
                bl = true;
            }
        } else {
            this.isFirstSearch = false;
        }
        return !bl;
    }

    public int getActiveColumn() {
        return this.mSpellCheckCols[this.mColArrayIndex];
    }

    public int getActiveRow() {
        return this.mSpellCheckRows[this.mRowArrayIndex];
    }

    public int getActiveValueLabelIndex() {
        return this.mActiveCellItemIndex;
    }
}

