/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.spell_check;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import java.io.File;
import java.util.Locale;
import java.util.prefs.Preferences;

public class SpellCheckHelper {
    public static final String SPELL_CHECK_PREFS = "dialog_settings/spell_checker";
    public static String BASE_DIR__PATH = System.getProperty("application.home") + File.separatorChar;
    public static String USER_DIR__PATH = System.getProperty("user.home.spss") + File.separatorChar + "spelling";
    public static final String US_ENGLISH = "US_ENGLISH";
    public static final String UK_ENGLISH = "UK_ENGLISH";
    public static final String US_UK_ENGLISH = "US_UK_ENGLISH";
    public static final String GERMAN = "GERMAN";
    public static final String SPANISH = "SPANISH";
    public static final String FRENCH = "FRENCH";
    public static final String ITALIAN = "ITALIAN";
    public static final String DUTCH = "DUTCH";
    public static final String SWISS_GERMAN = "SWISS_GERMAN";
    public static final String PORTUGUESE = "PORTUGUESE";
    public static final String BRAZIL_PORTUGUESE = "BRAZIL_PORTUGUESE";
    private static final DictionaryInfo[] mDictionaryInfos = new DictionaryInfo[]{new DictionaryInfo("US_ENGLISH", BASE_DIR__PATH + "us_english.dict", USER_DIR__PATH + File.separatorChar + "us_english_user.dict"), new DictionaryInfo("UK_ENGLISH", BASE_DIR__PATH + "uk_english.dict", USER_DIR__PATH + File.separatorChar + "uk_english_user.dict"), new DictionaryInfo("US_UK_ENGLISH", BASE_DIR__PATH + "usuk_english.dict", USER_DIR__PATH + File.separatorChar + "usuk_english_user.dict"), new DictionaryInfo("GERMAN", BASE_DIR__PATH + "german.dict", USER_DIR__PATH + File.separatorChar + "german_user.dict"), new DictionaryInfo("SPANISH", BASE_DIR__PATH + "spanish.dict", USER_DIR__PATH + File.separatorChar + "spanish_user.dict"), new DictionaryInfo("FRENCH", BASE_DIR__PATH + "french.dict", USER_DIR__PATH + File.separatorChar + "french_user.dict"), new DictionaryInfo("ITALIAN", BASE_DIR__PATH + "italian.dict", USER_DIR__PATH + File.separatorChar + "italian_user.dict"), new DictionaryInfo("DUTCH", BASE_DIR__PATH + "dutch.dict", USER_DIR__PATH + File.separatorChar + "dutch_user.dict"), new DictionaryInfo("SWISS_GERMAN", BASE_DIR__PATH + "swissgerman.dict", USER_DIR__PATH + File.separatorChar + "swissgerman_user.dict"), new DictionaryInfo("PORTUGUESE", BASE_DIR__PATH + "portuguese.dict", USER_DIR__PATH + File.separatorChar + "portuguese_user.dict"), new DictionaryInfo("BRAZIL_PORTUGUESE", BASE_DIR__PATH + "br_portuguese.dict", USER_DIR__PATH + File.separatorChar + "br_portuguese_user.dict")};

    public static Preferences getSpellPrefs() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node(SPELL_CHECK_PREFS);
        return preferences2;
    }

    public static String getSpellingMainDictionaryPref() {
        Preferences preferences = SpellCheckHelper.getSpellPrefs();
        String string = preferences.get("main_dictionary_id", US_ENGLISH);
        return string;
    }

    public static String getDefaultDictionaryPath() {
        String string = SpellCheckHelper.getDictionaryPathForLocale(ComponentState.getSPSSLocale());
        if (string == null) {
            string = SpellCheckHelper.getDictionaryPathForLocale(VersionInfo.getNLVLocale());
        }
        return string != null ? string : SpellCheckHelper.getDictionaryPath(US_ENGLISH);
    }

    public static String getDictionaryPathForLocale(Locale locale) {
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        String string3 = null;
        if (string.equals("en")) {
            string3 = string2.equals("GB") ? SpellCheckHelper.getDictionaryPath(UK_ENGLISH) : SpellCheckHelper.getDictionaryPath(US_ENGLISH);
        } else if (string.equals("de")) {
            string3 = string2.equals("CH") ? SpellCheckHelper.getDictionaryPath(SWISS_GERMAN) : SpellCheckHelper.getDictionaryPath(GERMAN);
        } else if (string.equals("es")) {
            string3 = SpellCheckHelper.getDictionaryPath(SPANISH);
        } else if (string.equals("fr")) {
            string3 = SpellCheckHelper.getDictionaryPath(FRENCH);
        } else if (string.equals("it")) {
            string3 = SpellCheckHelper.getDictionaryPath(ITALIAN);
        } else if (string.equals("nl")) {
            string3 = SpellCheckHelper.getDictionaryPath(DUTCH);
        } else if (string.equals("pt")) {
            string3 = !string2.equals("BR") ? SpellCheckHelper.getDictionaryPath(PORTUGUESE) : SpellCheckHelper.getDictionaryPath(BRAZIL_PORTUGUESE);
        }
        return string3;
    }

    public static DictionaryInfo findDictionaryInfo(String string) {
        DictionaryInfo dictionaryInfo = null;
        for (DictionaryInfo dictionaryInfo2 : mDictionaryInfos) {
            if (!dictionaryInfo2.getId().equals(string)) continue;
            dictionaryInfo = dictionaryInfo2;
            break;
        }
        return dictionaryInfo;
    }

    public static String getDictionaryPath(String string) {
        DictionaryInfo dictionaryInfo = SpellCheckHelper.findDictionaryInfo(string);
        String string2 = dictionaryInfo != null ? dictionaryInfo.getBaseDictionaryPath() : null;
        return string2;
    }

    public static String getUserDictionaryPath(String string) {
        DictionaryInfo dictionaryInfo = SpellCheckHelper.findDictionaryInfo(string);
        String string2 = dictionaryInfo != null ? dictionaryInfo.getUserDictionaryPath() : null;
        return string2;
    }

    public static DictionaryInfo[] getDictionaryInfos() {
        return mDictionaryInfos;
    }

    public static class DictionaryInfo {
        String baseDictPath;
        String userDictPath;
        String id;

        public DictionaryInfo(String string, String string2, String string3) {
            this.id = string;
            this.baseDictPath = string2;
            this.userDictPath = string3;
        }

        public String getBaseDictionaryPath() {
            return this.baseDictPath;
        }

        public String getId() {
            return this.id;
        }

        public String getUserDictionaryPath() {
            return this.userDictPath;
        }
    }
}

