/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.spell_check;

import com.keyoti.rapidSpell.BadWord;
import com.keyoti.rapidSpell.NoCurrentBadWordException;
import com.keyoti.rapidSpell.RapidSpellChecker;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.dictionary.CaseIterator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.base.analyze.DataViewObserverAdapter;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.base.utilities.spell_check.SpellCheck;
import com.spss.java_client.ui.dialogs.base.utilities.spell_check.SpellCheckHelper;
import com.spss.java_client.ui.dialogs.base.utilities.spell_check.SpellingOptionsDlg;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataViewSpellCheckDlg
extends BaseDialog
implements SpellCheck {
    private BadWord mBadWord = null;
    private boolean mIsCancelled = false;
    private CaseIterator mCaseIterator = null;
    private List<Integer> mTextColumns;
    private int mColumnIndex = 0;
    private int mColumnCount = 0;
    private long mRowCount = 0L;
    private final int SPELLCHECK_FINISHED = 0;
    private final int SPELLCHECK_BADWORD = 1;
    private final int SPELLCHECK_CANCELLED = 2;
    private RapidSpellChecker mRapidSpellChecker;
    private DataFrame mFrame;
    private JProgressBar mProgressBar;
    private JTextField mNotInDictionary;
    private JButton mAddToDictionaryButton;
    private JButton mOptionsButton;
    private JButton mChangeButton;
    private JButton mIgnoreButton;
    private JButton mIgnoreAllButton;
    private JButton mCancelButton;
    private JButton mHelpButton;
    private JTextField mChangeToTextField;
    private JList mSuggestionsList;
    private JLabel mSearchingLabel;
    private JLabel mNotInDictLabel;
    private JLabel mChangeToLabel;
    private Thread mSpellCheckThread;
    MyDataSourceObserver myDataSourceObserver = new MyDataSourceObserver();

    public DataViewSpellCheckDlg(DataFrame dataFrame) {
        super((JFrame)dataFrame, "", false, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.mFrame = dataFrame;
        this.setTitle(this.getResString("IDS_SPELLING_TITLE"));
        this.createMainPanelComponents();
        this.initLayout();
        this.setupEditListener();
        this.setLocationRelativeTo(dataFrame);
    }

    private void createMainPanelComponents() {
        int n = 30;
        this.mProgressBar = new JProgressBar(0, 0, 100);
        this.mNotInDictionary = new JTextField("");
        this.mNotInDictionary.setEditable(false);
        this.mNotInDictionary.setColumns(n);
        this.mChangeToTextField = new JTextField("");
        this.mChangeToTextField.setColumns(n);
        this.mChangeToTextField.getDocument().addDocumentListener(new ChangeToListener());
        this.mSuggestionsList = new JList();
        this.mSuggestionsList.setVisibleRowCount(7);
        this.mSuggestionsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    DataViewSpellCheckDlg.this.changeText();
                }
            }
        });
        this.mSuggestionsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DataViewSpellCheckDlg.this.processListSelectionChange();
            }
        });
        this.mAddToDictionaryButton = new JButton(new AddToDictionaryAction());
        this.mOptionsButton = new JButton(new OptionsAction());
    }

    private void initLayout() {
        JPanel jPanel = this.getViewPanel();
        double[] dArray = new double[]{-2.0, -1.0, -2.0};
        double[] dArray2 = new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -1.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        tableLayout.setHGap(7);
        tableLayout.setVGap(7);
        jPanel.setLayout((LayoutManager)tableLayout);
        this.mSearchingLabel = new JLabel(this.getResString("IDS_BADWORD_SEARCH"));
        this.mNotInDictLabel = new JLabel(this.getResString("IDS_NOT_IN_DICTIONARY"));
        this.mChangeToLabel = new JLabel(this.getResString("IDS_CHANGE_TO"));
        this.mChangeToLabel.getAccessibleContext().setAccessibleName(this.getResString("IDS_CHANGE_TO") + "alt plus h");
        this.mChangeToLabel.setLabelFor(this.mChangeToTextField);
        this.mChangeToLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_CHANGE_TO_KEY"));
        JLabel jLabel = new JLabel(this.getResString("IDS_SUGGESTIONS"));
        jLabel.getAccessibleContext().setAccessibleName(this.getResString("IDS_SUGGESTIONS") + "alt plus s");
        jLabel.setLabelFor(this.mSuggestionsList);
        jLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_SUGGESTIONS"));
        JScrollPane jScrollPane = new JScrollPane(this.mSuggestionsList);
        JSeparator jSeparator = new JSeparator(0);
        jPanel.add((Component)this.mSearchingLabel, " 0, 0, 1, 0");
        jPanel.add((Component)this.mProgressBar, " 1, 1");
        jPanel.add((Component)jSeparator, " 0, 2, 2, 2");
        jPanel.add((Component)this.mNotInDictLabel, " 0, 3");
        jPanel.add((Component)this.mNotInDictionary, " 1, 3");
        jPanel.add((Component)this.mAddToDictionaryButton, " 2, 3");
        jPanel.add((Component)this.mChangeToLabel, " 0, 4");
        jPanel.add((Component)this.mChangeToTextField, " 1, 4");
        jPanel.add((Component)jLabel, " 1, 5");
        jPanel.add((Component)jScrollPane, " 1, 6");
        jPanel.add((Component)this.mOptionsButton, " 2, 6, f, t");
        this.pack();
    }

    private void onChangeToTextChange() {
        boolean bl = this.mChangeToTextField.getText().length() != 0;
        this.mChangeButton.setEnabled(bl);
    }

    private void setupEditListener() {
        this.mChangeToTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                DataViewSpellCheckDlg.this.onChangeToTextChange();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                DataViewSpellCheckDlg.this.onChangeToTextChange();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                DataViewSpellCheckDlg.this.onChangeToTextChange();
            }
        });
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mNotInDictionary);
        vector.add(this.mAddToDictionaryButton);
        vector.add(this.mChangeToTextField);
        vector.add(this.mSuggestionsList);
        vector.add(this.mOptionsButton);
        vector.add(this.mIgnoreButton);
        vector.add(this.mIgnoreAllButton);
        vector.add(this.mCancelButton);
        vector.add(this.mChangeButton);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        this.createButtonPanelComponents();
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = insets.left + insets.right;
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            int n2 = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
            n2 = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mIgnoreButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mIgnoreAllButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            gridBagConstraints.weightx = 1.0;
            DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mChangeButton, gridBagConstraints, 4, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(this.mChangeButton);
            jPanel.add(this.mIgnoreButton);
            jPanel.add(this.mIgnoreAllButton);
            jPanel.add(this.mCancelButton);
            jPanel.add(this.mHelpButton);
        }
        this.getRootPane().setDefaultButton(this.mChangeButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void createButtonPanelComponents() {
        this.mChangeButton = new JButton(new ChangeAction());
        this.mChangeButton.setMnemonic(this.getDlgAccessKey("IDK_CHANGE_KEY"));
        this.mIgnoreButton = new JButton(new IgnoreAction());
        this.mIgnoreButton.setMnemonic(this.getDlgAccessKey("IDK_IGNORE_KEY"));
        this.mIgnoreAllButton = new JButton(new IgnoreAllAction());
        this.mIgnoreAllButton.setMnemonic(this.getDlgAccessKey("IDK_IGNOREALL_KEY"));
        this.mCancelButton = new JButton(new CancelAction());
        this.mHelpButton = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(this.mHelpButton);
    }

    private void doCancel() {
        this.mIsCancelled = true;
        if (this.mSpellCheckThread.isAlive()) {
            try {
                this.mSpellCheckThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setVisible(false);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_spelling");
    }

    private void setComponentsSpellChecking(boolean bl) {
        this.mSearchingLabel.setEnabled(bl);
        this.mNotInDictLabel.setEnabled(!bl);
        this.mNotInDictionary.setEnabled(!bl);
        this.mAddToDictionaryButton.setEnabled(!bl);
        this.mChangeToLabel.setEnabled(!bl);
        this.mChangeToTextField.setEnabled(!bl);
        this.mSuggestionsList.setEnabled(!bl);
        this.mOptionsButton.setEnabled(!bl);
        if (bl) {
            this.mChangeButton.setEnabled(false);
        } else {
            this.onChangeToTextChange();
        }
        this.mIgnoreButton.setEnabled(!bl);
        this.mIgnoreAllButton.setEnabled(!bl);
    }

    @Override
    public void doSpellCheck() {
        DataViewTable dataViewTable = (DataViewTable)this.mFrame.getDataView().getDataTable(0);
        dataViewTable.stopCellEditing();
        if (!this.prepDataIterator()) {
            return;
        }
        this.initRapidSpell();
        this.setVisible(true);
        this.continueSpellCheck();
    }

    private void continueSpellCheck() {
        this.setComponentsSpellChecking(true);
        this.mSpellCheckThread = new Thread(new SpellCheckTask());
        this.mSpellCheckThread.start();
    }

    private boolean prepDataIterator() {
        this.mTextColumns = DataViewSpellCheckDlg.getTextColumns(this.mFrame.getDataView());
        this.mColumnCount = this.mTextColumns.size();
        this.mRowCount = this.mFrame.getDataSource().rowCount();
        if (this.mRowCount == -1L) {
            this.mProgressBar.setIndeterminate(true);
        }
        try {
            ISpssDataSrc iSpssDataSrc = this.mFrame.getDataSource();
            this.mCaseIterator = (CaseIterator)iSpssDataSrc.makeIterator();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            return false;
        }
        return true;
    }

    public static List<Integer> getTextColumns(DataView dataView) {
        ArrayList<Integer> arrayList;
        block4: {
            int[] nArray = DataViewSpellCheckDlg.getSelectedColumns(dataView);
            ISpssDataSrc iSpssDataSrc = dataView.getDataSrc();
            arrayList = new ArrayList<Integer>();
            if (iSpssDataSrc == null) break block4;
            if (nArray == null || nArray.length == 0) {
                for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
                    ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                    if (iSpssVariable.getType() <= 0 || !iSpssDataSrc.isVariableInCurrentSet(i)) continue;
                    arrayList.add(i);
                }
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(nArray[i]);
                    if (iSpssVariable == null || iSpssVariable.getType() <= 0 || !iSpssDataSrc.isVariableInCurrentSet(nArray[i])) continue;
                    arrayList.add(nArray[i]);
                }
            }
        }
        return arrayList;
    }

    private static int[] getSelectedColumns(DataView dataView) {
        JTable jTable;
        if (dataView != null && (jTable = dataView.getDataTable(dataView.getActiveView())) instanceof DataViewTable) {
            DataViewTable dataViewTable = (DataViewTable)jTable;
            return dataViewTable.getColumnSelections();
        }
        return new int[0];
    }

    private void initRapidSpell() {
        this.mRapidSpellChecker = new RapidSpellChecker();
        this.initDictionary();
    }

    private void initDictionary() {
        String string = SpellCheckHelper.getSpellingMainDictionaryPref();
        String string2 = SpellCheckHelper.getDictionaryPath(string);
        if (string2 == null) {
            string2 = SpellCheckHelper.getDefaultDictionaryPath();
        }
        if (string2 != null) {
            this.mRapidSpellChecker.setDictFilePath(string2);
        }
        String string3 = SpellCheckHelper.getUserDictionaryPath(string);
        File file = new File(string3);
        this.createFile(file);
        this.mRapidSpellChecker.setUserDictionary(file);
    }

    private void createFile(File file) {
        File file2 = new File(SpellCheckHelper.USER_DIR__PATH);
        file2.mkdir();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void handleBadWord(boolean bl) {
        block6: {
            if (bl) {
                this.mBadWord = this.mRapidSpellChecker.nextBadWord();
            }
            if (this.mBadWord != null) {
                this.mNotInDictionary.setText(this.mBadWord.getWord());
                try {
                    Vector vector = this.mRapidSpellChecker.findSuggestions();
                    if (vector != null && vector.size() > 0) {
                        this.mSuggestionsList.setListData(vector);
                        this.mSuggestionsList.setSelectedIndex(0);
                        this.mChangeToTextField.setText((String)this.mSuggestionsList.getModel().getElementAt(0));
                        break block6;
                    }
                    this.mSuggestionsList.setListData(new Vector());
                    this.mChangeToTextField.setText("");
                }
                catch (NoCurrentBadWordException noCurrentBadWordException) {
                    noCurrentBadWordException.printStackTrace();
                }
            } else {
                this.continueSpellCheck();
            }
        }
    }

    private void changeText() {
        String string = this.mChangeToTextField.getText();
        if ((string = string.trim()) != null) {
            try {
                String string2;
                boolean bl = true;
                if (!this.mRapidSpellChecker.lookUp(string)) {
                    string2 = MessageFormat.format(this.getResString("ERR_WORD_NOT_IN_DICTIONARY"), string);
                    int n = JOptionPane.showConfirmDialog((Component)((Object)this), string2);
                    if (n == 0) {
                        this.addWordToDictionary(string);
                    }
                    if (n == 2) {
                        bl = false;
                    }
                }
                if (bl) {
                    this.mRapidSpellChecker.changeBadWord(string);
                    string2 = this.mRapidSpellChecker.getAmendedText();
                    this.mCaseIterator.setColumnValue(this.mTextColumns.get(this.mColumnIndex - 1).intValue(), string2);
                    this.handleBadWord(true);
                }
            }
            catch (NoCurrentBadWordException noCurrentBadWordException) {
                noCurrentBadWordException.printStackTrace();
            }
        }
    }

    private void processListSelectionChange() {
        if (this.mSuggestionsList != null && this.mSuggestionsList.getModel().getSize() > 0) {
            int n = this.mSuggestionsList.getSelectedIndex();
            if (n != -1) {
                String string = (String)this.mSuggestionsList.getModel().getElementAt(n);
                this.mChangeToTextField.setText(string);
            }
        } else {
            this.mChangeToTextField.setText("");
        }
    }

    private void addWordToDictionary(String string) {
        if (string != null && string.length() > 0) {
            this.mRapidSpellChecker.addWord(string);
        }
    }

    private class ChangeToListener
    implements DocumentListener {
        private ChangeToListener() {
        }

        private void updateChangeButton() {
            DataViewSpellCheckDlg.this.mChangeButton.setEnabled(DataViewSpellCheckDlg.this.mChangeToTextField.getText().length() > 0);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateChangeButton();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateChangeButton();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateChangeButton();
        }
    }

    protected class MyDataSourceObserver
    extends DataViewObserverAdapter {
        protected MyDataSourceObserver() {
        }

        @Override
        public void notifyVariableInserted(int n, ORIGINATOR_ID oRIGINATOR_ID) {
            DataViewSpellCheckDlg.this.doCancel();
        }

        @Override
        public void notifyVariablesInserted(Vector<Integer> vector, ORIGINATOR_ID oRIGINATOR_ID) {
            DataViewSpellCheckDlg.this.doCancel();
        }

        @Override
        public void notifyVariablesDeleted(int n, int n2, int n3, ORIGINATOR_ID oRIGINATOR_ID) {
            DataViewSpellCheckDlg.this.doCancel();
        }

        public void notifyVariablesMoved(int n, int n2, int n3, ORIGINATOR_ID oRIGINATOR_ID) {
            DataViewSpellCheckDlg.this.doCancel();
        }

        @Override
        public void notifyNewRows(long l, long l2) {
            DataViewSpellCheckDlg.this.doCancel();
        }
    }

    private class SpellCheckReportProgress
    implements Runnable {
        private SpellCheckReportProgress() {
        }

        @Override
        public void run() {
            double d = DataViewSpellCheckDlg.this.mCaseIterator.tell();
            double d2 = DataViewSpellCheckDlg.this.mRowCount;
            double d3 = d * 100.0 / d2;
            DataViewSpellCheckDlg.this.mProgressBar.setValue(new Double(d3).intValue());
        }
    }

    private class SpellCheckTaskFinished
    implements Runnable {
        private int reason;

        public SpellCheckTaskFinished(int n) {
            this.reason = n;
        }

        @Override
        public void run() {
            if (this.reason == 2) {
                // empty if block
            }
            if (this.reason == 0) {
                DataViewSpellCheckDlg.this.mProgressBar.setValue(100);
                JOptionPane.showMessageDialog((Component)((Object)DataViewSpellCheckDlg.this), ResUtil.getString("IDS_SPELLCHECK_COMPLETE"));
                DataViewSpellCheckDlg.this.doCancel();
            }
            if (this.reason == 1) {
                int n = (int)DataViewSpellCheckDlg.this.mCaseIterator.tell();
                Integer n2 = (Integer)DataViewSpellCheckDlg.this.mTextColumns.get(DataViewSpellCheckDlg.this.mColumnIndex - 1);
                DataViewSpellCheckDlg.this.mFrame.getDataView().scrollCellToVisible(n2, n);
                DataViewSpellCheckDlg.this.mFrame.getDataView().selectCell(n2, n);
                DataViewSpellCheckDlg.this.setComponentsSpellChecking(false);
                DataViewSpellCheckDlg.this.handleBadWord(false);
            }
        }
    }

    private class SpellCheckTask
    implements Runnable {
        private SpellCheckTask() {
        }

        @Override
        public void run() {
            String string;
            while ((string = this.getNextCell()) != null) {
                DataViewSpellCheckDlg.this.mRapidSpellChecker.check(string);
                DataViewSpellCheckDlg.this.mBadWord = DataViewSpellCheckDlg.this.mRapidSpellChecker.nextBadWord();
                if (DataViewSpellCheckDlg.this.mBadWord != null) {
                    SpellCheckTaskFinished spellCheckTaskFinished = new SpellCheckTaskFinished(1);
                    SwingUtilities.invokeLater(spellCheckTaskFinished);
                    return;
                }
                Thread.yield();
                if (DataViewSpellCheckDlg.this.mIsCancelled) {
                    SpellCheckTaskFinished spellCheckTaskFinished = new SpellCheckTaskFinished(2);
                    SwingUtilities.invokeLater(spellCheckTaskFinished);
                    return;
                }
                SpellCheckReportProgress spellCheckReportProgress = new SpellCheckReportProgress();
                SwingUtilities.invokeLater(spellCheckReportProgress);
            }
            SpellCheckTaskFinished spellCheckTaskFinished = new SpellCheckTaskFinished(0);
            SwingUtilities.invokeLater(spellCheckTaskFinished);
        }

        private String getNextCell() {
            if (DataViewSpellCheckDlg.this.mColumnIndex >= DataViewSpellCheckDlg.this.mColumnCount) {
                DataViewSpellCheckDlg.this.mColumnIndex = 0;
                if (!DataViewSpellCheckDlg.this.mCaseIterator.nextCase()) {
                    return null;
                }
            }
            String string = DataViewSpellCheckDlg.this.mCaseIterator.getStringValue(((Integer)DataViewSpellCheckDlg.this.mTextColumns.get(DataViewSpellCheckDlg.this.mColumnIndex)).intValue());
            ++DataViewSpellCheckDlg.this.mColumnIndex;
            return string;
        }
    }

    private class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataViewSpellCheckDlg.this.doHelp();
        }
    }

    private class IgnoreAllAction
    extends AbstractAction {
        IgnoreAllAction() {
            Integer n;
            this.putValue("Name", DataViewSpellCheckDlg.this.getResString("IDS_IGNOREALL"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC && (n = DataViewSpellCheckDlg.this.getDlgAccessKey("IDK_IGNOREALL_KEY")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataViewSpellCheckDlg.this.mRapidSpellChecker.ignoreAll(DataViewSpellCheckDlg.this.mNotInDictionary.getText());
            DataViewSpellCheckDlg.this.handleBadWord(true);
        }
    }

    private class IgnoreAction
    extends AbstractAction {
        IgnoreAction() {
            Integer n;
            this.putValue("Name", DataViewSpellCheckDlg.this.getResString("IDS_IGNORE"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC && (n = DataViewSpellCheckDlg.this.getDlgAccessKey("IDK_IGNORE_KEY")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataViewSpellCheckDlg.this.handleBadWord(true);
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataViewSpellCheckDlg.this.doCancel();
        }
    }

    private class ChangeAction
    extends AbstractAction {
        ChangeAction() {
            Integer n;
            this.putValue("Name", DataViewSpellCheckDlg.this.getResString("IDS_CHANGE"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC && (n = DataViewSpellCheckDlg.this.getDlgAccessKey("IDK_CHANGE_KEY")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataViewSpellCheckDlg.this.changeText();
        }
    }

    private class AddToDictionaryAction
    extends AbstractAction {
        AddToDictionaryAction() {
            Integer n;
            this.putValue("Name", DataViewSpellCheckDlg.this.getResString("IDS_ADD_TO_DICTIONARY"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC && (n = DataViewSpellCheckDlg.this.getDlgAccessKey("IDK_ADD_TO_DICTIONARY_KEY")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = DataViewSpellCheckDlg.this.mNotInDictionary.getText();
            string = string.trim();
            DataViewSpellCheckDlg.this.addWordToDictionary(string);
            DataViewSpellCheckDlg.this.handleBadWord(true);
        }
    }

    private class OptionsAction
    extends AbstractAction {
        OptionsAction() {
            Integer n;
            this.putValue("Name", DataViewSpellCheckDlg.this.getResString("IDS_SPELLING_OPTIONS"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC && (n = DataViewSpellCheckDlg.this.getDlgAccessKey("IDK_SPELLING_OPTIONS_KEY")) != null) {
                this.putValue("MnemonicKey", n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpellingOptionsDlg spellingOptionsDlg = new SpellingOptionsDlg(DataViewSpellCheckDlg.this);
            spellingOptionsDlg.setVisible(true);
            if (spellingOptionsDlg.wasOKAction()) {
                DataViewSpellCheckDlg.this.initDictionary();
            }
        }
    }
}

