/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class SyntaxFileTableModel
extends AbstractTableModel {
    protected static String[] COLUMN_NAMES = new String[1];
    private Vector<String> mData;
    private JTable mTable;

    public SyntaxFileTableModel(Vector<String> vector, JTable jTable) {
        this.mData = vector;
        this.mTable = jTable;
        this.resize();
    }

    @Override
    public int getRowCount() {
        return this.mData.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    public Object getValue(int n) {
        return this.mData.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0 && n >= 0 && n < this.getRowCount()) {
            return this.mData.get(n);
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        assert (n >= 0);
        String string = (String)object;
        if (n2 == 0) {
            if (n < this.getRowCount()) {
                if (string == null || string.trim().length() == 0) {
                    this.removeRow(n);
                } else {
                    this.mData.set(n, string);
                    this.fireTableCellUpdated(n, n2);
                }
            } else if (string != null && string.trim().length() > 0) {
                this.addRow(string);
            }
        }
    }

    private void resize() {
        Dimension dimension = this.mTable.getSize();
        dimension.height = this.getRowCount() * this.mTable.getRowHeight();
        this.mTable.setPreferredSize(dimension);
        this.mTable.setMinimumSize(dimension);
        this.mTable.setMaximumSize(dimension);
        this.mTable.invalidate();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    public void moveRow(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n < 0 || n > this.mData.size() || n3 < 0 || n3 > this.mData.size() || n == n3) {
            return;
        }
        if (n > n2) {
            n5 = n;
            n = n2;
            n2 = n5;
        }
        n5 = n3;
        int n6 = n2 - n + 1;
        if (n < n3) {
            n5 = n3 - n6 + 1;
        }
        String[] stringArray = new String[n6];
        for (n4 = n6 - 1; n4 >= 0; --n4) {
            stringArray[n4] = this.mData.get(n + n4);
            this.mData.remove(n + n4);
        }
        for (n4 = n6 - 1; n4 >= 0; --n4) {
            this.mData.insertElementAt(stringArray[n4], n5);
        }
    }

    public void addRow(String string) {
        this.mData.addElement(string);
        this.fireTableRowsInserted(this.mData.size() - 1, this.mData.size() - 1);
        this.resize();
        this.mTable.scrollRectToVisible(this.mTable.getCellRect(this.mData.size() - 1, 0, false));
        this.mTable.changeSelection(this.mData.size() - 1, 0, false, false);
    }

    public void removeRow(int n) {
        boolean bl = this.mTable.getSelectedRow() > -1;
        boolean bl2 = n > -1 && n == this.mData.size() - 1;
        this.mData.remove(n);
        this.fireTableRowsDeleted(n, n);
        this.resize();
        if (bl) {
            if (bl2) {
                --n;
            }
            this.mTable.scrollRectToVisible(this.mTable.getCellRect(n, 0, false));
            this.mTable.changeSelection(n, 0, false, false);
        }
    }
}

