/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.ui.dialogs.base.utilities.production.RuntimeValuesTableItem;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class RuntimeValuesTableModel
extends AbstractTableModel {
    private static int COLUMN_COUNT = 4;
    protected static String[] COLUMN_NAMES = new String[COLUMN_COUNT];
    private Vector<RuntimeValuesTableItem> mData;
    private JTable mTable;

    public RuntimeValuesTableModel(Vector<RuntimeValuesTableItem> vector, JTable jTable) {
        this.mData = vector;
        this.mTable = jTable;
        this.resize();
    }

    @Override
    public int getRowCount() {
        return this.mData.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    public Object getValue(int n) {
        return this.mData.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        RuntimeValuesTableItem runtimeValuesTableItem = this.mData.get(n);
        switch (n2) {
            case 0: {
                return runtimeValuesTableItem.getSymbol();
            }
            case 1: {
                return runtimeValuesTableItem.getDefaultValue();
            }
            case 2: {
                return runtimeValuesTableItem.getUserPrompt();
            }
            case 3: {
                return runtimeValuesTableItem.getQuoteValue();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Object object2;
        RuntimeValuesTableItem runtimeValuesTableItem = this.mData.get(n);
        if (n2 == 0) {
            object2 = (String)object;
            runtimeValuesTableItem.setSymbol((String)object2);
        } else if (n2 == 1) {
            object2 = (String)object;
            runtimeValuesTableItem.setDefaultValue((String)object2);
        } else if (n2 == 2) {
            object2 = (String)object;
            runtimeValuesTableItem.setUserPrompt((String)object2);
        } else if (n2 == 3) {
            object2 = (Boolean)object;
            runtimeValuesTableItem.setQuoteValue((Boolean)object2);
        }
        object2 = this.mData.get(this.getRowCount() - 1);
        if (((RuntimeValuesTableItem)object2).getSymbol().trim().length() > 0) {
            RuntimeValuesTableItem runtimeValuesTableItem2 = new RuntimeValuesTableItem("", "", "", false);
            this.addRow(runtimeValuesTableItem2);
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    private void resize() {
        Dimension dimension = this.mTable.getSize();
        dimension.height = this.getRowCount() * this.mTable.getRowHeight();
        this.mTable.setPreferredSize(dimension);
        this.mTable.setMinimumSize(dimension);
        this.mTable.setMaximumSize(dimension);
        this.mTable.repaint();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 != 0) {
            String string = (String)this.getValueAt(n, 0);
            return string != null && string.length() > 0;
        }
        return true;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n >= 0 && n < 3) {
            return String.class;
        }
        if (n == 3) {
            return Boolean.class;
        }
        return super.getColumnClass(n);
    }

    public void addRow(RuntimeValuesTableItem runtimeValuesTableItem) {
        this.mData.addElement(runtimeValuesTableItem);
        this.resize();
        this.mTable.changeSelection(this.mData.size() - 2, 1, false, false);
    }

    public void removeRow(int n) {
        this.mData.remove(n);
        if (this.mData.size() == 0) {
            this.mData.addElement(new RuntimeValuesTableItem("", "", "", false));
        }
        this.resize();
        this.mTable.changeSelection(n, 0, false, false);
    }
}

