/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.core.common.LogonMgr;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.ServerObject;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionJobDlg;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.LogonDlg;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class RunOptionsDlg
extends BaseDialog
implements ItemListener,
ActionListener {
    protected boolean mModalResult = false;
    private JRadioButton mInteractivelyRadio;
    private JRadioButton mBackgroundRadio;
    private JTextArea mInteractivelyHelpText;
    private JTextArea mBackgroundHelpText;
    private SpssButtonGroup mRunTypeButtonGrp;
    private JTextField mServerNameTextField;
    private JButton mSelectServerButton;
    private ServerObject mServerObject = null;
    protected ProductionJobDlg mParent;
    private JButton mHelpButton;
    private JButton mOkButton;
    private boolean mInitialized = false;
    private GridBagConstraints mGridConstraints;

    public RunOptionsDlg(ProductionJobDlg productionJobDlg) {
        super((BaseDialog)productionJobDlg, productionJobDlg.getResString("IDS_RUN_OPTIONS_TITLE"), true, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), UtilitiesResBundle.getImageFolder());
        this.mParent = productionJobDlg;
        this.setDefaultCloseOperation(2);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                RunOptionsDlg.this.mModalResult = false;
            }
        };
        this.addWindowListener(windowAdapter);
        this.setDefaults();
        this.loadDialogState();
        this.setInitialized(true);
        this.enableUIItems();
        this.pack();
        this.setLocationRelativeTo((Component)((Object)productionJobDlg));
    }

    public String getDialogHelpID() {
        return "idh_prod_run_options";
    }

    protected void loadDialogState() {
        BaseProcedureDialog.loadState(this.mParent.getDialogDataModel(), (Container)((Object)this), BaseProcedureDialog.NameLabelOption.no_override);
        this.loadState(this.mParent.getDialogDataModel());
    }

    protected void saveDialogState() {
        BaseProcedureDialog.saveState(this.mParent.getDialogDataModel(), (Container)((Object)this));
        this.saveState(this.mParent.getDialogDataModel());
        ProcedureDlgMgr.getMgr().savePersistentState(this.mParent.getIActionKey(), this.mParent.getDialogDataModel());
    }

    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putObject("STATISTICS_SERVER_KEY", this.mServerObject);
        return true;
    }

    protected void loadState(DialogDataModel dialogDataModel) {
        this.mServerObject = (ServerObject)dialogDataModel.getObject("STATISTICS_SERVER_KEY");
        LogonMgr logonMgr = LogonMgr.getLogonMgr();
        if (this.mServerObject == null) {
            this.mServerObject = DataServerProxy.getDataProxy().getServerObject();
            if (this.mServerObject == null || this.mServerObject.isLocalServer()) {
                this.mServerObject = logonMgr.getDefaultServer();
            }
        }
        if (this.mServerObject != null) {
            if (this.mServerObject.isLocalServer()) {
                this.mServerObject = null;
            } else {
                int n = logonMgr.getServerIndex(this.mServerObject);
                logonMgr.setCurrentServerIndex(n);
            }
        }
        this.setSeverNameField();
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.mOkButton = new JButton(new OkAction());
        JButton jButton = new JButton(new CancelAction());
        this.mHelpButton = new JButton((Action)this.createHelpAction());
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        FlowLayout flowLayout = new FlowLayout(1, n, 0);
        jPanel.setLayout(flowLayout);
        jPanel.add(this.mOkButton);
        jPanel.add(jButton);
        jPanel.add(this.mHelpButton);
        this.getRootPane().setDefaultButton(this.mOkButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.enableUIItems();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    protected void init() {
        super.init();
        this.initVars();
        this.setupPanel();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        super.init();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_RUN_OPTIONS_INTERACTIVELY");
        this.mInteractivelyRadio = new JRadioButton(toggleButtonAction);
        this.mInteractivelyRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_RUN_OPTIONS_BACKGROUND");
        this.mBackgroundRadio = new JRadioButton(toggleButtonAction);
        this.mBackgroundRadio.addItemListener(this);
        this.mRunTypeButtonGrp = new SpssButtonGroup();
        this.mRunTypeButtonGrp.add(this.mInteractivelyRadio);
        this.mRunTypeButtonGrp.add(this.mBackgroundRadio);
        this.mInteractivelyHelpText = new JTextArea(this.getResString("IDS_RUN_OPTIONS_INTERACTIVELY_HELP_MSG"));
        this.mInteractivelyHelpText.setLineWrap(true);
        this.mInteractivelyHelpText.setWrapStyleWord(true);
        this.mInteractivelyHelpText.setBorder(null);
        this.mInteractivelyHelpText.setOpaque(false);
        this.mInteractivelyHelpText.setFocusable(false);
        Dimension dimension = this.mInteractivelyHelpText.getPreferredSize();
        dimension.width = 400;
        this.mInteractivelyHelpText.setMinimumSize(dimension);
        this.mBackgroundHelpText = new JTextArea(this.getResString("IDS_RUN_OPTIONS_BACKGROUND_HELP_MSG"));
        this.mBackgroundHelpText.setLineWrap(true);
        this.mBackgroundHelpText.setWrapStyleWord(true);
        this.mBackgroundHelpText.setBorder(null);
        this.mBackgroundHelpText.setOpaque(false);
        this.mBackgroundHelpText.setFocusable(false);
        this.mGridConstraints = new GridBagConstraints();
    }

    private void setDefaults() {
        this.mBackgroundRadio.setSelected(false);
        this.mInteractivelyRadio.setSelected(true);
        if (VersionInfo.IsApplicationOnCloud()) {
            this.mBackgroundRadio.setEnabled(false);
            this.mBackgroundHelpText.setEnabled(false);
            this.mServerNameTextField.setEnabled(false);
        }
    }

    void enableUIItems() {
        if (this.isInitialized()) {
            if (this.mBackgroundRadio.isSelected()) {
                this.mSelectServerButton.setEnabled(true);
                boolean bl = this.mServerNameTextField.getText() != null && this.mServerNameTextField.getText().length() > 0;
                this.mOkButton.setEnabled(bl);
            } else {
                this.mSelectServerButton.setEnabled(false);
                this.mOkButton.setEnabled(true);
            }
        }
    }

    private void setupPanel() {
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupRadioPanel();
        JPanel jPanel3 = this.setupSelectServerPanel();
        int n = 23;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mGridConstraints, 0, 0, 1, 1, n, null);
        Insets insets = (Insets)new Insets(0, DialogUtil.getSubCheckboxGroupIndent(), 0, 0).clone();
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mGridConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel setupRadioPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n2 = DialogUtil.getSubCheckboxGroupIndent();
        int n3 = 23;
        Insets insets2 = new Insets(insets.top, n, insets.bottom, n);
        Insets insets3 = new Insets(insets.top, n + n2, insets.bottom, n);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_RUN_OPTIONS_TOP_LABEL");
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mGridConstraints, 0, 0, 1, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mInteractivelyRadio, this.mGridConstraints, 0, 1, 1, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mInteractivelyHelpText, this.mGridConstraints, 0, 2, 1, 1, n3, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mBackgroundRadio, this.mGridConstraints, 0, 3, 1, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mBackgroundHelpText, this.mGridConstraints, 0, 4, 1, 1, n3, insets3);
        return jPanel;
    }

    private JPanel setupSelectServerPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n = DialogUtil.getGroupBoxInnerMargin();
        this.mSelectServerButton = DialogUtil.createButton(this, "IDS_RUN_OPTIONS_SELECT_SERVER_BUTTON", this);
        this.mSelectServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunOptionsDlg.this.showLogonDlg();
            }
        });
        this.mServerNameTextField = new JTextField();
        this.mServerNameTextField.setAction(new TextFieldAction(this.mParent, "IDS_RUN_OPTIONS_SERVER_NAME_TEXT_FIELD_KEY"));
        this.mServerNameTextField.setEditable(false);
        this.mServerNameTextField.setOpaque(false);
        Dimension dimension = this.mServerNameTextField.getPreferredSize();
        dimension.width = 300;
        this.mServerNameTextField.setMinimumSize(dimension);
        this.mServerNameTextField.setPreferredSize(dimension);
        JLabel jLabel = new JLabel(this.getResString("IDS_RUN_OPTIONS_STATISTICS_SERVER_LABEL"));
        if (VersionInfo.IsApplicationOnCloud()) {
            jLabel.setEnabled(false);
        }
        Insets insets2 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        int n2 = 21;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, new Insets(insets2.top, n, insets.bottom, insets.right));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mServerNameTextField, gridBagConstraints, 1, 0, 1, 1, n2, new Insets(insets2.top, insets.left, insets.bottom, insets.right));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSelectServerButton, gridBagConstraints, 2, 0, 1, 1, n2, new Insets(insets2.top, insets.left, insets.bottom, n));
        return jPanel;
    }

    public void showLogonDlg() {
        boolean bl;
        LogonDlg logonDlg = new LogonDlg(null, true);
        logonDlg.setCursor(Cursor.getDefaultCursor());
        logonDlg.setVisible(true);
        boolean bl2 = bl = !logonDlg.getModalResult();
        if (!bl) {
            this.mServerObject = logonDlg.getSelectedServer();
        }
        this.setSeverNameField();
    }

    private void setSeverNameField() {
        String string = this.mServerObject != null ? this.mServerObject.getName() : "";
        this.mServerNameTextField.setText(string);
        this.enableUIItems();
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRunTypeButtonGrp);
        vector.add(this.mSelectServerButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    public boolean getModalResult() {
        return this.mModalResult;
    }

    public boolean runInteractively() {
        ToggleButtonAction toggleButtonAction = (ToggleButtonAction)this.mInteractivelyRadio.getAction();
        return this.mParent.getDialogDataModel().getBoolean(toggleButtonAction.getActionKey());
    }

    public ServerObject getServerObject() {
        return this.mServerObject;
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public void setInitialized(boolean bl) {
        this.mInitialized = bl;
    }

    public JButton getHelpButton() {
        return this.mHelpButton;
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RunOptionsDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RunOptionsDlg.this.dispose();
            RunOptionsDlg.this.mModalResult = false;
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RunOptionsDlg.this.saveDialogState();
            RunOptionsDlg.this.dispose();
            RunOptionsDlg.this.mModalResult = true;
        }
    }
}

