/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.production.ProductionSymbol;
import com.spss.java_client.ui.dialogs.base.utilities.production.UserPromptsTableModel;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;

public class ProductionUserPromptsDlg
extends BaseDialog {
    private LinkedHashMap<String, ProductionSymbol> mSymbols = null;
    private boolean mOk = false;
    private JTable mUserPromptsTable;
    private UserPromptsTableModel mUserPromptsTableModel;
    private JTableHeader mTableHeader;

    public ProductionUserPromptsDlg(JFrame jFrame, String string, LinkedHashMap<String, ProductionSymbol> linkedHashMap) {
        super(jFrame, true, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), UtilitiesResBundle.getImageFolder());
        this.mSymbols = linkedHashMap;
        this.loadUserPromptsTableModel(linkedHashMap);
        this.setTitle(String.format(ResUtil.getLocale(), this.getResString("IDS_PRODUCTION_USER_PROMPTS_TITLE"), string));
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    public String getDialogHelpID() {
        return "idh_prod_macro_prompt";
    }

    public boolean isOk() {
        return this.mOk;
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.setupViewPanel(gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.setTabPolicy();
        this.pack();
    }

    private JPanel setupViewPanel(GridBagConstraints gridBagConstraints) {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mUserPromptsTable = new JTable(){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    ((JTextComponent)component).selectAll();
                }
                return bl;
            }
        };
        this.mUserPromptsTable.getColumnModel().getSelectionModel().addListSelectionListener(new ColumnListener());
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (ProductionUserPromptsDlg.this.mUserPromptsTable.getSelectedColumn() < 1) {
                    int n = ProductionUserPromptsDlg.this.mUserPromptsTable.getSelectedRow();
                    if (n < 0) {
                        n = 0;
                    }
                    ProductionUserPromptsDlg.this.mUserPromptsTable.changeSelection(n, 1, false, false);
                }
            }
        };
        this.mUserPromptsTable.addFocusListener(focusAdapter);
        this.mTableHeader = this.mUserPromptsTable.getTableHeader();
        this.mUserPromptsTable.setTableHeader(null);
        this.mUserPromptsTableModel = new UserPromptsTableModel(this.mUserPromptsTable);
        this.mUserPromptsTable.setModel(this.mUserPromptsTableModel);
        this.mUserPromptsTable.setCellSelectionEnabled(true);
        this.mUserPromptsTable.getColumnModel().getColumn(0).setPreferredWidth(210);
        this.mUserPromptsTable.getColumnModel().getColumn(1).setPreferredWidth(140);
        this.mUserPromptsTable.setDefaultRenderer(Object.class, new UserPromptsTableRenderer());
        this.mUserPromptsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JScrollPane jScrollPane = new JScrollPane(this.mUserPromptsTable, 20, 31);
        Dimension dimension = new Dimension(350, 3 * this.mUserPromptsTable.getRowHeight() + 2);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        jScrollPane.setMaximumSize(dimension);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        int n = 10;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        return jPanel;
    }

    private void setTabPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mUserPromptsTable);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        JButton jButton = new JButton(new OkAction());
        JButton jButton2 = new JButton((Action)this.createCancelAction());
        JButton jButton3 = new JButton((Action)this.createHelpAction());
        if (UIToolDialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 4, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void loadUserPromptsTableModel(LinkedHashMap<String, ProductionSymbol> linkedHashMap) {
        Vector<UserPromptsTableItem> vector = this.mUserPromptsTableModel.getData();
        vector.clear();
        Set<Map.Entry<String, ProductionSymbol>> set = linkedHashMap.entrySet();
        for (Map.Entry<String, ProductionSymbol> entry : set) {
            ProductionSymbol productionSymbol = entry.getValue();
            String string = productionSymbol.hasPrompt() ? productionSymbol.getPrompt() : String.format("@%s", productionSymbol.getName());
            String string2 = productionSymbol.getDefault();
            UserPromptsTableItem userPromptsTableItem = new UserPromptsTableItem(string, string2);
            vector.addElement(userPromptsTableItem);
        }
        this.mUserPromptsTable.setPreferredSize(new Dimension(1000, this.mUserPromptsTable.getRowHeight() * vector.size()));
    }

    class ColumnListener
    implements ListSelectionListener {
        ColumnListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            if (ProductionUserPromptsDlg.this.mUserPromptsTable.getSelectedColumn() < 1) {
                ProductionUserPromptsDlg.this.mUserPromptsTable.changeSelection(ProductionUserPromptsDlg.this.mUserPromptsTable.getSelectedRow(), 1, false, false);
            }
        }
    }

    class UserPromptsTableItem {
        boolean mEnable = false;
        String mUserPrompt = "";
        String mDefaultValue = "";

        public UserPromptsTableItem(String string, String string2) {
            this.mUserPrompt = string;
            this.mDefaultValue = string2;
        }

        public String getDefaultValue() {
            return this.mDefaultValue;
        }

        public void setDefaultValue(String string) {
            this.mDefaultValue = string;
        }

        public String getUserPrompt() {
            return this.mUserPrompt;
        }

        public void setUserPrompt(String string) {
            this.mUserPrompt = string;
        }

        public boolean isEnabled() {
            return this.mEnable;
        }

        public void setEnabled(boolean bl) {
            this.mEnable = bl;
        }
    }

    class UserPromptsTableRenderer
    extends DefaultTableCellRenderer {
        private final Icon mIndentIcon = new ImageIcon(new BufferedImage(2, 16, 6));

        UserPromptsTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            UserPromptsTableModel userPromptsTableModel = (UserPromptsTableModel)jTable.getModel();
            UserPromptsTableItem userPromptsTableItem = (UserPromptsTableItem)userPromptsTableModel.getValue(n);
            if (n2 == 0) {
                component.setBackground(ProductionUserPromptsDlg.this.mTableHeader.getBackground());
                component.setForeground(ProductionUserPromptsDlg.this.mTableHeader.getForeground());
                ((JLabel)component).setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                ((JLabel)component).setToolTipText(userPromptsTableItem.getUserPrompt());
            } else {
                if (component.hasFocus()) {
                    ((JLabel)component).setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                }
                if (!bl) {
                    component.setBackground(jTable.getBackground());
                }
            }
            ((JLabel)component).setIcon(this.mIndentIcon);
            ((JLabel)component).setHorizontalAlignment(10);
            return component;
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Vector<UserPromptsTableItem> vector = ProductionUserPromptsDlg.this.mUserPromptsTableModel.getData();
            int n = 0;
            Set set = ProductionUserPromptsDlg.this.mSymbols.entrySet();
            for (Map.Entry entry : set) {
                ProductionSymbol productionSymbol = (ProductionSymbol)entry.getValue();
                UserPromptsTableItem userPromptsTableItem = vector.get(n++);
                productionSymbol.setDefault(userPromptsTableItem.getDefaultValue());
            }
            ProductionUserPromptsDlg.this.mOk = true;
            ProductionUserPromptsDlg.this.dispose();
        }
    }
}

