/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.production.ProductionOutput;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionJobDlg;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionOptionsDlg;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

class ProductionTextOptionsDlg
extends ProductionOptionsDlg
implements ItemListener,
FocusListener {
    static final String COLUMN_SEPARATORS = "IDS_PRODUCTION_TEXT_COLUMN_SEPARATORS";
    static final String COLUMN_WIDTH = "IDS_PRODUCTION_TEXT_COLUMN_WIDTH";
    private JLabel mColumnSeparatorsLabel;
    private JComboBox mColumnSeparatorCombo;
    private JLabel mRowBorderLabel;
    private StringTextField mRowBorderCharField;
    private JLabel mColumnBorderLabel;
    private StringTextField mColumnBorderCharField;
    private JLabel mColumnWidthLabel;
    private JRadioButton mColumnAutofitButton;
    private JRadioButton mColumnCustomButton;
    private JLabel mColumnInCharsLabel;
    private IntTextField mColumnInCharsField;
    private JLabel mImageTypeLabel;
    private JComboBox mImageTypeCombo;
    private String[] mGraphicsFileExtnSupportedArray;
    private JSpinner mImageSizeSpinner;
    private JLabel mImageSizeLabel;

    ProductionTextOptionsDlg(ProductionJobDlg productionJobDlg, String string, boolean bl) {
        super(productionJobDlg, string, bl);
    }

    @Override
    protected String getDialogHelpID() {
        return "idh_prod_expopt_text";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mColumnSeparatorCombo) {
            if (this.mColumnSeparatorCombo.getSelectedIndex() == 1) {
                this.mRowBorderCharField.setEnabled(false);
                this.mColumnBorderCharField.setEnabled(false);
                this.mColumnAutofitButton.setEnabled(false);
                this.mColumnCustomButton.setEnabled(false);
                this.mColumnInCharsField.setEnabled(false);
            } else if (this.mColumnSeparatorCombo.getSelectedIndex() == 0) {
                this.mRowBorderCharField.setEnabled(true);
                this.mColumnBorderCharField.setEnabled(true);
                this.mColumnAutofitButton.setEnabled(true);
                this.mColumnCustomButton.setEnabled(true);
                if (this.mColumnAutofitButton.isSelected()) {
                    this.mColumnInCharsField.setEnabled(false);
                } else {
                    this.mColumnInCharsField.setEnabled(true);
                }
            }
        } else if (itemEvent.getSource() == this.mColumnAutofitButton) {
            if (this.mColumnAutofitButton.isSelected()) {
                this.mColumnInCharsField.setEnabled(false);
            } else {
                this.mColumnInCharsField.setEnabled(true);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mColumnSeparatorCombo) {
            if (this.getOptions().getTableColumnSeparator() == ProductionOutput.TableColumnSeparator.TAB && this.mColumnSeparatorCombo.getSelectedIndex() == 0 || this.getOptions().getTableColumnSeparator() != ProductionOutput.TableColumnSeparator.TAB && this.mColumnSeparatorCombo.getSelectedIndex() == 1) {
                this.mParent.setModified(true);
            }
        } else if (focusEvent.getSource() == this.mRowBorderCharField) {
            if (!this.mRowBorderCharField.getText().equals("-") && this.getOptions().getTableRowBorder() == null || !this.mRowBorderCharField.getText().equals(this.getOptions().getTableRowBorder().toString())) {
                this.mParent.setModified(true);
            }
        } else if (focusEvent.getSource() == this.mColumnBorderCharField) {
            if (!this.mColumnBorderCharField.getText().equals("|") && this.getOptions().getTableColumnBorder() == null || !this.mColumnBorderCharField.getText().equals(this.getOptions().getTableColumnBorder().toString())) {
                this.mParent.setModified(true);
            }
        } else if (focusEvent.getSource() == this.mColumnAutofitButton) {
            if (this.mColumnAutofitButton.isSelected() && this.getOptions().getTableColumnAutofit() != null && !this.getOptions().getTableColumnAutofit().booleanValue()) {
                this.mParent.setModified(true);
            }
        } else if (focusEvent.getSource() == this.mColumnCustomButton) {
            if (this.mColumnCustomButton.isSelected() && (this.getOptions().getTableColumnAutofit() == null || this.getOptions().getTableColumnAutofit().booleanValue())) {
                this.mParent.setModified(true);
            }
        } else if (focusEvent.getSource() == this.mColumnInCharsField) {
            if (!this.mColumnInCharsField.getText().equals("15") && this.getOptions().getTableColumnWidth() == null || !this.mColumnInCharsField.getText().equals(this.getOptions().getTableColumnWidth().toString())) {
                this.mParent.setModified(true);
            }
        } else if (focusEvent.getSource() == this.mImageTypeCombo) {
            ProductionOutput.ImageFormat imageFormat = this.getOptions().getImageFormat();
            if (this.getImageFormatIndex(imageFormat) != this.mImageTypeCombo.getSelectedIndex()) {
                this.mParent.setModified(true);
            }
        } else if (focusEvent.getSource() == this.mImageSizeSpinner.getEditor() && this.getOptions().getImageSize() != this.mImageSizeSpinner.getValue()) {
            this.mParent.setModified(true);
        }
    }

    @Override
    public boolean continuePressed() {
        if (((JTextField)this.mImageSizeSpinner.getEditor()).getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MESSAGE"), 1, 200), VersionInfo.getAppVersionString());
            this.mImageSizeSpinner.setValue(100);
            this.mImageSizeSpinner.requestFocus();
            return false;
        }
        int n = Integer.valueOf(((IntTextField)this.mImageSizeSpinner.getEditor()).getText());
        if (n < 1 || n > 200) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MESSAGE"), 1, 200), VersionInfo.getAppVersionString());
            this.mImageSizeSpinner.setValue(100);
            this.mImageSizeSpinner.requestFocus();
            return false;
        }
        this.saveOptions();
        return true;
    }

    @Override
    protected Vector<Object> getTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mColumnSeparatorCombo);
        vector.add(this.mRowBorderCharField);
        vector.add(this.mColumnBorderCharField);
        vector.add(this.mColumnAutofitButton);
        vector.add(this.mColumnCustomButton);
        vector.add(this.mColumnInCharsField);
        vector.add(this.mImageTypeCombo);
        vector.add(this.mImageSizeSpinner.getEditor());
        return vector;
    }

    @Override
    protected void loadOptions() {
        ProductionOutput.TableColumnSeparator tableColumnSeparator = this.getOptions().getTableColumnSeparator();
        if (tableColumnSeparator == ProductionOutput.TableColumnSeparator.NULL) {
            tableColumnSeparator = ProductionOutput.TableColumnSeparator.SPACE;
            this.getOptions().setTableColumnSeparator(tableColumnSeparator);
        }
        if (tableColumnSeparator == ProductionOutput.TableColumnSeparator.SPACE) {
            this.mRowBorderCharField.setEnabled(true);
            this.mColumnBorderCharField.setEnabled(true);
            this.mColumnSeparatorCombo.setSelectedIndex(0);
        } else if (tableColumnSeparator == ProductionOutput.TableColumnSeparator.TAB) {
            this.mRowBorderCharField.setEnabled(false);
            this.mColumnBorderCharField.setEnabled(false);
            this.mColumnSeparatorCombo.setSelectedIndex(1);
        }
        Character c = this.getOptions().getTableRowBorder();
        if (c == null) {
            c = Character.valueOf('-');
            this.getOptions().setTableRowBorder(c);
        }
        this.mRowBorderCharField.setText(c.toString());
        Character c2 = this.getOptions().getTableColumnBorder();
        if (c2 == null) {
            c2 = Character.valueOf('|');
            this.getOptions().setTableColumnBorder(c2);
        }
        this.mColumnBorderCharField.setText(c2.toString());
        Boolean bl = this.getOptions().getTableColumnAutofit();
        if (bl == null) {
            bl = true;
            this.getOptions().setTableColumnAutofit(Boolean.valueOf(true));
        }
        this.mColumnAutofitButton.setSelected(bl);
        this.mColumnCustomButton.setSelected(bl == false);
        this.mColumnInCharsField.setEnabled(bl == false);
        Integer n = this.getOptions().getTableColumnWidth();
        if (n == null) {
            n = 15;
            this.getOptions().setTableColumnWidth(n);
        }
        this.mColumnInCharsField.setText(n.toString());
        ProductionOutput.ImageFormat imageFormat = this.getOptions().getImageFormat();
        if (imageFormat == ProductionOutput.ImageFormat.NULL) {
            imageFormat = ProductionOutput.ImageFormat.JPG;
            this.getOptions().setImageFormat(ProductionOutput.ImageFormat.JPG);
        }
        this.mImageTypeCombo.setSelectedIndex(this.getImageFormatIndex(imageFormat));
        Integer n2 = this.getOptions().getImageSize();
        if (n2 == null) {
            n2 = 100;
            this.getOptions().setImageSize(n2);
        }
        this.mImageSizeSpinner.getModel().setValue(n2);
    }

    @Override
    protected void saveOptions() {
        if (this.mColumnSeparatorCombo.getSelectedIndex() == 0) {
            this.getOptions().setTableColumnSeparator(ProductionOutput.TableColumnSeparator.SPACE);
            String string = this.mRowBorderCharField.getText();
            if (string.length() > 0) {
                this.getOptions().setTableRowBorder(Character.valueOf(this.mRowBorderCharField.getText().charAt(0)));
            }
            if ((string = this.mColumnBorderCharField.getText()).length() > 0) {
                this.getOptions().setTableColumnBorder(Character.valueOf(this.mColumnBorderCharField.getText().charAt(0)));
            }
        } else if (this.mColumnSeparatorCombo.getSelectedIndex() == 1) {
            this.getOptions().setTableColumnSeparator(ProductionOutput.TableColumnSeparator.TAB);
        } else {
            this.getOptions().setTableColumnSeparator(ProductionOutput.TableColumnSeparator.NULL);
        }
        if (this.mColumnAutofitButton.isSelected()) {
            this.getOptions().setTableColumnAutofit(Boolean.valueOf(true));
        } else {
            this.getOptions().setTableColumnAutofit(Boolean.valueOf(false));
            this.getOptions().setTableColumnWidth(new Integer(this.mColumnInCharsField.getText()));
        }
        this.getOptions().setImageSize((Integer)this.mImageSizeSpinner.getModel().getValue());
        this.getOptions().setImageFormat(this.getImageFormatFrom(this.mGraphicsFileExtnSupportedArray[this.mImageTypeCombo.getSelectedIndex()]));
    }

    @Override
    protected JPanel setupTableOptionPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_PRODUCTION_TABLE_OPTIONS_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, 0, n3);
        DialogUtil.addUsingGBL(jPanel, this.mColumnSeparatorsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, 0, 0, n2 * 3);
        DialogUtil.addUsingGBL(jPanel, this.mColumnSeparatorCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, 0, n3);
        DialogUtil.addUsingGBL(jPanel, this.mRowBorderLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, 0, 0, n2 * 3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mRowBorderCharField), gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mColumnBorderLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n3, 0, n2, n2 * 3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mColumnBorderCharField), gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n3, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.setupColumnWidthPanel(), gridBagConstraints, 0, 3, 2, 1, n, insets);
        return jPanel;
    }

    @Override
    protected JPanel setupImagePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_PRODUCTION_IMAGE_OPTIONS_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets = new Insets(n + 4, n, 0, n);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mImageTypeLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.set(n + 4, n, 0, n * 3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mImageTypeCombo, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        insets.set(n * 2 + 4, n, n * 2, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mImageSizeLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        insets.set(n * 2 + 4, n, n * 2, n);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mImageSizeSpinner, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        return jPanel;
    }

    @Override
    protected void initVars() {
        Object object;
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        this.mColumnSeparatorsLabel = DialogUtil.createLabel(this, "IDS_PRODUCTION_TEXT_COLUMN_SEP");
        this.mColumnSeparatorCombo = new JComboBox<String>(this.getResStringArray(COLUMN_SEPARATORS));
        this.mColumnSeparatorCombo.addItemListener(this);
        this.mColumnSeparatorCombo.addFocusListener(this);
        this.mColumnSeparatorCombo.setAction(new ComboboxAction(this, COLUMN_SEPARATORS));
        ((JTextField)this.mColumnSeparatorCombo.getEditor().getEditorComponent()).setOpaque(false);
        this.mColumnSeparatorsLabel.setLabelFor(this.mColumnSeparatorCombo);
        this.mRowBorderLabel = DialogUtil.createLabel(this, "IDS_PRODUCTION_TEXT_ROW_BORDER_CHAR");
        this.mRowBorderCharField = new StringTextField("-");
        this.mRowBorderCharField.addFocusListener(this);
        this.mRowBorderCharField.setColumns(3);
        this.mRowBorderLabel.setLabelFor((Component)((Object)this.mRowBorderCharField));
        this.mColumnBorderLabel = DialogUtil.createLabel(this, "IDS_PRODUCTION_TEXT_COLUMN_BORDER_CHAR");
        this.mColumnBorderCharField = new StringTextField("|");
        this.mColumnBorderCharField.addFocusListener(this);
        this.mColumnBorderCharField.setColumns(3);
        this.mColumnBorderLabel.setLabelFor((Component)((Object)this.mColumnBorderCharField));
        this.mColumnWidthLabel = DialogUtil.createLabel(this, COLUMN_WIDTH);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_PRODUCTION_TEXT_COLUMN_AUTOFIT");
        this.mColumnAutofitButton = new JRadioButton(toggleButtonAction);
        this.mColumnAutofitButton.addItemListener(this);
        this.mColumnAutofitButton.addFocusListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_PRODUCTION_TEXT_COLUMN_CUSTOM");
        this.mColumnCustomButton = new JRadioButton(toggleButtonAction);
        this.mColumnCustomButton.addItemListener(this);
        this.mColumnCustomButton.addFocusListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mColumnAutofitButton);
        spssButtonGroup.add(this.mColumnCustomButton);
        this.mColumnInCharsLabel = DialogUtil.createLabel(this, "IDS_PRODUCTION_TEXT_COLUMN_NUM_CHARS");
        this.mColumnInCharsField = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mColumnInCharsField.setAction((Action)new TextFieldAction(this, COLUMN_WIDTH));
        this.mColumnInCharsField.setColumns(4);
        this.mColumnInCharsField.addFocusListener((FocusListener)this);
        this.mColumnInCharsLabel.setLabelFor((Component)this.mColumnInCharsField);
        this.mImageTypeLabel = DialogUtil.createLabel(this, "IDS_PRODUCTION_IMAGE_TYPE");
        String[] stringArray = resourceBundle.getStringArray("IDS_EXPORTOUTPUT_GRAPHICS_TYPE_COMBO");
        String[] stringArray2 = resourceBundle.getStringArray("IDS_EXPORTOUTPUT_GRAPHICS_FILTER_EXTN");
        if (OSCheck.getOSType() != OSInfo.OSType.WIN) {
            int n;
            object = new String[stringArray.length - 1];
            int n2 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                if (n == 1) continue;
                object[n2] = stringArray[n];
                ++n2;
            }
            this.mImageTypeCombo = new JComboBox<String>((E[])object);
            n2 = 0;
            for (n = 0; n < stringArray2.length; ++n) {
                if (n == 1) continue;
                object[n2] = stringArray2[n];
                ++n2;
            }
            this.mGraphicsFileExtnSupportedArray = object;
        } else {
            this.mImageTypeCombo = new JComboBox<String>(stringArray);
            this.mGraphicsFileExtnSupportedArray = stringArray2;
        }
        this.mImageTypeCombo.setPreferredSize(new Dimension(200, this.mImageTypeCombo.getPreferredSize().height));
        this.mImageTypeCombo.addFocusListener(this);
        this.mImageTypeCombo.setAction(new ComboboxAction(this, "GRAPHICS_COMBO_KEY"));
        this.mImageTypeLabel.setLabelFor(this.mImageTypeCombo);
        this.mImageSizeLabel = new JLabel(this.getResString("IDS_PRODUCTION_IMAGE_SIZE"));
        object = new SpinnerNumberModel(100, 1, 200, 1);
        IntTextField intTextField = new IntTextField(true);
        intTextField.setAction((Action)new TextFieldAction(this, "IMAGE_SIZE_KEY"));
        this.mImageSizeSpinner = new NumberSpinner(intTextField, (SpinnerNumberModel)object);
        this.mImageSizeSpinner.getEditor().addFocusListener(this);
        this.mImageSizeLabel.setLabelFor(this.mImageSizeSpinner);
    }

    private JPanel setupColumnWidthPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, 0, insets.bottom, insets.right);
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mColumnWidthLabel, gridBagConstraints, 0, 0, 2, 1, n2, insets2);
        insets2.set(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mColumnAutofitButton, gridBagConstraints, 0, 1, 2, 1, n2, insets2);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mColumnCustomButton, gridBagConstraints, 0, 2, 2, 1, n2, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets2.set(insets.top, n * 3, insets.bottom, n);
        DialogUtil.addUsingGBL(jPanel, this.mColumnInCharsLabel, gridBagConstraints, 0, 3, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets2.set(insets.top, n, n, n * 3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mColumnInCharsField, gridBagConstraints, 1, 3, 1, 1, n2, insets2);
        return jPanel;
    }
}

