/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.production.ProductionDocument;
import com.spss.java_client.core.documents.production.ProductionSymbol;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionJobDlg;
import com.spss.java_client.ui.dialogs.base.utilities.production.RuntimeValuesTableItem;
import com.spss.java_client.ui.dialogs.base.utilities.production.RuntimeValuesTableModel;
import com.spss.java_client.ui.dialogs.common.BaseSpssTab;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.JTextComponent;

public class ProductionRuntimeTab
extends BaseSpssTab
implements ActionListener,
FocusListener,
TableModelListener {
    public final int OUTPUT_FILE_TEXT_FIELD_SIZE = 25;
    private Border mDefaultScrollPaneBorder = UIManager.getBorder("Table.ScrollPaneBorder");
    private PlainTable mRuntimeValuesTable;
    private RuntimeValuesTableModel mRuntimeValuesTableModel;
    private JScrollPane mRuntimeValuesTableScrollPane;
    private JTextArea mNote;
    ProductionJobDlg mParentDlg;

    public ProductionRuntimeTab(ProductionJobDlg productionJobDlg, boolean bl) {
        super(productionJobDlg, bl);
        this.mParentDlg = productionJobDlg;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prod_substitute";
    }

    @Override
    public void reset() {
        super.reset();
        this.loadTabState(null);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVariables();
        this.setupPanel();
        this.loadTabState(null);
        this.enableUIItems();
        this.setFocusTraversalPolicy();
    }

    void enableUIItems() {
        this.enableRuntimeValuesTable();
    }

    private boolean enableRuntimeValuesTable() {
        boolean bl = this.mParentDlg != null && this.mParentDlg.hasDocument();
        this.mRuntimeValuesTable.setEnabled(bl);
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.mParentDlg.setModified(true);
    }

    private void initVariables() {
        this.mNote = new JTextArea(this.getResString("IDS_PRODUCTION_JOB_RUNTIME_VALUES_TAB_NOTE"));
        this.mNote.setLineWrap(true);
        this.mNote.setWrapStyleWord(true);
        this.mNote.setBorder(null);
        this.mNote.setOpaque(false);
        this.mNote.setFocusable(false);
        this.mNote.setPreferredSize(new Dimension(400, 70));
        Font font = this.mParent.getFont();
        if (font != null) {
            this.mNote.setFont(font);
        }
        this.mRuntimeValuesTable = new PlainTable(){
            private int mRow = -1;
            private int mCol = -1;

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                if (!bl) {
                    return false;
                }
                Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    ((JTextComponent)component).selectAll();
                }
                return bl;
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                this.mRow = this.getSelectedRow();
                this.mCol = this.getSelectedColumn();
                super.editingStopped(changeEvent);
                this.validateSymbol();
            }

            private void validateSymbol() {
                if (this.mCol == 0 && this.mRow != -1) {
                    String string = (String)ProductionRuntimeTab.this.mRuntimeValuesTable.getValueAt(this.mRow, this.mCol);
                    if (string == null || string.trim().length() == 0) {
                        ProductionRuntimeTab.this.mRuntimeValuesTableModel.removeRow(this.mRow);
                    } else if (string.charAt(0) != '@') {
                        String string2 = ProductionRuntimeTab.this.getResString("ERR_PRODUCTION_JOB_RUNTIME_VALUES_TAB_SYMBOL_ERROR");
                        SpssAlertOptionPane.showConfirmDialog((Window)((Object)ProductionRuntimeTab.this.mParentDlg), string2, VersionInfo.getAppVersionString(), null);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.changeSelection(mRow, mCol, false, false);
                                this.editCellAt(mRow, mCol, null);
                                this.getEditorComponent().requestFocusInWindow();
                            }
                        });
                    } else {
                        ProductionSymbol productionSymbol = new ProductionSymbol();
                        productionSymbol.setName(string.substring(1));
                        if (!productionSymbol.validateName()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this.changeSelection(mRow, mCol, false, false);
                                    this.editCellAt(mRow, mCol, null);
                                    this.getEditorComponent().requestFocusInWindow();
                                }
                            });
                        }
                    }
                }
            }
        };
        this.mRuntimeValuesTable.setSelectionMode(0);
        this.mRuntimeValuesTable.setRowSelectionAllowed(false);
        this.mRuntimeValuesTable.setCellSelectionEnabled(true);
        this.mRuntimeValuesTable.setAutoResizeMode(3);
        RuntimeValuesTableModel.COLUMN_NAMES[0] = this.getResString("IDS_PRODUCTION_JOB_RUNTIME_VALUES_TAB_TABLE_COLUMN_HEADER_1");
        RuntimeValuesTableModel.COLUMN_NAMES[1] = this.getResString("IDS_PRODUCTION_JOB_RUNTIME_VALUES_TAB_TABLE_COLUMN_HEADER_2");
        RuntimeValuesTableModel.COLUMN_NAMES[2] = this.getResString("IDS_PRODUCTION_JOB_RUNTIME_VALUES_TAB_TABLE_COLUMN_HEADER_3");
        RuntimeValuesTableModel.COLUMN_NAMES[3] = this.getResString("IDS_PRODUCTION_JOB_RUNTIME_VALUES_TAB_TABLE_COLUMN_HEADER_4");
        this.loadRuntimeValuesTableModel(null);
        this.mRuntimeValuesTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.mRuntimeValuesTable.putClientProperty("terminateEditOnFocusLost", Boolean.FALSE);
        this.mRuntimeValuesTable.setPreferredSize(new Dimension(500, this.mRuntimeValuesTable.getRowHeight() * this.mRuntimeValuesTable.getRowCount()));
        this.mRuntimeValuesTable.getTableHeader().setPreferredSize(new Dimension(500, this.mRuntimeValuesTable.getRowHeight()));
        if (this.mRuntimeValuesTableScrollPane == null) {
            this.mRuntimeValuesTableScrollPane = new JScrollPane(this.mRuntimeValuesTable, 20, 31);
        }
        this.mRuntimeValuesTableScrollPane.setBorder(this.mDefaultScrollPaneBorder);
        this.sizeRuntimeValuesTable();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mRuntimeValuesTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mRuntimeValuesTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mRuntimeValuesTable.getActionMap().put("tabIn", abstractAction2);
        this.mRuntimeValuesTable.getActionMap().put("tabOut", abstractAction);
    }

    private void setupPanel() {
        this.setLayout(new GridBagLayout());
        Insets insets = (Insets)DialogUtil.getStandardDialogInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        int n = 10;
        DialogUtil.addUsingGBL(this, this.mNote, gridBagConstraints, 0, 0, 1, 1, n, new Insets(insets.top, insets.left + 15, 0, 0));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        n = 23;
        DialogUtil.addUsingGBL(this, this.mRuntimeValuesTableScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mRuntimeValuesTable);
        this.mComponentOrder.add(((ProductionJobDlg)this.mParent).getCloseButton());
        this.mComponentOrder.add(((ProductionJobDlg)this.mParent).getHelpButton());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mRuntimeValuesTable) {
            // empty if block
        }
    }

    @Override
    protected boolean validateTab() {
        if (this.mRuntimeValuesTable.isEditing()) {
            this.mRuntimeValuesTable.getCellEditor().stopCellEditing();
        }
        return super.validateTab();
    }

    void loadTabState(ProductionDocument productionDocument) {
        this.loadRuntimeValuesTableModel(productionDocument);
        this.sizeRuntimeValuesTable();
    }

    void saveTabState(ProductionDocument productionDocument) {
        if (productionDocument == null) {
            return;
        }
        this.saveRuntimeValuesTableModel(productionDocument);
    }

    private void saveRuntimeValuesTableModel(ProductionDocument productionDocument) {
        if (productionDocument == null) {
            return;
        }
        LinkedHashMap linkedHashMap = productionDocument.getJob().getSymbols();
        linkedHashMap.clear();
        for (int i = 0; i < this.mRuntimeValuesTableModel.getRowCount(); ++i) {
            String string = (String)this.mRuntimeValuesTableModel.getValueAt(i, 0);
            if (string == null || string.length() <= 0) continue;
            ProductionSymbol productionSymbol = new ProductionSymbol();
            String string2 = string.substring(1);
            productionSymbol.setName(string2);
            productionSymbol.setDefault((String)this.mRuntimeValuesTableModel.getValueAt(i, 1));
            productionSymbol.setPrompt((String)this.mRuntimeValuesTableModel.getValueAt(i, 2));
            productionSymbol.setQuoteValue(((Boolean)this.mRuntimeValuesTableModel.getValueAt(i, 3)).booleanValue());
            linkedHashMap.put(string2, productionSymbol);
        }
    }

    private void loadRuntimeValuesTableModel(ProductionDocument productionDocument) {
        Vector<RuntimeValuesTableItem> vector = new Vector<RuntimeValuesTableItem>();
        if (productionDocument != null) {
            TableModelListener[] tableModelListenerArray = this.mRuntimeValuesTableModel.getTableModelListeners();
            for (TableModelListener object : tableModelListenerArray) {
                this.mRuntimeValuesTableModel.removeTableModelListener(object);
            }
            LinkedHashMap linkedHashMap = productionDocument.getJob().getSymbols();
            Set set = linkedHashMap.entrySet();
            for (Map.Entry entry : set) {
                ProductionSymbol productionSymbol = (ProductionSymbol)entry.getValue();
                vector.addElement(new RuntimeValuesTableItem(String.format("@%s", productionSymbol.getName()), productionSymbol.getDefault(), productionSymbol.getPrompt(), productionSymbol.quoteValue()));
            }
            vector.addElement(new RuntimeValuesTableItem("", "", "", false));
        } else {
            vector.addElement(new RuntimeValuesTableItem("", "", "", false));
        }
        this.mRuntimeValuesTableModel = new RuntimeValuesTableModel(vector, this.mRuntimeValuesTable);
        this.mRuntimeValuesTableModel.addTableModelListener(this);
        this.mRuntimeValuesTable.setModel(this.mRuntimeValuesTableModel);
    }

    private void sizeRuntimeValuesTable() {
        this.mRuntimeValuesTable.getColumnModel().getColumn(0).setPreferredWidth(65);
        this.mRuntimeValuesTable.getColumnModel().getColumn(1).setPreferredWidth(65);
        this.mRuntimeValuesTable.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.mRuntimeValuesTable.getColumnModel().getColumn(3).setPreferredWidth(65);
        int n = this.mRuntimeValuesTable.getRowCount() + 1;
        Dimension dimension = this.mRuntimeValuesTableScrollPane.getSize();
        dimension.height = n * this.mRuntimeValuesTable.getRowHeight() + 2;
        this.mRuntimeValuesTableScrollPane.setPreferredSize(dimension);
        dimension.height = 2 * this.mRuntimeValuesTable.getRowHeight() + 2;
        this.mRuntimeValuesTableScrollPane.setMinimumSize(dimension);
        dimension.height = 17 * this.mRuntimeValuesTable.getRowHeight() + 2;
        this.mRuntimeValuesTableScrollPane.setMaximumSize(dimension);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.mParentDlg.setModified(true);
    }
}

