/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ProductionRunOutput
extends BaseDialog {
    private Process mProcess = null;
    private String mName = null;
    private JProgressBar mProgressBar = null;
    private boolean mCancel = false;
    private JTextArea mText = null;
    private JButton mCloseButton = null;
    private JButton mCancelButton = null;

    public ProductionRunOutput(JDialog jDialog, String string, Process process, Vector<String> vector, String string2) {
        super(jDialog, string, false, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), UtilitiesResBundle.getImageFolder());
        this.setDefaultCloseOperation(0);
        this.mProcess = process;
        this.mName = string2;
        this.init(vector);
    }

    private void init(Vector<String> vector) {
        super.init();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ProductionRunOutput.this.close();
            }
        });
        this.setPreferredSize(new Dimension(400, 300));
        this.mProgressBar = new JProgressBar();
        this.mProgressBar.setIndeterminate(true);
        this.mText = new JTextArea(5, 30);
        this.mText.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.mText);
        for (String string : vector) {
            this.mText.append(string + ' ');
        }
        this.mText.append("\n\n");
        this.add(this.mProgressBar, "North");
        this.add(jScrollPane, "Center");
        this.consume();
        this.finish();
        this.pack();
        this.setLocationByPlatform(true);
        this.setVisible(true);
    }

    protected JPanel setupCmdButtonPanel() {
        this.mCloseButton = new JButton(new CloseAction());
        this.mCloseButton.setEnabled(false);
        this.mCancelButton = new JButton(new CancelAction());
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        if (UIToolDialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                DialogUtil.addUsingGBL(jPanel, this.mCloseButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mCloseButton);
                jPanel.add(this.mCancelButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mCloseButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCancelButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mCloseButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void consume() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    InputStream inputStream = ProductionRunOutput.this.mProcess.getInputStream();
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        final String string2 = string;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProductionRunOutput.this.mText.append(string2 + '\n');
                            }
                        });
                        string = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        new Thread(runnable).start();
    }

    private void finish() {
        ProductionRunOutput productionRunOutput = this;
        Runnable runnable = new Runnable((JDialog)((Object)productionRunOutput)){
            final /* synthetic */ JDialog val$parent;
            {
                this.val$parent = jDialog;
            }

            @Override
            public void run() {
                try {
                    ProductionRunOutput.this.mProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProductionRunOutput.this.mText.append(String.format(ResUtil.getLocale(), ResUtil.getString(ProductionRunOutput.this.mResBundle, "IDS_PRODUCTION_RUN_JOB_TERMINATED"), ProductionRunOutput.this.mName, ProductionRunOutput.this.mProcess.exitValue()));
                        ProductionRunOutput.this.mProgressBar.setIndeterminate(false);
                        ProductionRunOutput.this.mCancelButton.setEnabled(false);
                        ProductionRunOutput.this.mCloseButton.setEnabled(true);
                        if (!ProductionRunOutput.this.mCancel) {
                            JOptionPane.showMessageDialog(val$parent, String.format(ResUtil.getLocale(), ResUtil.getString(ProductionRunOutput.this.mResBundle, "IDS_PRODUCTION_RUN_JOB_FINISH"), ProductionRunOutput.this.mName));
                        }
                    }
                });
            }
        };
        new Thread(runnable).start();
    }

    public void doHelp() {
    }

    private void cancel() {
        this.mCancel = true;
        this.mProcess.destroy();
    }

    private void close() {
        this.cancel();
        this.dispose();
    }

    public synchronized boolean abort() {
        return this.mCancel;
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CLOSE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProductionRunOutput.this.close();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ProductionRunOutput.this.getResString("IDS_PRODUCTION_STOP"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", ProductionRunOutput.this.getDlgAccessKey("IDK_PRODUCTION_STOP_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProductionRunOutput.this.cancel();
        }
    }
}

