/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.core.common.ClusterMgr;
import com.spss.java_client.core.server.ClusterObject;
import com.spss.java_client.core.server.ServerObject;
import com.spss.java_client.ui.dialogs.base.utilities.production.BaseProgressDialog;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionRunOutput;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ProductionRunJob
extends Thread {
    private ResourceBundle mResBundle = null;
    private String mName;
    private File mJob;
    private String mStrClientHost;
    private Boolean mInteractive;
    private Boolean mUseUnicode;
    private Boolean mUseCodepageSyntaxFiles;
    private ServerObject mServer;
    private JDialog mParent = null;
    private Process mProcess;

    public ProductionRunJob(JDialog jDialog, String string, File file, Boolean bl, Boolean bl2, Boolean bl3, ServerObject serverObject) {
        super(string);
        this.mName = string;
        this.mJob = file;
        this.mParent = jDialog;
        this.mInteractive = bl;
        this.mUseUnicode = bl2;
        this.mUseCodepageSyntaxFiles = bl3;
        this.mServer = serverObject;
        this.mResBundle = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        this.start();
    }

    @Override
    public void run() {
        try {
            Object object;
            Object object2;
            StringBuffer stringBuffer = new StringBuffer(System.getProperty("application.home"));
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                stringBuffer.append(File.separator).append("..").append(File.separator).append("MacOS");
            }
            stringBuffer.append(File.separator).append("stats");
            if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
                stringBuffer.append(".com");
            }
            Vector<String> vector = new Vector<String>();
            vector.add(stringBuffer.toString());
            vector.add("-production");
            vector.add("-unicode");
            vector.add(this.mUseUnicode != false ? " on" : " off");
            if (this.mUseCodepageSyntaxFiles.booleanValue()) {
                vector.add("-codepageSyntaxFiles");
                vector.add(this.mUseCodepageSyntaxFiles != false ? " on" : " off");
            }
            if (!this.mInteractive.booleanValue()) {
                vector.add("-background");
                vector.add("-server");
                this.mStrClientHost = "";
                if (this.mServer instanceof ClusterObject) {
                    object2 = (ClusterObject)this.mServer;
                    this.mServer = ClusterMgr.getClusterMgr().getServerObjectForCluster((ClusterObject)object2);
                }
                this.mStrClientHost = this.mServer.getSslProtocolType() == ServerObject.SslProtocolType.SslNotUsed ? "inet:" : "ssl:";
                this.mStrClientHost = this.mStrClientHost + this.mServer.getName() + ":" + Integer.toString(this.mServer.getPort());
                vector.add(this.mStrClientHost);
                object = this.mServer.getDomain();
                object2 = object != null && ((String)object).length() > 0 ? (String)object + "\\" + this.mServer.getUserID() : this.mServer.getUserID();
                vector.add("-user");
                vector.add((String)object2);
                String string = this.mServer.getPassword();
                vector.add("-password");
                vector.add(string);
            }
            vector.add(this.mJob.getCanonicalPath());
            object2 = new ProcessBuilder(vector);
            ((ProcessBuilder)object2).redirectErrorStream(true);
            object = ((ProcessBuilder)object2).start();
            this.notifyStart((Process)object, vector);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void notifyStart(Process process, Vector<String> vector) {
        if (this.mInteractive.booleanValue()) {
            this.mParent.setEnabled(false);
            String string = String.format(ResUtil.getLocale(), ResUtil.getString(this.mResBundle, "IDS_PRODUCTION_RUN_JOB_START"), this.mName);
            new ProductionRunOutput(this.mParent, string, process, vector, this.mName);
            this.mParent.setEnabled(true);
        } else {
            this.mParent.setEnabled(false);
            BackgroundProgressDialog backgroundProgressDialog = new BackgroundProgressDialog(process);
            backgroundProgressDialog.setVisible(true);
            this.mParent.setEnabled(true);
        }
    }

    class BackgroundProgressDialog
    extends BaseProgressDialog {
        BackgroundProgressDialog(Process process) {
            super(ProductionRunJob.this.mParent, ResUtil.getString(ProductionRunJob.this.mResBundle, "IDS_RUN_OPTIONS_BACKGROUND_PROGRESS_TITLE"));
            ProductionRunJob.this.mProcess = process;
            this.mCloseButton.setEnabled(false);
            String string = ResUtil.getString(ProductionRunJob.this.mResBundle, "IDS_RUN_OPTIONS_BACKGROUND_PROGRESS_SUBMITTED");
            String string2 = ProductionRunJob.this.mName + ResUtil.getString(ProductionRunJob.this.mResBundle, "IDS_PRODUCTION_JOB_SPJ_FILE_EXTENSION");
            String string3 = MessageFormat.format(string, string2, ProductionRunJob.this.mServer.getName());
            this.setProgressStatusText(string3);
            this.finish();
        }

        private void finish() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        final int n = ProductionRunJob.this.mProcess.waitFor();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BackgroundProgressDialog.this.setProgressBarMoving(false);
                                if (n == 0) {
                                    String string = ResUtil.getString(ProductionRunJob.this.mResBundle, "IDS_RUN_OPTIONS_BACKGROUND_PROGRESS_SUCCESS_CONNECT");
                                    String string2 = ProductionRunJob.this.mName + ResUtil.getString(ProductionRunJob.this.mResBundle, "IDS_PRODUCTION_JOB_SPJ_FILE_EXTENSION");
                                    String string3 = MessageFormat.format(string, string2, ProductionRunJob.this.mServer.getName());
                                    BackgroundProgressDialog.this.setProgressStatusText(string3);
                                } else {
                                    String string = ResUtil.getString(ProductionRunJob.this.mResBundle, "ERR_RUN_OPTIONS_BACKGROUND_PROGRESS_FAILED_CONNECT");
                                    String string4 = MessageFormat.format(string, ProductionRunJob.this.mStrClientHost);
                                    BackgroundProgressDialog.this.setProgressStatusText(string4);
                                }
                                BackgroundProgressDialog.this.mCloseButton.setEnabled(true);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            };
            new Thread(runnable).start();
        }

        @Override
        public String getCloseButtonText() {
            return ResUtil.getString(ProductionRunJob.this.mResBundle, "IDS_RUN_OPTIONS_BACKGROUND_PROGRESS_CLOSE");
        }

        @Override
        public JPanel getUserDefinedTopPanel() {
            return new JPanel();
        }

        @Override
        public JPanel getUserDefinedBottomPanel() {
            return new JPanel(new FlowLayout());
        }

        @Override
        public void processCloseAction() {
            this.dispose();
        }

        @Override
        public void dispose() {
            super.dispose();
        }
    }
}

