/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionJobDlg;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionOptionsDlg;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

class ProductionPPTOptionsDlg
extends ProductionOptionsDlg
implements FocusListener {
    private JCheckBox mTableOptionCheck;
    private JSpinner mImageSizeSpinner;
    private JLabel mImageSizeLabel;

    ProductionPPTOptionsDlg(ProductionJobDlg productionJobDlg, String string, boolean bl) {
        super(productionJobDlg, string, bl);
    }

    @Override
    protected String getDialogHelpID() {
        return "idh_prod_expopt_ppt";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mTableOptionCheck) {
            if (this.mTableOptionCheck.isSelected() != this.getOptions().getTableSlideTitle().booleanValue()) {
                this.mParent.setModified(true);
            }
        } else if (focusEvent.getSource() == this.mImageSizeSpinner.getEditor() && this.getOptions().getImageSize() != this.mImageSizeSpinner.getValue()) {
            this.mParent.setModified(true);
        }
    }

    @Override
    public boolean continuePressed() {
        if (((JTextField)this.mImageSizeSpinner.getEditor()).getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MESSAGE"), 1, 200), VersionInfo.getAppVersionString());
            this.mImageSizeSpinner.setValue(100);
            this.mImageSizeSpinner.requestFocus();
            return false;
        }
        int n = Integer.valueOf(((IntTextField)this.mImageSizeSpinner.getEditor()).getText());
        if (n < 1 || n > 200) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MESSAGE"), 1, 200), VersionInfo.getAppVersionString());
            this.mImageSizeSpinner.setValue(100);
            this.mImageSizeSpinner.requestFocus();
            return false;
        }
        this.saveOptions();
        return true;
    }

    @Override
    protected Vector<Object> getTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTableOptionCheck);
        vector.add(this.mImageSizeSpinner);
        return vector;
    }

    @Override
    protected void loadOptions() {
        Boolean bl = this.getOptions().getTableSlideTitle();
        if (bl == null) {
            bl = true;
            this.getOptions().setTableSlideTitle(bl);
        }
        this.mTableOptionCheck.setSelected(bl);
        Integer n = this.getOptions().getImageSize();
        if (n == null) {
            n = 100;
            this.getOptions().setImageSize(n);
        }
        this.mImageSizeSpinner.getModel().setValue(n);
    }

    @Override
    protected void saveOptions() {
        this.getOptions().setTableSlideTitle(Boolean.valueOf(this.mTableOptionCheck.isSelected()));
        this.getOptions().setImageSize((Integer)this.mImageSizeSpinner.getModel().getValue());
    }

    @Override
    protected JPanel setupTableOptionPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_PRODUCTION_TABLE_OPTIONS_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2 * 4, n2 * 2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTableOptionCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel;
    }

    @Override
    protected JPanel setupImagePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_PRODUCTION_IMAGE_OPTIONS_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets = new Insets(n * 4 + 4, n * 2, n * 3, n);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mImageSizeLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        insets.set(n * 4 + 2, n * 2, n * 3, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mImageSizeSpinner, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        return jPanel;
    }

    @Override
    protected void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_PRODUCTION_SLIDE_TITLE");
        this.mTableOptionCheck = new JCheckBox(toggleButtonAction);
        this.mTableOptionCheck.addFocusListener(this);
        this.mImageSizeLabel = DialogUtil.createLabel(this, "IDS_PRODUCTION_IMAGE_SIZE");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(100, 1, 200, 1);
        IntTextField intTextField = new IntTextField(true);
        intTextField.setAction((Action)new TextFieldAction(this, "IMAGE_SIZE_KEY"));
        this.mImageSizeSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mImageSizeSpinner.getEditor().addFocusListener(this);
        this.mImageSizeLabel.setLabelFor(this.mImageSizeSpinner);
    }
}

