/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionJobDlg;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionOptionsDlg;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

class ProductionPDFOptionsDlg
extends ProductionOptionsDlg
implements FocusListener {
    private JCheckBox mTableEmbedBookmarksCheck;
    private JCheckBox mTableEmbedFontsCheck;
    private JTextArea mMessageArea;
    private JLabel mImageLabel;

    ProductionPDFOptionsDlg(ProductionJobDlg productionJobDlg, String string, boolean bl) {
        super(productionJobDlg, string, bl);
    }

    @Override
    protected String getDialogHelpID() {
        return "idh_prod_expopt_pdf";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Boolean bl;
        if (focusEvent.getSource() == this.mTableEmbedBookmarksCheck) {
            Boolean bl2 = this.getOptions().getTableEmbedBookmark();
            if (bl2.booleanValue() != this.mTableEmbedBookmarksCheck.isSelected()) {
                this.mParent.setModified(true);
            }
        } else if (focusEvent.getSource() == this.mTableEmbedFontsCheck && (bl = this.getOptions().getTableEmbedFont()).booleanValue() != this.mTableEmbedFontsCheck.isSelected()) {
            this.mParent.setModified(true);
        }
    }

    @Override
    public boolean continuePressed() {
        this.saveOptions();
        return true;
    }

    @Override
    protected Vector<Object> getTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTableEmbedBookmarksCheck);
        vector.add(this.mTableEmbedFontsCheck);
        return vector;
    }

    @Override
    protected void loadOptions() {
        Boolean bl = this.getOptions().getTableEmbedBookmark();
        if (bl == null) {
            bl = true;
            this.getOptions().setTableEmbedBookmark(bl);
        }
        this.mTableEmbedBookmarksCheck.setSelected(bl);
        Boolean bl2 = this.getOptions().getTableEmbedFont();
        if (bl2 == null) {
            bl2 = true;
            this.getOptions().setTableEmbedFont(bl2);
        }
        this.mTableEmbedFontsCheck.setSelected(bl2);
    }

    @Override
    protected void saveOptions() {
        this.getOptions().setTableEmbedBookmark(Boolean.valueOf(this.mTableEmbedBookmarksCheck.isSelected()));
        this.getOptions().setTableEmbedFont(Boolean.valueOf(this.mTableEmbedFontsCheck.isSelected()));
    }

    @Override
    protected JPanel setupTableOptionPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_PRODUCTION_TABLE_OPTIONS_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2 * 4, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTableEmbedBookmarksCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setRows(3);
        jTextArea.setOpaque(false);
        jTextArea.setFont(this.mTableEmbedBookmarksCheck.getFont());
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText(this.getResString("IDS_PRODUCTION_PDF_TABLE_OPTIONS_MESG"));
        jTextArea.setFocusable(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, n2 * 2 + 8, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTableEmbedFontsCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    @Override
    protected JPanel setupImagePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_PRODUCTION_IMAGE_OPTIONS_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, n2 * 2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mImageLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        insets.set(n2, n2, n2 * 2, n2 * 6);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mMessageArea, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    @Override
    protected void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_PRODUCTION_PDF_EMBED_BOOKMARKS");
        this.mTableEmbedBookmarksCheck = new JCheckBox(toggleButtonAction);
        this.mTableEmbedBookmarksCheck.addFocusListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_PRODUCTION_PDF_EMBED_FONTS");
        this.mTableEmbedFontsCheck = new JCheckBox(toggleButtonAction);
        this.mTableEmbedFontsCheck.addFocusListener(this);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        this.mImageLabel = new JLabel();
        this.mImageLabel.setIcon(new ImageIcon(uRL));
        this.mMessageArea = new JTextArea();
        this.mMessageArea.setRows(2);
        this.mMessageArea.setOpaque(false);
        this.mMessageArea.setLineWrap(true);
        this.mMessageArea.setWrapStyleWord(true);
        this.mMessageArea.setText(this.getResString("ERR_PRODUCTION_PDF_IMAGE_OPTION_MESG"));
        this.mMessageArea.setFocusable(false);
    }
}

