/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.production.ProductionOutput;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionJobDlg;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

abstract class ProductionOptionsDlg
extends BaseDialog {
    static final String TYPE_COMBO_BOX = "IDS_PRODUCTION_IMAGE_TYPE_COMBO";
    protected static final int DEFAULT_WIDTH_COMBO = 200;
    protected static final int DEFAULT_WIDTH_PANEL = 350;
    protected static final int DEFAULT_HEIGHT_PANEL = 270;
    static final String DEFAULT_SPINNER_STRING_VALUE = "100";
    static final int DEFAULT_SPINNER_VALUE = 100;
    static final int SPINNER_MINIMUM_VALUE = 1;
    static final int SPINNER_STEP_SIZE_VALUE = 1;
    static final int SPINNER_MAXIMUM_VALUE = 200;
    protected boolean mContinuePressed;
    protected OptionContinueAction mContinueAction;
    ProductionJobDlg mParent;

    ProductionOptionsDlg(ProductionJobDlg productionJobDlg, String string, boolean bl) {
        super((BaseDialog)productionJobDlg, string, bl, productionJobDlg.getResourceBundle(), productionJobDlg.getImageFilePath());
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(2);
        this.mParent = productionJobDlg;
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    protected abstract String getDialogHelpID();

    public boolean wasContinuePressed() {
        return this.mContinuePressed;
    }

    public boolean continuePressed() {
        return true;
    }

    public void enableContinue(boolean bl) {
        if (this.mContinueAction != null) {
            this.mContinueAction.setEnabled(bl);
        }
    }

    public int getImageFormatIndex(ProductionOutput.ImageFormat imageFormat) {
        int n = -1;
        switch (imageFormat) {
            case BMP: {
                n = 0;
                break;
            }
            case EPS: {
                n = 2;
                break;
            }
            case JPG: {
                n = 3;
                break;
            }
            case PNG: {
                n = 4;
                break;
            }
            case TIF: {
                n = 5;
                break;
            }
            case EMF: {
                n = 1;
            }
        }
        if ((OSCheck.getOSType() == OSInfo.OSType.LINUX || OSCheck.getOSType() == OSInfo.OSType.MAC) && n > 0) {
            --n;
        }
        return n;
    }

    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        int n = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.5;
        gridBagConstraints.weighty = 1.5;
        gridBagConstraints.fill = 1;
        if (jPanel.getComponentCount() > 0) {
            jPanel.removeAll();
        }
        JPanel jPanel2 = this.setupTableOptionPanel();
        jPanel2.setMinimumSize(new Dimension(350, 270));
        jPanel2.setPreferredSize(new Dimension(350, 270));
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupImagePanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setupTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            Dimension dimension = new Dimension(this.getSize().width, this.getSize().height + 40);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            this.pack();
        }
    }

    protected abstract void initVars();

    protected abstract JPanel setupImagePanel();

    protected abstract JPanel setupTableOptionPanel();

    protected abstract void loadOptions();

    protected abstract void saveOptions();

    protected abstract Vector<Object> getTraversal();

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.mContinueAction = new OptionContinueAction();
        JButton jButton = new JButton(this.mContinueAction);
        JButton jButton2 = new JButton((Action)this.createCancelAction());
        JButton jButton3 = new JButton((Action)this.createHelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = 6 * (insets.left + insets.right);
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            int n2 = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
            n2 = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add(jButton3);
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected ProductionOutput.ImageFormat getImageFormatFrom(String string) {
        ProductionOutput.ImageFormat imageFormat = ProductionOutput.ImageFormat.JPG;
        if (string.equals("*.bmp")) {
            imageFormat = ProductionOutput.ImageFormat.BMP;
        } else if (string.equals("*.emf")) {
            imageFormat = ProductionOutput.ImageFormat.EMF;
        } else if (string.equals("*.eps")) {
            imageFormat = ProductionOutput.ImageFormat.EPS;
        } else if (string.equals("*.jpg")) {
            imageFormat = ProductionOutput.ImageFormat.JPG;
        } else if (string.equals("*.png")) {
            imageFormat = ProductionOutput.ImageFormat.PNG;
        } else if (string.equals("*.tif")) {
            imageFormat = ProductionOutput.ImageFormat.TIF;
        }
        return imageFormat;
    }

    protected ProductionOutput getOptions() {
        return this.mParent.getDocument().getJob().getOutput();
    }

    private Vector<Object> setupTraversal() {
        Vector<Object> vector = this.getTraversal();
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    class OptionContinueAction
    extends AbstractAction {
        OptionContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProductionOptionsDlg.this.mContinuePressed = true;
            if (ProductionOptionsDlg.this.continuePressed()) {
                ProductionOptionsDlg.this.dispose();
            } else {
                ProductionOptionsDlg.this.mContinuePressed = false;
            }
        }
    }
}

