/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.production.ProductionDocument;
import com.spss.java_client.core.documents.production.ProductionOutput;
import com.spss.java_client.core.server.ServerObject;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionBKJobStatusTab;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionGeneralTab;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSpssTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ProductionJobDlg
extends BaseDialog {
    private JTabbedPane mTabbedPane;
    private ProductionGeneralTab mGeneralTab;
    private ProductionBKJobStatusTab mBKJobStatusTab;
    private JButton mCloseButton;
    private JButton mHelpButton;
    private ProductionDocument mDocument = null;
    protected DialogDataModel mDialogDataModel = new DialogDataModel();

    public ProductionJobDlg(SpssFrame spssFrame) {
        super((JFrame)spssFrame, false, ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), UtilitiesResBundle.getImageFolder());
        Point point;
        this.setDefaultCloseOperation(0);
        this.setTitle(this.getResString("IDS_PRODUCTION_MODE_CONSOLE_TITLE"));
        this.pack();
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize(this.getIActionKey());
        if (dimension != null) {
            this.setSize(dimension);
        }
        if ((point = ProcedureDlgMgr.getMgr().getDialogLocation(this.getIActionKey())) != null) {
            this.setLocation(point);
        } else {
            this.setLocationRelativeTo(spssFrame);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProductionJobDlg.this.isDisplayable()) {
                    ProcedureDlgMgr.getMgr().loadPersistentState(ProductionJobDlg.this.getIActionKey(), ProductionJobDlg.this.getDialogDataModel());
                    ProductionJobDlg.this.loadDialogState();
                }
            }
        });
    }

    protected void loadDialogState() {
        BaseProcedureDialog.loadState(this.getDialogDataModel(), (Container)((Object)this), BaseProcedureDialog.NameLabelOption.no_override);
        this.mGeneralTab.loadDialogState();
    }

    protected void saveDialogState() {
        this.mGeneralTab.saveDialogState();
        BaseProcedureDialog.saveState(this.getDialogDataModel(), (Container)((Object)this));
        ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.getDialogDataModel());
        ProcedureDlgMgr.getMgr().addRecallItem(this.getTitle(), this.getIActionKey());
    }

    public DialogDataModel getDialogDataModel() {
        return this.mDialogDataModel;
    }

    protected void init() {
        super.init();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ProductionJobDlg.this.close();
            }
        });
        JPanel jPanel = this.getViewPanel();
        this.setupTabbedPane(jPanel);
        this.mGeneralTab = new ProductionGeneralTab(this, true);
        this.mBKJobStatusTab = new ProductionBKJobStatusTab(this, true);
        this.addTab(this.getResString("IDS_PRODUCTION_GENERAL_TAB_TITLE"), this.mGeneralTab);
        if (VersionInfo.IsApplicationOnPrem()) {
            this.addTab(this.getResString("IDS_PRODUCTION_BK_JOB_STATUS"), this.mBKJobStatusTab);
        }
        this.pack();
    }

    public void dispose() {
        super.dispose();
        if (this.mBKJobStatusTab != null) {
            this.mBKJobStatusTab.dispose();
        }
        if (this.mDocument != null) {
            this.mDocument.closeDocument();
            this.mDocument = null;
        }
    }

    public String getIActionKey() {
        return "utilities_production_mode_console";
    }

    public void doHelp() {
        BaseSpssTab baseSpssTab = (BaseSpssTab)this.mTabbedPane.getSelectedComponent();
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, baseSpssTab.getDialogHelpID());
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        this.mCloseButton = new JButton(new CloseAction());
        this.mHelpButton = new JButton((Action)this.createHelpAction());
        if (UIToolDialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                DialogUtil.setupMacHelpButton(this.mHelpButton);
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 10;
                DialogUtil.addUsingGBL(jPanel, this.mCloseButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mCloseButton);
                jPanel.add(this.mHelpButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mCloseButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mHelpButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mCloseButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    ProductionOutput getOutput() {
        if (this.mDocument != null) {
            return this.mDocument.getJob().getOutput();
        }
        return null;
    }

    void loadState(ProductionDocument productionDocument) {
        this.setModified(false);
        if (this.mDocument != null) {
            this.mDocument.closeDocument();
        }
        this.mDocument = productionDocument;
        this.mGeneralTab.loadTabDocState(productionDocument);
    }

    public void saveState() {
        this.setModified(false);
        this.mGeneralTab.saveTabDocState(this.mDocument);
    }

    void enableUIItems() {
        this.mGeneralTab.enableUIItems();
        this.mBKJobStatusTab.enableUIItems();
    }

    private void addTab(String string, BaseSpssTab baseSpssTab) {
        this.mTabbedPane.add(string, baseSpssTab);
    }

    private void setupTabbedPane(JPanel jPanel) {
        this.mTabbedPane = new JTabbedPane(){

            @Override
            public void setSelectedIndex(int n) {
                BaseSpssTab baseSpssTab = (BaseSpssTab)ProductionJobDlg.this.mTabbedPane.getComponentAt(n);
                if (baseSpssTab instanceof ProductionBKJobStatusTab) {
                    ((ProductionBKJobStatusTab)baseSpssTab).aboutToShowTab();
                }
                super.setSelectedIndex(n);
                ProductionJobDlg.this.setTabTraversalPolicy();
            }
        };
        this.mTabbedPane.setFocusable(true);
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ProductionJobDlg.this.mTabbedPane.repaint();
            }
        };
        this.mTabbedPane.addFocusListener(focusAdapter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ProductionJobDlg.this.mTabbedPane.requestFocusInWindow();
            }
        };
        this.mTabbedPane.addMouseListener(mouseAdapter);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTabbedPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
    }

    private void setTabTraversalPolicy() {
        BaseSpssTab baseSpssTab = (BaseSpssTab)this.mTabbedPane.getSelectedComponent();
        baseSpssTab.setEnabled(true);
        baseSpssTab.setFocusable(true);
        Vector<Object> vector = baseSpssTab.getComponentOrder();
        if (!vector.contains(this.mTabbedPane)) {
            vector.add(this.mTabbedPane);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    boolean saveJob(File file) {
        this.saveState();
        return this.mDocument.saveDocument(file, false);
    }

    boolean getModified() {
        return this.mDocument != null && this.mDocument.getModifiedFlag();
    }

    void setModified(boolean bl) {
        if (this.mDocument != null) {
            this.mDocument.setModifiedFlag(bl);
        }
    }

    boolean hasDocument() {
        return this.mDocument != null;
    }

    ProductionDocument getDocument() {
        return this.mDocument;
    }

    private void close() {
        if (this.validateTabs()) {
            boolean bl = false;
            if (this.getModified()) {
                if (this.mGeneralTab.querySaveDiscard()) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                this.saveDialogState();
                ProcedureDlgMgr.getMgr().saveDialogSize(this.getIActionKey(), this.getSize());
                ProcedureDlgMgr.getMgr().saveDialogLocation(this.getIActionKey(), this.getLocation());
                this.dispose();
            }
        }
    }

    boolean validateTabs() {
        return this.mGeneralTab.validateTab() && this.mBKJobStatusTab.validateTab();
    }

    public ServerObject getServerFromModel() {
        return (ServerObject)this.getDialogDataModel().getObject("STATISTICS_SERVER_KEY");
    }

    public JButton getHelpButton() {
        return this.mHelpButton;
    }

    public JButton getCloseButton() {
        return this.mCloseButton;
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CLOSE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProductionJobDlg.this.close();
        }
    }
}

