/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.production.ProductionOutput;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionJobDlg;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionOptionsDlg;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

class ProductionHTMLOptionsDlg
extends ProductionOptionsDlg
implements FocusListener {
    private JTextArea mMessageArea;
    private JLabel mImageLabel;
    private JLabel mImageTypeLabel;
    private JComboBox mImageTypeCombo;
    private String[] mGraphicsFileExtnSupportedArray;
    private JSpinner mImageSizeSpinner;
    private JLabel mImageSizeLabel;

    ProductionHTMLOptionsDlg(ProductionJobDlg productionJobDlg, String string, boolean bl) {
        super(productionJobDlg, string, bl);
    }

    @Override
    protected String getDialogHelpID() {
        return "idh_prod_expopt_html";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mImageTypeCombo) {
            ProductionOutput.ImageFormat imageFormat = this.getOptions().getImageFormat();
            if (this.getImageFormatIndex(imageFormat) != this.mImageTypeCombo.getSelectedIndex()) {
                this.mParent.setModified(true);
            }
        } else if (focusEvent.getSource() == this.mImageSizeSpinner.getEditor() && this.getOptions().getImageSize() != this.mImageSizeSpinner.getValue()) {
            this.mParent.setModified(true);
        }
    }

    @Override
    public boolean continuePressed() {
        if (((JTextField)this.mImageSizeSpinner.getEditor()).getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MESSAGE"), 1, 200), VersionInfo.getAppVersionString());
            this.mImageSizeSpinner.setValue(100);
            this.mImageSizeSpinner.getEditor().requestFocus();
            return false;
        }
        int n = Integer.valueOf(((IntTextField)this.mImageSizeSpinner.getEditor()).getText());
        if (n < 1 || n > 200) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MESSAGE"), 1, 200), VersionInfo.getAppVersionString());
            this.mImageSizeSpinner.setValue(100);
            this.mImageSizeSpinner.getEditor().requestFocus();
            return false;
        }
        this.saveOptions();
        return true;
    }

    @Override
    protected Vector<Object> getTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mImageTypeCombo);
        vector.add(this.mImageSizeSpinner.getEditor());
        return vector;
    }

    @Override
    protected void loadOptions() {
        ProductionOutput.ImageFormat imageFormat = this.getOptions().getImageFormat();
        if (imageFormat == ProductionOutput.ImageFormat.NULL) {
            imageFormat = ProductionOutput.ImageFormat.JPG;
            this.getOptions().setImageFormat(ProductionOutput.ImageFormat.JPG);
        }
        this.mImageTypeCombo.setSelectedIndex(this.getImageFormatIndex(imageFormat));
        Integer n = this.getOptions().getImageSize();
        if (n == null) {
            n = 100;
            this.getOptions().setImageSize(n);
        }
        this.mImageSizeSpinner.getModel().setValue(n);
    }

    @Override
    protected void saveOptions() {
        this.getOptions().setImageSize((Integer)this.mImageSizeSpinner.getModel().getValue());
        this.getOptions().setImageFormat(this.getImageFormatFrom(this.mGraphicsFileExtnSupportedArray[this.mImageTypeCombo.getSelectedIndex()]));
    }

    @Override
    protected JPanel setupTableOptionPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_PRODUCTION_TABLE_OPTIONS_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2 * 4, n2 * 6, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mImageLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        insets.set(n2 * 4, n2, n2, n2 * 6);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mMessageArea, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    @Override
    protected JPanel setupImagePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_PRODUCTION_IMAGE_OPTIONS_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets = new Insets(n + 4, n, 0, n);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mImageTypeLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.set(n + 4, n, 0, n * 3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mImageTypeCombo, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        insets.set(n * 2 + 4, n, n * 2, n);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mImageSizeLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        insets.set(n * 2 + 4, n, n * 2, n);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mImageSizeSpinner, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        return jPanel;
    }

    @Override
    protected void initVars() {
        Object object;
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        this.mImageLabel = new JLabel();
        this.mImageLabel.setIcon(new ImageIcon(uRL));
        this.mMessageArea = new JTextArea();
        this.mMessageArea.setRows(2);
        this.mMessageArea.setOpaque(false);
        this.mMessageArea.setLineWrap(true);
        this.mMessageArea.setWrapStyleWord(true);
        this.mMessageArea.setText(this.getResString("ERR_PRODUCTION_HTML_TABLE_OPTION_MESG"));
        this.mMessageArea.setFocusable(false);
        this.mImageTypeLabel = DialogUtil.createLabel(this, "IDS_PRODUCTION_IMAGE_TYPE");
        String[] stringArray = resourceBundle.getStringArray("IDS_EXPORTOUTPUT_GRAPHICS_TYPE_COMBO");
        String[] stringArray2 = resourceBundle.getStringArray("IDS_EXPORTOUTPUT_GRAPHICS_FILTER_EXTN");
        if (OSCheck.getOSType() != OSInfo.OSType.WIN) {
            int n;
            object = new String[stringArray.length - 1];
            int n2 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                if (n == 1) continue;
                object[n2] = stringArray[n];
                ++n2;
            }
            this.mImageTypeCombo = new JComboBox<String>((E[])object);
            n2 = 0;
            for (n = 0; n < stringArray2.length; ++n) {
                if (n == 1) continue;
                object[n2] = stringArray2[n];
                ++n2;
            }
            this.mGraphicsFileExtnSupportedArray = object;
        } else {
            this.mImageTypeCombo = new JComboBox<String>(stringArray);
            this.mGraphicsFileExtnSupportedArray = stringArray2;
        }
        this.mImageTypeCombo.setPreferredSize(new Dimension(200, this.mImageTypeCombo.getPreferredSize().height));
        this.mImageTypeCombo.addFocusListener(this);
        this.mImageTypeCombo.setAction(new ComboboxAction(this, "GRAPHICS_COMBO_KEY"));
        this.mImageTypeLabel.setLabelFor(this.mImageTypeCombo);
        this.mImageSizeLabel = DialogUtil.createLabel(this, "IDS_PRODUCTION_IMAGE_SIZE");
        object = new SpinnerNumberModel(100, 1, 200, 1);
        IntTextField intTextField = new IntTextField(true);
        intTextField.setAction((Action)new TextFieldAction(this, "IMAGE_SIZE_KEY"));
        this.mImageSizeSpinner = new NumberSpinner(intTextField, (SpinnerNumberModel)object);
        this.mImageSizeSpinner.getEditor().addFocusListener(this);
        this.mImageSizeLabel.setLabelFor(this.mImageSizeSpinner);
    }
}

