/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.production.OutputFormat;
import com.spss.java_client.core.documents.production.ProductionDocument;
import com.spss.java_client.core.documents.production.ProductionJob;
import com.spss.java_client.core.documents.production.ProductionOutput;
import com.spss.java_client.core.documents.production.ProductionSymbol;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.controls.AddDeleteButton;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssAddDeleteButtons;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionHTMLOptionsDlg;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionJobDlg;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionOptionsDlg;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionPDFOptionsDlg;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionPPTOptionsDlg;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionRunJob;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionTextOptionsDlg;
import com.spss.java_client.ui.dialogs.base.utilities.production.RunOptionsDlg;
import com.spss.java_client.ui.dialogs.base.utilities.production.RuntimeValuesTableItem;
import com.spss.java_client.ui.dialogs.base.utilities.production.RuntimeValuesTableModel;
import com.spss.java_client.ui.dialogs.base.utilities.production.SyntaxFileTableModel;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.PerConnectAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.repository.client.application.jaxws.Repository;
import com.spss.shared.core_tools.file.SpssFile;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FocusableLabel;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.JTextComponent;

public class ProductionGeneralTab
extends BaseProcedureTab
implements FocusListener,
ActionListener,
TableModelListener,
ListSelectionListener {
    public final int LOCATION_FILE_TEXT_FIELD_SIZE = 25;
    public final int OUTPUT_FILE_TEXT_FIELD_SIZE = 25;
    public static final String OUTPUT_FILE_PATH = "IDS_GENERAL_OUTPUT_FILE_PATH";
    public static final int SYMB_VAL_COL_IND = 0;
    public static final int DEF_VAL_COL_IND = 1;
    public static final int USER_PROMPT_COL_IND = 2;
    private JTextArea mJobNameLabel;
    private JLabel mLocationFieldLabel;
    private FileTextField mLocationField;
    private JButton mLocationBrowseButton;
    private JTable mSyntaxFileTable;
    private SyntaxFileTableModel mSyntaxFileTableModel;
    private JScrollPane mSyntaxFileTableScrollPane;
    private ArrowButton mUpButton;
    private ArrowButton mDownButton;
    private AddDeleteButton mAddButton;
    private AddDeleteButton mDeleteButton;
    private JLabel mSyntaxFormatComboLabel;
    private JComboBox mSyntaxFormatCombo;
    private JLabel mErrorProcessingComboLabel;
    private JComboBox mErrorProcessingCombo;
    private JLabel mOutputFileFieldLabel;
    private FileTextField mOutputFileField;
    private JButton mOutputFileBrowseButton;
    private JLabel mOutputFormatComboLabel;
    private JComboBox mOutputFormatCombo;
    private JButton mOutputOptionsButton;
    private JCheckBox mPrintOnCompletionCheck;
    private JButton mNewButton;
    private JButton mSaveButton;
    private JButton mSaveAsButton;
    private JButton mRunButton;
    private Border mDefaultScrollPaneBorder = UIManager.getBorder("Table.ScrollPaneBorder");
    private static int sDocumentCounter = 1;
    File mFile = null;
    private PlainTable mRuntimeValuesTable;
    private RuntimeValuesTableModel mRuntimeValuesTableModel;
    private JScrollPane mRuntimeValuesTableScrollPane;
    private JTextArea mNote;
    private FocusableLabel mPrintNote;
    ProductionJobDlg mParentDlg;
    int mCurrentJobFileIndex = -1;
    ProductionHTMLOptionsDlg mHTMLDialog;
    ProductionPPTOptionsDlg mPPTDialog;
    ProductionPDFOptionsDlg mPDFDialog;
    ProductionTextOptionsDlg mTextDialog;
    private JList mJobFilesList;
    private JScrollPane mJobFilesListScrollPane;
    private SpssButtonGroup mEncodingButtonGroup;
    private JRadioButton mUnicodeOnRadio;
    private JRadioButton mUnicodeOffRadio;
    private JCheckBox mCodepageSyntaxFiles;
    private boolean mProcessRemoveUpdate = true;

    public ProductionGeneralTab(ProductionJobDlg productionJobDlg, boolean bl) {
        super(productionJobDlg, false);
        this.mParentDlg = productionJobDlg;
        if (bl) {
            this.initPanel();
            this.setInitialized(true);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prod";
    }

    @Override
    public void reset() {
        super.reset();
        this.loadTabDocState(null);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVariables();
        this.setupPanel();
        this.sizeSyntaxFileTable();
        this.sizeRuntimeValuesTable();
        this.enableUIItems();
        this.setFocusTraversalPolicy();
    }

    protected void loadDialogState() {
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        BaseProcedureDialog.loadState(dialogDataModel, this, BaseProcedureDialog.NameLabelOption.no_override);
        String string = FileLocationsUtil.getOtherFilesDirectoryPath();
        File file = new File(string);
        if (file.isFile()) {
            this.mLocationField.setText(file.getParent());
            this.mLocationField.setToolTipText(file.getParent());
        } else {
            this.mLocationField.setText(string);
            this.mLocationField.setToolTipText(string);
        }
        if (this.mLocationField.getText() != null) {
            this.PopulateJobFilesListbox(this.mLocationField.getText().trim());
            this.enableJobFilesList();
        }
        this.loadTabDocState(this.mParentDlg.getDocument());
    }

    protected void saveDialogState() {
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        BaseProcedureDialog.saveState(dialogDataModel, this);
        ProcedureDlgMgr.getMgr().savePersistentState(this.mParentDlg.getIActionKey(), dialogDataModel);
        this.saveTabDocState(this.mParentDlg.getDocument());
    }

    void loadTabDocState(ProductionDocument productionDocument) {
        this.loadSyntaxFileTableModel(productionDocument);
        this.sizeSyntaxFileTable();
        this.loadOutputFormat(productionDocument);
        if (productionDocument == null) {
            this.mJobNameLabel.setText(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_CLICK_NEW_MSG"));
            this.mOutputFileField.setText(null);
            this.mOutputFileField.setToolTipText(null);
            this.mSyntaxFormatCombo.getModel().setSelectedItem(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SYNTAX_FORMAT_COMBO_OPTION_0"));
            this.mErrorProcessingCombo.getModel().setSelectedItem(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_ERROR_PROCESSING_COMBO_OPTION_0"));
            this.mPrintOnCompletionCheck.setSelected(false);
            this.mUnicodeOnRadio.setSelected(true);
            this.mUnicodeOffRadio.setSelected(false);
            this.mCodepageSyntaxFiles.setSelected(false);
        } else {
            this.mJobNameLabel.setText(productionDocument.getDocName());
            this.mOutputFileField.setText(productionDocument.getJob().getOutput().getPath());
            this.mOutputFileField.setToolTipText(productionDocument.getJob().getOutput().getPath());
            if (productionDocument.getJob().getSyntaxFormat() == ProductionJob.SyntaxFormat.INTERACTIVE) {
                this.mSyntaxFormatCombo.getModel().setSelectedItem(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SYNTAX_FORMAT_COMBO_OPTION_0"));
            } else {
                this.mSyntaxFormatCombo.getModel().setSelectedItem(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SYNTAX_FORMAT_COMBO_OPTION_1"));
            }
            if (productionDocument.getJob().getSyntaxErrorHandling() == ProductionJob.SyntaxErrorHandling.CONTINUE) {
                this.mErrorProcessingCombo.getModel().setSelectedItem(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_ERROR_PROCESSING_COMBO_OPTION_0"));
            } else {
                this.mErrorProcessingCombo.getModel().setSelectedItem(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_ERROR_PROCESSING_COMBO_OPTION_1"));
            }
            this.mPrintOnCompletionCheck.setSelected(productionDocument.getJob().print());
            this.mUnicodeOnRadio.setSelected(productionDocument.getJob().getUnicode());
            this.mUnicodeOffRadio.setSelected(!productionDocument.getJob().getUnicode());
            this.mCodepageSyntaxFiles.setSelected(productionDocument.getJob().getCodepageSyntaxFiles());
        }
        this.loadRuntimeValuesTableModel(productionDocument);
    }

    void saveTabDocState(ProductionDocument productionDocument) {
        Repository repository;
        if (productionDocument == null) {
            return;
        }
        this.saveSyntaxFileTableModel(productionDocument);
        this.saveOutputFormat(productionDocument);
        productionDocument.setDocName(this.mJobNameLabel.getText());
        this.appendOutputFileExtension();
        productionDocument.getJob().getOutput().setPath(this.mOutputFileField.getText());
        if (productionDocument.getJob().getOutput().getPath().startsWith("spsscr:") && productionDocument.getJob().getRepositoryConnectionDescriptor() == null && (repository = PES_Repository.getRepository()) == null) {
            PerConnectAction perConnectAction = new PerConnectAction();
            perConnectAction.doConnect((SpssFrame)this.mParentDlg.getParent(), true, false);
            PES_Repository.getRepository();
        }
        if (this.mSyntaxFormatCombo.getModel().getSelectedItem() == this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SYNTAX_FORMAT_COMBO_OPTION_0")) {
            productionDocument.getJob().setSyntaxFormat(ProductionJob.SyntaxFormat.INTERACTIVE);
        } else {
            productionDocument.getJob().setSyntaxFormat(ProductionJob.SyntaxFormat.BATCH);
        }
        if (this.mErrorProcessingCombo.getModel().getSelectedItem() == this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_ERROR_PROCESSING_COMBO_OPTION_0")) {
            productionDocument.getJob().setSyntaxErrorHandling(ProductionJob.SyntaxErrorHandling.CONTINUE);
        } else {
            productionDocument.getJob().setSyntaxErrorHandling(ProductionJob.SyntaxErrorHandling.STOP);
        }
        productionDocument.getJob().setPrint(this.mPrintOnCompletionCheck.isSelected());
        productionDocument.getJob().setUnicode(this.mUnicodeOnRadio.isSelected());
        productionDocument.getJob().setCodepageSyntaxFiles(this.mCodepageSyntaxFiles.isSelected());
        this.saveRuntimeValuesTableModel(productionDocument);
    }

    private void saveOutputFormat(ProductionDocument productionDocument) {
        if (productionDocument == null) {
            return;
        }
        ProductionOutput productionOutput = productionDocument.getJob().getOutput();
        OutputFormat outputFormat = this.getOutputFormatType((String)this.mOutputFormatCombo.getModel().getSelectedItem());
        productionOutput.setOutputFormat(outputFormat);
        ProductionOptionsDlg productionOptionsDlg = this.getOptionsDialog(outputFormat);
        if (productionOptionsDlg != null) {
            productionOptionsDlg.saveOptions();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        ProductionDocument productionDocument;
        ProductionJob productionJob = null;
        if (this.mParentDlg != null && (productionDocument = this.mParentDlg.getDocument()) != null) {
            productionJob = productionDocument.getJob();
        }
        if (productionJob == null) {
            return;
        }
        if (focusEvent.getSource() == this.mSyntaxFormatCombo) {
            productionDocument = productionJob.getSyntaxFormat();
            String string = (String)this.mSyntaxFormatCombo.getModel().getSelectedItem();
            if (productionDocument == ProductionJob.SyntaxFormat.INTERACTIVE && string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SYNTAX_FORMAT_COMBO_OPTION_1")) || productionDocument == ProductionJob.SyntaxFormat.BATCH && string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SYNTAX_FORMAT_COMBO_OPTION_0"))) {
                this.setJobFileDirty();
            }
        } else if (focusEvent.getSource() == this.mErrorProcessingCombo) {
            productionDocument = productionJob.getSyntaxErrorHandling();
            String string = (String)this.mErrorProcessingCombo.getModel().getSelectedItem();
            if (productionDocument == ProductionJob.SyntaxErrorHandling.CONTINUE && string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_ERROR_PROCESSING_COMBO_OPTION_1")) || productionDocument == ProductionJob.SyntaxErrorHandling.STOP && string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_ERROR_PROCESSING_COMBO_OPTION_0"))) {
                this.setJobFileDirty();
            }
        } else if (focusEvent.getSource() == this.mOutputFileField) {
            String string;
            productionDocument = productionJob.getOutput();
            String string2 = string = productionDocument != null ? productionDocument.getPath() : null;
            if (string != null) {
                File file = new File(string);
                if (!file.equals(new File(this.mOutputFileField.getText()))) {
                    if (this.isOutputFileExtensionValid()) {
                        this.replaceOutputFileFieldExtension();
                    } else {
                        this.appendOutputFileExtension();
                    }
                    this.setJobFileDirty();
                }
            } else {
                if (this.isOutputFileExtensionValid()) {
                    this.replaceOutputFileFieldExtension();
                } else {
                    this.appendOutputFileExtension();
                }
                this.setJobFileDirty();
            }
        } else if (focusEvent.getSource() == this.mOutputFormatCombo) {
            productionDocument = productionJob.getOutput();
            OutputFormat outputFormat = this.getOutputFormatType((String)this.mOutputFormatCombo.getModel().getSelectedItem());
            if (outputFormat != productionDocument.getOutputFormat() || this.mParentDlg.getModified()) {
                if (this.isOutputFileExtensionValid()) {
                    this.replaceOutputFileFieldExtension();
                } else {
                    this.appendOutputFileExtension();
                }
                this.setJobFileDirty();
            }
        } else if (focusEvent.getSource() == this.mPrintOnCompletionCheck) {
            if (productionJob.print() != this.mPrintOnCompletionCheck.isSelected()) {
                this.setJobFileDirty();
            }
        } else if (focusEvent.getSource() == this.mUnicodeOnRadio || focusEvent.getSource() == this.mUnicodeOffRadio) {
            if (productionJob.getUnicode() != this.mUnicodeOnRadio.isSelected()) {
                this.setJobFileDirty();
            }
        } else if (focusEvent.getSource() == this.mCodepageSyntaxFiles && productionJob.getCodepageSyntaxFiles() != this.mCodepageSyntaxFiles.isSelected()) {
            this.setJobFileDirty();
        }
    }

    void setJobFileDirty() {
        String string;
        DefaultListModel defaultListModel = (DefaultListModel)this.mJobFilesList.getModel();
        if (defaultListModel != null && this.mCurrentJobFileIndex > -1 && this.mCurrentJobFileIndex < defaultListModel.getSize() && (string = defaultListModel.get(this.mCurrentJobFileIndex).toString()).lastIndexOf(" *") == -1) {
            defaultListModel.set(this.mCurrentJobFileIndex, string + " *");
        }
        if (!this.mParentDlg.getModified()) {
            this.mParentDlg.setModified(true);
        }
    }

    void setJobFileClean() {
        String string;
        DefaultListModel defaultListModel = (DefaultListModel)this.mJobFilesList.getModel();
        if (defaultListModel != null && this.mCurrentJobFileIndex > -1 && this.mCurrentJobFileIndex < defaultListModel.getSize() && (string = defaultListModel.get(this.mCurrentJobFileIndex).toString()).lastIndexOf(" *") != -1) {
            defaultListModel.set(this.mCurrentJobFileIndex, string.substring(0, string.lastIndexOf(" *")));
        }
        if (this.mParentDlg.getModified()) {
            this.mParentDlg.setModified(false);
        }
    }

    private void PopulateJobFilesListbox(String string) {
        this.setJobFileClean();
        this.ClearListboxModel();
        File file = new File(string.trim());
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(ProductionGeneralTab.this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_SPJ_EXTN"));
            }
        };
        String[] stringArray = file.list(filenameFilter);
        if (stringArray != null) {
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            DefaultListModel defaultListModel = (DefaultListModel)this.mJobFilesList.getModel();
            this.mJobFilesList.removeListSelectionListener(this);
            for (String string2 : arrayList) {
                File file2 = new File(string2);
                defaultListModel.addElement(file2.getName());
            }
            this.mJobFilesList.addListSelectionListener(this);
            if (defaultListModel.getSize() > 0) {
                this.mJobFilesList.setSelectedIndex(0);
            }
        }
    }

    private void ClearListboxModel() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mJobFilesList.getModel();
        defaultListModel.removeAllElements();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object object = listSelectionEvent.getSource();
        if (object.equals(this.mJobFilesList) && !listSelectionEvent.getValueIsAdjusting() && this.mJobFilesList != null && this.mJobFilesList.getSelectedValue() != null) {
            if (this.mParentDlg.getModified() && !this.querySaveDiscard()) {
                int n = this.mJobFilesList.getSelectedIndex();
                int n2 = n == listSelectionEvent.getFirstIndex() ? listSelectionEvent.getLastIndex() : listSelectionEvent.getFirstIndex();
                this.mJobFilesList.removeListSelectionListener(this);
                this.mJobFilesList.setSelectedIndex(n2);
                this.mCurrentJobFileIndex = n2;
                this.mJobFilesList.addListSelectionListener(this);
                return;
            }
            this.setJobFileClean();
            this.mCurrentJobFileIndex = this.mJobFilesList.getSelectedIndex();
            String string = this.mJobFilesList.getSelectedValue().toString();
            String string2 = FileLocationsUtil.getOtherFilesDirectoryPath();
            String string3 = string2.endsWith(File.separator) ? string2 + string : string2 + File.separator + string;
            this.ReadJobFile(string3);
        }
    }

    public static boolean strEmpty(String string) {
        return string == null || string.length() == 0;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mUpButton) {
            int n = this.mSyntaxFileTable.getSelectedRow();
            if (n > 0) {
                int n2 = n - 1;
                this.mSyntaxFileTableModel.moveRow(n, n, n2);
                this.mSyntaxFileTable.getSelectionModel().setSelectionInterval(n2, n2);
                this.mSyntaxFileTable.scrollRectToVisible(this.mSyntaxFileTable.getCellRect(n2, 0, false));
            }
        } else if (actionEvent.getSource() == this.mDownButton) {
            int n = this.mSyntaxFileTable.getSelectedRow();
            if (n < this.mSyntaxFileTableModel.getRowCount() - 1) {
                int n3 = n + 1;
                this.mSyntaxFileTableModel.moveRow(n, n, n3);
                this.mSyntaxFileTable.getSelectionModel().setSelectionInterval(n3, n3);
                this.mSyntaxFileTable.scrollRectToVisible(this.mSyntaxFileTable.getCellRect(n3, 0, false));
            }
        } else if (actionEvent.getSource() == this.mAddButton) {
            String string = this.showFileDialog(OpenSaveType.OPEN, this.getResString("IDS_PRODUCTION_JOB_SPS_FILE_EXTENSION"), this.getResString("IDS_PRODUCTION_JOB_SPS_FILE_FILTER"), this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SELECT_DIALOG_TITLE"));
            if (string != null && string.trim().length() > 0) {
                int n = this.mSyntaxFileTable.getRowCount();
                this.mSyntaxFileTableModel.setValueAt(string, n, 0);
                this.sizeSyntaxFileTable();
            }
        } else if (actionEvent.getSource() == this.mDeleteButton) {
            int n = this.mSyntaxFileTable.getSelectedRow();
            this.mSyntaxFileTableModel.removeRow(n);
            this.sizeSyntaxFileTable();
        } else if (actionEvent.getSource() == this.mOutputFormatCombo) {
            OutputFormat outputFormat = this.getOutputFormatType((String)this.mOutputFormatCombo.getModel().getSelectedItem());
            this.mOutputOptionsButton.setEnabled(outputFormat.hasOptions());
            if (this.isOutputFileExtensionValid()) {
                this.replaceOutputFileFieldExtension();
            } else {
                this.appendOutputFileExtension();
            }
        }
    }

    void enableUIItems() {
        this.enableNewButton();
        this.enableJobFilesList();
        this.enableSyntaxFileTable();
        this.enableSyntaxFileArrowButtons();
        this.enableSyntaxFormatCombo();
        this.enableErrorProcessingCombo();
        this.enableOutputFileFields();
        this.enableOutputFormatControls();
        this.enablePrintOnCompletionCheck();
        this.enableSaveButton();
        this.enableSaveAsButton();
        this.enableRunButton();
        this.enableRuntimeValuesTable();
        this.enableUnicodeRadioButtons();
    }

    private void initVariables() {
        this.mJobNameLabel = new JTextArea(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_CLICK_NEW_MSG"));
        this.mJobNameLabel.setLineWrap(true);
        this.mJobNameLabel.setWrapStyleWord(true);
        this.mJobNameLabel.setBorder(null);
        this.mJobNameLabel.setOpaque(false);
        this.mJobNameLabel.setFocusable(false);
        this.mLocationField = new FileTextField();
        this.mLocationField.setColumns(25);
        this.mLocationField.setEditable(false);
        this.mLocationField.setOpaque(false);
        this.mLocationField.setAction(new TextFieldAction(this.mParentDlg, "IDS_LOCATION_FIELD_KEY"));
        String string = FileLocationsUtil.getOtherFilesDirectoryPath();
        File file = new File(string);
        if (file.isFile()) {
            this.mLocationField.setText(file.getParent());
            this.mLocationField.setToolTipText(file.getParent());
        } else {
            this.mLocationField.setText(string);
            this.mLocationField.setToolTipText(string);
        }
        this.mLocationFieldLabel = new JLabel(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_LOCATION_FIELD_LABEL"));
        this.mLocationFieldLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_PRODUCTION_JOB_GENERAL_TAB_LOCATION_FIELD_LABEL_KEY"));
        this.mLocationFieldLabel.setLabelFor((Component)((Object)this.mLocationField));
        this.mLocationField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ProductionGeneralTab.this.mParentDlg.enableUIItems();
            }
        });
        this.mLocationBrowseButton = DialogUtil.createButton(this.mParent, "IDS_PRODUCTION_JOB_GENERAL_TAB_BROWSE_BUTTON_LABEL", this);
        this.mLocationBrowseButton = new JButton(new AbstractAction(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_BROWSE_BUTTON_LABEL")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == ProductionGeneralTab.this.mLocationBrowseButton) {
                    ProductionGeneralTab.this.processLocationBrowseButton();
                }
            }
        });
        this.mLocationBrowseButton.setMnemonic(this.getDlgAccessKey("IDK_PRODUCTION_JOB_GENERAL_TAB_BROWSE_BUTTON_LABEL_KEY"));
        this.mJobFilesList = new JList(new DefaultListModel());
        this.mJobFilesList.addListSelectionListener(this);
        Border border = BorderFactory.createLineBorder(Color.BLACK);
        this.mJobFilesList.setBorder(border);
        this.mJobFilesListScrollPane = new JScrollPane(this.mJobFilesList);
        Dimension dimension = this.mJobFilesList.getPreferredSize();
        dimension.width = 160;
        dimension.height = 100;
        this.mJobFilesListScrollPane.setMinimumSize(dimension);
        this.mJobFilesListScrollPane.setPreferredSize(dimension);
        this.mAddButton = new AddDeleteButton(SpssAddDeleteButtons.ButtonType.add);
        this.mAddButton.addActionListener(this);
        this.mDeleteButton = new AddDeleteButton(SpssAddDeleteButtons.ButtonType.delete);
        this.mDeleteButton.addActionListener(this);
        this.mUpButton = new ArrowButton(true, SpssArrowButton.ButtonOrientation.up);
        this.mUpButton.addActionListener(this);
        this.mDownButton = new ArrowButton(true, SpssArrowButton.ButtonOrientation.down);
        this.mDownButton.addActionListener(this);
        this.mAddButton.setPreferredSize(new Dimension(18, 18));
        this.mDeleteButton.setPreferredSize(new Dimension(18, 18));
        this.mUpButton.setPreferredSize(new Dimension(18, 18));
        this.mDownButton.setPreferredSize(new Dimension(18, 18));
        this.mSyntaxFileTable = new SyntaxFileTable();
        this.mSyntaxFileTable.getTableHeader().setDefaultRenderer(new MyTableHeaderRenderer());
        this.mSyntaxFileTable.setSelectionMode(0);
        this.mSyntaxFileTable.setRowSelectionAllowed(false);
        this.mSyntaxFileTable.setCellSelectionEnabled(true);
        this.mSyntaxFileTable.setColumnSelectionAllowed(false);
        this.mSyntaxFileTable.setAutoResizeMode(3);
        SyntaxFileTableModel.COLUMN_NAMES[0] = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FILE_COLUMN_TITLE");
        this.loadSyntaxFileTableModel(null);
        this.mSyntaxFileTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.mSyntaxFileTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.mSyntaxFileTable.setPreferredSize(new Dimension(300, this.mSyntaxFileTable.getRowHeight() * this.mSyntaxFileTable.getRowCount()));
        this.mSyntaxFileTable.getTableHeader().setPreferredSize(new Dimension(300, this.mSyntaxFileTable.getRowHeight()));
        this.mSyntaxFileTable.getTableHeader().setReorderingAllowed(false);
        if (this.mSyntaxFileTableScrollPane == null) {
            this.mSyntaxFileTableScrollPane = new JScrollPane(this.mSyntaxFileTable, 20, 31);
        }
        if (this.mDefaultScrollPaneBorder != null) {
            this.mSyntaxFileTableScrollPane.setBorder(this.mDefaultScrollPaneBorder);
        }
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mSyntaxFileTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mSyntaxFileTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mSyntaxFileTable.getActionMap().put("tabIn", abstractAction2);
        this.mSyntaxFileTable.getActionMap().put("tabOut", abstractAction);
        this.mSyntaxFileTable.addFocusListener(this);
        String[] stringArray = new String[]{this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SYNTAX_FORMAT_COMBO_OPTION_0"), this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SYNTAX_FORMAT_COMBO_OPTION_1")};
        this.mSyntaxFormatCombo = new JComboBox<String>(stringArray);
        this.mSyntaxFormatCombo.addActionListener(this);
        this.mSyntaxFormatCombo.addFocusListener(this);
        Dimension dimension2 = this.mSyntaxFormatCombo.getMinimumSize();
        dimension2.width = 60;
        this.mSyntaxFormatCombo.setMinimumSize(dimension2);
        this.mSyntaxFormatComboLabel = new JLabel(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SYNTAX_FORMAT_COMBO_LABEL"));
        this.mSyntaxFormatComboLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_PRODUCTION_JOB_GENERAL_TAB_SYNTAX_FORMAT_COMBO_LABEL_KEY"));
        this.mSyntaxFormatComboLabel.setLabelFor(this.mSyntaxFormatCombo);
        String[] stringArray2 = new String[]{this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_ERROR_PROCESSING_COMBO_OPTION_0"), this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_ERROR_PROCESSING_COMBO_OPTION_1")};
        this.mErrorProcessingCombo = new JComboBox<String>(stringArray2);
        this.mErrorProcessingCombo.addActionListener(this);
        this.mErrorProcessingCombo.addFocusListener(this);
        this.mErrorProcessingComboLabel = new JLabel(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_ERROR_PROCESSING_COMBO_LABEL"));
        this.mErrorProcessingComboLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_PRODUCTION_JOB_GENERAL_TAB_ERROR_PROCESSING_COMBO_LABEL_KEY"));
        this.mErrorProcessingComboLabel.setLabelFor(this.mErrorProcessingCombo);
        this.mOutputFileField = new FileTextField();
        this.mOutputFileField.setColumns(25);
        this.mOutputFileField.addFocusListener(this);
        this.mOutputFileFieldLabel = new JLabel(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FILE_NAME_LABEL"));
        this.mOutputFileFieldLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_PRODUCTION_JOB_GENERAL_TAB_FILE_NAME_KEY"));
        this.mOutputFileFieldLabel.setLabelFor((Component)((Object)this.mOutputFileField));
        this.mOutputFileField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ProductionGeneralTab.this.mParentDlg.enableUIItems();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (ProductionGeneralTab.this.mProcessRemoveUpdate) {
                    ProductionGeneralTab.this.mParentDlg.enableUIItems();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ProductionGeneralTab.this.mParentDlg.enableUIItems();
            }
        });
        this.mOutputFormatCombo = new JComboBox<String>(this.getOutputTypes());
        this.mOutputFormatCombo.setMaximumRowCount(this.getOutputTypes().length);
        if (OSCheck.getOSType() != OSInfo.OSType.WIN) {
            this.mOutputFormatCombo.removeItem(this.getOutputFormatName(OutputFormat.POWER_POINT));
        }
        this.mOutputFormatCombo.addActionListener(this);
        this.mOutputFormatCombo.addFocusListener(this);
        this.mOutputFormatComboLabel = new JLabel(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_LABEL"));
        this.mOutputFormatComboLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_LABEL_KEY"));
        this.mOutputFormatComboLabel.setLabelFor(this.mOutputFormatCombo);
        this.mOutputOptionsButton = new JButton(new AbstractAction(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_OPTIONS_BUTTON_LABEL")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputFormat outputFormat = ProductionGeneralTab.this.getOutputFormatType((String)ProductionGeneralTab.this.mOutputFormatCombo.getModel().getSelectedItem());
                ProductionOptionsDlg productionOptionsDlg = ProductionGeneralTab.this.getOptionsDialog(outputFormat);
                if (productionOptionsDlg != null) {
                    productionOptionsDlg.setVisible(true);
                }
            }
        });
        this.mOutputOptionsButton.setMnemonic(this.getDlgAccessKey("IDK_PRODUCTION_JOB_GENERAL_TAB_OPTIONS_BUTTON_LABEL_KEY"));
        this.mOutputFileBrowseButton = new JButton(new AbstractAction(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_BROWSE_BUTTON_LABEL")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                String string2 = (String)ProductionGeneralTab.this.mOutputFormatCombo.getModel().getSelectedItem();
                String string3 = ProductionGeneralTab.this.getOutputFileExtension();
                OutputFormat outputFormat = ProductionGeneralTab.this.getOutputFormatType(string2);
                String string4 = ProductionGeneralTab.this.mOutputFileField.getText();
                if (string4 != null && string4.length() > 0 && string4.lastIndexOf(File.separatorChar) > 0) {
                    string4 = string4.substring(0, string4.lastIndexOf(File.separatorChar));
                }
                if (outputFormat == OutputFormat.VIEWER || outputFormat == OutputFormat.WEB_REPORTS) {
                    string = ProductionGeneralTab.this.showFileDialog(OpenSaveType.OUTPUT, string3, string2, ProductionGeneralTab.this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SELECT_DIALOG_TITLE"), true, string4);
                    if (string != null && PES_Repository.isPesUri((String)string)) {
                        PesFile pesFile = new PesFile(string);
                        string = pesFile.getUri();
                    }
                } else {
                    string = ProductionGeneralTab.this.showFileDialog(OpenSaveType.OUTPUT, string3, string2, ProductionGeneralTab.this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SELECT_DIALOG_TITLE"), false, string4);
                }
                if (string != null && string.trim().length() > 0) {
                    ProductionGeneralTab.this.mOutputFileField.setText(string.trim());
                    ProductionGeneralTab.this.mOutputFileField.setToolTipText(string.trim());
                }
            }
        });
        this.mOutputFileBrowseButton.setMnemonic(this.getDlgAccessKey("IDK_PRODUCTION_JOB_GENERAL_TAB_FILE_NAME_BROWSE_KEY"));
        this.mPrintOnCompletionCheck = new JCheckBox(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_PRINT_ON_COMPLETION_CHECK_BOX"));
        this.mPrintOnCompletionCheck.setMnemonic(this.getDlgAccessKey("IDK_PRODUCTION_JOB_GENERAL_TAB_PRINT_ON_COMPLETION_CHECK_BOX_KEY"));
        this.mPrintOnCompletionCheck.addActionListener(this);
        this.mPrintOnCompletionCheck.addFocusListener(this);
        this.mPrintNote = new FocusableLabel(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_PRINT_NOTE"));
        this.mNewButton = new JButton(new AbstractAction(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_NEW_BUTTON")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ProductionGeneralTab.this.mParentDlg.validateTabs() && ProductionGeneralTab.this.mParentDlg.getModified() && !ProductionGeneralTab.this.querySaveDiscard()) {
                    return;
                }
                ProductionGeneralTab.this.setJobFileClean();
                ProductionGeneralTab.this.mJobFilesList.removeSelectionInterval(ProductionGeneralTab.this.mCurrentJobFileIndex, ProductionGeneralTab.this.mCurrentJobFileIndex);
                ProductionGeneralTab.this.mCurrentJobFileIndex = -1;
                String string = String.format(ProductionGeneralTab.this.getResString("IDS_PRODUCTION_GENERAL_TAB_NEW_FILENAME"), sDocumentCounter++);
                string = string + ProductionGeneralTab.this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_SPJ_EXTN");
                ProductionDocument productionDocument = new ProductionDocument();
                productionDocument.setDocName(string);
                ProductionGeneralTab.this.mParentDlg.loadState(productionDocument);
                ProductionGeneralTab.this.mParentDlg.setModified(true);
                ProductionGeneralTab.this.mParentDlg.setTitle(ProductionGeneralTab.this.getResString("IDS_PRODUCTION_MODE_CONSOLE_FILENAME_TITLE"));
                ProductionGeneralTab.this.mFile = null;
                ProductionGeneralTab.this.mParentDlg.enableUIItems();
            }
        });
        this.mNewButton.setMnemonic(this.getDlgAccessKey("IDK_PRODUCTION_JOB_GENERAL_TAB_NEW_BUTTON_KEY"));
        this.mSaveButton = new JButton(new AbstractAction(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SAVE_BUTTON")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProductionGeneralTab.this.doSave();
            }
        });
        this.mSaveButton.setMnemonic(this.getDlgAccessKey("IDK_PRODUCTION_JOB_GENERAL_TAB_SAVE_BUTTON_KEY"));
        this.mSaveAsButton = new JButton(new AbstractAction(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SAVE_AS_BUTTON")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProductionGeneralTab.this.doSaveAs();
            }
        });
        this.mSaveAsButton.setMnemonic(this.getDlgAccessKey("IDK_PRODUCTION_JOB_GENERAL_TAB_SAVE_AS_BUTTON_KEY"));
        this.mRunButton = new JButton(new AbstractAction(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_RUN_BUTTON")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProductionGeneralTab.this.doRun();
            }
        });
        this.mRunButton.setMnemonic(this.getDlgAccessKey("IDK_PRODUCTION_JOB_GENERAL_TAB_RUN_BUTTON_KEY"));
        this.mNote = new JTextArea(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_NOTE"));
        this.mNote.setLineWrap(true);
        this.mNote.setWrapStyleWord(true);
        this.mNote.setBorder(null);
        this.mNote.setOpaque(false);
        this.mNote.setFocusable(true);
        this.mNote.setEditable(false);
        this.mNote.setPreferredSize(new Dimension(450, 70));
        this.mRuntimeValuesTable = new PlainTable(){
            private int mRow = -1;
            private int mCol = -1;

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                if (!bl) {
                    return false;
                }
                Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    if (ComponentState.isBtdRtlOrLtr() && (n2 == 0 || n2 == 1 || n2 == 2) && ((JTextComponent)component).getDocument() != null) {
                        if (ComponentState.getBTD() == 1) {
                            ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                        } else {
                            ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                        }
                    }
                    ((JTextComponent)component).selectAll();
                }
                return bl;
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                this.mRow = this.getSelectedRow();
                this.mCol = this.getSelectedColumn();
                super.editingStopped(changeEvent);
                this.validateSymbol();
            }

            private void validateSymbol() {
                if (this.mCol == 0 && this.mRow != -1) {
                    String string = (String)ProductionGeneralTab.this.mRuntimeValuesTable.getValueAt(this.mRow, this.mCol);
                    if (string == null || string.trim().length() == 0) {
                        ProductionGeneralTab.this.mRuntimeValuesTableModel.removeRow(this.mRow);
                    } else if (string.charAt(0) != '@') {
                        String string2 = ProductionGeneralTab.this.getResString("ERR_PRODUCTION_JOB_GENERAL_TAB_SYMBOL_ERROR");
                        SpssAlertOptionPane.showConfirmDialog((Window)((Object)ProductionGeneralTab.this.mParentDlg), string2, VersionInfo.getAppVersionString(), null);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.changeSelection(mRow, mCol, false, false);
                                this.editCellAt(mRow, mCol, null);
                                this.getEditorComponent().requestFocusInWindow();
                            }
                        });
                    } else {
                        ProductionSymbol productionSymbol = new ProductionSymbol();
                        productionSymbol.setName(string.substring(1));
                        if (!productionSymbol.validateName()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this.changeSelection(mRow, mCol, false, false);
                                    this.editCellAt(mRow, mCol, null);
                                    this.getEditorComponent().requestFocusInWindow();
                                }
                            });
                        }
                    }
                }
            }
        };
        this.mRuntimeValuesTable.setSelectionMode(0);
        this.mRuntimeValuesTable.setRowSelectionAllowed(false);
        this.mRuntimeValuesTable.setCellSelectionEnabled(true);
        this.mRuntimeValuesTable.setAutoResizeMode(3);
        RuntimeValuesTableModel.COLUMN_NAMES[0] = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_TABLE_COLUMN_HEADER_1");
        RuntimeValuesTableModel.COLUMN_NAMES[1] = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_TABLE_COLUMN_HEADER_2");
        RuntimeValuesTableModel.COLUMN_NAMES[2] = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_TABLE_COLUMN_HEADER_3");
        RuntimeValuesTableModel.COLUMN_NAMES[3] = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_TABLE_COLUMN_HEADER_4");
        this.loadRuntimeValuesTableModel(null);
        if (ComponentState.isBtdRtlOrLtr()) {
            this.mRuntimeValuesTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JLabel jLabel = object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    jLabel.setBackground(jTable.getTableHeader().getBackground());
                    jLabel.setForeground(jTable.getTableHeader().getForeground());
                    return jLabel;
                }
            });
        } else {
            this.mRuntimeValuesTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        }
        this.mRuntimeValuesTable.putClientProperty("terminateEditOnFocusLost", Boolean.FALSE);
        this.mRuntimeValuesTable.setPreferredSize(new Dimension(500, this.mRuntimeValuesTable.getRowHeight() * this.mRuntimeValuesTable.getRowCount()));
        this.mRuntimeValuesTable.getTableHeader().setPreferredSize(new Dimension(500, this.mRuntimeValuesTable.getRowHeight()));
        if (this.mRuntimeValuesTableScrollPane == null) {
            this.mRuntimeValuesTableScrollPane = new JScrollPane(this.mRuntimeValuesTable, 20, 31);
        }
        this.mRuntimeValuesTableScrollPane.setBorder(this.mDefaultScrollPaneBorder);
        this.mRuntimeValuesTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mRuntimeValuesTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mRuntimeValuesTable.getActionMap().put("tabIn", abstractAction2);
        this.mRuntimeValuesTable.getActionMap().put("tabOut", abstractAction);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_PRODUCTION_JOB_GENERAL_TAB_UNICODE_ON_RADIO");
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this.mParentDlg, "IDS_PRODUCTION_JOB_GENERAL_TAB_UNICODE_OFF_RADIO");
        this.mUnicodeOnRadio = new JRadioButton(toggleButtonAction);
        this.mUnicodeOnRadio.addFocusListener(this);
        this.mUnicodeOffRadio = new JRadioButton(toggleButtonAction2);
        this.mUnicodeOffRadio.addFocusListener(this);
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction(this.mParentDlg, "IDS_PRODUCTION_JOB_GENERAL_TAB_CODEPAGESYNTAX_CHECK");
        this.mCodepageSyntaxFiles = new JCheckBox(toggleButtonAction3);
        this.mCodepageSyntaxFiles.addFocusListener(this);
        this.mEncodingButtonGroup = new SpssButtonGroup();
        this.mEncodingButtonGroup.add(this.mUnicodeOnRadio);
        this.mEncodingButtonGroup.add(this.mUnicodeOffRadio);
        this.mEncodingButtonGroup.setSelected(this.mUnicodeOnRadio.getModel(), true);
    }

    private void updateSyntaxFileTableToolTip() {
        int n = this.mSyntaxFileTable.getSelectedRow();
        if (n >= 0) {
            String string = this.mSyntaxFileTable.getModel().getValueAt(n, 0).toString();
            this.mSyntaxFileTable.setToolTipText(string);
        } else {
            this.mSyntaxFileTable.setToolTipText(null);
        }
    }

    private void ReadJobFile(String string) {
        String string2;
        File file = new File(string);
        PesFile pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
        if (pesFile != null) {
            string2 = PES_Repository.RetrieveFromPES((PesFile)pesFile, (boolean)false);
            file = pesFile.getCacheFile();
            if (file == null) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mParentDlg), string2, VersionInfo.getAppVersionString());
                return;
            }
            string = file.getAbsolutePath();
        }
        if ((string2 = new SpssFile(string)).hasExtension(SpssFile.Extension.SPSS_LEGACY_PRODUCTION_JOB)) {
            String string3 = this.getResString("ERR_PRODUCTION_JOB_GENERAL_TAB_LEGACY_PRODUCTION_JOB_MSG");
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mParentDlg), string3, VersionInfo.getAppVersionString());
            return;
        }
        ProductionDocument productionDocument = new ProductionDocument();
        if (productionDocument.openDocument((File)((Object)string2))) {
            String string4 = string2.getName();
            String string5 = String.format(this.getResString("IDS_PRODUCTION_MODE_CONSOLE_FILENAME_TITLE"), string4);
            this.mParentDlg.setTitle(string5);
            this.mParentDlg.loadState(productionDocument);
            this.mJobNameLabel.setText(string4);
            this.mFile = string2;
            this.mParentDlg.enableUIItems();
        }
    }

    private void setupPanel() {
        this.setLayout(new GridBagLayout());
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 2;
        JPanel jPanel = this.initTopPanel();
        JPanel jPanel2 = this.initLeftPanel();
        JPanel jPanel3 = this.initCenterPanel();
        JPanel jPanel4 = this.initRightPanel();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 3, 1, n, new Insets(insets2.top, insets.left, insets.bottom, insets.right));
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, insets.left, insets.bottom, insets2.right));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, new Insets(0, 0, insets.bottom, insets.right));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, jPanel4, gridBagConstraints, 2, 1, 1, 1, n, new Insets(0, insets.left, insets.bottom, insets.right));
    }

    private JPanel initTopPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mLocationFieldLabel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(insets.top, insets.left, insets.bottom, insets.right));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mLocationField), gridBagConstraints, 1, 0, 3, 1, n, new Insets(insets.top, insets.left, insets.bottom, insets.right));
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mLocationBrowseButton, gridBagConstraints, 4, 0, 1, 1, n, new Insets(insets.top, insets.left, insets.bottom, insets.right));
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_PRODUCTION_JOB_GENERAL_TAB_JOB_LIST_LABEL");
        jLabel.setLabelFor(this.mJobFilesList);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, new Insets(insets2.top, insets.left, insets.bottom, insets.right));
        return jPanel;
    }

    private JPanel initLeftPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mJobFilesListScrollPane, gridBagConstraints, 0, 0, 1, 1, n, new Insets(insets.top, insets.left, insets.bottom, insets.right));
        return jPanel;
    }

    private JPanel initCenterPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JPanel jPanel2 = this.initSyntaxPanel();
        JPanel jPanel3 = this.initOutputPanel();
        JPanel jPanel4 = this.initRuntimeValuesPanel();
        JPanel jPanel5 = this.initDefaultUnicodePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mJobNameLabel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(insets.top, insets.left, insets.bottom, 0));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, insets.left, insets.bottom, 0));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n, new Insets(0, insets.left, insets.bottom, 0));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 3, 1, 1, n, new Insets(0, insets.left, insets.bottom, 0));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 4, 1, 1, n, new Insets(0, insets.left, insets.bottom, 0));
        return jPanel;
    }

    private JPanel initRightPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        Insets insets2 = new Insets(7, insets.left, 0, insets.right);
        JTextArea jTextArea = new JTextArea("");
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 0, 1, 1, n, new Insets(insets.top, insets.left, insets.bottom, 0));
        DialogUtil.addUsingGBL(jPanel, this.mNewButton, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, insets.left, 0, insets.right));
        DialogUtil.addUsingGBL(jPanel, this.mSaveButton, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mSaveAsButton, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mRunButton, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel initSyntaxPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SYNTAX_FILES_GROUP")));
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSyntaxFileTableScrollPane, gridBagConstraints, 0, 0, 2, 4, n, new Insets(insets.top, insets.left, insets.bottom, insets.right));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mAddButton, gridBagConstraints, 2, 0, 1, 1, n, new Insets(2 * insets.top + insets.bottom, insets.left, insets.bottom, insets.right));
        DialogUtil.addUsingGBL(jPanel, this.mUpButton, gridBagConstraints, 2, 1, 1, 1, n, new Insets(insets.top, insets.left, insets.bottom, insets.right));
        DialogUtil.addUsingGBL(jPanel, this.mDownButton, gridBagConstraints, 2, 2, 1, 1, n, new Insets(insets.top, insets.left, insets.bottom, insets.right));
        DialogUtil.addUsingGBL(jPanel, this.mDeleteButton, gridBagConstraints, 2, 3, 1, 1, n, new Insets(insets.top, insets.left, insets.bottom, insets.right));
        gridBagConstraints.fill = 2;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        this.mSyntaxFormatComboLabel.setAlignmentX(0.0f);
        jPanel2.add(this.mSyntaxFormatComboLabel);
        this.mSyntaxFormatCombo.setAlignmentX(0.0f);
        jPanel2.add(this.mSyntaxFormatCombo);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 4, 1, 1, n, insets);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        this.mErrorProcessingComboLabel.setAlignmentX(0.0f);
        jPanel3.add(this.mErrorProcessingComboLabel);
        this.mErrorProcessingCombo.setAlignmentX(0.0f);
        jPanel3.add(this.mErrorProcessingCombo);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 4, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel initOutputPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_OUTPUT_GROUP")));
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mOutputFileFieldLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mOutputFileField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mOutputFileBrowseButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mOutputFormatComboLabel, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, insets.left, insets.bottom, insets.right));
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mOutputFormatCombo, gridBagConstraints, 1, 1, 1, 1, n, new Insets(0, insets.left, insets.bottom, insets.right));
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mOutputOptionsButton, gridBagConstraints, 2, 1, 1, 1, n, new Insets(0, insets.left, insets.bottom, insets.right));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mPrintOnCompletionCheck, gridBagConstraints, 0, 2, 2, 1, n, new Insets(insets.top, insets.left + 15, insets.bottom, insets.right));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mPrintNote, gridBagConstraints, 0, 3, 2, 1, n, new Insets(insets.top, insets.left + 15, insets.bottom, insets.right));
        return jPanel;
    }

    private JPanel initRuntimeValuesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_RUNTIME_VALUES_GROUP")));
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mNote, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, insets.left, insets.bottom, insets.right));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mRuntimeValuesTableScrollPane, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, insets.left, insets.bottom, insets.right));
        return jPanel;
    }

    private JPanel initDefaultUnicodePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mUnicodeOnRadio, this.mUnicodeOffRadio, this.mCodepageSyntaxFiles};
        return PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_UNICODE_GROUP_BOX"), 2);
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mLocationBrowseButton);
        this.mComponentOrder.add(this.mJobFilesList);
        this.mComponentOrder.add(this.mSyntaxFileTable);
        this.mComponentOrder.add(this.mAddButton);
        this.mComponentOrder.add(this.mUpButton);
        this.mComponentOrder.add(this.mDownButton);
        this.mComponentOrder.add(this.mDeleteButton);
        this.mComponentOrder.add(this.mSyntaxFormatCombo);
        this.mComponentOrder.add(this.mErrorProcessingCombo);
        this.mComponentOrder.add(this.mOutputFileField);
        this.mComponentOrder.add(this.mOutputFileBrowseButton);
        this.mComponentOrder.add(this.mOutputFormatCombo);
        this.mComponentOrder.add(this.mOutputOptionsButton);
        this.mComponentOrder.add(this.mPrintOnCompletionCheck);
        this.mComponentOrder.add(this.mPrintNote);
        this.mComponentOrder.add(this.mNote);
        this.mComponentOrder.add(this.mRuntimeValuesTable);
        this.mComponentOrder.add(this.mEncodingButtonGroup);
        this.mComponentOrder.add(this.mNewButton);
        this.mComponentOrder.add(this.mSaveButton);
        this.mComponentOrder.add(this.mSaveAsButton);
        this.mComponentOrder.add(this.mRunButton);
        this.mComponentOrder.add(this.mParentDlg.getCloseButton());
        this.mComponentOrder.add(this.mParentDlg.getHelpButton());
    }

    private void loadSyntaxFileTableModel(ProductionDocument productionDocument) {
        Vector<String> vector = new Vector<String>();
        if (productionDocument != null) {
            TableModelListener[] tableModelListenerArray = this.mSyntaxFileTableModel.getTableModelListeners();
            for (TableModelListener tableModelListener : tableModelListenerArray) {
                this.mSyntaxFileTableModel.removeTableModelListener(tableModelListener);
            }
            LinkedList linkedList = productionDocument.getJob().getSyntaxFilenames();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                vector.addElement(string);
            }
        }
        this.mSyntaxFileTableModel = new SyntaxFileTableModel(vector, this.mSyntaxFileTable);
        this.mSyntaxFileTableModel.addTableModelListener(this);
        this.mSyntaxFileTable.setModel(this.mSyntaxFileTableModel);
        if (this.mSyntaxFileTableModel.getRowCount() > 0) {
            this.mSyntaxFileTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void sizeSyntaxFileTable() {
        Dimension dimension = this.mSyntaxFileTableScrollPane.getSize();
        dimension.height = 5 * this.mSyntaxFileTable.getRowHeight() + 2;
        this.mSyntaxFileTableScrollPane.setMinimumSize(dimension);
        this.mSyntaxFileTableScrollPane.setPreferredSize(dimension);
        this.mSyntaxFileTableScrollPane.setMaximumSize(dimension);
    }

    private void loadOutputFormat(ProductionDocument productionDocument) {
        if (productionDocument == null) {
            return;
        }
        ProductionOutput productionOutput = productionDocument.getJob().getOutput();
        OutputFormat outputFormat = productionOutput.getOutputFormat();
        if (OSCheck.getOSType() != OSInfo.OSType.WIN && outputFormat == OutputFormat.POWER_POINT) {
            outputFormat = OutputFormat.VIEWER;
        }
        this.mOutputFormatCombo.getModel().setSelectedItem(this.getOutputFormatName(outputFormat));
    }

    private void processLocationBrowseButton() {
        String string;
        if (this.mParentDlg.validateTabs() && this.mParentDlg.getModified() && !this.querySaveDiscard()) {
            return;
        }
        String string2 = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_LOCATION_DIALOG_TITLE");
        String string3 = this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_SPJ_EXTN");
        String string4 = this.showFileDialog(OpenSaveType.OPEN, string3, string = this.getResString("IDS_PRODUCTION_JOB_SPJ_FILE_FILTER"), string2, true);
        if (string4 != null) {
            Object object;
            if (PES_Repository.isPesUri((String)(string4 = string4.trim()))) {
                object = new PesFile(string4);
                string4 = object.getUri().trim();
            }
            if (string4.length() > 0) {
                object = new File(string4);
                this.doUpdateFromFile((File)object);
            }
        }
    }

    private void doUpdateFromFile(File file) {
        String string = file.getPath().trim();
        String string2 = file.getName();
        File file2 = new File(string.substring(0, string.lastIndexOf(string2)));
        String string3 = file2.getAbsolutePath();
        FileLocationsUtil.setOtherFilesDirectoryPath((String)string3);
        this.mLocationField.setText(string3);
        this.mLocationField.setToolTipText(string3);
        this.PopulateJobFilesListbox(string3);
        this.enableJobFilesList();
        this.mJobFilesList.setSelectedValue(string2, true);
        this.mCurrentJobFileIndex = this.mJobFilesList.getSelectedIndex();
        this.ReadJobFile(string);
    }

    @Override
    protected boolean validateTab() {
        if (this.mRuntimeValuesTable.isEditing()) {
            this.mRuntimeValuesTable.getCellEditor().stopCellEditing();
        }
        return super.validateTab();
    }

    private String showFileDialog(OpenSaveType openSaveType, String string, String string2, String string3) {
        return this.showFileDialog(openSaveType, string, string2, string3, false);
    }

    private String showFileDialog(OpenSaveType openSaveType, String string, String string2, String string3, boolean bl) {
        return this.showFileDialog(openSaveType, string, string2, string3, bl, "");
    }

    private String showFileDialog(OpenSaveType openSaveType, String string, String string2, String string3, boolean bl, String string4) {
        if (string4 == null || string4.length() <= 0) {
            string4 = FileLocationsUtil.getOtherFilesDirectoryPath();
        }
        RemoteFileChooser remoteFileChooser = (openSaveType == OpenSaveType.SAVE || openSaveType == OpenSaveType.OUTPUT) && bl ? new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, string4, false, false, false, true) : (openSaveType == OpenSaveType.OPEN && bl ? new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, string4, false, false, false, true) : (openSaveType == OpenSaveType.SAVE || openSaveType == OpenSaveType.OUTPUT ? new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.GenericWithoutPES, string4, false) : new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.GenericWithoutPES, string4, false)));
        remoteFileChooser.setDialogTitle(string3);
        remoteFileChooser.setFileSelectionMode(0);
        RefFileFilter refFileFilter = new RefFileFilter(string2, string);
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        if (openSaveType == OpenSaveType.SAVE || openSaveType == OpenSaveType.OUTPUT) {
            remoteFileChooser.setAcceptAllFileFilterUsed(false);
        } else if (openSaveType == OpenSaveType.OPEN && bl) {
            remoteFileChooser.setAcceptAllFileFilterUsed(false);
        } else {
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
        }
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        int n = openSaveType == OpenSaveType.SAVE ? remoteFileChooser.showSaveDialog((Component)((Object)this.mParentDlg), this.mJobNameLabel.getText()) : (openSaveType == OpenSaveType.OUTPUT ? remoteFileChooser.showSaveDialog((Component)((Object)this.mParentDlg), this.mOutputFileField.getText()) : remoteFileChooser.showOpenDialog((Component)((Object)this.mParentDlg)));
        if (n == 0) {
            File file = remoteFileChooser.getSelectedFile();
            String string5 = file.getAbsolutePath().trim();
            if (openSaveType == OpenSaveType.SAVE && string5.lastIndexOf(".") == -1) {
                string5 = string5.concat(string);
            }
            return string5;
        }
        return null;
    }

    boolean isComplete() {
        boolean bl = false;
        if (this.hasDocument()) {
            String string = (String)this.mSyntaxFileTableModel.getValueAt(0, 0);
            String string2 = this.mOutputFileField.getText();
            if (string != null && string.trim().length() > 0 && string2 != null && string2.trim().length() > 0) {
                bl = true;
            }
        }
        return bl;
    }

    boolean hasDocument() {
        return this.mParentDlg != null && this.mParentDlg.hasDocument();
    }

    boolean validateOutputFile() {
        this.appendOutputFileExtension();
        return FileValidator.validatePath(this, this.mOutputFileField.getText(), true, false);
    }

    private void replaceOutputFileFieldExtension() {
        File file = new File(this.mOutputFileField.getText().trim());
        String string = file.getPath();
        string = string.substring(0, string.lastIndexOf("."));
        if ((string = string + this.getOutputFileExtension()).length() > 0) {
            this.mProcessRemoveUpdate = false;
        }
        this.mOutputFileField.setText(string);
        this.mProcessRemoveUpdate = true;
    }

    void appendOutputFileExtension() {
        File file = new File(this.mOutputFileField.getText().trim());
        String string = file.getPath();
        String string2 = this.getOutputFileExtension();
        if (string.length() > 0 && !string.endsWith(string2)) {
            string = string + string2;
        }
        if (string != null && string.length() > 0) {
            this.mProcessRemoveUpdate = false;
        }
        this.mOutputFileField.setText(string);
        this.mProcessRemoveUpdate = true;
    }

    private boolean isOutputFileExtensionValid() {
        File file = new File(this.mOutputFileField.getText().trim());
        String string = file.getPath();
        boolean bl = string.endsWith(this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_SPV_EXTN")) || string.endsWith(this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_SPW_EXTN")) || string.endsWith(this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_HTM_EXTN")) || string.endsWith(this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_XLS_EXTN")) || string.endsWith(this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_XLSX_EXTN")) || string.endsWith(this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_XLSM_EXTN")) || string.endsWith(this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_DOC_EXTN")) || string.endsWith(this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_PPT_EXTN")) || string.endsWith(this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_PDF_EXTN")) || string.endsWith(this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_TXT_EXTN"));
        return bl;
    }

    private String getOutputFileExtension() {
        String string = "";
        OutputFormat outputFormat = this.getOutputFormatType((String)this.mOutputFormatCombo.getModel().getSelectedItem());
        switch (outputFormat) {
            case VIEWER: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_SPV_EXTN");
                break;
            }
            case WEB_REPORTS: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_SPW_EXTN");
                break;
            }
            case HTML: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_HTM_EXTN");
                break;
            }
            case EXCEL: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_XLS_EXTN");
                break;
            }
            case EXCELX: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_XLSX_EXTN");
                break;
            }
            case EXCELM: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_XLSM_EXTN");
                break;
            }
            case WORD: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_DOC_EXTN");
                break;
            }
            case POWER_POINT: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_PPT_EXTN");
                break;
            }
            case PDF: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_PDF_EXTN");
                break;
            }
            case TEXT_CODEPAGE: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_TXT_EXTN");
                break;
            }
            case TEXT_UTF8: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_TXT_EXTN");
                break;
            }
            case TEXT_UTF16: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_TXT_EXTN");
            }
        }
        return string;
    }

    private OutputFormat getOutputFormatType(String string) {
        OutputFormat outputFormat = OutputFormat.VIEWER;
        if (string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_VIEWER"))) {
            outputFormat = OutputFormat.VIEWER;
        } else if (string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_WEB_REPORTS"))) {
            outputFormat = OutputFormat.WEB_REPORTS;
        } else if (string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_HTML"))) {
            outputFormat = OutputFormat.HTML;
        } else if (string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_EXCEL"))) {
            outputFormat = OutputFormat.EXCEL;
        } else if (string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_EXCELX"))) {
            outputFormat = OutputFormat.EXCELX;
        } else if (string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_EXCELM"))) {
            outputFormat = OutputFormat.EXCELM;
        } else if (string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_WORD"))) {
            outputFormat = OutputFormat.WORD;
        } else if (string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_POWER_POINT"))) {
            outputFormat = OutputFormat.POWER_POINT;
        } else if (string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_PDF"))) {
            outputFormat = OutputFormat.PDF;
        } else if (string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_TEXT_CODEPAGE"))) {
            outputFormat = OutputFormat.TEXT_CODEPAGE;
        } else if (string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_TEXT_UTF8"))) {
            outputFormat = OutputFormat.TEXT_UTF8;
        } else if (string.equals(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_TEXT_UTF16"))) {
            outputFormat = OutputFormat.TEXT_UTF16;
        }
        return outputFormat;
    }

    private String getOutputFormatName(OutputFormat outputFormat) {
        String string = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_VIEWER");
        switch (outputFormat) {
            case VIEWER: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_VIEWER");
                break;
            }
            case WEB_REPORTS: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_WEB_REPORTS");
                break;
            }
            case HTML: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_HTML");
                break;
            }
            case EXCEL: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_EXCEL");
                break;
            }
            case EXCELX: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_EXCELX");
                break;
            }
            case EXCELM: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_EXCELM");
                break;
            }
            case WORD: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_WORD");
                break;
            }
            case POWER_POINT: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_POWER_POINT");
                break;
            }
            case PDF: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_PDF");
                break;
            }
            case TEXT_CODEPAGE: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_TEXT_CODEPAGE");
                break;
            }
            case TEXT_UTF8: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_TEXT_UTF8");
                break;
            }
            case TEXT_UTF16: {
                string = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_TEXT_UTF16");
            }
        }
        return string;
    }

    boolean querySaveDiscard() {
        boolean bl = false;
        if (this.isComplete()) {
            String string = String.format(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SAVE_CHANGES_MSG"), this.mJobNameLabel.getText());
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mParentDlg), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_CANCEL_OPTION);
            if (n == 1) {
                bl = this.doSave();
            } else if (n == 2) {
                bl = true;
            }
        } else {
            String string = String.format(this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_DISCARD_CHANGES_MSG"), this.mJobNameLabel.getText());
            if (SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mParentDlg), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION) == 1) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setJobFileDirty();
        if (this.mSyntaxFileTable.getModel().getValueAt(0, 0) != null) {
            this.mParentDlg.enableUIItems();
        }
    }

    public String getOutputFormatString(OutputFormat outputFormat) {
        String string = String.format("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_%d", outputFormat.ordinal());
        ResourceBundle resourceBundle = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        return UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)string);
    }

    private ProductionOptionsDlg getOptionsDialog(OutputFormat outputFormat) {
        ProductionOptionsDlg productionOptionsDlg = null;
        switch (outputFormat) {
            case HTML: {
                if (this.mHTMLDialog == null) {
                    this.mHTMLDialog = new ProductionHTMLOptionsDlg(this.mParentDlg, this.getResString("IDS_PRODUCTION_HTML_OPTIONS_TITLE"), true);
                    this.mHTMLDialog.loadOptions();
                }
                productionOptionsDlg = this.mHTMLDialog;
                break;
            }
            case POWER_POINT: {
                if (this.mPPTDialog == null) {
                    this.mPPTDialog = new ProductionPPTOptionsDlg(this.mParentDlg, this.getResString("IDS_PRODUCTION_PPT_OPTIONS_TITLE"), true);
                    this.mPPTDialog.loadOptions();
                }
                productionOptionsDlg = this.mPPTDialog;
                break;
            }
            case PDF: {
                if (this.mPDFDialog == null) {
                    this.mPDFDialog = new ProductionPDFOptionsDlg(this.mParentDlg, this.getResString("IDS_PRODUCTION_PDF_OPTIONS_TITLE"), true);
                    this.mPDFDialog.loadOptions();
                }
                productionOptionsDlg = this.mPDFDialog;
                break;
            }
            case TEXT_CODEPAGE: 
            case TEXT_UTF8: 
            case TEXT_UTF16: {
                if (this.mTextDialog == null) {
                    this.mTextDialog = new ProductionTextOptionsDlg(this.mParentDlg, this.getResString("IDS_PRODUCTION_TEXT_OPTIONS_TITLE"), true);
                    this.mTextDialog.loadOptions();
                }
                productionOptionsDlg = this.mTextDialog;
                break;
            }
        }
        return productionOptionsDlg;
    }

    private void saveSyntaxFileTableModel(ProductionDocument productionDocument) {
        if (productionDocument == null) {
            return;
        }
        LinkedList linkedList = productionDocument.getJob().getSyntaxFilenames();
        linkedList.clear();
        for (int i = 0; i < this.mSyntaxFileTableModel.getRowCount(); ++i) {
            String string = (String)this.mSyntaxFileTableModel.getValueAt(i, 0);
            if (string == null || string.length() <= 0) continue;
            linkedList.add(string);
        }
    }

    private boolean doSave() {
        if (this.mFile == null) {
            return this.doSaveAs();
        }
        return this.save(this.mFile);
    }

    private boolean save(File file) {
        boolean bl = false;
        if (file != null) {
            String string = file.getName();
            String string2 = String.format(this.getResString("IDS_PRODUCTION_MODE_CONSOLE_FILENAME_TITLE"), string);
            this.mParentDlg.setTitle(string2);
            this.saveJob(file);
            this.setJobFileClean();
            this.mJobNameLabel.setText(string);
            bl = true;
        }
        return bl;
    }

    private boolean doSaveAs() {
        String string;
        boolean bl = false;
        String string2 = this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_SAVE_AS_SPJ_DIALOG_TITLE");
        String string3 = this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_SPJ_EXTN");
        String string4 = this.showFileDialog(OpenSaveType.SAVE, string3, string = this.getResString("IDS_PRODUCTION_JOB_SPJ_FILE_FILTER"), string2);
        if (string4 != null && string4.length() > 0) {
            File file = new File(string4);
            bl = this.save(file);
            if (bl) {
                this.doUpdateFromFile(file);
                this.mSaveAsButton.requestFocusInWindow();
            } else {
                this.mFile = null;
            }
        }
        return bl;
    }

    private boolean doRun() {
        boolean bl = true;
        if (this.mParentDlg.getModified()) {
            this.setJobFileDirty();
        } else {
            this.setJobFileClean();
        }
        File file = this.saveTempJob();
        if (file != null && this.validateOutputFile()) {
            String string = file.getName();
            int n = string.lastIndexOf(".");
            if (n > 0) {
                string = string.substring(0, n);
            }
            RunOptionsDlg runOptionsDlg = new RunOptionsDlg(this.mParentDlg);
            runOptionsDlg.setVisible(true);
            boolean bl2 = runOptionsDlg.getModalResult();
            if (bl2) {
                boolean bl3 = runOptionsDlg.runInteractively();
                new ProductionRunJob((JDialog)((Object)this.mParentDlg), string, file, bl3, this.mUnicodeOnRadio.isSelected(), this.mCodepageSyntaxFiles.isSelected(), runOptionsDlg.getServerObject());
            }
        }
        return bl;
    }

    public File saveTempJob() {
        File file = new File(PrefsMgr.getPrefsMgr().getTempPath());
        String string = this.mParentDlg.getDocument().getDocName();
        if (!string.endsWith(this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_SPJ_EXTN"))) {
            string = string + this.getResString("IDS_PRODUCTION_JOB_GENRAL_TAB_SPJ_EXTN");
        }
        File file2 = new File(file, string);
        file2.deleteOnExit();
        if (!this.saveJob(file2)) {
            file2 = null;
        }
        return file2;
    }

    private boolean saveJob(File file) {
        this.mParentDlg.saveState();
        return this.mParentDlg.getDocument().saveDocument(file, false);
    }

    private boolean enableNewButton() {
        this.mNewButton.setEnabled(true);
        return true;
    }

    private boolean enableJobFilesList() {
        boolean bl = this.validatePath(this.mLocationField.getText().trim());
        if (!bl) {
            this.ClearListboxModel();
        }
        this.mJobFilesList.setEnabled(bl);
        this.mJobFilesList.repaint();
        return bl;
    }

    private boolean validatePath(String string) {
        boolean bl = false;
        if (string == null || string.length() == 0) {
            bl = true;
        } else {
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean enableSyntaxFileTable() {
        boolean bl = this.hasDocument();
        this.mSyntaxFileTable.setEnabled(bl);
        this.mSyntaxFileTable.getTableHeader().setEnabled(bl);
        this.mSyntaxFileTableScrollPane.setEnabled(bl);
        this.updateSyntaxFileTableToolTip();
        return bl;
    }

    private boolean enableSyntaxFileUpArrowButton() {
        int n = this.mSyntaxFileTable.getSelectedRow();
        this.mSyntaxFileTableModel.getRowCount();
        boolean bl = this.hasDocument() && n > 0;
        this.mUpButton.setEnabled(bl);
        return bl;
    }

    private boolean enableSyntaxFileDownArrowButton() {
        int n = this.mSyntaxFileTable.getSelectedRow();
        int n2 = this.mSyntaxFileTableModel.getRowCount();
        boolean bl = this.hasDocument() && n > -1 && n < n2 - 1;
        this.mDownButton.setEnabled(bl);
        return bl;
    }

    private boolean enableSyntaxFileAddArrowButton() {
        boolean bl = this.hasDocument();
        this.mAddButton.setEnabled(bl);
        return bl;
    }

    private boolean enableSyntaxFileDeleteArrowButton() {
        int n = this.mSyntaxFileTable.getSelectedRow();
        boolean bl = this.hasDocument() && n > -1;
        this.mDeleteButton.setEnabled(bl);
        return bl;
    }

    private void enableSyntaxFileArrowButtons() {
        this.enableSyntaxFileAddArrowButton();
        this.enableSyntaxFileUpArrowButton();
        this.enableSyntaxFileDownArrowButton();
        this.enableSyntaxFileDeleteArrowButton();
    }

    private boolean enableSyntaxFormatCombo() {
        boolean bl = this.hasDocument();
        this.mSyntaxFormatComboLabel.setEnabled(bl);
        this.mSyntaxFormatCombo.setEnabled(bl);
        return bl;
    }

    private boolean enableErrorProcessingCombo() {
        boolean bl = this.hasDocument();
        this.mErrorProcessingComboLabel.setEnabled(bl);
        this.mErrorProcessingCombo.setEnabled(bl);
        return bl;
    }

    private boolean enableOutputFileFields() {
        boolean bl = this.hasDocument();
        this.mOutputFileFieldLabel.setEnabled(bl);
        this.mOutputFileField.setEnabled(bl);
        this.mOutputFileBrowseButton.setEnabled(bl);
        return bl;
    }

    private boolean enableOutputFormatControls() {
        boolean bl = this.hasDocument();
        this.mOutputFormatCombo.setEnabled(bl);
        this.mOutputFormatComboLabel.setEnabled(bl);
        bl = this.hasDocument() && this.getOutputFormatType((String)this.mOutputFormatCombo.getModel().getSelectedItem()).hasOptions();
        this.mOutputOptionsButton.setEnabled(bl);
        return bl;
    }

    private boolean enablePrintOnCompletionCheck() {
        boolean bl = this.hasDocument();
        this.mPrintOnCompletionCheck.setEnabled(bl);
        return bl;
    }

    private boolean enableUnicodeRadioButtons() {
        boolean bl = this.hasDocument();
        this.mUnicodeOnRadio.setEnabled(bl);
        this.mUnicodeOffRadio.setEnabled(bl);
        this.mCodepageSyntaxFiles.setEnabled(bl);
        return bl;
    }

    private boolean enableRuntimeValuesTable() {
        boolean bl = this.mParentDlg != null && this.mParentDlg.hasDocument();
        this.mRuntimeValuesTable.setEnabled(bl);
        return bl;
    }

    private boolean enableSaveAsButton() {
        boolean bl = this.isComplete();
        this.mSaveAsButton.setEnabled(bl);
        return bl;
    }

    private boolean enableSaveButton() {
        boolean bl = this.isComplete();
        this.mSaveButton.setEnabled(bl);
        return bl;
    }

    private boolean enableRunButton() {
        boolean bl = this.isComplete();
        this.mRunButton.setEnabled(bl);
        return bl;
    }

    private void saveRuntimeValuesTableModel(ProductionDocument productionDocument) {
        if (productionDocument == null) {
            return;
        }
        LinkedHashMap linkedHashMap = productionDocument.getJob().getSymbols();
        linkedHashMap.clear();
        for (int i = 0; i < this.mRuntimeValuesTableModel.getRowCount(); ++i) {
            String string = (String)this.mRuntimeValuesTableModel.getValueAt(i, 0);
            if (string == null || string.length() <= 0) continue;
            ProductionSymbol productionSymbol = new ProductionSymbol();
            String string2 = string.substring(1);
            productionSymbol.setName(string2);
            productionSymbol.setDefault((String)this.mRuntimeValuesTableModel.getValueAt(i, 1));
            productionSymbol.setPrompt((String)this.mRuntimeValuesTableModel.getValueAt(i, 2));
            productionSymbol.setQuoteValue(((Boolean)this.mRuntimeValuesTableModel.getValueAt(i, 3)).booleanValue());
            linkedHashMap.put(string2, productionSymbol);
        }
    }

    private void loadRuntimeValuesTableModel(ProductionDocument productionDocument) {
        Vector<RuntimeValuesTableItem> vector = new Vector<RuntimeValuesTableItem>();
        if (productionDocument != null) {
            TableModelListener[] tableModelListenerArray = this.mRuntimeValuesTableModel.getTableModelListeners();
            for (TableModelListener object : tableModelListenerArray) {
                this.mRuntimeValuesTableModel.removeTableModelListener(object);
            }
            LinkedHashMap linkedHashMap = productionDocument.getJob().getSymbols();
            Set set = linkedHashMap.entrySet();
            for (Map.Entry entry : set) {
                ProductionSymbol productionSymbol = (ProductionSymbol)entry.getValue();
                vector.addElement(new RuntimeValuesTableItem(String.format("@%s", productionSymbol.getName()), productionSymbol.getDefault(), productionSymbol.getPrompt(), productionSymbol.quoteValue()));
            }
            vector.addElement(new RuntimeValuesTableItem("", "", "", false));
        } else {
            vector.addElement(new RuntimeValuesTableItem("", "", "", false));
        }
        this.mRuntimeValuesTableModel = new RuntimeValuesTableModel(vector, this.mRuntimeValuesTable);
        this.mRuntimeValuesTableModel.addTableModelListener(this);
        this.mRuntimeValuesTable.setModel(this.mRuntimeValuesTableModel);
    }

    private void sizeRuntimeValuesTable() {
        this.mRuntimeValuesTable.getColumnModel().getColumn(0).setPreferredWidth(65);
        this.mRuntimeValuesTable.getColumnModel().getColumn(1).setPreferredWidth(65);
        this.mRuntimeValuesTable.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.mRuntimeValuesTable.getColumnModel().getColumn(3).setPreferredWidth(65);
        int n = this.mRuntimeValuesTable.getRowCount() + 1;
        Dimension dimension = this.mRuntimeValuesTableScrollPane.getSize();
        dimension.height = n * this.mRuntimeValuesTable.getRowHeight() + 2;
        this.mRuntimeValuesTableScrollPane.setPreferredSize(dimension);
        dimension.height = 2 * this.mRuntimeValuesTable.getRowHeight() + 2;
        this.mRuntimeValuesTableScrollPane.setMinimumSize(dimension);
        dimension.height = 5 * this.mRuntimeValuesTable.getRowHeight() + 2;
        this.mRuntimeValuesTableScrollPane.setMaximumSize(dimension);
    }

    public String[] getOutputTypes() {
        return new String[]{this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_VIEWER"), this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_WEB_REPORTS"), this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_WORD"), this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_EXCEL"), this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_EXCELX"), this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_HTML"), this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_PDF"), this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_POWER_POINT"), this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_TEXT_CODEPAGE"), this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_TEXT_UTF8"), this.getResString("IDS_PRODUCTION_JOB_GENERAL_TAB_FORMAT_COMBO_OPTION_TEXT_UTF16")};
    }

    private static enum OpenSaveType {
        OPEN,
        SAVE,
        OUTPUT;

    }

    class MyTableHeaderRenderer
    extends DefaultTableCellRenderer {
        MyTableHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Color color = jTable.isEnabled() ? UIManager.getColor("Table.foreground") : Color.gray;
            component.setForeground(color);
            return component;
        }
    }

    class SyntaxFileTable
    extends JTable {
        SyntaxFileTable() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            super.valueChanged(listSelectionEvent);
            ProductionGeneralTab.this.enableUIItems();
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            int n = ProductionGeneralTab.this.mSyntaxFileTable.rowAtPoint(mouseEvent.getPoint());
            return ProductionGeneralTab.this.mSyntaxFileTable.getModel().getValueAt(n, 0).toString();
        }
    }

    class FilePathVerifier
    extends InputVerifier {
        FilePathVerifier() {
        }

        @Override
        public boolean verify(JComponent jComponent) {
            boolean bl;
            FileTextField fileTextField = (FileTextField)((Object)jComponent);
            fileTextField.setInputVerifier(null);
            String string = fileTextField.getText();
            if (string == null) {
                string = "";
                fileTextField.setText("");
            } else {
                String string2 = string;
                if (!string2.equals(string = string.trim())) {
                    fileTextField.setText(string);
                }
            }
            boolean bl2 = bl = string.length() == 0 || ProductionGeneralTab.this.validatePath(string);
            if (!bl) {
                SpssAlertOptionPane.showWarningMessageDialog(ProductionGeneralTab.this, CoreResUtil.getString((String)"ERR_FOLDER_DOESNT_EXIST_WARNING_MESSAGE"), VersionInfo.getAppVersionString());
            }
            fileTextField.setInputVerifier(this);
            return bl;
        }
    }
}

