/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.core.common.ClusterMgr;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LogonMgr;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.production.ProductionJobClient;
import com.spss.java_client.core.documents.production.ProductionJobErrorCodes;
import com.spss.java_client.core.server.ClusterObject;
import com.spss.java_client.core.server.ServerObject;
import com.spss.java_client.core.server.messages.prodjobmsg.ProductionJobStatus;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.TableSorter;
import com.spss.java_client.ui.dialogs.base.utilities.production.BaseProgressDialog;
import com.spss.java_client.ui.dialogs.base.utilities.production.JobStatusTableModel;
import com.spss.java_client.ui.dialogs.base.utilities.production.ProductionJobDlg;
import com.spss.java_client.ui.dialogs.common.BaseSpssTab;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.LogonDlg;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.pes.util.io.FileUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.TableUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class ProductionBKJobStatusTab
extends BaseSpssTab
implements ActionListener {
    public static final Comparator<Object> STRING_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            return string.compareToIgnoreCase(string2);
        }
    };
    public static final Comparator<Object> INTEGER_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            Integer n = (Integer)object;
            Integer n2 = (Integer)object2;
            return n.compareTo(n2);
        }
    };
    public final int OUTPUT_FILE_TEXT_FIELD_SIZE = 25;
    private final int SERVER_COUNT_FOR_PROGRESS_DLG = 5;
    public HashMap<String, String> mExtensionMap;
    private ServerObject mServerObject = null;
    private JobStatusTable mJobStatusTable;
    private JScrollPane mJobStatusTableScrollPane;
    private MyTableSorter mTableSorter;
    ProductionJobDlg mParentDlg;
    private JTextField mServerNameTextField;
    private JButton mSelectServerButton;
    private JButton mRefreshButton;
    private JButton mGetJobOutputButton;
    private JButton mCancelJobButton;
    private JButton mRemoveJobButton;
    private JLabel mLastUpdatedLabel;
    private RemoteFileChooser mFileChooser;
    private static int mNumServerConnectAttempts = 0;
    private static boolean mErrorConnectingToAllServers = false;
    private static Cursor mOldCursor = null;
    private ServerConnectProgressDialog mServerConnectProgressDialog;
    HashSet<ProductionJobClient> mServerConnectionsSet = new HashSet();

    public ProductionBKJobStatusTab(ProductionJobDlg productionJobDlg, boolean bl) {
        super(productionJobDlg, bl);
        this.mParentDlg = productionJobDlg;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prod_substitute";
    }

    @Override
    public void reset() {
        super.reset();
        this.loadTabState();
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        mOldCursor = this.getCursor();
        this.initExtensionMap();
        this.initVariables();
        this.setupPanel();
        this.setFocusTraversalPolicy();
    }

    @Override
    public void aboutToShowTab() {
        JobStatusTableModel.RowInfo rowInfo;
        int n;
        if (this.mServerObject == null) {
            this.mServerObject = this.mParentDlg.getServerFromModel();
            if (this.mServerObject == null) {
                n = LogonMgr.getLogonMgr().getCurrentServerIndex();
                this.mServerObject = LogonMgr.getLogonMgr().getServer(n);
                if (this.mServerObject == null || this.mServerObject.isLocalServer()) {
                    this.mServerObject = LogonMgr.getLogonMgr().getDefaultServer();
                }
            }
            if (this.mServerObject != null) {
                if (this.mServerObject.isLocalServer()) {
                    this.mServerObject = null;
                } else {
                    n = LogonMgr.getLogonMgr().getServerIndex(this.mServerObject);
                    LogonMgr.getLogonMgr().setCurrentServerIndex(n);
                }
            }
        }
        n = this.mJobStatusTable != null ? this.mJobStatusTable.getSelectedRow() : -1;
        JobStatusTableModel.RowInfo rowInfo2 = rowInfo = n != -1 && this.mTableSorter != null ? this.mTableSorter.getRowInfoInfoAt(n) : null;
        if (this.mServerObject instanceof ClusterObject && (this.mServerObject.getPassword() == null || this.mServerObject.getPassword().length() == 0)) {
            this.showLogonDlg();
        } else {
            this.refreshServerList();
        }
        this.enableUIItems();
        this.selectRowInfo(rowInfo);
    }

    private void initExtensionMap() {
        if (this.mExtensionMap == null) {
            this.mExtensionMap = new HashMap();
            this.mExtensionMap.put("spv", this.getResString("IDS_PRODUCTION_BK_JOB_SPV"));
            this.mExtensionMap.put("spw", this.getResString("IDS_PRODUCTION_BK_JOB_SPW"));
            this.mExtensionMap.put("htm", this.getResString("IDS_PRODUCTION_BK_JOB_HTM"));
            this.mExtensionMap.put("html", this.getResString("IDS_PRODUCTION_BK_JOB_HTM"));
            this.mExtensionMap.put("xls", this.getResString("IDS_PRODUCTION_BK_JOB_XLS"));
            this.mExtensionMap.put("doc", this.getResString("IDS_PRODUCTION_BK_JOB_DOC"));
            this.mExtensionMap.put("ppt", this.getResString("IDS_PRODUCTION_BK_JOB_PPF"));
            this.mExtensionMap.put("pdf", this.getResString("IDS_PRODUCTION_BK_JOB_PDF"));
            this.mExtensionMap.put("txt", this.getResString("IDS_PRODUCTION_BK_JOB_TXT"));
            this.mExtensionMap.put(".spv", this.getResString("IDS_PRODUCTION_BK_JOB_SPV"));
            this.mExtensionMap.put(".spw", this.getResString("IDS_PRODUCTION_BK_JOB_SPW"));
            this.mExtensionMap.put(".htm", this.getResString("IDS_PRODUCTION_BK_JOB_HTM"));
            this.mExtensionMap.put(".html", this.getResString("IDS_PRODUCTION_BK_JOB_HTM"));
            this.mExtensionMap.put(".xls", this.getResString("IDS_PRODUCTION_BK_JOB_XLS"));
            this.mExtensionMap.put(".doc", this.getResString("IDS_PRODUCTION_BK_JOB_DOC"));
            this.mExtensionMap.put(".ppt", this.getResString("IDS_PRODUCTION_BK_JOB_PPF"));
            this.mExtensionMap.put(".pdf", this.getResString("IDS_PRODUCTION_BK_JOB_PDF"));
            this.mExtensionMap.put(".txt", this.getResString("IDS_PRODUCTION_BK_JOB_TXT"));
        }
    }

    private void refreshServerList() {
        this.initForServerSelected(this.mServerObject);
    }

    private void initForServerSelected(ServerObject serverObject) {
        String string;
        this.enableAllControls(false);
        this.mJobStatusTable.clearTable();
        String string2 = string = serverObject != null ? serverObject.getName() : "";
        if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
            this.mServerNameTextField.setText(ComponentState.prepareStringForBidiRendering((String)string));
        } else {
            this.mServerNameTextField.setText(string);
        }
        if (serverObject != null) {
            final ArrayList<JobStatusTableModel.RowInfo> arrayList = new ArrayList<JobStatusTableModel.RowInfo>();
            if (serverObject instanceof ClusterObject) {
                final List list = ClusterMgr.getClusterMgr().getServerObjectsForCluster((ClusterObject)serverObject);
                mNumServerConnectAttempts = 0;
                if (list.size() <= 5) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                } else {
                    this.mServerConnectProgressDialog = new ServerConnectProgressDialog();
                }
                for (int i = 0; i < list.size(); ++i) {
                    final ServerObject serverObject2 = (ServerObject)list.get(i);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            boolean bl = ProductionBKJobStatusTab.this.addJobStatusForServer(serverObject2, arrayList);
                            if (!bl) {
                                mErrorConnectingToAllServers = false;
                            }
                            ProductionBKJobStatusTab.this.incrementServerCount();
                            ProductionBKJobStatusTab.this.checkForCompleteAndUpdateTable(list, arrayList);
                        }
                    }).start();
                }
                if (this.mServerConnectProgressDialog != null) {
                    this.mServerConnectProgressDialog.setVisible(true);
                }
            } else {
                Cursor cursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.addJobStatusForServer(serverObject, arrayList);
                this.updateJobStatusTableModel(arrayList);
                this.setLastUpdatedText();
                this.setCursor(cursor);
                this.enableUIItems();
                if (this.mJobStatusTable.getSelectedRow() == -1) {
                    this.mJobStatusTable.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        }
    }

    private synchronized void checkForCompleteAndUpdateTable(List<ServerObject> list, final ArrayList<JobStatusTableModel.RowInfo> arrayList) {
        if (mNumServerConnectAttempts == list.size()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ProductionBKJobStatusTab.this.mServerConnectProgressDialog != null) {
                        ProductionBKJobStatusTab.this.mServerConnectProgressDialog.setProgressBarMoving(false);
                        if (ProductionBKJobStatusTab.this.mServerConnectProgressDialog.isAutoClose()) {
                            ProductionBKJobStatusTab.this.mServerConnectProgressDialog.setVisible(false);
                            ProductionBKJobStatusTab.this.mServerConnectProgressDialog = null;
                        }
                    }
                    ProductionBKJobStatusTab.this.updateJobStatusTableModel(arrayList);
                    ProductionBKJobStatusTab.this.setLastUpdatedText();
                    mNumServerConnectAttempts = 0;
                    if (mOldCursor != null) {
                        ProductionBKJobStatusTab.this.setCursor(mOldCursor);
                    }
                    if (ProductionBKJobStatusTab.this.mJobStatusTable.getSelectedRow() == -1) {
                        ProductionBKJobStatusTab.this.mJobStatusTable.getSelectionModel().setSelectionInterval(0, 0);
                    }
                    ProductionBKJobStatusTab.this.enableUIItems();
                    if (mErrorConnectingToAllServers) {
                        ProductionBKJobStatusTab.this.doErrorMessage(ProductionBKJobStatusTab.this.getResString("IDS_PRODUCTION_BK_JOBS_ERR_CONNECTING_TO_ALL_SERVERS_IN_CLUSTER"));
                    }
                }
            });
        }
    }

    private synchronized void incrementServerCount() {
        ++mNumServerConnectAttempts;
    }

    private boolean addJobStatusForServer(ServerObject serverObject, ArrayList<JobStatusTableModel.RowInfo> arrayList) {
        boolean bl = false;
        ProductionJobClient productionJobClient = this.connectToProductionClient(serverObject);
        if (productionJobClient != null) {
            this.getServerConnectionsSet().add(productionJobClient);
            List list = productionJobClient.getAllProductionJobStatus();
            if (list != null) {
                for (ProductionJobStatus productionJobStatus : list) {
                    arrayList.add(new JobStatusTableModel.RowInfo(serverObject, productionJobClient, productionJobStatus));
                }
                if (this.mServerConnectProgressDialog != null) {
                    this.mServerConnectProgressDialog.addToProgressJobsCompletedText(serverObject, list.size());
                }
                bl = true;
            } else {
                productionJobClient.disconnect();
            }
        }
        return bl;
    }

    private HashSet<ProductionJobClient> getServerConnectionsSet() {
        if (this.mServerConnectionsSet == null) {
            this.mServerConnectionsSet = new HashSet();
        }
        return this.mServerConnectionsSet;
    }

    private ProductionJobClient connectToProductionClient(ServerObject serverObject) {
        ProductionJobClient productionJobClient = ProductionJobClient.getProductionJobClient((ServerObject)serverObject);
        boolean bl = productionJobClient.connect();
        return bl ? productionJobClient : null;
    }

    private void setLastUpdatedText() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());
        String string = dateFormat.format(date);
        DateFormat dateFormat2 = DateFormat.getTimeInstance(2, Locale.getDefault());
        String string2 = dateFormat2.format(calendar.getTime());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getResString("IDS_PRODUCTION_BK_JOB_STATUS_LAST_UPDATED"));
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        if (ComponentState.isBtdRtlOrLtr() && stringBuffer.toString() != null && stringBuffer.toString().length() > 0) {
            this.mLastUpdatedLabel.setText(ComponentState.prepareStringForBidiRendering((String)stringBuffer.toString()));
        } else {
            this.mLastUpdatedLabel.setText(stringBuffer.toString());
        }
    }

    void enableUIItems() {
        boolean bl = false;
        int n = -1;
        if (this.mJobStatusTable != null) {
            this.mJobStatusTable.setEnabled(true);
            bl = this.mJobStatusTable.getRowCount() > 0 && this.mJobStatusTable.getSelectedRowCount() > 0;
            n = this.mJobStatusTable.getSelectedRow();
        }
        if (this.mSelectServerButton != null) {
            this.mSelectServerButton.setEnabled(true);
        }
        if (this.mRefreshButton != null) {
            this.mRefreshButton.setEnabled(bl);
        }
        if (this.mGetJobOutputButton != null) {
            this.mGetJobOutputButton.setEnabled(bl && this.canGetOutput(n));
        }
        if (this.mCancelJobButton != null) {
            this.mCancelJobButton.setEnabled(bl && this.canCancelJob(n));
        }
        if (this.mRemoveJobButton != null) {
            this.mRemoveJobButton.setEnabled(bl && this.canRemoveJob(n));
        }
    }

    private void enableAllControls(boolean bl) {
        if (this.mJobStatusTable != null) {
            this.mJobStatusTable.setEnabled(bl);
        }
        if (this.mSelectServerButton != null) {
            this.mSelectServerButton.setEnabled(bl);
        }
        if (this.mRefreshButton != null) {
            this.mRefreshButton.setEnabled(bl);
        }
        if (this.mGetJobOutputButton != null) {
            this.mGetJobOutputButton.setEnabled(bl);
        }
        if (this.mCancelJobButton != null) {
            this.mCancelJobButton.setEnabled(bl);
        }
        if (this.mRemoveJobButton != null) {
            this.mRemoveJobButton.setEnabled(bl);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void initVariables() {
        this.mFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.GenericWithoutPES, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        this.mJobStatusTable = new JobStatusTable();
        this.mJobStatusTable.setDefaultRenderer(Integer.class, new BKJobStatusCellRenderer());
        this.mJobStatusTable.setDefaultRenderer(String.class, new BKJobStatusCellRenderer());
        this.mJobStatusTable.setAutoResizeMode(3);
        JobStatusTableModel.COLUMN_NAMES[0] = this.getResString("IDS_JOB_STATUS_TAB_TABLE_COLUMN_HEADER_2");
        JobStatusTableModel.COLUMN_NAMES[1] = this.getResString("IDS_JOB_STATUS_TAB_TABLE_COLUMN_HEADER_3");
        JobStatusTableModel.COLUMN_NAMES[2] = this.getResString("IDS_JOB_STATUS_TAB_TABLE_COLUMN_HEADER_4");
        JobStatusTableModel.COLUMN_NAMES[3] = this.getResString("IDS_JOB_STATUS_TAB_TABLE_COLUMN_HEADER_5");
        this.mJobStatusTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.mJobStatusTable.putClientProperty("terminateEditOnFocusLost", Boolean.FALSE);
        this.mJobStatusTable.setPreferredSize(new Dimension(500, this.mJobStatusTable.getRowHeight() * this.mJobStatusTable.getRowCount()));
        this.mJobStatusTable.getTableHeader().setPreferredSize(new Dimension(500, this.mJobStatusTable.getRowHeight()));
        if (this.mJobStatusTableScrollPane == null) {
            this.mJobStatusTableScrollPane = new JScrollPane(this.mJobStatusTable, 20, 31);
        }
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mJobStatusTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mJobStatusTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mJobStatusTable.getActionMap().put("tabIn", abstractAction2);
        this.mJobStatusTable.getActionMap().put("tabOut", abstractAction);
    }

    private void setupPanel() {
        this.setLayout(new GridBagLayout());
        Insets insets = (Insets)DialogUtil.getStandardDialogInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JPanel jPanel = this.createMainPanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = this.createButtonPanel();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        n = 23;
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
    }

    private JPanel createButtonPanel() {
        this.mRefreshButton = DialogUtil.createButton(this.mParent, "IDS_BK_JOB_STATUS_REFRESH", new RefreshJobsListAction());
        this.mGetJobOutputButton = DialogUtil.createButton(this.mParent, "IDS_BK_JOB_STATUS_GET_OUTPUT", new getJobOutputAction());
        this.mCancelJobButton = DialogUtil.createButton(this.mParent, "IDS_BK_JOB_STATUS_CANCEL_JOB", new CancelJobAction());
        this.mRemoveJobButton = DialogUtil.createButton(this.mParent, "IDS_BK_JOB_STATUS_REMOVE_JOB", new RemoveJobAction());
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = (Insets)DialogUtil.getStandardDialogInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mRefreshButton, gridBagConstraints, 0, 0, 1, 1, n, new Insets(insets.top, insets.left + 15, 0, 0));
        DialogUtil.addUsingGBL(jPanel, this.mGetJobOutputButton, gridBagConstraints, 0, 1, 1, 1, n, new Insets(insets.top, insets.left + 15, 0, 0));
        DialogUtil.addUsingGBL(jPanel, this.mCancelJobButton, gridBagConstraints, 0, 2, 1, 1, n, new Insets(insets.top, insets.left + 15, 0, 0));
        DialogUtil.addUsingGBL(jPanel, this.mRemoveJobButton, gridBagConstraints, 0, 3, 1, 1, n, new Insets(insets.top, insets.left + 15, 0, 0));
        return jPanel;
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mSelectServerButton = DialogUtil.createButton(this.mParent, "IDS_PRODUCTION_BK_JOB_SELECT_SERVER_BUTTON", this);
        this.mSelectServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProductionBKJobStatusTab.this.showLogonDlg();
            }
        });
        this.mServerNameTextField = new JTextField();
        this.mServerNameTextField.setEditable(false);
        this.mServerNameTextField.setPreferredSize(new Dimension(150, 25));
        JLabel jLabel = new JLabel(this.getResString("IDS_PRODUCTION_BK_JOB_STATUS_SERVER_NAME"));
        jLabel.setLabelFor(this.mServerNameTextField);
        Insets insets = (Insets)DialogUtil.getStandardDialogInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(insets.top, 0, 0, 0));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mServerNameTextField, gridBagConstraints, 1, 0, 1, 1, n, new Insets(insets.top, 0, 0, 0));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSelectServerButton, gridBagConstraints, 2, 0, 1, 1, n, new Insets(insets.top, 5, 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.mLastUpdatedLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.5;
        n = 23;
        DialogUtil.addUsingGBL(jPanel2, jPanel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, 0, 0, 0));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.5;
        DialogUtil.addUsingGBL(jPanel2, new JPanel(), gridBagConstraints, 1, 0, 1, 1, n, new Insets(0, 0, 0, 0));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        n = 13;
        DialogUtil.addUsingGBL(jPanel2, this.mLastUpdatedLabel, gridBagConstraints, 2, 0, 1, 1, n, new Insets(10, 0, 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel3, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, 0, 0, 0));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel3, this.mJobStatusTableScrollPane, gridBagConstraints, 0, 1, 1, 1, n, new Insets(15, 0, 0, 0));
        return jPanel3;
    }

    public void showLogonDlg() {
        boolean bl;
        LogonDlg logonDlg = new LogonDlg(null, true);
        logonDlg.setCursor(Cursor.getDefaultCursor());
        logonDlg.setVisible(true);
        boolean bl2 = bl = !logonDlg.getModalResult();
        if (!bl) {
            this.mServerObject = logonDlg.getSelectedServer();
            this.initForServerSelected(this.mServerObject);
        }
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mServerNameTextField);
        this.mComponentOrder.add(this.mSelectServerButton);
        this.mComponentOrder.add(this.mLastUpdatedLabel);
        this.mComponentOrder.add(this.mJobStatusTable);
        this.mComponentOrder.add(this.mRefreshButton);
        this.mComponentOrder.add(this.mGetJobOutputButton);
        this.mComponentOrder.add(this.mCancelJobButton);
        this.mComponentOrder.add(this.mRemoveJobButton);
        this.mComponentOrder.add(((ProductionJobDlg)this.mParent).getCloseButton());
        this.mComponentOrder.add(((ProductionJobDlg)this.mParent).getHelpButton());
    }

    @Override
    protected boolean validateTab() {
        if (this.mJobStatusTable.isEditing()) {
            this.mJobStatusTable.getCellEditor().stopCellEditing();
        }
        return super.validateTab();
    }

    void loadTabState() {
        this.sizeJobStatusTable();
    }

    private void updateJobStatusTableModel(ArrayList<JobStatusTableModel.RowInfo> arrayList) {
        JobStatusTableModel jobStatusTableModel = new JobStatusTableModel(arrayList, this.mJobStatusTable);
        this.mTableSorter = new MyTableSorter(jobStatusTableModel, this.mJobStatusTable.getTableHeader());
        this.mJobStatusTable.setModel(this.mTableSorter);
        this.mTableSorter.setColumnComparator(String.class, STRING_COMPARATOR);
        this.mTableSorter.setColumnComparator(Integer.class, INTEGER_COMPARATOR);
        this.mTableSorter.setSortingStatus(2, -1);
    }

    private void sizeJobStatusTable() {
        this.mJobStatusTable.getColumnModel().getColumn(1).setPreferredWidth(180);
        this.mJobStatusTable.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.mJobStatusTable.getColumnModel().getColumn(3).setPreferredWidth(120);
        this.mJobStatusTable.getColumnModel().getColumn(4).setPreferredWidth(120);
        int n = this.mJobStatusTable.getRowCount() + 1;
        Dimension dimension = this.mJobStatusTableScrollPane.getSize();
        dimension.height = n * this.mJobStatusTable.getRowHeight() + 2;
        this.mJobStatusTableScrollPane.setPreferredSize(dimension);
        dimension.height = 2 * this.mJobStatusTable.getRowHeight() + 2;
        this.mJobStatusTableScrollPane.setMinimumSize(dimension);
        dimension.height = 17 * this.mJobStatusTable.getRowHeight() + 2;
        this.mJobStatusTableScrollPane.setMaximumSize(dimension);
    }

    public void dispose() {
        if (this.mTableSorter != null) {
            this.disconnectFromAllServers();
        }
        this.mServerConnectProgressDialog = null;
    }

    private void disconnectFromAllServers() {
        for (ProductionJobClient productionJobClient : this.getServerConnectionsSet()) {
            if (productionJobClient == null) continue;
            productionJobClient.disconnect();
        }
    }

    private String convertToClientErrorMessage(int n) {
        String string = null;
        if (n == ProductionJobErrorCodes.DELETE_PRODUCTIONJOB_ERROR) {
            string = this.getResString("IDS_DELETE_PRODUCTIONJOB_ERROR_4");
        } else if (n == ProductionJobErrorCodes.PRODUCTIONJOBDIR_NOTFOUND_ERROR) {
            string = this.getResString("IDS_PRODUCTIONJOBDIR_NOTFOUND_ERROR_5");
        } else if (n == ProductionJobErrorCodes.PRODUCTIONJOBFILE_NOTFOUND_ERROR) {
            string = this.getResString("IDS_PRODUCTIONJOBFILE_NOTFOUND_ERROR_6");
        } else if (n == ProductionJobErrorCodes.OUTPUTFILE_NOTFOUND_ERROR) {
            string = this.getResString("IDS_OUTPUTFILE_NOTFOUND_ERROR_7");
        } else if (n == ProductionJobErrorCodes.PRODUCTIONJOBSYNTAX_NOTFOUND_ERROR) {
            string = this.getResString("IDS_PRODUCTIONJOBSYNTAX_NOTFOUND_ERROR_8");
        } else if (n == ProductionJobErrorCodes.CANCEL_PRODUCTIONJOB_ERROR) {
            string = this.getResString("IDS_CANCEL_PRODUCTIONJOB_ERROR_9");
        }
        return string;
    }

    private boolean canCancelJob(int n) {
        JobStatusTableModel.RowInfo rowInfo;
        boolean bl = false;
        if (n >= 0 && (rowInfo = this.mTableSorter.getRowInfoInfoAt(n)).getServerConection() != null) {
            bl = rowInfo.getJobStatus().getJobState() == ProductionJobStatus.JobState.RUNNING;
        }
        return bl;
    }

    private boolean canGetOutput(int n) {
        JobStatusTableModel.RowInfo rowInfo;
        boolean bl = false;
        if (n >= 0 && (rowInfo = this.mTableSorter.getRowInfoInfoAt(n)).getServerConection() != null) {
            bl = rowInfo.getJobStatus().getJobState() == ProductionJobStatus.JobState.COMPLETED;
        }
        return bl;
    }

    private boolean canRemoveJob(int n) {
        JobStatusTableModel.RowInfo rowInfo;
        boolean bl = false;
        if (n >= 0 && (rowInfo = this.mTableSorter.getRowInfoInfoAt(n)).getServerConection() != null) {
            bl = rowInfo.getJobStatus().getJobState() == ProductionJobStatus.JobState.COMPLETED || rowInfo.getJobStatus().getJobState() == ProductionJobStatus.JobState.CANCELED;
        }
        return bl;
    }

    private void deleteJob(int n) {
        this.deleteJob(n, true, true);
    }

    private JobReturnInfo deleteJob(int n, boolean bl, boolean bl2) {
        JobStatusTableModel.RowInfo rowInfo = this.mTableSorter.getRowInfoInfoAt(n);
        JobReturnInfo jobReturnInfo = null;
        if (rowInfo.getServerConection() != null) {
            int n2;
            int n3 = n2 = bl ? SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mParentDlg), this.getResString("IDS_PRODUCTION_BK_JOB_STATUS_REMOVE_ARE_YOU_SURE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.YES_NO_OPTION) : 1;
            if (n2 == 1) {
                int n4 = rowInfo.getServerConection().deleteProductionJob(rowInfo.getJobStatus().getJobId());
                if (n4 == ProductionJobErrorCodes.PRODUCTIONJOB_NOERROR) {
                    jobReturnInfo = new JobReturnInfo(false);
                    this.mTableSorter.deleteRowInfoInfoAt(n);
                    if (this.mJobStatusTable.getRowCount() > 0) {
                        this.mJobStatusTable.getSelectionModel().setSelectionInterval(0, 0);
                    }
                } else {
                    String string = this.convertToClientErrorMessage(n4);
                    jobReturnInfo = new JobReturnInfo(true, string);
                    if (bl2) {
                        if (string != null) {
                            this.doErrorMessage(string);
                        } else {
                            this.refreshServerList();
                        }
                    }
                }
            }
        }
        return jobReturnInfo;
    }

    private void cancelJob(int n) {
        JobStatusTableModel.RowInfo rowInfo = this.mTableSorter.getRowInfoInfoAt(n);
        if (rowInfo.getServerConection() != null) {
            int n2 = rowInfo.getServerConection().cancelProductionJob(rowInfo.getJobStatus().getJobId());
            if (n2 == ProductionJobErrorCodes.PRODUCTIONJOB_NOERROR) {
                this.mTableSorter.cancelRowInfoAt(n);
                this.mJobStatusTable.repaint();
            } else {
                this.processServerErrorMessage(n2);
            }
        }
    }

    private void processServerErrorMessage(int n) {
        String string = this.convertToClientErrorMessage(n);
        if (string != null) {
            this.doErrorMessage(string);
        } else {
            this.refreshServerList();
        }
    }

    private void getJobOutput(int n) {
        JobStatusTableModel.RowInfo rowInfo = this.mTableSorter.getRowInfoInfoAt(n);
        if (rowInfo.getServerConection() != null) {
            GetJobOutputProgressDialog getJobOutputProgressDialog = new GetJobOutputProgressDialog(n);
            getJobOutputProgressDialog.setVisible(true);
        }
    }

    private File getSaveOutputFile(String string) {
        File file;
        String string2 = FileUtil.getDirectoryName((String)string);
        if (string2 != null && !string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        File file2 = file = string != null ? new File(string2) : null;
        if (file != null && file.isDirectory() && file.exists()) {
            String string3;
            int n;
            file = new File(string);
            if (file.exists() && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mParentDlg), string3 = MessageFormat.format(this.getResString("IDS_PRODUCTION_BK_JOB_STATUS_OUTPUT_FILE_EXISTS"), FileUtil.getBaseNameAndExtension((String)string)), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) != 1) {
                file = this.launchSaveAsDialog(FileUtil.getExtension((String)string, (boolean)false));
            }
        } else {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("IDS_PRODUCTION_BK_JOB_STATUS_OUTPUT_FOLDER_DOES_NOT_EXIST"), VersionInfo.getAppVersionString());
            file = this.launchSaveAsDialog(FileUtil.getExtension((String)string, (boolean)true));
        }
        return file;
    }

    private File launchSaveAsDialog(String string) {
        int n;
        this.initExtensionMap();
        File file = null;
        this.mFileChooser.setDialogTitle(this.getResString("IDS_EXPORTOUTPUT_SAVE_FILE_DIALOG_TITLE"));
        this.mFileChooser.setAcceptAllFileFilterUsed(false);
        String string2 = this.getDescriptionForExtension(string);
        if (string2 != null) {
            this.mFileChooser.setFileFilter((FileFilter)new RefFileFilter(string2, string));
        }
        if ((n = this.mFileChooser.showSaveDialog(this)) == 0) {
            String string3 = this.mFileChooser.getSelectedFilePath();
            file = new File(string3);
        }
        return file;
    }

    private String getDescriptionForExtension(String string) {
        String string2 = null;
        String string3 = this.mExtensionMap.get(string);
        if (string3 != null) {
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.append("(*");
            stringBuffer.append(string);
            stringBuffer.append(")");
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private void doErrorMessage(String string) {
        if (string != null) {
            SpssAlertOptionPane.showWarningMessageDialog(this, string, VersionInfo.getAppVersionString());
        }
    }

    private void selectRowInfo(JobStatusTableModel.RowInfo rowInfo) {
        int n = -1;
        if (rowInfo != null) {
            for (int i = 0; i < this.mTableSorter.getRowCount(); ++i) {
                JobStatusTableModel.RowInfo rowInfo2 = this.mTableSorter.getRowInfoInfoAt(i);
                if (rowInfo2 != rowInfo) continue;
                n = i;
                break;
            }
        }
        int n2 = n = n != -1 ? n : 0;
        if (n != -1 && this.mJobStatusTable.getRowCount() > 0) {
            this.mJobStatusTable.getSelectionModel().setSelectionInterval(n, n);
            this.mJobStatusTable.scrollRectToVisible(this.mJobStatusTable.getCellRect(n, 0, true));
        }
    }

    class JobReturnInfo {
        private boolean mHasError;
        private String mErrorMessage;

        JobReturnInfo(boolean bl) {
            this.mHasError = bl;
        }

        JobReturnInfo(boolean bl, String string) {
            this.mErrorMessage = string;
            this.mHasError = bl;
        }

        public boolean hasError() {
            return this.mHasError;
        }

        public String getErrorMessage() {
            return this.mErrorMessage;
        }
    }

    private class MyTableSorter
    extends TableSorter {
        private MyTableSorter(TableModel tableModel, JTableHeader jTableHeader) {
            super(tableModel, jTableHeader);
        }

        @Override
        protected int onMouseClickedOnHeader(MouseEvent mouseEvent) {
            int n = ProductionBKJobStatusTab.this.mJobStatusTable.getSelectedRow();
            JobStatusTableModel.RowInfo rowInfo = ProductionBKJobStatusTab.this.mTableSorter.getRowInfoInfoAt(n);
            int n2 = super.onMouseClickedOnHeader(mouseEvent);
            ProductionBKJobStatusTab.this.selectRowInfo(rowInfo);
            return n2;
        }

        public JobStatusTableModel.RowInfo getRowInfoInfoAt(int n) {
            return ((JobStatusTableModel)this.mTableModel).getRowInfoAt(this.modelIndex(n));
        }

        public void deleteRowInfoInfoAt(int n) {
            ((JobStatusTableModel)this.mTableModel).deleteRowInfoInfoAt(this.modelIndex(n));
        }

        public void cancelRowInfoAt(int n) {
            ((JobStatusTableModel)this.mTableModel).cancelRowInfoInfoAt(this.modelIndex(n));
        }

        public int getJobStartTimeAt(int n) {
            return ((JobStatusTableModel)this.mTableModel).getJobStartTimeAt(this.modelIndex(n));
        }

        public int getJobEndTimeAt(int n) {
            return ((JobStatusTableModel)this.mTableModel).getJobEndTimeAt(this.modelIndex(n));
        }

        public String getJobStateAt(int n) {
            return ((JobStatusTableModel)this.mTableModel).getJobStateAt(this.modelIndex(n));
        }

        public String getJobNameAt(int n) {
            return ((JobStatusTableModel)this.mTableModel).getJobNameAt(this.modelIndex(n));
        }

        public int getJobIDAt(int n) {
            return ((JobStatusTableModel)this.mTableModel).getJobIDAt(this.modelIndex(n));
        }

        public String getJobOutputPathAt(int n) {
            return ((JobStatusTableModel)this.mTableModel).getJobOutputPathAt(this.modelIndex(n));
        }
    }

    public class BKJobStatusCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            String string = "error";
            switch (n2) {
                case 0: 
                case 1: {
                    string = (String)ProductionBKJobStatusTab.this.mTableSorter.getValueAt(n, n2);
                    break;
                }
                case 2: 
                case 3: {
                    int n3 = (Integer)ProductionBKJobStatusTab.this.mTableSorter.getValueAt(n, n2);
                    string = n3 > 0 ? this.formatDate(n3) : "";
                    break;
                }
            }
            this.setText(string);
            return component;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }

        private String formatDate(int n) {
            long l = (long)n * 1000L;
            DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());
            String string = dateFormat.format(new Date(l));
            DateFormat dateFormat2 = DateFormat.getTimeInstance(2, Locale.getDefault());
            String string2 = dateFormat2.format(new Date(l));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
    }

    class JobStatusTable
    extends PlainTable {
        JobStatusTable() {
            this.setRowSelectionAllowed(true);
            this.setColumnSelectionAllowed(false);
            this.getSelectionModel().setSelectionMode(0);
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ProductionBKJobStatusTab.this.enableUIItems();
                }
            });
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = super.getToolTipText(mouseEvent);
            int n = ProductionBKJobStatusTab.this.mJobStatusTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = ProductionBKJobStatusTab.this.mJobStatusTable.columnAtPoint(mouseEvent.getPoint());
            if (n2 == 0) {
                string = ProductionBKJobStatusTab.this.mTableSorter.getJobOutputPathAt(n);
            }
            return string;
        }

        public void clearTable() {
            ArrayList arrayList = new ArrayList();
            ProductionBKJobStatusTab.this.updateJobStatusTableModel(arrayList);
        }

        public ProductionJobStatus getSelectedProductionJobStatus() {
            int n;
            ProductionJobStatus productionJobStatus = null;
            if (ProductionBKJobStatusTab.this.mJobStatusTable != null && (n = ProductionBKJobStatusTab.this.mJobStatusTable.getSelectedRow()) != 0) {
                productionJobStatus = ProductionBKJobStatusTab.this.mTableSorter.getRowInfoInfoAt(n).getJobStatus();
            }
            return productionJobStatus;
        }

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (keyEvent.getKeyCode() == 525 || keyEvent.isShiftDown() && keyEvent.getKeyCode() == 121) {
                this.dopopupMenu(TableUtilities.getPopupDisplayLocation((JTable)this));
                keyEvent.consume();
            } else {
                super.processKeyEvent(keyEvent);
            }
        }

        @Override
        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && (mouseEvent.getID() == 501 || mouseEvent.getID() == 502)) {
                int n = this.rowAtPoint(mouseEvent.getPoint());
                this.getSelectionModel().setSelectionInterval(n, n);
                this.dopopupMenu(mouseEvent.getPoint());
            } else {
                super.processMouseEvent(mouseEvent);
            }
        }

        private void dopopupMenu(Point point) {
            int n = this.columnModel.getColumnIndexAtX((int)point.getX());
            JPopupMenu jPopupMenu = this.createPopupMenu(n);
            jPopupMenu.show(this, (int)point.getX(), (int)point.getY());
        }

        public JPopupMenu createPopupMenu(int n) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.createMenuItem("IDS_BK_JOB_STATUS_REFRESH", new RefreshJobsListAction()));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.createMenuItem("IDS_BK_JOB_STATUS_GET_OUTPUT", new getJobOutputAction()));
            jPopupMenu.add(this.createMenuItem("IDS_BK_JOB_STATUS_CANCEL_JOB", new CancelJobAction()));
            jPopupMenu.add(this.createMenuItem("IDS_BK_JOB_STATUS_REMOVE_JOB", new RemoveJobAction()));
            JMenu jMenu = this.createMenu("IDS_JOB_STATUS_TABLE.Sort_MENU");
            JMenuItem jMenuItem = this.createMenuItem("IDS_JOB_STATUS_TABLE.SortAscending", new SortAction(n, 1));
            jMenu.add(jMenuItem);
            jMenuItem = this.createMenuItem("IDS_JOB_STATUS_TABLE.SortDescending", new SortAction(n, -1));
            jMenu.add(jMenuItem);
            jMenuItem = this.createMenuItem("IDS_JOB_STATUS_TABLE.SortOriginal", new SortAction(n, 0));
            jMenu.add(jMenuItem);
            jPopupMenu.add(jMenu);
            return jPopupMenu;
        }

        public JMenu createMenu(String string) {
            JMenu jMenu = new JMenu(ProductionBKJobStatusTab.this.getResString(string));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                String string2 = string + "_KEY";
                string2 = string2.replaceFirst("IDS_", "IDK_");
                Integer n = ProductionBKJobStatusTab.this.mParent.getDlgAccessKey(string2);
                if (n != null) {
                    jMenu.setMnemonic(n);
                }
            }
            return jMenu;
        }

        public JMenuItem createMenuItem(String string, ActionListener actionListener) {
            JMenuItem jMenuItem = new JMenuItem(ProductionBKJobStatusTab.this.getResString(string));
            jMenuItem.addActionListener(actionListener);
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                String string2 = string + "_KEY";
                string2 = string2.replaceFirst("IDS_", "IDK_");
                Integer n = ProductionBKJobStatusTab.this.mParent.getDlgAccessKey(string2);
                if (n != null) {
                    jMenuItem.setMnemonic(n);
                }
            }
            return jMenuItem;
        }

        class SortAction
        extends AbstractAction {
            int mSortOrder = 0;
            int mColumn = -1;

            SortAction(int n, int n2) {
                this.mColumn = n;
                this.mSortOrder = n2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ProductionBKJobStatusTab.this.mJobStatusTable.getSelectedRow();
                JobStatusTableModel.RowInfo rowInfo = ProductionBKJobStatusTab.this.mTableSorter.getRowInfoInfoAt(n);
                ProductionBKJobStatusTab.this.mTableSorter.cancelSorting();
                if (this.mColumn != -1) {
                    ProductionBKJobStatusTab.this.mTableSorter.setSortingStatus(this.mColumn, this.mSortOrder);
                }
                ProductionBKJobStatusTab.this.selectRowInfo(rowInfo);
            }
        }
    }

    class RemoveJobAction
    implements ActionListener {
        RemoveJobAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProductionBKJobStatusTab.this.deleteJob(ProductionBKJobStatusTab.this.mJobStatusTable.getSelectedRow());
        }
    }

    class CancelJobAction
    implements ActionListener {
        CancelJobAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProductionBKJobStatusTab.this.cancelJob(ProductionBKJobStatusTab.this.mJobStatusTable.getSelectedRow());
        }
    }

    class getJobOutputAction
    implements ActionListener {
        getJobOutputAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProductionBKJobStatusTab.this.getJobOutput(ProductionBKJobStatusTab.this.mJobStatusTable.getSelectedRow());
        }
    }

    class RefreshJobsListAction
    extends AbstractAction {
        RefreshJobsListAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProductionBKJobStatusTab.this.refreshServerList();
        }
    }

    class GetJobOutputProgressDialog
    extends BaseProgressDialog {
        private static final String AUTO_CLOSE = "bk_get_job_ouput_status_auto_close";
        StringBuffer mJobsCompletedBuffer;
        JCheckBox mAutoCloseCheckBox;
        boolean mAutoClose;
        boolean mDoRefreshOnClose;
        private String mJobName;

        GetJobOutputProgressDialog(final int n) {
            super((JDialog)ProductionBKJobStatusTab.this.mParent, "");
            this.mJobsCompletedBuffer = null;
            this.mAutoClose = false;
            this.mDoRefreshOnClose = false;
            final JobStatusTableModel.RowInfo rowInfo = ProductionBKJobStatusTab.this.mTableSorter.getRowInfoInfoAt(n);
            String string = rowInfo.getJobStatus().getOutputPath();
            final File file = ProductionBKJobStatusTab.this.getSaveOutputFile(string);
            this.mJobName = rowInfo.getJobStatus().getJobName();
            String string2 = MessageFormat.format(ProductionBKJobStatusTab.this.getResString("IDS_GET_JOB_OUTPUT_PROGRESS_TITLE"), this.mJobName);
            this.setTitle(string2);
            String string3 = MessageFormat.format(ProductionBKJobStatusTab.this.getResString("IDS_GET_JOB_OUTPUT_PROGRESS_SAVING_TO"), file.getAbsolutePath());
            this.setProgressStatusText(string3);
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            Preferences preferences2 = preferences.node("dialog_settings");
            int n2 = preferences2.getInt(AUTO_CLOSE, 0);
            this.mAutoClose = n2 != 0;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JobReturnInfo jobReturnInfo;
                    int n2 = rowInfo.getServerConection().getProductionJobOutput(rowInfo.getJobStatus().getJobId(), file);
                    if (n2 == ProductionJobErrorCodes.PRODUCTIONJOB_NOERROR) {
                        jobReturnInfo = ProductionBKJobStatusTab.this.deleteJob(n, false, false);
                    } else {
                        String string = ProductionBKJobStatusTab.this.convertToClientErrorMessage(n2);
                        jobReturnInfo = new JobReturnInfo(true, string);
                    }
                    GetJobOutputProgressDialog.this.processGetJobOutputComplete(jobReturnInfo);
                }
            }).start();
        }

        private void processGetJobOutputComplete(JobReturnInfo jobReturnInfo) {
            this.setProgressBarMoving(false);
            if (jobReturnInfo.hasError()) {
                if (jobReturnInfo.getErrorMessage() != null) {
                    this.appendToProgressStatusText(jobReturnInfo.getErrorMessage());
                } else {
                    this.mDoRefreshOnClose = true;
                }
            } else {
                String string = MessageFormat.format(ProductionBKJobStatusTab.this.getResString("IDS_GET_JOB_OUTPUT_PROGRESS_COMPLETE_TITLE"), this.mJobName);
                this.setTitle(string);
                this.appendToProgressStatusText(ProductionBKJobStatusTab.this.getResString("IDS_GET_JOB_OUTPUT_SUCCESS"));
            }
            if (this.mAutoClose) {
                this.closeDialog(false);
            }
        }

        @Override
        public String getCloseButtonText() {
            return ProductionBKJobStatusTab.this.getResString("IDS_GET_JOB_OUTPUT_PROGRESS_CLOSE");
        }

        @Override
        public JPanel getUserDefinedTopPanel() {
            return new JPanel();
        }

        @Override
        public JPanel getUserDefinedBottomPanel() {
            JPanel jPanel = new JPanel(new FlowLayout());
            this.mAutoCloseCheckBox = DialogUtil.createCheckBox(ProductionBKJobStatusTab.this.mParent, "IDS_GET_JOB_OUTPUT_PROGRESS_CLOSE_AUTOCLOSE", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GetJobOutputProgressDialog.this.mAutoClose = GetJobOutputProgressDialog.this.mAutoCloseCheckBox.isSelected();
                }
            });
            this.mAutoCloseCheckBox.setSelected(this.mAutoClose);
            jPanel.add((Component)this.mAutoCloseCheckBox, 0);
            return jPanel;
        }

        @Override
        public void processCloseAction() {
            this.closeDialog(true);
        }

        private void closeDialog(boolean bl) {
            int n = this.mAutoCloseCheckBox != null && this.mAutoCloseCheckBox.isSelected() ? 1 : 0;
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            Preferences preferences2 = preferences.node("dialog_settings");
            preferences2.putInt(AUTO_CLOSE, n);
            if (this.mDoRefreshOnClose) {
                ProductionBKJobStatusTab.this.refreshServerList();
            }
            if (bl) {
                this.dispose();
            } else {
                this.setVisible(false);
            }
        }

        public boolean isAutoClose() {
            return this.mAutoClose;
        }
    }

    class ServerConnectProgressDialog
    extends BaseProgressDialog {
        private static final String AUTO_CLOSE = "bk_job_status_auto_close";
        Timer mTimer;
        StringBuffer mJobsCompletedBuffer;
        JCheckBox mAutoCloseCheckBox;
        boolean mAutoClose;

        ServerConnectProgressDialog() {
            super((JDialog)ProductionBKJobStatusTab.this.mParent, ProductionBKJobStatusTab.this.getResString("IDS_PRODUCTION_BK_PROGRESS_TITLE"));
            this.mJobsCompletedBuffer = null;
            this.mAutoClose = false;
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            Preferences preferences2 = preferences.node("dialog_settings");
            int n = preferences2.getInt(AUTO_CLOSE, 0);
            this.mAutoClose = n != 0;
            this.mTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ServerConnectProgressDialog.this.mJobsCompletedBuffer != null) {
                        ServerConnectProgressDialog.this.setProgressStatusText(ServerConnectProgressDialog.this.mJobsCompletedBuffer.toString());
                    }
                }
            });
            this.mTimer.start();
        }

        @Override
        public String getCloseButtonText() {
            return ProductionBKJobStatusTab.this.getResString("IDS_PRODUCTION_BK_PROGRESS_CLOSE");
        }

        @Override
        public JPanel getUserDefinedTopPanel() {
            return new JPanel();
        }

        @Override
        public JPanel getUserDefinedBottomPanel() {
            JPanel jPanel = new JPanel(new FlowLayout());
            this.mAutoCloseCheckBox = DialogUtil.createCheckBox(ProductionBKJobStatusTab.this.mParent, "IDS_PRODUCTION_BK_PROGRESS_AUTOCLOSE", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ServerConnectProgressDialog.this.mAutoClose = ServerConnectProgressDialog.this.mAutoCloseCheckBox.isSelected();
                }
            });
            this.mAutoCloseCheckBox.setSelected(this.mAutoClose);
            jPanel.add((Component)this.mAutoCloseCheckBox, 0);
            return jPanel;
        }

        public void addToProgressJobsCompletedText(ServerObject serverObject, int n) {
            String string = MessageFormat.format(ProductionBKJobStatusTab.this.getResString("IDS_PRODUCTION_BK_JOBS_COMPLETED_TEXT"), serverObject.getName(), "" + n);
            if (this.mJobsCompletedBuffer == null) {
                this.mJobsCompletedBuffer = new StringBuffer(string);
            } else {
                this.mJobsCompletedBuffer.append("\n");
                this.mJobsCompletedBuffer.append(string);
            }
        }

        @Override
        public void processCloseAction() {
            int n = this.mAutoCloseCheckBox != null && this.mAutoCloseCheckBox.isSelected() ? 1 : 0;
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            Preferences preferences2 = preferences.node("dialog_settings");
            preferences2.putInt(AUTO_CLOSE, n);
            this.dispose();
        }

        @Override
        public void dispose() {
            if (this.mTimer != null) {
                this.mTimer.stop();
                this.mTimer = null;
            }
            super.dispose();
        }

        public boolean isAutoClose() {
            return this.mAutoClose;
        }
    }
}

