/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.core.documents.production.ProductionJobClient;
import com.spss.java_client.core.server.ServerObject;
import com.spss.java_client.core.server.messages.prodjobmsg.ProductionJobStatus;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class JobStatusTableModel
extends AbstractTableModel {
    private static int COLUMN_COUNT = 4;
    public static final int COLUMN_JOB_NAME = 0;
    public static final int COLUMN_JOB_STATE = 1;
    public static final int COLUMN_JOB_STARTTIME = 2;
    public static final int COLUMN_JOB_ENDTIME = 3;
    protected static String[] COLUMN_NAMES = new String[COLUMN_COUNT];
    ArrayList<RowInfo> mRowInfoList;
    private JTable mTable;

    public JobStatusTableModel(ArrayList<RowInfo> arrayList, JTable jTable) {
        this.mRowInfoList = arrayList;
        this.mTable = jTable;
        this.resize();
    }

    public ArrayList<RowInfo> getRowInfoList() {
        return this.mRowInfoList;
    }

    public RowInfo getRowInfoAt(int n) {
        if (n < 0) {
            return null;
        }
        return this.mRowInfoList != null ? this.mRowInfoList.get(n) : null;
    }

    public void deleteRowInfoInfoAt(int n) {
        if (this.mRowInfoList != null) {
            this.mRowInfoList.remove(n);
        }
        this.fireTableRowsDeleted(n, n);
    }

    public void cancelRowInfoInfoAt(int n) {
        RowInfo rowInfo = this.getRowInfoAt(n);
        if (rowInfo != null) {
            rowInfo.getJobStatus().setJobState(ProductionJobStatus.JobState.CANCELED);
        }
    }

    @Override
    public int getRowCount() {
        return this.mRowInfoList.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    public Object getValue(int n) {
        return this.mRowInfoList.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.getJobNameAt(n);
            }
            case 1: {
                return this.getJobStateAt(n);
            }
            case 2: {
                return this.getJobStartTimeAt(n);
            }
            case 3: {
                return this.getJobEndTimeAt(n);
            }
        }
        return "";
    }

    public int getJobStartTimeAt(int n) {
        ProductionJobStatus productionJobStatus = this.getRowInfoAt(n).getJobStatus();
        return productionJobStatus.getStartTimestamp();
    }

    public int getJobEndTimeAt(int n) {
        ProductionJobStatus productionJobStatus = this.getRowInfoAt(n).getJobStatus();
        return productionJobStatus.getEndTimestamp();
    }

    public String getJobStateAt(int n) {
        ProductionJobStatus productionJobStatus = this.getRowInfoAt(n).getJobStatus();
        return productionJobStatus.getJobState().name();
    }

    public String getJobNameAt(int n) {
        ProductionJobStatus productionJobStatus = this.getRowInfoAt(n).getJobStatus();
        return productionJobStatus.getJobName();
    }

    public int getJobIDAt(int n) {
        ProductionJobStatus productionJobStatus = this.getRowInfoAt(n).getJobStatus();
        return productionJobStatus.getJobId().getSequence();
    }

    public String getJobOutputPathAt(int n) {
        ProductionJobStatus productionJobStatus = this.getRowInfoAt(n).getJobStatus();
        return productionJobStatus.getOutputPath();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    private void resize() {
        Dimension dimension = this.mTable.getSize();
        dimension.height = this.getRowCount() * this.mTable.getRowHeight();
        this.mTable.setPreferredSize(dimension);
        this.mTable.setMinimumSize(dimension);
        this.mTable.setMaximumSize(dimension);
        this.mTable.repaint();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return Integer.class;
            }
            case 0: 
            case 1: {
                return String.class;
            }
        }
        return String.class;
    }

    public void addRow(RowInfo rowInfo) {
        this.resize();
        this.mTable.changeSelection(this.mRowInfoList.size() - 2, 1, false, false);
    }

    public void removeRow(int n) {
        this.mRowInfoList.remove(n);
        if (this.mRowInfoList.size() == 0) {
            // empty if block
        }
        this.resize();
        this.mTable.changeSelection(n, 0, false, false);
    }

    public static class RowInfo {
        ServerObject mServerObject;
        ProductionJobStatus mProductionJobStatus;
        ProductionJobClient mServerConnection;

        public RowInfo(ServerObject serverObject, ProductionJobClient productionJobClient, ProductionJobStatus productionJobStatus) {
            this.mServerObject = serverObject;
            this.mProductionJobStatus = productionJobStatus;
            this.mServerConnection = productionJobClient;
        }

        public ProductionJobClient getServerConection() {
            return this.mServerConnection;
        }

        public ServerObject getServerObject() {
            return this.mServerObject;
        }

        public ProductionJobStatus getJobStatus() {
            return this.mProductionJobStatus;
        }
    }
}

