/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.production;

import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.LineBorder;

public abstract class BaseProgressDialog
extends JDialog {
    protected JButton mCloseButton;
    private JPanel mMessagePanel;
    private JPanel mUserDefinedPanel;
    private JTextArea mStatusTextArea;
    private JScrollPane mScrollPane;
    private DrawPanel mDisplayPanel;
    private JProgressBar mProgressBar;
    private Timer mMoveSprite;
    private Image[] mSpinImage = new Image[3];
    private int mSpinner = 0;
    private int mSpinner2 = 0;
    private int mSpinSpeed = 2;
    private boolean mSpinLeft = false;

    public BaseProgressDialog(JDialog jDialog, String string) {
        super((Dialog)jDialog, string);
        this.mProgressBar = new JProgressBar();
        this.setProgressBarMoving(true);
        this.setModal(true);
        this.initialize();
    }

    public BaseProgressDialog(BaseDialog baseDialog, Frame frame, String string, String string2, ActionListener actionListener) {
        super(frame, string);
        this.mDisplayPanel = new DrawPanel();
        this.initMovementIcons(baseDialog);
        this.initialize();
    }

    public void setProgressBarMoving(boolean bl) {
        this.mProgressBar.setIndeterminate(bl);
    }

    private void initMovementIcons(BaseDialog baseDialog) {
        String string = baseDialog.getResString("IDS_JOB_STATUS_progressImage1_IMAGE_KEY");
        URL uRL = ResUtil.getImageResourceFullPath(UtilitiesResBundle.getImageFolder() + string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.mSpinImage[0] = new ImageIcon(uRL).getImage();
        string = baseDialog.getResString("IDS_JOB_STATUS_progressImage1_IMAGE_KEY");
        uRL = ResUtil.getImageResourceFullPath(UtilitiesResBundle.getImageFolder() + string);
        imageIcon = new ImageIcon(uRL);
        this.mSpinImage[1] = new ImageIcon(uRL).getImage();
        string = baseDialog.getResString("IDS_JOB_STATUS_progressImage1_IMAGE_KEY");
        uRL = ResUtil.getImageResourceFullPath(UtilitiesResBundle.getImageFolder() + string);
        imageIcon = new ImageIcon(uRL);
        this.mSpinImage[2] = new ImageIcon(uRL).getImage();
        int n = 20;
        this.mMoveSprite = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseProgressDialog.this.mDisplayPanel.repaint();
            }
        });
        this.mMoveSprite.start();
    }

    public void appendToProgressStatusText(String string) {
        this.mStatusTextArea.append("\n" + string);
    }

    public void setProgressStatusText(String string) {
        this.mStatusTextArea.setText(string);
    }

    @Override
    public void dispose() {
        if (this.mMoveSprite != null) {
            this.mMoveSprite.stop();
        }
        super.dispose();
    }

    private void initialize() {
        this.mCloseButton = new JButton();
        CloseActionListener closeActionListener = new CloseActionListener();
        this.mCloseButton.addActionListener(closeActionListener);
        this.mCloseButton.registerKeyboardAction(closeActionListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.mUserDefinedPanel = this.getUserDefinedBottomPanel();
        this.mStatusTextArea = new JTextArea();
        this.mStatusTextArea.setEditable(false);
        this.mStatusTextArea.setWrapStyleWord(true);
        this.mStatusTextArea.setLineWrap(true);
        Dimension dimension = new Dimension(100, 100);
        this.mStatusTextArea.setPreferredSize(dimension);
        this.mStatusTextArea.setMinimumSize(dimension);
        this.mScrollPane = new JScrollPane(this.mStatusTextArea);
        this.mScrollPane.setHorizontalScrollBarPolicy(31);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        JComponent jComponent = this.mDisplayPanel != null ? this.mDisplayPanel : this.mProgressBar;
        jComponent.setBorder(new LineBorder(new Color(0, 0, 0)));
        jComponent.setPreferredSize(new Dimension(250, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.mScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.mUserDefinedPanel, gridBagConstraints);
        this.mCloseButton.setText(this.getCloseButtonText());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.getContentPane().add((Component)this.mCloseButton, gridBagConstraints);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BaseProgressDialog.this.dispose();
            }
        });
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public abstract String getCloseButtonText();

    public abstract JPanel getUserDefinedBottomPanel();

    public abstract JPanel getUserDefinedTopPanel();

    public abstract void processCloseAction();

    class DrawPanel
    extends JComponent {
        private boolean moveRight = true;
        private Point spriteLocation = new Point(10, 3);
        private int size = 25;
        private int move = 1;

        DrawPanel() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            if (this.moveRight) {
                if (this.spriteLocation.x + this.size > dimension.width - 10) {
                    this.moveRight = false;
                    BaseProgressDialog.this.mSpinLeft = true;
                }
                this.spriteLocation.setLocation(this.spriteLocation.x + this.move, this.spriteLocation.y);
            } else if (this.spriteLocation.x <= 10) {
                this.moveRight = true;
                BaseProgressDialog.this.mSpinLeft = false;
                this.spriteLocation.setLocation(this.spriteLocation.x + this.move, this.spriteLocation.y);
            } else {
                this.spriteLocation.setLocation(this.spriteLocation.x - this.move, this.spriteLocation.y);
            }
            graphics.drawImage(BaseProgressDialog.this.mSpinImage[BaseProgressDialog.this.mSpinner], this.spriteLocation.x, this.spriteLocation.y, null);
            BaseProgressDialog.this.mSpinner2++;
            if (BaseProgressDialog.this.mSpinSpeed == BaseProgressDialog.this.mSpinner2) {
                if (BaseProgressDialog.this.mSpinLeft) {
                    BaseProgressDialog.this.mSpinner--;
                    if (BaseProgressDialog.this.mSpinner == -1) {
                        BaseProgressDialog.this.mSpinner = 2;
                    }
                    BaseProgressDialog.this.mSpinner2 = 0;
                } else {
                    BaseProgressDialog.this.mSpinner++;
                    if (BaseProgressDialog.this.mSpinner == 3) {
                        BaseProgressDialog.this.mSpinner = 0;
                    }
                    BaseProgressDialog.this.mSpinner2 = 0;
                }
            }
        }
    }

    class CloseActionListener
    implements ActionListener {
        CloseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseProgressDialog.this.processCloseAction();
        }
    }
}

