/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.oms_control;

import com.spss.java_client.ui.dialogs.base.utilities.oms_control.OmsRequest;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class OmsTableModel
extends AbstractTableModel {
    private List<OmsRequest> mRequests = new ArrayList<OmsRequest>();
    private List<String> mColumnNames = new ArrayList<String>(13);

    public void setColumnNames(List<String> list) {
        this.mColumnNames.clear();
        this.mColumnNames.addAll(list);
    }

    public void addRequest(OmsRequest omsRequest) {
        this.mRequests.add(omsRequest);
        this.fireTableDataChanged();
    }

    public List<OmsRequest> getRequestObjects() {
        return this.mRequests;
    }

    public void removeRequest(int n) {
        this.mRequests.remove(n);
        this.fireTableDataChanged();
    }

    public void clear() {
        int n = this.mRequests.size();
        this.mRequests.clear();
        if (n > 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
    }

    public OmsRequest getRow(int n) {
        return this.mRequests.get(n);
    }

    public void updateRequest(OmsRequest omsRequest) {
        int n = this.mRequests.indexOf(omsRequest);
        this.fireTableRowsUpdated(n, n);
    }

    @Override
    public int getRowCount() {
        return this.mRequests.size();
    }

    @Override
    public int getColumnCount() {
        return this.mColumnNames.size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        return this.mColumnNames.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        OmsRequest omsRequest = this.mRequests.get(n);
        ResourceBundle resourceBundle = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        String string = ResUtil.getString(resourceBundle, "IDS_OMS_COLUMN_IMAGE_PATH");
        URL uRL = ResUtil.getImageResourceFullPath(UtilitiesResBundle.getImageFolder() + string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        switch (n2) {
            case 0: {
                object = imageIcon;
                break;
            }
            case 1: {
                object = omsRequest.getStatus();
                break;
            }
            case 2: {
                object = omsRequest.getId();
                break;
            }
            case 3: {
                object = omsRequest.getTypes();
                break;
            }
            case 4: {
                object = omsRequest.getCommands();
                break;
            }
            case 5: {
                object = omsRequest.getSubtypes();
                break;
            }
            case 6: {
                object = omsRequest.getLabels();
                break;
            }
            case 7: {
                object = omsRequest.getDestination();
                break;
            }
            case 8: {
                object = omsRequest.getFormat();
                break;
            }
            case 9: {
                object = omsRequest.getColumns();
                break;
            }
            case 10: {
                object = omsRequest.getViewer();
                break;
            }
            case 11: {
                object = omsRequest.getNumber();
                break;
            }
            case 12: {
                object = omsRequest.getImages();
                break;
            }
            case 13: {
                object = omsRequest.getImagesDe();
            }
        }
        return object;
    }
}

