/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.oms_control;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.utilities.oms_control.OmsCtrlPanelDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OmsOptionSubDialog
extends BaseSubDialog
implements ItemListener,
DocumentListener,
FocusListener {
    public static final String TABLE_NUMBER_ACTION = "TABLE_NUMBER_ACTION";
    static final String LIST_DIMENSION_TEXT = "IDS_LIST_DIMENSION_TEXT";
    public static final String LIST_POS_TEXT = "IDS_LIST_POS_TEXT";
    public static final String IDS_OMS_LIST_DIMENSION_RADIO = "IDS_OMS_LIST_DIMENSION_RADIO";
    public static final String IDS_OMS_LIST_POSITION_RADIO = "IDS_OMS_LIST_POSITION_RADIO";
    public static final String IDS_OMS_ALL_DIMENSION_RADIO = "IDS_OMS_ALL_DIMENSION_RADIO";
    public static final String IDS_OMS_TABLE_NONE_RADIO = "IDS_OMS_TABLE_NONE_RADIO";
    public static final String IMAGE_FORMAT_COMBO = "IMAGE_FORMAT_COMBO";
    public static final String FILE_FORMAT_COMBO = "FILE_FORMAT_COMBO";
    static final String IDS_OMS_INCLUDE_IMAGES_CHECK = "IDS_OMS_INCLUDE_IMAGES_CHECK";
    static final String IDS_OMS_INCLUDE_IMAGEMAPS_CHECK = "IDS_OMS_INCLUDE_IMAGEMAPS_CHECK";
    static final String IDS_OMS_STATIC_TABLES_CHECK = "IDS_OMS_STATIC_TABLES_CHECK";
    public static final String IMAGE_SIZE_TEXT = "IDS_OMS_IMAGE_SIZE_TEXT";
    private JComboBox mFormatCombo;
    private JCheckBox mIncludeImageCheck;
    private JLabel mImageFormatLabel;
    private JLabel mSizeLabel;
    private JComboBox mImageFormatCombo;
    private IntTextField mSizeText;
    private JRadioButton mNoneRadioButton;
    private JRadioButton mAllDimensionRadioButton;
    private JRadioButton mListPositionButton;
    private JRadioButton mListDimensionButton;
    private JLabel mListPositionLabel;
    private JLabel mListDimensionLabel;
    private StringTextField mListPositionText;
    private StringTextField mListDimensionText;
    private JLabel mTableNumberLabel;
    private StringTextField mTableNumberText;
    private JCheckBox mIncludeImageMapsCheck;
    private JCheckBox mStaticTablesCheck;

    public OmsOptionSubDialog(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_OMS_OPTIONS_TITLE"), true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableControls();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableControls();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableControls();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mSizeText) {
            this.mSizeText.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean continuePressed() {
        int n;
        if (this.mListDimensionButton.isSelected()) {
            this.formatDimensionName();
        }
        if (this.mIncludeImageCheck.isSelected() && ((n = Integer.parseInt(this.mSizeText.getText())) < 10 || n > 200)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mParentDlg), this.getResString("ERR_OMS_IMAGE_SIZE"), VersionInfo.getAppVersionString());
            this.mSizeText.selectAll();
            this.mSizeText.requestFocus();
            return false;
        }
        if (this.isSelectedFormat("SPSS") && !this.isValidName()) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this.mParentDlg), this.getResString("ERR_OMS_TABLE_NUBER"), VersionInfo.getAppVersionString());
            this.mTableNumberText.selectAll();
            this.mTableNumberText.requestFocus();
            return false;
        }
        if (this.mListPositionButton.isSelected()) {
            n = 1;
            boolean bl = this.mListPositionText.getText().indexOf(44) > -1;
            String[] stringArray = this.mListPositionText.getText().trim().split("[(\\s,)]+");
            int n2 = stringArray.length;
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : stringArray) {
                hashSet.add(string.toLowerCase().trim());
            }
            if (n2 > hashSet.size()) {
                n = 0;
            }
            if (n != 0) {
                for (String string : stringArray) {
                    String string2 = string.trim();
                    char c = string2.charAt(0);
                    if (c != 'R' && c != 'r' && c != 'L' && c != 'l' && c != 'C' && c != 'c') {
                        n = 0;
                    }
                    int n3 = string2.length();
                    String string3 = string2.substring(1, n3);
                    if (n == 0) continue;
                    try {
                        Integer.parseInt(string3);
                        n = 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (string3.equalsIgnoreCase("ALL")) continue;
                        n = 0;
                    }
                }
            }
            if (n != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    stringBuffer.append(string);
                    if (i >= stringArray.length - 1) continue;
                    stringBuffer.append(bl ? "," : " ");
                }
                this.mListPositionText.setText(stringBuffer.toString().trim());
                return true;
            }
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this.mParentDlg), this.getResString("ERR_OMS_LIST_COLUMN"), VersionInfo.getAppVersionString());
            this.mListPositionText.selectAll();
            this.mListPositionText.requestFocus();
            return false;
        }
        return super.continuePressed();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.mListPositionLabel.setEnabled(this.mListPositionButton.isSelected());
        this.mListPositionText.setEnabled(this.mListPositionButton.isSelected());
        this.mListPositionText.setOpaque(this.mListPositionButton.isSelected());
        this.mListDimensionLabel.setEnabled(this.mListDimensionButton.isSelected());
        this.mListDimensionText.setEnabled(this.mListDimensionButton.isSelected());
        this.mListDimensionText.setOpaque(this.mListDimensionButton.isSelected());
        this.mIncludeImageCheck.setEnabled(this.isSelectedFormat("HTML") || this.isSelectedFormat("REPORTHTML") || this.isSelectedFormat("REPORTMHT"));
        boolean bl = this.isSelectedFormat("SPSS");
        this.mTableNumberLabel.setEnabled(bl);
        this.mTableNumberText.setEnabled(bl);
        this.mTableNumberText.setOpaque(bl);
        this.enableImagePanelControls();
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_oms_options";
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (OmsCtrlPanelDlg.isNewRowAdded) {
            this.setDefaults();
            OmsCtrlPanelDlg.isNewRowAdded = false;
        }
        if (this.mParentDlg.getDialogDataModel().getBoolean("IDS_OMS_DATASET_RADIO") != null) {
            Boolean bl = this.mParentDlg.getDialogDataModel().getBoolean("IDS_OMS_DATASET_RADIO");
            if (bl.booleanValue()) {
                this.setSelectedFormat("SPSS");
            }
            this.mFormatCombo.setEnabled(bl == false);
        }
        if (this.mListDimensionButton.isSelected()) {
            this.formatDimensionName();
        }
        if (dialogDataModel.getInteger(FILE_FORMAT_COMBO) == null) {
            this.setSelectedFormat("OXML");
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initvars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupFormatPanel();
        JPanel jPanel3 = this.setupGraphicImagePanel();
        JPanel jPanel4 = this.setupTablePivotPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTableNumberLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTableNumberText), gridBagConstraints, 1, 3, 1, 1, n, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    private void formatDimensionName() {
        String string = this.mListDimensionText.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(this.mListDimensionText.getText(), "\"");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreElements()) {
            String string2 = ((String)stringTokenizer.nextElement()).trim();
            if (string2.length() <= 0) continue;
            stringBuffer.append("\"").append(string2).append("\" ");
        }
        this.mListDimensionText.setText(stringBuffer.toString().trim());
        if (!string.contains("\"")) {
            this.mListDimensionText.setText("\"" + string + "\"");
        }
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mFormatCombo);
        vector.add(this.mIncludeImageCheck);
        vector.add(this.mIncludeImageMapsCheck);
        vector.add(this.mImageFormatCombo);
        vector.add(this.mSizeText);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mNoneRadioButton);
        spssButtonGroup.add(this.mAllDimensionRadioButton);
        spssButtonGroup.add(this.mListPositionButton);
        spssButtonGroup.add(this.mListDimensionButton);
        vector.add(spssButtonGroup);
        vector.add(this.mListPositionText);
        vector.add(this.mListDimensionText);
        vector.add(this.mStaticTablesCheck);
        vector.add(this.mTableNumberText);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupFormatPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_OMS_FORMAT_COMBO");
        jLabel.setLabelFor(this.mFormatCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        ComboboxAction comboboxAction = new ComboboxAction(this, FILE_FORMAT_COMBO);
        this.mFormatCombo.setAction(comboboxAction);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mFormatCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setDefaults() {
        this.mIncludeImageCheck.setEnabled(false);
        this.mIncludeImageCheck.setSelected(false);
        this.mIncludeImageMapsCheck.setEnabled(false);
        this.mIncludeImageMapsCheck.setSelected(false);
        this.mStaticTablesCheck.setEnabled(false);
        this.mStaticTablesCheck.setSelected(false);
        this.mNoneRadioButton.setSelected(true);
        this.mListPositionLabel.setEnabled(false);
        this.mListPositionText.setEnabled(false);
        this.mListPositionText.setOpaque(false);
        this.mListPositionText.setText("");
        this.mListDimensionLabel.setEnabled(false);
        this.mListDimensionText.setEnabled(false);
        this.mListDimensionText.setOpaque(false);
        this.mListDimensionText.setText("");
        this.mTableNumberText.setText("TableNumber_");
        this.mTableNumberLabel.setEnabled(false);
        this.mTableNumberText.setEnabled(false);
        this.mTableNumberText.setOpaque(false);
        this.mSizeText.setText("100");
        this.mImageFormatCombo.setSelectedIndex(0);
        this.enableImagePanelControls();
    }

    private JPanel setupTablePivotPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(insets.top, n2 * 2, insets.left, insets.bottom);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OMS_TABLE_PIVOTS_TITLE")));
        DialogUtil.addUsingGBL(jPanel, this.mNoneRadioButton, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mAllDimensionRadioButton, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mListPositionButton, gridBagConstraints, 0, 2, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mListPositionLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mListPositionText), gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mListDimensionButton, gridBagConstraints, 0, 4, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mListDimensionLabel, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mListDimensionText), gridBagConstraints, 1, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mStaticTablesCheck, gridBagConstraints, 0, 6, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupGraphicImagePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OMS_GRAPHICS_IMAGES_TITLE")));
        DialogUtil.addUsingGBL(jPanel, this.mIncludeImageCheck, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(insets.top, n2, insets.left, insets.bottom);
        DialogUtil.addUsingGBL(jPanel, this.mImageFormatLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mImageFormatCombo, gridBagConstraints, 1, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2.top = n2 / 2;
        DialogUtil.addUsingGBL(jPanel, this.mSizeLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2.left = insets.left;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSizeText, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        JLabel jLabel = new JLabel(this.getResString("IDS_OMS_PERCENT_LABEL"));
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeImageMapsCheck, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        return jPanel;
    }

    private void initvars() {
        this.mFormatCombo = new JComboBox<String>(((OmsCtrlPanelDlg)((Object)this.getParent())).mComboArray);
        this.mFormatCombo.addItemListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, IDS_OMS_INCLUDE_IMAGES_CHECK);
        this.mIncludeImageCheck = new JCheckBox(toggleButtonAction);
        this.mIncludeImageCheck.addItemListener(this);
        this.mImageFormatCombo = new JComboBox<String>(this.getResStringArray("IDS_OMS_IMAGE_FORMAT_COMBO_ITEMS"));
        ComboboxAction comboboxAction = new ComboboxAction(this, IMAGE_FORMAT_COMBO);
        this.mImageFormatCombo.setAction(comboboxAction);
        this.mImageFormatLabel = DialogUtil.createLabel(this, "IDS_OMS_IMAGE_FORMAT");
        this.mImageFormatLabel.setLabelFor(this.mImageFormatCombo);
        this.mSizeText = new IntTextField(10, 200, true);
        this.mSizeText.setAction((Action)new TextFieldAction(this, IMAGE_SIZE_TEXT));
        FocusListener[] focusListenerArray = this.mSizeText.getFocusListeners();
        if (focusListenerArray != null) {
            for (FocusListener focusListener : focusListenerArray) {
                if (!(focusListener instanceof IntTextField)) continue;
                this.mSizeText.removeFocusListener(focusListener);
            }
        }
        this.mSizeText.addFocusListener((FocusListener)this);
        this.mSizeText.getDocument().addDocumentListener(this);
        this.mSizeLabel = DialogUtil.createLabel(this, "IDS_OMS_SIZE");
        this.mSizeLabel.setLabelFor((Component)this.mSizeText);
        toggleButtonAction = new ToggleButtonAction(this, IDS_OMS_TABLE_NONE_RADIO);
        this.mNoneRadioButton = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, IDS_OMS_ALL_DIMENSION_RADIO);
        this.mAllDimensionRadioButton = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, IDS_OMS_LIST_POSITION_RADIO);
        this.mListPositionButton = new JRadioButton(toggleButtonAction);
        this.mListPositionButton.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, IDS_OMS_LIST_DIMENSION_RADIO);
        this.mListDimensionButton = new JRadioButton(toggleButtonAction);
        this.mListDimensionButton.addItemListener(this);
        this.mListPositionText = new StringTextField();
        this.mListPositionText.getDocument().addDocumentListener(this);
        this.mListPositionText.setAction(new TextFieldAction(this, LIST_POS_TEXT));
        this.mListPositionLabel = DialogUtil.createLabel(this, "IDS_OMS_LIST_POSITION");
        this.mListPositionLabel.setLabelFor((Component)((Object)this.mListPositionText));
        this.mListDimensionText = new StringTextField();
        this.mListDimensionText.getDocument().addDocumentListener(this);
        this.mListDimensionText.setAction(new TextFieldAction(this, LIST_DIMENSION_TEXT));
        this.mListDimensionLabel = DialogUtil.createLabel(this, "IDS_OMS_LIST_DIMENSION");
        this.mListDimensionLabel.setLabelFor((Component)((Object)this.mListDimensionText));
        this.mTableNumberText = new StringTextField();
        this.mTableNumberText.setAction(new TextFieldAction(this, TABLE_NUMBER_ACTION));
        this.mTableNumberText.getDocument().addDocumentListener(this);
        this.mTableNumberLabel = DialogUtil.createLabel(this, "IDS_OMS_TABLE_NUBER_VARIABLE");
        this.mTableNumberLabel.setLabelFor((Component)((Object)this.mTableNumberText));
        toggleButtonAction = new ToggleButtonAction(this, IDS_OMS_INCLUDE_IMAGEMAPS_CHECK);
        this.mIncludeImageMapsCheck = new JCheckBox(toggleButtonAction);
        this.mIncludeImageMapsCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, IDS_OMS_STATIC_TABLES_CHECK);
        this.mStaticTablesCheck = new JCheckBox(toggleButtonAction);
        this.mStaticTablesCheck.addItemListener(this);
    }

    private void enableImagePanelControls() {
        boolean bl = this.mIncludeImageCheck.isEnabled() && this.mIncludeImageCheck.isSelected();
        this.mImageFormatLabel.setEnabled(bl);
        this.mImageFormatLabel.setEnabled(bl);
        this.mImageFormatCombo.setEnabled(bl);
        this.mSizeLabel.setEnabled(bl);
        this.mSizeText.setEnabled(bl);
        this.mSizeText.setOpaque(bl);
        this.mIncludeImageMapsCheck.setEnabled(bl && (this.isSelectedFormat("HTML") || this.isSelectedFormat("REPORTHTML") || this.isSelectedFormat("REPORTMHT")));
    }

    private boolean isSelectedFormat(String string) {
        if (string.equals("HTML")) {
            return this.mFormatCombo.getSelectedItem().toString().equals(this.getResString("IDS_OMS_FORMAT_HTML"));
        }
        if (string.equals("OXML")) {
            return this.mFormatCombo.getSelectedItem().toString().equals(this.getResString("IDS_OMS_FORMAT_OXML"));
        }
        if (string.equals("SPV")) {
            return this.mFormatCombo.getSelectedItem().toString().equals(this.getResString("IDS_OMS_FORMAT_SPV"));
        }
        if (string.equals("SPSS")) {
            return this.mFormatCombo.getSelectedItem().toString().equals(this.getResString("IDS_OMS_FORMAT_SPSS"));
        }
        if (string.equals("SPW")) {
            return this.mFormatCombo.getSelectedItem().toString().equals(this.getResString("IDS_OMS_FORMAT_SPW"));
        }
        if (string.equals("REPORTHTML")) {
            return this.mFormatCombo.getSelectedItem().toString().equals(this.getResString("IDS_OMS_FORMAT_REPORTHTML"));
        }
        if (string.equals("REPORTMHT")) {
            return this.mFormatCombo.getSelectedItem().toString().equals(this.getResString("IDS_OMS_FORMAT_REPORTMHT"));
        }
        return false;
    }

    private void setSelectedFormat(String string) {
        int n = 0;
        List<String> list = Arrays.asList(((OmsCtrlPanelDlg)((Object)this.getParent())).mComboArray);
        if (string.equals("OXML")) {
            n = list.indexOf(this.getResString("IDS_OMS_FORMAT_OXML"));
        } else if (string.equals("SPSS")) {
            n = list.indexOf(this.getResString("IDS_OMS_FORMAT_SPSS"));
        } else if (string.equals("SPW")) {
            n = list.indexOf(this.getResString("IDS_OMS_FORMAT_SPW"));
        } else if (string.equals("REPORTHTML")) {
            n = list.indexOf(this.getResString("IDS_OMS_FORMAT_REPORTHTML"));
        } else if (string.equals("REPORTMHT")) {
            n = list.indexOf(this.getResString("IDS_OMS_FORMAT_REPORTMHT"));
        }
        this.mFormatCombo.setSelectedItem(n);
        this.mParentDlg.getDialogDataModel().putInteger(FILE_FORMAT_COMBO, n);
    }

    private void enableControls() {
        this.mListPositionLabel.setEnabled(this.mListPositionButton.isSelected());
        this.mListPositionText.setEnabled(this.mListPositionButton.isSelected());
        this.mListPositionText.setOpaque(this.mListPositionButton.isSelected());
        this.mListDimensionLabel.setEnabled(this.mListDimensionButton.isSelected());
        this.mListDimensionText.setEnabled(this.mListDimensionButton.isSelected());
        this.mListDimensionText.setOpaque(this.mListDimensionButton.isSelected());
        boolean bl = this.isSelectedFormat("SPV");
        boolean bl2 = this.isSelectedFormat("SPSS");
        Boolean bl3 = this.mParentDlg.getDialogDataModel().getBoolean("IDS_OMS_DATASET_RADIO");
        this.mIncludeImageCheck.setEnabled(bl3 == false && (this.isSelectedFormat("OXML") || this.isSelectedFormat("HTML")) || this.isSelectedFormat("REPORTHTML") || this.isSelectedFormat("REPORT_HTML"));
        this.mTableNumberLabel.setEnabled(bl2);
        this.mTableNumberText.setEnabled(bl2);
        this.mTableNumberText.setOpaque(bl2);
        this.mStaticTablesCheck.setEnabled(bl);
        this.enableImagePanelControls();
        this.enableContinue(this.canEnableContinue());
    }

    private boolean canEnableContinue() {
        boolean bl = true;
        if (this.isSelectedFormat("SPSS")) {
            boolean bl2 = bl = this.mTableNumberText.getText().length() != 0;
        }
        if (bl && this.mListDimensionButton.isSelected()) {
            bl = this.mListDimensionText.getText().length() != 0;
        } else if (bl && this.mListPositionButton.isSelected()) {
            bl = this.mListPositionText.getText().length() != 0;
        } else if (bl && this.mIncludeImageCheck.isSelected()) {
            bl = this.mSizeText.getText().length() != 0;
        }
        return bl;
    }

    private boolean isValidName() {
        boolean bl = true;
        String string = this.mTableNumberText.getText();
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        switch (n) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            case 4: {
                bl = false;
                break;
            }
            case 5: {
                bl = false;
                break;
            }
            case 6: {
                bl = false;
                break;
            }
            case 7: {
                bl = false;
                break;
            }
        }
        return bl;
    }
}

