/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.utilities.oms_control;

import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.TraceSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OmsLoggingSubDialog
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    static final String IDS_OMS_LOGGING_TEXT_RADIO = "IDS_OMS_LOGGING_TEXT_RADIO";
    static final String IDS_OMS_LOGGING_XML_RADIO = "IDS_OMS_LOGGING_XML_RADIO";
    static final String LOGGING_FILE_TEXT = "LOGGING_FILE_TEXT";
    static final String IDS_OMS_LOG_ACTIVITY_CHECK = "IDS_OMS_LOG_ACTIVITY_CHECK";
    private static final String FILE_BROWSE_BUTTON = "IDS_OMS_LOGGING_FILE_BROWSE_BUTTON";
    private JCheckBox mLogOmsCheck;
    private FileTextField mFileText;
    private JButton mBrowseButton;
    private JRadioButton mXmlRadioButton;
    private JRadioButton mTextRadioButton;
    private SpssButtonGroup mButtonGroup;
    private JLabel mFileLabel;

    public OmsLoggingSubDialog(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_OMS_LOGGING_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_oms_logging";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.mLogOmsCheck.isSelected();
        if (bl) {
            this.enableContinue(this.mFileText.getText().length() > 0);
        } else {
            this.enableContinue(true);
        }
        this.updateControls(bl);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mLogOmsCheck.isSelected()) {
            this.enableContinue(this.mFileText.getText().length() > 0);
        } else {
            this.enableContinue(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mLogOmsCheck.isSelected()) {
            this.enableContinue(this.mFileText.getText().length() > 0);
        } else {
            this.enableContinue(true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mLogOmsCheck.isSelected()) {
            this.enableContinue(this.mFileText.getText().length() > 0);
        } else {
            this.enableContinue(true);
        }
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (!this.mLogOmsCheck.isSelected()) {
            this.mFileText.setText("");
        }
        this.updateControls(this.mLogOmsCheck.isSelected());
    }

    private void updateControls(boolean bl) {
        Color color;
        this.mFileLabel.setEnabled(bl);
        this.mFileText.setEnabled(bl);
        this.mBrowseButton.setEnabled(bl);
        this.mXmlRadioButton.setEnabled(bl);
        this.mTextRadioButton.setEnabled(bl);
        SystemColor systemColor = color = bl ? SystemColor.text : SystemColor.control;
        if (bl && OSCheck.getOSType() == OSInfo.OSType.LINUX) {
            color = Color.white;
        }
        this.mFileText.setBackground(color);
    }

    @Override
    protected void init() {
        super.init();
        this.initvars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JPanel jPanel2 = this.setupFormatPanel();
        this.mFileLabel = DialogUtil.createLabel(this, "IDS_OMS_FILE");
        this.mFileLabel.setLabelFor((Component)((Object)this.mFileText));
        DialogUtil.addUsingGBL(jPanel, this.mLogOmsCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mFileLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileText), gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    protected void initvars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, IDS_OMS_LOG_ACTIVITY_CHECK);
        this.mLogOmsCheck = new JCheckBox(toggleButtonAction);
        this.mLogOmsCheck.addItemListener(this);
        this.mFileText = new FileTextField();
        this.mFileText.setFocusable(true);
        this.mFileText.setDocument(new FixedLengthDocument(30000));
        this.mFileText.getDocument().addDocumentListener(this);
        this.mFileText.setAction(new TextFieldAction(this, LOGGING_FILE_TEXT));
        toggleButtonAction = new ToggleButtonAction(this, FILE_BROWSE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OmsLoggingSubDialog.this.showBrowseFileDialog();
            }
        };
        this.mBrowseButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, IDS_OMS_LOGGING_XML_RADIO);
        this.mXmlRadioButton = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, IDS_OMS_LOGGING_TEXT_RADIO);
        this.mTextRadioButton = new JRadioButton(toggleButtonAction);
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mXmlRadioButton);
        this.mButtonGroup.add(this.mTextRadioButton);
    }

    private void setDefaults() {
        this.mXmlRadioButton.setSelected(true);
        this.mLogOmsCheck.setSelected(false);
    }

    private JPanel setupFormatPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OMS_FORMAT_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mXmlRadioButton);
        spssButtonGroup.add(this.mTextRadioButton);
        DialogUtil.addUsingGBL(jPanel, this.mXmlRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mTextRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void showBrowseFileDialog() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(this.getResString("IDS_OMS_SAVE_FILE_TITLE"));
        int n = remoteFileChooser.showSaveDialog(this.getParent());
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string = remoteFileChooser.getSelectedFilePath();
            this.mFileText.setText(string);
        } else {
            TraceSettings.trace1((String)"No Selection", (int)15);
        }
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mLogOmsCheck);
        vector.add(this.mFileText);
        vector.add(this.mBrowseButton);
        vector.add(this.mButtonGroup);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

